/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.service.graph.DatabaseDatasetFactoryService;
import jp.ossc.nimbus.service.graph.DatabaseTimeSeriesCollectionFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

public class DatabaseTimeSeriesCollectionFactoryService
extends DatabaseDatasetFactoryService
implements DatabaseTimeSeriesCollectionFactoryServiceMBean {
    private String dateFormatPattern;
    private String dateColumnName;
    private String timeColumnName;
    private String valueColumnName;
    private boolean isContainsDuplicateValue;
    private Map timePeriodClassMap;

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    public String getDateColumnName() {
        return this.dateColumnName;
    }

    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    public void setValueColumnName(String columnName) {
        this.valueColumnName = columnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public boolean isContainsDuplicateValue() {
        return this.isContainsDuplicateValue;
    }

    public void setContainsDuplicateValue(boolean isContains) {
        this.isContainsDuplicateValue = isContains;
    }

    public void setTimePeriodClass(String seriesName, Class clazz) {
        this.timePeriodClassMap.put(seriesName, clazz);
    }

    public Class getTimePeriodClass(String seriesName) {
        return (Class)this.timePeriodClassMap.get(seriesName);
    }

    public void createService() throws Exception {
        super.createService();
        this.timePeriodClassMap = new HashMap();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.dateFormatPattern != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        if (!this.isPermitNullColumnName()) {
            if (this.dateColumnName == null) {
                throw new IllegalArgumentException("date column name must be specified.");
            }
            if (this.valueColumnName == null) {
                throw new IllegalArgumentException("value column name must be specified.");
            }
        }
    }

    public void destroyService() throws Exception {
        this.timePeriodClassMap = null;
    }

    protected Dataset createDataset(DatasetCondition[] dsConditions, String[] seriesArray, ResultSet[] rSets) throws DatasetCreateException {
        if (seriesArray == null || seriesArray.length == 0 || rSets == null || rSets.length == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = null;
        if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        try {
            for (int i = 0; i < seriesArray.length; ++i) {
                String series = seriesArray[i];
                ResultSet rs = rSets[i];
                Class timePeriodClass = (Class)this.timePeriodClassMap.get(series);
                long period = 0L;
                TimeSeries timeSeries = null;
                if (this.isContainsDuplicateValue) {
                    if (timePeriodClass == null) {
                        timePeriodClass = new TimeSeries(series).getTimePeriodClass();
                    }
                    if ((class$org$jfree$data$time$Second == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Second") : class$org$jfree$data$time$Second).equals(timePeriodClass)) {
                        period = 1000L;
                    } else if ((class$org$jfree$data$time$Minute == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Minute") : class$org$jfree$data$time$Minute).equals(timePeriodClass)) {
                        period = 60000L;
                    } else if ((class$org$jfree$data$time$Hour == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Hour") : class$org$jfree$data$time$Hour).equals(timePeriodClass)) {
                        period = 3600000L;
                    } else if ((class$org$jfree$data$time$Day == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Day") : class$org$jfree$data$time$Day).equals(timePeriodClass)) {
                        period = 86400000L;
                    } else if ((class$org$jfree$data$time$Week == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Week") : class$org$jfree$data$time$Week).equals(timePeriodClass)) {
                        period = 604800000L;
                    } else if ((class$org$jfree$data$time$Month == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Month") : class$org$jfree$data$time$Month).equals(timePeriodClass)) {
                        period = -1875767296L;
                    } else if ((class$org$jfree$data$time$Quarter == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Quarter") : class$org$jfree$data$time$Quarter).equals(timePeriodClass)) {
                        period = 367807232L;
                    } else if ((class$org$jfree$data$time$Year == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Year") : class$org$jfree$data$time$Year).equals(timePeriodClass)) {
                        period = 1471228928L;
                    }
                    timePeriodClass = class$org$jfree$data$time$Millisecond == null ? DatabaseTimeSeriesCollectionFactoryService.class$("org.jfree.data.time.Millisecond") : class$org$jfree$data$time$Millisecond;
                    timeSeries = new TimeSeries(series, timePeriodClass);
                } else if (timePeriodClass != null) {
                    timeSeries = new TimeSeries(series, timePeriodClass);
                } else {
                    timeSeries = new TimeSeries(series);
                    timePeriodClass = timeSeries.getTimePeriodClass();
                }
                Date lastDate = null;
                double lastValue = Double.NaN;
                LinkedHashMap<Date, Double> sameDateValueMap = new LinkedHashMap<Date, Double>();
                while (rs.next()) {
                    Date date = null;
                    if (dateFormat != null) {
                        String dateStr = null;
                        if (this.dateColumnName != null) {
                            dateStr = rs.getString(this.dateColumnName);
                        }
                        if (this.timeColumnName != null) {
                            dateStr = dateStr != null ? dateStr + rs.getString(this.timeColumnName) : rs.getString(this.timeColumnName);
                        }
                        date = dateFormat.parse(dateStr);
                    } else {
                        date = rs.getDate(this.dateColumnName);
                    }
                    if (date == null) {
                        throw new DatasetCreateException("date is null.");
                    }
                    double value = this.getDoubleWithWasNullCheck(rs, this.valueColumnName);
                    if (this.isContainsDuplicateValue) {
                        if (lastDate != null && date.equals(lastDate)) {
                            sameDateValueMap.put(lastDate, new Double(lastValue));
                        } else {
                            if (sameDateValueMap.size() > 0) {
                                long interval = period / (long)(sameDateValueMap.size() + 1);
                                long additionalTime = lastDate.getTime();
                                Iterator dates = sameDateValueMap.keySet().iterator();
                                int count = 0;
                                while (dates.hasNext() && (long)count < period) {
                                    Date d = (Date)dates.next();
                                    this.addTimeSeries(timeSeries, new Date(additionalTime), (Double)sameDateValueMap.get(d), timePeriodClass);
                                    additionalTime += interval;
                                    ++count;
                                }
                                lastDate = new Date(additionalTime);
                                sameDateValueMap.clear();
                            }
                            if (lastDate != null) {
                                this.addTimeSeries(timeSeries, lastDate, lastValue, timePeriodClass);
                            }
                        }
                        lastDate = date;
                        lastValue = value;
                        continue;
                    }
                    this.addTimeSeries(timeSeries, date, value, timePeriodClass);
                }
                if (this.isContainsDuplicateValue && lastDate != null) {
                    this.addTimeSeries(timeSeries, lastDate, lastValue, timePeriodClass);
                }
                dataset.addSeries(timeSeries);
                timePeriodClass = null;
            }
        }
        catch (SQLException e) {
            throw new DatasetCreateException(e);
        }
        catch (ParseException e) {
            throw new DatasetCreateException(e);
        }
        return dataset;
    }

    private TimeSeries addTimeSeries(TimeSeries series, Date date, double value, Class timePeriodClass) {
        if (timePeriodClass.equals(Millisecond.class)) {
            series.add((RegularTimePeriod)new Millisecond(date), value);
        } else if (timePeriodClass.equals(FixedMillisecond.class)) {
            series.add((RegularTimePeriod)new FixedMillisecond(date), value);
        } else if (timePeriodClass.equals(Second.class)) {
            series.add((RegularTimePeriod)new Second(date), value);
        } else if (timePeriodClass.equals(Minute.class)) {
            series.add((RegularTimePeriod)new Minute(date), value);
        } else if (timePeriodClass.equals(Hour.class)) {
            series.add((RegularTimePeriod)new Hour(date), value);
        } else if (timePeriodClass.equals(Day.class)) {
            series.add((RegularTimePeriod)new Day(date), value);
        } else if (timePeriodClass.equals(Week.class)) {
            series.add((RegularTimePeriod)new Week(date), value);
        } else if (timePeriodClass.equals(Month.class)) {
            series.add((RegularTimePeriod)new Month(date), value);
        } else if (timePeriodClass.equals(Quarter.class)) {
            series.add((RegularTimePeriod)new Quarter(date), value);
        } else if (timePeriodClass.equals(Year.class)) {
            series.add((RegularTimePeriod)new Year(date), value);
        }
        return series;
    }
}

