/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy.invoker;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.proxy.RemoteServiceCallException;
import jp.ossc.nimbus.service.proxy.invoker.JMXClientRMICallInvokerServiceMBean;

public class JMXClientRMICallInvokerService
extends ServiceBase
implements Invoker,
Serializable,
JMXClientRMICallInvokerServiceMBean {
    private static final String SETTER_PREFIX = "set";
    private static final int SETTER_PREFIX_LENGTH = 3;
    private static final String GETTER_PREFIX = "get";
    private static final int GETTER_PREFIX_LENGTH = 3;
    private ServiceName jndiFinderServiceName;
    private JndiFinder jndiFinder;
    private String rmiAdaptorName = "jmx/invoker/RMIAdaptor";
    private String objectNameDomain;
    private Properties objectNameProperties;
    private String objectNameStr;
    private ObjectName objectName;

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setRMIAdaptorName(String name) {
        this.rmiAdaptorName = name;
    }

    public String getRMIAdaptorName() {
        return this.rmiAdaptorName;
    }

    public void setObjectName(String name) {
        this.objectNameStr = name;
    }

    public String getObjectName() {
        return this.objectNameStr;
    }

    public void setObjectNameDomain(String domain) {
        this.objectNameDomain = domain;
    }

    public String getObjectNameDomain() {
        return this.objectNameDomain;
    }

    public void setObjectNameProperties(Properties prop) {
        this.objectNameProperties = prop;
    }

    public Properties getObjectNameProperties() {
        return this.objectNameProperties;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        }
        if (this.jndiFinder == null) {
            throw new IllegalArgumentException("JndiFinderServiceName or JndiFinder must be specified.");
        }
        if (this.objectNameStr == null) {
            if (this.objectNameDomain == null) {
                throw new IllegalArgumentException("objectNameDomain must be specified.");
            }
            if (this.objectNameProperties == null) {
                throw new IllegalArgumentException("objectNameProperties must be specified.");
            }
            this.objectName = new ObjectName(this.objectNameDomain, this.objectNameProperties);
        } else {
            this.objectName = new ObjectName(this.objectNameStr);
        }
    }

    public Object invoke(InvocationContext context) throws Throwable {
        MethodInvocationContext methodContext = (MethodInvocationContext)context;
        try {
            MBeanServerConnection connection = (MBeanServerConnection)this.jndiFinder.lookup(this.rmiAdaptorName);
            Method method = methodContext.getTargetMethod();
            String methodName = method.getName();
            Object[] params = methodContext.getParameters();
            if (methodName.length() > 3 && methodName.startsWith(SETTER_PREFIX) && params != null && params.length == 1) {
                Attribute attr = new Attribute(methodName.substring(3), params[0]);
                connection.setAttribute(this.objectName, attr);
                return null;
            }
            if (methodName.length() > 3 && methodName.startsWith(GETTER_PREFIX) && (params == null || params.length == 0)) {
                return connection.getAttribute(this.objectName, methodName.substring(3));
            }
            String[] sigs = null;
            if (params != null) {
                sigs = new String[params.length];
                for (int i = 0; i < params.length; ++i) {
                    sigs[i] = params[i].getClass().getName();
                }
            }
            return connection.invoke(this.objectName, methodName, params, sigs);
        }
        catch (NamingException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (RemoteException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (MBeanException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (ReflectionException e) {
            throw new RemoteServiceCallException(e);
        }
        catch (IOException e) {
            throw new RemoteServiceCallException(e);
        }
    }
}

