/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import jp.ossc.nimbus.beans.Utility;

public class DateEditor
extends PropertyEditorSupport
implements Serializable {
    public static final String NOW = "NOW";
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss SSS";
    private static final String DELIMETER_SPACE = " ";
    private SimpleDateFormat format;

    public void setAsText(String text) {
        StringTokenizer tokens;
        int count;
        if (text == null) {
            this.setValue(null);
            return;
        }
        String str = Utility.replaceSystemProperty(text).trim();
        if (NOW.equals(str)) {
            this.setValue(new Date());
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar now = null;
        if (str.indexOf(NOW) != -1) {
            now = Calendar.getInstance();
        }
        if ((count = (tokens = new StringTokenizer(str, DELIMETER_SPACE)).countTokens()) > 3 || count == 0) {
            throw new IllegalArgumentException(str);
        }
        String token = null;
        boolean isSetDate = false;
        boolean isSetTime = false;
        if (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.indexOf(47) != -1) {
                this.setDateField(now, calendar, token);
                isSetDate = true;
            } else if (token.indexOf(58) != -1) {
                this.setTimeField(now, calendar, token);
                isSetTime = true;
            } else if (count == 1) {
                this.setMillisField(now, calendar, token);
            } else if (count >= 2) {
                this.setDateField(now, calendar, token);
                isSetDate = true;
            }
        }
        if (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.indexOf(47) != -1) {
                throw new IllegalArgumentException(str);
            }
            if (token.indexOf(58) != -1) {
                this.setTimeField(now, calendar, token);
            } else if (isSetDate) {
                this.setTimeField(now, calendar, token);
                isSetTime = true;
            } else if (isSetTime) {
                this.setMillisField(now, calendar, token);
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.indexOf(47) != -1) {
                    throw new IllegalArgumentException(str);
                }
                if (token.indexOf(58) != -1) {
                    throw new IllegalArgumentException(str);
                }
                this.setMillisField(now, calendar, token);
                if (tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException(str);
                }
            }
        }
        this.setValue(calendar.getTime());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDateField(Calendar now, Calendar calendar, String str) {
        String tmp = str.trim();
        int index = tmp.lastIndexOf(47);
        int year = -1;
        int month = -1;
        int day = -1;
        if (index == -1) {
            if (!tmp.equals(NOW)) throw new IllegalArgumentException("Invalid date field : " + str);
            year = now.get(1);
            month = now.get(2) + 1;
            day = now.get(5);
        } else {
            if (index != tmp.length() - 1) {
                String dayStr = tmp.substring(index + 1).trim();
                day = dayStr.equals(NOW) ? now.get(5) : Integer.parseInt(dayStr);
            }
            if ((index = (tmp = tmp.substring(0, index).trim()).lastIndexOf(47)) == -1) {
                if (tmp.equals(NOW)) {
                    month = now.get(2);
                } else {
                    int length = tmp.length();
                    if (length != 0) {
                        if (length == 4) {
                            year = Integer.parseInt(tmp);
                            month = day;
                            day = -1;
                        } else {
                            if (length != 2 && length != 1) throw new IllegalArgumentException("Invalid date field : " + str);
                            month = Integer.parseInt(tmp);
                        }
                    }
                }
            } else {
                if (index != tmp.length() - 1) {
                    String monthStr = tmp.substring(index + 1).trim();
                    if (monthStr.equals(NOW)) {
                        month = now.get(2) + 1;
                    } else if (monthStr.length() != 0) {
                        month = Integer.parseInt(monthStr);
                    }
                }
                if (index != (tmp = tmp.substring(0, index).trim()).length() - 1) {
                    if (tmp.equals(NOW)) {
                        year = now.get(1);
                    } else if (tmp.length() != 0) {
                        year = Integer.parseInt(tmp);
                    }
                }
            }
        }
        if (year != -1) {
            if (year < 0) {
                throw new IllegalArgumentException("Invalid date field : " + str);
            }
            calendar.set(1, year);
        }
        if (month != -1) {
            if (month > 12 || month < 1) {
                throw new IllegalArgumentException("Invalid date field : " + str);
            }
            calendar.set(2, month - 1);
        }
        if (day == -1) return;
        if (day > 31 || day < 1) {
            throw new IllegalArgumentException("Invalid date field : " + str);
        }
        calendar.set(5, day);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setTimeField(Calendar now, Calendar calendar, String str) {
        String tmp = str;
        int index = tmp.lastIndexOf(58);
        int hour = -1;
        int minute = -1;
        int second = -1;
        if (index == -1) {
            if (!tmp.equals(NOW)) throw new IllegalArgumentException("Invalid time field : " + str);
            hour = now.get(11);
            minute = now.get(12);
            second = now.get(13);
        } else {
            if (index != tmp.length() - 1) {
                String secondStr = tmp.substring(index + 1).trim();
                second = secondStr.equals(NOW) ? now.get(13) : Integer.parseInt(secondStr);
            }
            if ((index = (tmp = tmp.substring(0, index).trim()).lastIndexOf(58)) == -1) {
                if (tmp.equals(NOW)) {
                    hour = now.get(11);
                } else if (tmp.length() != 0) {
                    hour = Integer.parseInt(tmp);
                }
                if (hour != -1) {
                    minute = second;
                    second = -1;
                }
            } else {
                if (index != tmp.length() - 1) {
                    String minuteStr = tmp.substring(index + 1).trim();
                    if (minuteStr.equals(NOW)) {
                        minute = now.get(12);
                    } else if (minuteStr.length() != 0) {
                        minute = Integer.parseInt(minuteStr);
                    }
                }
                if (index != (tmp = tmp.substring(0, index).trim()).length() - 1) {
                    if (tmp.equals(NOW)) {
                        hour = now.get(11);
                    } else if (tmp.length() != 0) {
                        hour = Integer.parseInt(tmp);
                    }
                }
            }
        }
        if (hour != -1) {
            if (hour > 24 || hour < 0) {
                throw new IllegalArgumentException("Invalid time field : " + str);
            }
            calendar.set(11, hour);
        }
        if (minute != -1) {
            if (minute > 59 || minute < 0) {
                throw new IllegalArgumentException("Invalid time field : " + str);
            }
            calendar.set(12, minute);
        }
        if (second == -1) return;
        if (second > 59 || second < 0) {
            throw new IllegalArgumentException("Invalid time field : " + str);
        }
        calendar.set(13, second);
    }

    private void setMillisField(Calendar now, Calendar calendar, String str) {
        String tmp = str.trim();
        if (tmp.length() != 0) {
            int millis = 0;
            millis = tmp.equals(NOW) ? now.get(14) : Integer.parseInt(tmp);
            if (millis > 999 || millis < 0) {
                throw new IllegalArgumentException("Invalid millis field : " + tmp);
            }
            calendar.set(14, millis);
        }
    }

    public String getAsText() {
        Date date = (Date)this.getValue();
        if (date == null) {
            return null;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(DATE_FORMAT);
        }
        return this.format.format(date);
    }
}

