/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.cache.TimeExpierOverflowValidatorServiceMBean;

public class TimeExpierOverflowValidatorService
extends ServiceBase
implements OverflowValidator,
CacheRemoveListener,
Serializable,
TimeExpierOverflowValidatorServiceMBean {
    private long expierTerm = -1L;
    private Map references;

    public void createService() throws Exception {
        this.references = Collections.synchronizedMap(new LinkedHashMap());
    }

    public void destroyService() throws Exception {
        this.reset();
        this.references = null;
    }

    public void setExpierTerm(long millis) throws IllegalArgumentException {
        this.expierTerm = millis;
    }

    public long getExpierTerm() {
        return this.expierTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validate() {
        if (this.references == null || this.references.size() == 0) {
            return 0;
        }
        Map map = this.references;
        synchronized (map) {
            Date date;
            if (this.getState() != 3) {
                return 0;
            }
            if (this.getExpierTerm() < 0L) {
                return 0;
            }
            long currentTime = System.currentTimeMillis();
            Object[] dates = this.references.values().toArray();
            int count = 0;
            for (count = 0; count < dates.length && currentTime >= (date = (Date)dates[count]).getTime() + this.expierTerm; ++count) {
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (!this.references.containsKey(ref)) {
                this.references.put(ref, new Date());
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Map map = this.references;
        synchronized (map) {
            if (this.references.containsKey(ref)) {
                this.references.remove(ref);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.references != null) {
            Map map = this.references;
            synchronized (map) {
                Object[] refs = this.references.keySet().toArray();
                for (int i = 0; i < refs.length; ++i) {
                    CachedReference ref = (CachedReference)refs[i];
                    this.remove(ref);
                }
                this.references.clear();
            }
        }
    }

    public void removed(CachedReference ref) {
        if (this.references == null) {
            return;
        }
        this.remove(ref);
    }
}

