/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerServiceMBean;

public class QueueHandlerContainerService
extends ServiceBase
implements QueueHandlerContainerServiceMBean {
    protected ServiceName queueServiceName;
    protected Queue requestQueue;
    protected Daemon[] daemons;
    protected QueueReceiver[] invokers;
    protected int queueHandlerSize = 1;
    protected ServiceName queueHandlerServiceName;
    protected QueueHandler queueHandler;
    protected String handlingErrorMessageId = "QHC__00001";

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setQueueHandlerServiceName(ServiceName name) {
        this.queueHandlerServiceName = name;
    }

    public ServiceName getQueueHandlerServiceName() {
        return this.queueHandlerServiceName;
    }

    public void setQueueHandlerSize(int size) {
        this.queueHandlerSize = size;
    }

    public int getQueueHandlerSize() {
        return this.queueHandlerSize;
    }

    public void setHandlingErrorMessageId(String id) {
        this.handlingErrorMessageId = id;
    }

    public String getHandlingErrorMessageId() {
        return this.handlingErrorMessageId;
    }

    public int getActiveQueueHandlerSize() {
        if (this.invokers == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.invokers.length; ++i) {
            if (!this.invokers[i].isActive) continue;
            ++count;
        }
        return count;
    }

    public void startService() throws Exception {
        if (this.getQueueServiceName() == null) {
            if (this.getQueueService() == null) {
                throw new IllegalArgumentException("Queue is null");
            }
        } else {
            this.setQueueService((Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName));
        }
        if (this.getQueueHandler() == null) {
            throw new IllegalArgumentException("QueueHandler is null.");
        }
        this.getQueueService().accept();
        if (this.queueHandlerSize < 0) {
            throw new IllegalArgumentException("queueHandlerSize < 0.");
        }
        this.invokers = new QueueReceiver[this.queueHandlerSize];
        this.daemons = new Daemon[this.queueHandlerSize];
        for (int i = 0; i < this.queueHandlerSize; ++i) {
            this.invokers[i] = new QueueReceiver();
            this.daemons[i] = new Daemon(this.invokers[i]);
            this.daemons[i].setName(this.getServiceNameObject() + " QueueReceiver" + (i + 1));
            this.daemons[i].start();
        }
    }

    public void stopService() throws Exception {
        this.getQueueService().release();
        for (int i = 0; i < this.daemons.length; ++i) {
            this.daemons[i].stop();
            this.daemons[i] = null;
            this.invokers[i] = null;
        }
        this.daemons = null;
        this.invokers = null;
    }

    public void setQueueService(Queue queue) {
        this.requestQueue = queue;
    }

    protected Queue getQueueService() {
        return this.requestQueue;
    }

    public void setQueueHandler(QueueHandler handler) {
        this.queueHandler = handler;
    }

    protected QueueHandler getQueueHandler() {
        if (this.queueHandler != null) {
            return this.queueHandler;
        }
        if (this.queueHandlerServiceName != null) {
            return (QueueHandler)ServiceManagerFactory.getServiceObject(this.queueHandlerServiceName);
        }
        return null;
    }

    protected class QueueReceiver
    implements DaemonRunnable {
        public boolean isActive;

        protected QueueReceiver() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) {
            return QueueHandlerContainerService.this.getQueueService().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(Object dequeued, DaemonControl ctrl) {
            QueueHandler handler = QueueHandlerContainerService.this.getQueueHandler();
            if (handler == null) {
                return;
            }
            try {
                this.isActive = true;
                try {
                    handler.handleDequeuedObject(dequeued);
                }
                catch (Throwable th) {
                    QueueHandlerContainerService.this.getLogger().write(QueueHandlerContainerService.this.handlingErrorMessageId, th);
                }
            }
            finally {
                this.isActive = false;
            }
        }

        public void garbage() {
            if (QueueHandlerContainerService.this.getQueueService() != null) {
                while (QueueHandlerContainerService.this.getQueueService().size() > 0) {
                    this.consume(QueueHandlerContainerService.this.getQueueService().get(0L), null);
                }
            }
        }
    }
}

