/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.MemoryCacheMapService;
import jp.ossc.nimbus.service.scheduler.DefaultScheduleStateManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler.ScheduleStateManager;

public class DefaultScheduleStateManagerService
extends ServiceBase
implements ScheduleStateManager,
DefaultScheduleStateManagerServiceMBean {
    protected ServiceName cacheMapServiceName;
    protected CacheMap stateManageMap;

    public void setCacheMapServiceName(ServiceName name) {
        this.cacheMapServiceName = name;
    }

    public ServiceName getCacheMapServiceName() {
        return this.cacheMapServiceName;
    }

    public void startService() throws Exception {
        if (this.stateManageMap == null) {
            if (this.cacheMapServiceName == null) {
                MemoryCacheMapService caheMap = new MemoryCacheMapService();
                caheMap.create();
                caheMap.start();
                this.stateManageMap = caheMap;
            } else {
                this.stateManageMap = (CacheMap)ServiceManagerFactory.getServiceObject(this.cacheMapServiceName);
            }
        }
    }

    public void setCacheMap(CacheMap map) {
        this.stateManageMap = map;
    }

    public CacheMap getCacheMap() {
        return this.stateManageMap;
    }

    public void changeState(String name, int state) {
        if (this.stateManageMap == null) {
            return;
        }
        this.stateManageMap.put(name, new Integer(state));
    }

    public int getState(String name) {
        if (this.stateManageMap == null) {
            return -1;
        }
        if (this.stateManageMap.containsKey(name)) {
            return (Integer)this.stateManageMap.get(name);
        }
        return -1;
    }

    public void clearState(String name) {
        if (this.stateManageMap == null) {
            return;
        }
        this.stateManageMap.remove(name);
    }

    public void clearAllStates() {
        if (this.stateManageMap == null) {
            return;
        }
        this.stateManageMap.clear();
    }
}

