/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected List waitThreads = new Vector();
    protected Set wakeUpThreads = Collections.synchronizedSet(new HashSet());
    protected List usedThreads = new Vector();
    protected long sleepTime = 10000L;

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        Thread current;
        block38: {
            boolean bl;
            block37: {
                boolean bl2;
                block36: {
                    boolean bl3;
                    block35: {
                        boolean bl4;
                        block34: {
                            List list;
                            boolean bl5;
                            block33: {
                                if (maxWaitCount > 0 && this.waitThreads.size() >= maxWaitCount) {
                                    return false;
                                }
                                current = Thread.currentThread();
                                if (this.waitThreads != null) {
                                    List list2 = this.waitThreads;
                                    synchronized (list2) {
                                        this.waitThreads.add(current);
                                        this.wakeUpThreads.add(current);
                                    }
                                }
                                long timeOutMs = -1L;
                                if (timeOutMiliSecond >= 0L) {
                                    timeOutMs = timeOutMiliSecond;
                                }
                                long processTime = 0L;
                                try {
                                    while (timeOutMs <= 0L || timeOutMs > processTime) {
                                        if (this.mFourceEndFlg) {
                                            bl5 = false;
                                            Object var15_12 = null;
                                            if (this.waitThreads == null) return bl5;
                                            list = this.waitThreads;
                                            break block33;
                                        }
                                        while (this.mResourceCnt == 0 && (timeOutMs < 0L || timeOutMs > processTime)) {
                                            if (this.mFourceEndFlg) {
                                                bl4 = false;
                                                break block34;
                                            }
                                            long proc = 0L;
                                            if (timeOutMs > 0L) {
                                                proc = System.currentTimeMillis();
                                            }
                                            try {
                                                if (!Thread.interrupted()) {
                                                    this.wakeUpThreads.remove(current);
                                                    Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                                                    this.wakeUpThreads.add(current);
                                                }
                                            }
                                            catch (InterruptedException e) {
                                                if (!this.wakeUpThreads.contains(current)) {
                                                    boolean bl6 = false;
                                                    Object var15_14 = null;
                                                    if (this.waitThreads == null) return bl6;
                                                    List list3 = this.waitThreads;
                                                    synchronized (list3) {
                                                        this.waitThreads.remove(current);
                                                        this.wakeUpThreads.remove(current);
                                                        return bl6;
                                                    }
                                                }
                                                Thread.interrupted();
                                            }
                                            if (timeOutMs <= 0L) continue;
                                            proc = System.currentTimeMillis() - proc;
                                            processTime += proc;
                                        }
                                        MemorySemaphore memorySemaphore = this;
                                        synchronized (memorySemaphore) {
                                            if (this.mFourceEndFlg) {
                                                bl3 = false;
                                                // MONITOREXIT @DISABLED, blocks:[1, 20, 10, 30] lbl66 : MonitorExitStatement: MONITOREXIT : var9_7
                                                break block35;
                                            }
                                            if (this.mResourceCnt > 0 && this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                                --this.mResourceCnt;
                                                this.usedThreads.add(current);
                                                bl2 = true;
                                                // MONITOREXIT @DISABLED, blocks:[1, 20, 10, 29] lbl74 : MonitorExitStatement: MONITOREXIT : var9_7
                                                break block36;
                                            }
                                            if (timeOutMs == 0L) {
                                                bl = false;
                                                // MONITOREXIT @DISABLED, blocks:[1, 20, 10, 28] lbl79 : MonitorExitStatement: MONITOREXIT : var9_7
                                                break block37;
                                            }
                                        }
                                    }
                                    break block38;
                                }
                                catch (Throwable throwable) {
                                    Object var15_19 = null;
                                    if (this.waitThreads == null) throw throwable;
                                    List list4 = this.waitThreads;
                                    synchronized (list4) {
                                        this.waitThreads.remove(current);
                                        this.wakeUpThreads.remove(current);
                                        throw throwable;
                                    }
                                }
                            }
                            synchronized (list) {
                                this.waitThreads.remove(current);
                                this.wakeUpThreads.remove(current);
                                return bl5;
                            }
                        }
                        Object var15_13 = null;
                        if (this.waitThreads == null) return bl4;
                        List list = this.waitThreads;
                        synchronized (list) {
                            this.waitThreads.remove(current);
                            this.wakeUpThreads.remove(current);
                            return bl4;
                        }
                    }
                    Object var15_15 = null;
                    if (this.waitThreads == null) return bl3;
                    List list = this.waitThreads;
                    synchronized (list) {
                        this.waitThreads.remove(current);
                        this.wakeUpThreads.remove(current);
                        return bl3;
                    }
                }
                Object var15_16 = null;
                if (this.waitThreads == null) return bl2;
                List list = this.waitThreads;
                synchronized (list) {
                    this.waitThreads.remove(current);
                    this.wakeUpThreads.remove(current);
                    return bl2;
                }
            }
            Object var15_17 = null;
            if (this.waitThreads == null) return bl;
            List list = this.waitThreads;
            synchronized (list) {
                this.waitThreads.remove(current);
                this.wakeUpThreads.remove(current);
                return bl;
            }
        }
        Object var15_18 = null;
        if (this.waitThreads == null) return false;
        List list = this.waitThreads;
        synchronized (list) {
            this.waitThreads.remove(current);
            this.wakeUpThreads.remove(current);
            return false;
        }
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource() {
        return this.getResource(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeResource() {
        Object object;
        Thread current = Thread.currentThread();
        if (this.usedThreads.contains(current)) {
            this.usedThreads.remove(current);
            if (this.mResourceCnt < this.mInitialResource) {
                object = this;
                synchronized (object) {
                    ++this.mResourceCnt;
                }
            }
        }
        object = this.waitThreads;
        synchronized (object) {
            Thread waitThread;
            if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                this.wakeUpThreads.add(waitThread);
                waitThread.interrupt();
            }
        }
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceRemain() {
        int cnt;
        MemorySemaphore memorySemaphore = this;
        synchronized (memorySemaphore) {
            cnt = this.mResourceCnt;
        }
        return cnt;
    }

    public int getWaitingCount() {
        return this.waitThreads.size();
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void release() {
        this.mFourceEndFlg = true;
        while (this.waitThreads.size() != 0) {
            this.freeResource();
        }
    }

    public void accept() {
        this.mFourceEndFlg = false;
    }
}

