/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.GenericsFactoryService;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;

public class GenericsServiceFactoryService
extends GenericsFactoryService {
    public void startService() throws Exception {
        super.startService();
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                service.start();
            }
        }
    }

    public void stopService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                service.stop();
            }
        }
        super.stopService();
    }

    public void destroyService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                service.destroy();
            }
        }
        super.destroyService();
    }

    public void setSystemLoggerServiceName(ServiceName name) {
        super.setSystemLoggerServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemLoggerServiceName(name);
            }
        }
    }

    public void setSystemMessageRecordFactoryServiceName(ServiceName name) {
        super.setSystemMessageRecordFactoryServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemMessageRecordFactoryServiceName(name);
            }
        }
    }

    protected Object createInstance() throws Exception {
        Service service = (Service)this.instantiateClass.newInstance();
        if (service == null) {
            return null;
        }
        if (this.isManagement() && this.getServiceManagerName() != null) {
            service.setServiceName(this.getServiceName() + '$' + this.getManagedInstanceSet().size());
            service.setServiceManagerName(this.getServiceManagerName());
        } else if (service instanceof ServiceBase) {
            ServiceBase base = (ServiceBase)service;
            if (this.manager != null) {
                base.logger.setDefaultLogger(this.manager.getLogger());
                if (this.getSystemLoggerServiceName() == null) {
                    base.logger.setLogger(this.manager.getLogger());
                }
                base.message.setDefaultMessageRecordFactory(this.manager.getMessageRecordFactory());
                if (this.getSystemMessageRecordFactoryServiceName() == null) {
                    base.message.setMessageRecordFactory(this.manager.getMessageRecordFactory());
                }
            }
            if (this.getSystemLoggerServiceName() != null) {
                base.setSystemLoggerServiceName(this.getSystemLoggerServiceName());
            }
            if (this.getSystemMessageRecordFactoryServiceName() != null) {
                base.setSystemMessageRecordFactoryServiceName(this.getSystemMessageRecordFactoryServiceName());
            }
        }
        service.create();
        this.setAttributes(service);
        service.start();
        return service;
    }

    public void release(Object obj) {
        Service service = (Service)obj;
        service.stop();
        service.destroy();
        super.release(service);
    }
}

