/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.Locale;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceStateBroadcaster;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.service.message.MessageRecord;
import jp.ossc.nimbus.service.message.MessageRecordFactory;

class MessageRecordFactoryWrapper
implements MessageRecordFactory,
ServiceStateListener,
Serializable {
    private MessageRecordFactory defaultMessage;
    private MessageRecordFactory currentMessage;

    public MessageRecordFactoryWrapper(MessageRecordFactory defaultMessage) {
        this(null, null, defaultMessage);
    }

    public MessageRecordFactoryWrapper(MessageRecordFactory message, Service messageService, MessageRecordFactory defaultMessage) {
        this.setDefaultMessageRecordFactory(defaultMessage);
        this.setMessageRecordFactory(message, messageService);
    }

    public void setDefaultMessageRecordFactory(MessageRecordFactory message) {
        if (message == this) {
            return;
        }
        this.defaultMessage = message;
    }

    public MessageRecordFactory getDefaultMessageRecordFactory() {
        return this.defaultMessage;
    }

    public void setMessageRecordFactory(MessageRecordFactory message) {
        this.setMessageRecordFactory(message, null);
    }

    public void setMessageRecordFactory(MessageRecordFactory message, Service messageService) {
        if (message == this) {
            return;
        }
        if (messageService != null) {
            this.currentMessage = messageService.getState() == 3 ? message : this.defaultMessage;
            try {
                ServiceStateBroadcaster broadcaster = ServiceManagerFactory.getServiceStateBroadcaster(messageService.getServiceManagerName(), messageService.getServiceName());
                if (broadcaster != null) {
                    broadcaster.addServiceStateListener(this);
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {}
        } else {
            this.currentMessage = message != null ? message : this.defaultMessage;
        }
    }

    public MessageRecordFactory getMessageRecordFactory() {
        return this.currentMessage;
    }

    public void stateChanged(ServiceStateChangeEvent e) throws Exception {
        Service service = e.getService();
        int state = service.getState();
        String managerName = service.getServiceManagerName();
        String serviceName = service.getServiceName();
        switch (state) {
            case 3: {
                this.currentMessage = (MessageRecordFactory)ServiceManagerFactory.getServiceObject(managerName, serviceName);
                break;
            }
            case 5: {
                this.currentMessage = this.defaultMessage;
                break;
            }
        }
    }

    public boolean isEnabledState(int state) {
        switch (state) {
            case 3: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public MessageRecord findMessageRecord(String key) {
        if (this.currentMessage != null) {
            return this.currentMessage.findMessageRecord(key);
        }
        return null;
    }

    public void findLocale(Locale locale) {
        if (this.currentMessage != null) {
            this.currentMessage.findLocale(locale);
        }
    }

    public String findMessageTemplete(String key) {
        if (this.currentMessage != null) {
            return this.currentMessage.findMessageTemplete(key);
        }
        return null;
    }

    public String findMessageTemplete(Locale lo, String key) {
        if (this.currentMessage != null) {
            return this.currentMessage.findMessageTemplete(lo, key);
        }
        return null;
    }

    public String findMessage(String key) {
        if (this.currentMessage != null) {
            return this.currentMessage.findMessage(key);
        }
        return null;
    }

    public String findMessage(Locale lo, String key) {
        if (this.currentMessage != null) {
            return this.currentMessage.findMessage(lo, key);
        }
        return null;
    }

    public String findEmbedMessage(String key, Object[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, byte[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, short[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, char[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, int[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, long[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, float[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, double[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, boolean[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, Object[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, byte[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, short[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, char[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, int[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, long[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, float[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, double[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, boolean[] embeds) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embeds);
        }
        return null;
    }

    public String findEmbedMessage(String key, Object embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, byte embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, short embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, char embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, int embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, long embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, float embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, double embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(String key, boolean embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, Object embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, byte embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, short embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, char embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, int embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, long embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, float embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, double embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }

    public String findEmbedMessage(Locale lo, String key, boolean embed) {
        if (this.currentMessage != null) {
            return this.currentMessage.findEmbedMessage(lo, key, embed);
        }
        return null;
    }
}

