/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CacheSizeOverflowValidatorServiceMBean;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.OverflowValidator;

public class CacheSizeOverflowValidatorService
extends ServiceBase
implements OverflowValidator,
CacheRemoveListener,
Serializable,
CacheSizeOverflowValidatorServiceMBean {
    private int maxSize;
    private Set references;

    public void createService() throws Exception {
        this.references = Collections.synchronizedSet(new HashSet());
    }

    public void destroyService() throws Exception {
        this.reset();
        this.references = null;
    }

    public void setMaxSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size : " + size);
        }
        this.maxSize = size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validate() {
        if (this.references == null || this.references.size() == 0) {
            return 0;
        }
        Set set = this.references;
        synchronized (set) {
            if (this.getState() != 3) {
                return 0;
            }
            if (this.getMaxSize() == 0) {
                return 0;
            }
            int overflowSize = this.references.size() - this.getMaxSize();
            int n = overflowSize > 0 ? overflowSize : 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Set set = this.references;
        synchronized (set) {
            if (!this.references.contains(ref)) {
                this.references.add(ref);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.references == null || ref == null) {
            return;
        }
        Set set = this.references;
        synchronized (set) {
            if (this.references.contains(ref)) {
                this.references.remove(ref);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.references != null) {
            Set set = this.references;
            synchronized (set) {
                Object[] refs = this.references.toArray();
                for (int i = 0; i < refs.length; ++i) {
                    CachedReference ref = (CachedReference)refs[i];
                    this.remove(ref);
                }
                this.references.clear();
            }
        }
    }

    public void removed(CachedReference ref) {
        if (this.references == null) {
            return;
        }
        this.remove(ref);
    }
}

