/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.DefaultOverflowControllerServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowAction;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;
import jp.ossc.nimbus.service.cache.OverflowController;
import jp.ossc.nimbus.service.cache.OverflowValidator;
import jp.ossc.nimbus.service.cache.RemoveOverflowActionService;
import jp.ossc.nimbus.service.queue.Queue;

public class DefaultOverflowControllerService
extends ServiceBase
implements OverflowController,
DaemonRunnable,
CacheRemoveListener,
DefaultOverflowControllerServiceMBean {
    protected ServiceName validatorServiceName;
    protected OverflowValidator validator;
    protected ServiceName algorithmServiceName;
    protected OverflowAlgorithm algorithm;
    protected ServiceName actionServiceName;
    protected OverflowAction action;
    protected RemoveOverflowActionService defaultAction;
    protected ServiceName queueServiceName;
    protected Queue queue;
    protected Daemon daemon;
    protected CachedReference dequeuedRef;
    protected Object lock = "lock";
    protected long periodicOverflowIntervalTime;
    protected long periodicOverflowInterval;

    public void setOverflowValidatorServiceName(ServiceName name) {
        this.validatorServiceName = name;
    }

    public ServiceName getOverflowValidatorServiceName() {
        return this.validatorServiceName;
    }

    public void setOverflowAlgorithmServiceName(ServiceName name) {
        this.algorithmServiceName = name;
    }

    public ServiceName getOverflowAlgorithmServiceName() {
        return this.algorithmServiceName;
    }

    public void setOverflowActionServiceName(ServiceName name) {
        this.actionServiceName = name;
    }

    public ServiceName getOverflowActionServiceName() {
        return this.actionServiceName;
    }

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setPeriodicOverflowIntervalTime(long time) {
        this.periodicOverflowIntervalTime = time;
    }

    public long getPeriodicOverflowIntervalTime() {
        return this.periodicOverflowIntervalTime;
    }

    public void setOverflowAction(OverflowAction action) {
        this.action = action;
    }

    public void setOverflowAlgorithm(OverflowAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public void setOverflowValidator(OverflowValidator validator) {
        this.validator = validator;
    }

    public void createService() throws Exception {
        this.daemon = new Daemon(this);
        this.daemon.setName("Nimbus OverflowControllerDaemon " + this.getServiceNameObject());
    }

    public void startService() throws Exception {
        if (this.validatorServiceName != null) {
            this.validator = (OverflowValidator)ServiceManagerFactory.getServiceObject(this.validatorServiceName);
        }
        if (this.algorithmServiceName != null) {
            this.algorithm = (OverflowAlgorithm)ServiceManagerFactory.getServiceObject(this.algorithmServiceName);
        }
        if (this.validator != null && this.algorithm == null) {
            throw new IllegalArgumentException("OverflowAlgorithm must specify when OverflowValidator is specified.");
        }
        this.action = this.actionServiceName != null ? (OverflowAction)ServiceManagerFactory.getServiceObject(this.actionServiceName) : this.getDefaultOverflowActionService();
        this.action.setOverflowController(this);
        if (this.queueServiceName != null) {
            this.queue = (Queue)ServiceManagerFactory.getServiceObject(this.queueServiceName);
        }
        if (this.periodicOverflowIntervalTime > 0L) {
            this.periodicOverflowInterval = this.periodicOverflowIntervalTime;
        }
        if (this.queue != null || this.periodicOverflowInterval > 0L) {
            this.queue.accept();
            this.daemon.start();
        }
    }

    public void stopService() throws Exception {
        if (this.queue != null || this.periodicOverflowInterval > 0L) {
            this.queue.release();
            this.daemon.stop();
        }
        this.validator = null;
        this.algorithm = null;
        if (this.defaultAction != null && this.action == this.defaultAction) {
            this.defaultAction.stop();
        }
        this.action = null;
        this.queue = null;
    }

    public void destroyService() throws Exception {
        if (this.defaultAction != null) {
            this.defaultAction.destroy();
            this.defaultAction = null;
        }
        this.daemon = null;
    }

    protected OverflowAction getDefaultOverflowActionService() throws Exception {
        if (this.defaultAction == null) {
            RemoveOverflowActionService act = new RemoveOverflowActionService();
            act.create();
            act.start();
            this.defaultAction = act;
        } else if (this.defaultAction.getState() != 3) {
            this.defaultAction.start();
        }
        return this.defaultAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void control(CachedReference ref) {
        if (this.getState() != 3) {
            return;
        }
        if (ref != null) {
            ref.addCacheRemoveListener(this);
        }
        if (this.queue == null) {
            Object object = this.lock;
            synchronized (object) {
                this.dequeuedRef = ref;
            }
            this.consume(ref, this.daemon);
        } else {
            this.queue.push(ref);
        }
    }

    public void reset() {
        if (this.validator != null) {
            this.validator.reset();
        }
        if (this.algorithm != null) {
            this.algorithm.reset();
        }
        if (this.action != null) {
            this.action.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(CachedReference ref) {
        if (ref == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dequeuedRef != null && this.dequeuedRef.equals(ref)) {
                this.dequeuedRef = null;
            }
        }
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object provide(DaemonControl ctrl) {
        if (this.queue == null || this.getState() != 3) {
            return null;
        }
        if (this.queue == null) {
            try {
                Thread.sleep(this.periodicOverflowInterval);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Object e = this.lock;
            synchronized (e) {
                this.dequeuedRef = null;
            }
        }
        CachedReference ref = null;
        ref = this.periodicOverflowInterval > 0L ? (CachedReference)this.queue.get(this.periodicOverflowInterval) : (CachedReference)this.queue.get();
        Object object = this.lock;
        synchronized (object) {
            this.dequeuedRef = ref != null && ref.isRemoved() ? null : ref;
        }
        return this.dequeuedRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Object dequeued, DaemonControl ctrl) {
        if (this.validator == null || this.getState() != 3) {
            return;
        }
        int overflowSize = 0;
        Object object = this.lock;
        synchronized (object) {
            if (this.dequeuedRef != null && !this.dequeuedRef.isRemoved()) {
                this.dequeuedRef.removeCacheRemoveListener(this);
            }
            if (this.dequeuedRef != null && !this.dequeuedRef.isRemoved() && this.validator != null) {
                this.validator.add(this.dequeuedRef);
            }
            overflowSize = this.validator.validate();
            if (this.dequeuedRef != null && !this.dequeuedRef.isRemoved() && this.algorithm != null) {
                this.algorithm.add(this.dequeuedRef);
            }
        }
        while (overflowSize > 0) {
            CachedReference overflowRef = null;
            if (this.algorithm != null) {
                overflowRef = this.algorithm.overflow();
            }
            if (overflowRef == null) break;
            if (overflowRef.isRemoved()) continue;
            if (this.validator != null) {
                this.validator.remove(overflowRef);
            }
            if (overflowRef != null && this.action != null && !overflowRef.isRemoved()) {
                this.action.action(this.validator, this.algorithm, overflowRef);
            }
            if (this.validator != null) {
                overflowSize = this.validator.validate();
                continue;
            }
            overflowSize = 0;
        }
        object = this.lock;
        synchronized (object) {
            this.dequeuedRef = null;
        }
    }

    public void garbage() {
        if (this.queue != null) {
            while (this.queue.size() > 0) {
                this.consume(this.queue.get(0L), this.daemon);
            }
        }
    }
}

