/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall.interceptor;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.FacadeValue;
import jp.ossc.nimbus.service.aspect.interfaces.Interceptor;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChain;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.ioccall.interceptor.DefaultAsynchCallInterceptorServiceMBean;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.jmsqueue.QueueTransanctionResource;

public class DefaultAsynchCallInterceptorService
extends ServiceBase
implements DefaultAsynchCallInterceptorServiceMBean,
Interceptor {
    private ServiceName queueSessionFactoryServiceName;
    private ResourceFactory queueSessionFactory;
    private String deliveryModeStr = "PERSISTENT";
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private boolean isIgnoreRedelivery;

    public void setQueueSessionFactoryServiceName(ServiceName name) {
        this.queueSessionFactoryServiceName = name;
    }

    public ServiceName getQueueSessionFactoryServiceName() {
        return this.queueSessionFactoryServiceName;
    }

    public void setDeliveryMode(String mode) {
        if ("PERSISTENT".equals(mode)) {
            this.deliveryMode = 2;
        } else if ("NON_PERSISTENT".equals(mode)) {
            this.deliveryMode = 1;
        } else {
            throw new IllegalArgumentException(mode);
        }
        this.deliveryModeStr = mode;
    }

    public String getDeliveryMode() {
        return this.deliveryModeStr;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setTimeToLive(long millis) {
        this.timeToLive = millis;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setIgnoreRedelivery(boolean ignore) {
        this.isIgnoreRedelivery = ignore;
    }

    public boolean isIgnoreRedelivery() {
        return this.isIgnoreRedelivery;
    }

    public void setQueueSessionResourceFactory(ResourceFactory factory) {
        this.queueSessionFactory = factory;
    }

    public void startService() throws Exception {
        if (this.queueSessionFactoryServiceName != null) {
            this.queueSessionFactory = (ResourceFactory)ServiceManagerFactory.getServiceObject(this.queueSessionFactoryServiceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invokeChain(Object inputObj, InterceptorChain interceptChain) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        Object ret = null;
        if (!(inputObj instanceof ObjectMessage)) return interceptChain.invokeChain(inputObj);
        ObjectMessage msg = (ObjectMessage)inputObj;
        FacadeValue in = null;
        if (this.isIgnoreRedelivery) {
            try {
                if (msg.getJMSRedelivered()) {
                    return ret;
                }
            }
            catch (JMSException e) {
                throw new InterceptorException("getJMSRedelivered JMSException", e);
            }
        }
        try {
            in = (FacadeValue)msg.getObject();
        }
        catch (JMSException e) {
            throw new InterceptorException("getObject JMSException", e);
        }
        try {
            ret = interceptChain.invokeChain(in);
        }
        catch (TargetUncheckedException e) {
            Throwable th = e.getCause();
            if (!(th instanceof RuntimeException)) throw new InterceptorException("Unexpected Exception", th);
            ret = th;
        }
        catch (TargetCheckedException e) {
            e.printStackTrace();
        }
        if (this.queueSessionFactory == null) return ret;
        try {
            Queue replyQueue = (Queue)msg.getJMSReplyTo();
            if (replyQueue == null) return ret;
            QueueTransanctionResource resource = null;
            try {
                resource = (QueueTransanctionResource)this.queueSessionFactory.makeResource(null);
                QueueSession session = (QueueSession)resource.getObject();
                QueueSender sender = session.createSender(replyQueue);
                sender.send((Message)session.createObjectMessage((Serializable)ret), this.deliveryMode, this.priority, this.timeToLive);
                return ret;
            }
            finally {
                if (resource != null) {
                    resource.close();
                }
            }
        }
        catch (Exception e) {
            throw new InterceptorException("Unexpected Exception", e);
        }
    }
}

