/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.scheduler.KeyMappingScheduleFactoryServiceMBean;
import jp.ossc.nimbus.service.scheduler.Schedule;
import jp.ossc.nimbus.service.scheduler.ScheduleFactory;

public class KeyMappingScheduleFactoryService
extends ServiceBase
implements KeyMappingScheduleFactoryServiceMBean,
ScheduleFactory {
    protected String[] keyAndScheduleFactoryServiceName;
    protected Map attrKeyAndScheduleFactory;
    protected Map keyAndScheduleFactory;
    protected ServiceName defaultScheduleFactoryServiceName;
    protected ScheduleFactory defaultScheduleFactory;

    public void setKeyAndScheduleFactoryServiceName(String[] mapping) {
        this.keyAndScheduleFactoryServiceName = mapping;
    }

    public String[] getKeyAndScheduleFactoryServiceName() {
        return this.keyAndScheduleFactoryServiceName;
    }

    public void setDefaultScheduleFactoryServiceName(ServiceName name) {
        this.defaultScheduleFactoryServiceName = name;
    }

    public ServiceName getDefaultScheduleFactoryServiceName() {
        return this.defaultScheduleFactoryServiceName;
    }

    public void createService() throws Exception {
        this.keyAndScheduleFactory = new HashMap();
    }

    public void startService() throws Exception {
        if (this.keyAndScheduleFactoryServiceName != null) {
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            for (int i = 0; i < this.keyAndScheduleFactoryServiceName.length; ++i) {
                String tmp = this.keyAndScheduleFactoryServiceName[i];
                int index = tmp.indexOf(61);
                if (index == -1 || index == tmp.length() - 1) {
                    throw new IllegalArgumentException("keyAndScheduleFactoryServiceName is \"key=ScheduleFactoryServiceName\"." + tmp);
                }
                String key = tmp.substring(0, index);
                String nameStr = tmp.substring(index + 1);
                editor.setAsText(nameStr);
                ServiceName name = (ServiceName)editor.getValue();
                ScheduleFactory factory = (ScheduleFactory)ServiceManagerFactory.getServiceObject(name);
                this.keyAndScheduleFactory.put(this.createKey(key), factory);
            }
        }
        if (this.attrKeyAndScheduleFactory != null) {
            Iterator keys = this.attrKeyAndScheduleFactory.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                ScheduleFactory factory = (ScheduleFactory)this.attrKeyAndScheduleFactory.get(key);
                this.keyAndScheduleFactory.put(this.createKey(key), factory);
            }
        }
        if (this.defaultScheduleFactoryServiceName != null) {
            this.defaultScheduleFactory = (ScheduleFactory)ServiceManagerFactory.getServiceObject(this.defaultScheduleFactoryServiceName);
        }
    }

    public void stopService() throws Exception {
        this.keyAndScheduleFactory.clear();
    }

    public void destroyService() throws Exception {
        this.keyAndScheduleFactory = null;
    }

    protected Object createKey(Object key) throws Exception {
        return key;
    }

    public void setKeyAndScheduleFactory(Map mapping) {
        this.attrKeyAndScheduleFactory = mapping;
    }

    public Schedule[] getSchedules(Object key) {
        ScheduleFactory factory = (ScheduleFactory)this.keyAndScheduleFactory.get(key);
        if (factory == null && this.defaultScheduleFactory != null) {
            factory = this.defaultScheduleFactory;
        }
        return factory == null ? new Schedule[]{} : factory.getSchedules(key);
    }
}

