/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.writer.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.jms.JMSMessageProducerFactory;
import jp.ossc.nimbus.service.writer.MessageWriteException;
import jp.ossc.nimbus.service.writer.WritableRecord;
import jp.ossc.nimbus.service.writer.jms.DestinationWriterServiceMBean;
import jp.ossc.nimbus.service.writer.jms.MessageCreator;
import jp.ossc.nimbus.service.writer.jms.ObjectMessageCreator;

public class DestinationWriterService
extends ServiceBase
implements DestinationWriterServiceMBean {
    private static final String JMSDW = "JMSDW";
    private static final String JMSDW0 = "JMSDW0";
    private static final String JMSDW00 = "JMSDW00";
    private static final String JMSDW000 = "JMSDW000";
    private static final String JMSDW0000 = "JMSDW0000";
    private static final String JMSDW00001 = "JMSDW00001";
    private static final String JMSDW00002 = "JMSDW00002";
    private static final String JMSDW00003 = "JMSDW00003";
    private static final String JMSDW00004 = "JMSDW00004";
    protected static final String DEFAULT_MSG_CREATOR_CLASS_NAME = ObjectMessageCreator.class.getName();
    protected ServiceName jmsMessageProducerFactoryServiceName;
    protected JMSMessageProducerFactory messageProducerFactory;
    protected MessageProducer messageProducer;
    protected ServiceName jmsMessageCreatorServiceName;
    protected String jmsMessageCreatorClassName = DEFAULT_MSG_CREATOR_CLASS_NAME;
    protected MessageCreator messageCreator;
    protected int priority = 4;
    protected String deliveryMode;
    protected int delivery = 2;
    protected long lifeTime = 0L;

    public void setJMSMessageProducerFactoryServiceName(ServiceName name) {
        this.jmsMessageProducerFactoryServiceName = name;
    }

    public ServiceName getJMSMessageProducerFactoryServiceName() {
        return this.jmsMessageProducerFactoryServiceName;
    }

    public void setJMSMessageCreatorServiceName(ServiceName name) {
        this.jmsMessageCreatorServiceName = name;
    }

    public ServiceName getJMSMessageCreatorServiceName() {
        return this.jmsMessageCreatorServiceName;
    }

    public void setJMSMessageCreatorClassName(String name) {
        this.jmsMessageCreatorClassName = name;
    }

    public String getJMSMessageCreatorClassName() {
        return this.jmsMessageCreatorClassName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setDeliveryMode(String mode) throws IllegalArgumentException {
        this.deliveryMode = mode;
        if ("NON_PERSISTENT".equals(this.deliveryMode)) {
            this.delivery = 1;
        } else if ("PERSISTENT".equals(this.deliveryMode)) {
            this.delivery = 2;
        } else {
            throw new IllegalArgumentException("Unsupported delivery mode : " + mode);
        }
    }

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setJMSMessageProducerFactory(JMSMessageProducerFactory fac) {
        this.messageProducerFactory = fac;
    }

    public void setJMSMessageCreator(MessageCreator creator) {
        this.messageCreator = creator;
    }

    public void startService() throws Exception {
        if (this.jmsMessageProducerFactoryServiceName != null) {
            this.messageProducerFactory = (JMSMessageProducerFactory)ServiceManagerFactory.getServiceObject(this.jmsMessageProducerFactoryServiceName);
        }
        if (this.messageProducerFactory == null) {
            throw new IllegalArgumentException("JMSMessageProducerFactory is null");
        }
        this.messageProducer = this.messageProducerFactory.createProducer();
        if (this.jmsMessageCreatorServiceName != null) {
            this.messageCreator = (MessageCreator)ServiceManagerFactory.getServiceObject(this.jmsMessageCreatorServiceName);
        }
        if (this.messageCreator == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(this.jmsMessageCreatorClassName, true, NimbusClassLoader.getInstance());
            this.messageCreator = (MessageCreator)clazz.newInstance();
        }
    }

    public void stopService() throws Exception {
        try {
            this.messageProducer.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.messageProducer = null;
    }

    public void write(WritableRecord rec) throws MessageWriteException {
        Session session = this.messageProducerFactory.getSession();
        Message message = null;
        try {
            message = this.messageCreator.createMessage(session, rec);
        }
        catch (Exception e) {
            this.getLogger().write(JMSDW00001, e);
            throw new MessageWriteException(e);
        }
        try {
            if (message != null) {
                this.send(message);
            }
        }
        catch (JMSException e) {
            this.getLogger().write(JMSDW00002, e);
            try {
                session.rollback();
            }
            catch (Exception ex) {
                this.getLogger().write(JMSDW00003, ex);
            }
            throw new MessageWriteException(e);
        }
        try {
            session.commit();
        }
        catch (Exception e) {
            this.getLogger().write(JMSDW00004, e);
            throw new MessageWriteException(e);
        }
    }

    protected void send(Message message) throws JMSException {
        this.messageProducer.send(message, this.delivery, this.priority, this.lifeTime);
    }
}

