/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.AbstractTickUnitAdjusterServiceMBean;
import jp.ossc.nimbus.service.graph.TickUnitAdjustCommonDivisorMap;
import jp.ossc.nimbus.service.graph.TickUnitAdjuster;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;

public abstract class AbstractTickUnitAdjusterService
extends ServiceBase
implements TickUnitAdjuster,
AbstractTickUnitAdjusterServiceMBean {
    protected int displayGraduationCount;
    protected double unitCountCommonDivisor = Double.NaN;
    protected boolean isDomain;
    protected int axisIndex = -1;
    protected ServiceName tickUnitAdjustCommonDivisorMapServiceName;
    protected TickUnitAdjustCommonDivisorMap tickUnitAdjustCommonDivisorMap;
    protected boolean autoRangeMinimumSizeEnabled;

    public void setDisplayGraduationCount(int count) {
        this.displayGraduationCount = count;
    }

    public int getDisplayGraduationCount() {
        return this.displayGraduationCount;
    }

    public void setUnitCountCommonDivisor(double divisor) {
        this.unitCountCommonDivisor = divisor;
    }

    public double getUnitCountCommonDivisor() {
        return this.unitCountCommonDivisor;
    }

    public void setDomain(boolean isDomain) {
        this.isDomain = isDomain;
    }

    public boolean isDomain() {
        return this.isDomain;
    }

    public void setAxisIndex(int index) {
        this.axisIndex = index;
    }

    public int getAxisIndex() {
        return this.axisIndex;
    }

    public void setAutoRangeMinimumSizeEnabled(boolean enabled) {
        this.autoRangeMinimumSizeEnabled = enabled;
    }

    public boolean getAutoRangeMinimumSizeEnabled() {
        return this.autoRangeMinimumSizeEnabled;
    }

    public void setTickUnitAdjustCommonDivisorMapServiceName(ServiceName serviceName) {
        this.tickUnitAdjustCommonDivisorMapServiceName = serviceName;
    }

    public ServiceName getTickUnitAdjustCommonDivisorMapServiceName() {
        return this.tickUnitAdjustCommonDivisorMapServiceName;
    }

    public void createService() throws Exception {
    }

    public void startService() throws Exception {
        if (this.displayGraduationCount <= 0) {
            throw new IllegalArgumentException("displayGraduationCount must be specified.");
        }
        if (this.axisIndex < 0) {
            throw new IllegalArgumentException("axisIndex must be specified.");
        }
        if (this.tickUnitAdjustCommonDivisorMapServiceName != null) {
            this.tickUnitAdjustCommonDivisorMap = (TickUnitAdjustCommonDivisorMap)ServiceManagerFactory.getServiceObject(this.tickUnitAdjustCommonDivisorMapServiceName);
        }
    }

    public void stopService() throws Exception {
    }

    public void destroyService() throws Exception {
    }

    public void adjust(XYPlot xyPlot) {
        ValueAxis axis = null;
        axis = this.isDomain() ? xyPlot.getDomainAxis(this.getAxisIndex()) : xyPlot.getRangeAxis(this.getAxisIndex());
        this.adjust(axis);
    }

    protected double adjustUnitCountByCommonDivisor(ValueAxis axis, double unitCount) {
        double commonDivisor = this.unitCountCommonDivisor;
        if (this.tickUnitAdjustCommonDivisorMap != null) {
            commonDivisor = this.tickUnitAdjustCommonDivisorMap.getCommonDivisor(axis.getRange().getLowerBound());
        }
        if (!Double.isNaN(commonDivisor) && unitCount % commonDivisor != 0.0) {
            unitCount += commonDivisor - unitCount % commonDivisor;
        }
        return unitCount;
    }

    protected abstract void adjust(ValueAxis var1);
}

