/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.DatabaseDatasetFactoryService;
import jp.ossc.nimbus.service.graph.DatabaseOHLCDatasetFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.OHLCDataItem;

public class DatabaseOHLCDatasetFactoryService
extends DatabaseDatasetFactoryService
implements DatabaseOHLCDatasetFactoryServiceMBean {
    private String dateFormatPattern;
    private String dateColumnName;
    private String timeColumnName;
    private String openPriceColumnName;
    private String highPriceColumnName;
    private String lowPriceColumnName;
    private String closePriceColumnName;
    private String volumeColumnName;
    private int dateColumnIndex = -1;
    private int timeColumnIndex = -1;
    private int openPriceColumnIndex = -1;
    private int highPriceColumnIndex = -1;
    private int lowPriceColumnIndex = -1;
    private int closePriceColumnIndex = -1;
    private int volumeColumnIndex = -1;
    private ServiceName dateFormatServiceName;

    public void createService() throws Exception {
        super.createService();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.dateFormatPattern != null) {
            new SimpleDateFormat(this.dateFormatPattern);
        }
        if (this.dateColumnName == null && this.dateColumnIndex <= 0 && this.timeColumnName == null && this.timeColumnIndex <= 0) {
            throw new IllegalArgumentException("dateColumnName or dateColumnIndex or timeColumnName or timeColumnIndex must be specified.");
        }
        if (this.openPriceColumnName == null && this.openPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("openPriceColumnName or openPriceColumnIndex must be specified.");
        }
        if (this.highPriceColumnName == null && this.highPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("highPriceColumnName or highPriceColumnIndex must be specified.");
        }
        if (this.lowPriceColumnName == null && this.lowPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("lowPriceColumnName or lowPriceColumnIndex must be specified.");
        }
        if (this.closePriceColumnName == null && this.closePriceColumnIndex <= 0) {
            throw new IllegalArgumentException("closePriceColumnName or closePriceColumnIndex must be specified.");
        }
    }

    public void stopService() throws Exception {
        super.stopService();
    }

    public void destroyService() throws Exception {
        super.destroyService();
    }

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    public String getDateColumnName() {
        return this.dateColumnName;
    }

    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    public void setOpenPriceColumnName(String columnName) {
        this.openPriceColumnName = columnName;
    }

    public String getOpenPriceColumnName() {
        return this.openPriceColumnName;
    }

    public void setHighPriceColumnName(String columnName) {
        this.highPriceColumnName = columnName;
    }

    public String getHighPriceColumnName() {
        return this.highPriceColumnName;
    }

    public void setLowPriceColumnName(String columnName) {
        this.lowPriceColumnName = columnName;
    }

    public String getLowPriceColumnName() {
        return this.lowPriceColumnName;
    }

    public void setClosePriceColumnName(String columnName) {
        this.closePriceColumnName = columnName;
    }

    public String getClosePriceColumnName() {
        return this.closePriceColumnName;
    }

    public void setVolumeColumnName(String columnName) {
        this.volumeColumnName = columnName;
    }

    public String getVolumeColumnName() {
        return this.volumeColumnName;
    }

    public void setDateColumnIndex(int index) {
        this.dateColumnIndex = index;
    }

    public int getDateColumnIndex() {
        return this.dateColumnIndex;
    }

    public void setTimeColumnIndex(int index) {
        this.timeColumnIndex = index;
    }

    public int getTimeColumnIndex() {
        return this.timeColumnIndex;
    }

    public void setOpenPriceColumnIndex(int index) {
        this.openPriceColumnIndex = index;
    }

    public int getOpenPriceColumnIndex() {
        return this.openPriceColumnIndex;
    }

    public void setHighPriceColumnIndex(int index) {
        this.highPriceColumnIndex = index;
    }

    public int getHighPriceColumnIndex() {
        return this.highPriceColumnIndex;
    }

    public void setLowPriceColumnIndex(int index) {
        this.lowPriceColumnIndex = index;
    }

    public int getLowPriceColumnIndex() {
        return this.lowPriceColumnIndex;
    }

    public void setClosePriceColumnIndex(int index) {
        this.closePriceColumnIndex = index;
    }

    public int getClostePriceColumnIndex() {
        return this.closePriceColumnIndex;
    }

    public void setVolumeColumnIndex(int index) {
        this.volumeColumnIndex = index;
    }

    public int getVolumeColumnIndex() {
        return this.volumeColumnIndex;
    }

    public void setDateFormatServiceName(ServiceName serviceName) {
        this.dateFormatServiceName = serviceName;
    }

    public ServiceName getDateFormatServiceName() {
        return this.dateFormatServiceName;
    }

    protected Dataset createDataset(DatasetCondition[] dsConditions, String[] seriesArray, ResultSet[] rSets) throws DatasetCreateException {
        if (seriesArray == null || seriesArray.length == 0 || rSets == null || rSets.length == 0) {
            return null;
        }
        String series = seriesArray[0];
        ResultSet rs = rSets[0];
        return new DefaultOHLCDataset((Comparable)((Object)series), this.createDataItems(dsConditions, series, rs));
    }

    protected OHLCDataItem[] createDataItems(DatasetCondition[] dsConditions, String series, ResultSet rs) throws DatasetCreateException {
        DateFormat dateFormat = null;
        if (this.dateFormatServiceName != null) {
            dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(this.dateFormatServiceName);
        } else if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        ArrayList<OHLCDataItem> list = new ArrayList<OHLCDataItem>();
        try {
            while (rs.next()) {
                Date date = null;
                double openPrice = 0.0;
                double highPrice = 0.0;
                double lowPrice = 0.0;
                double closePrice = 0.0;
                double volume = 0.0;
                if (dateFormat != null) {
                    String dateStr = null;
                    String dateVal = null;
                    String timeVal = null;
                    if (this.dateColumnIndex > 0) {
                        dateVal = rs.getString(this.dateColumnIndex);
                    } else if (this.dateColumnName != null) {
                        dateVal = rs.getString(this.dateColumnName);
                    }
                    if (this.timeColumnIndex > 0) {
                        timeVal = rs.getString(this.timeColumnIndex);
                    } else if (this.timeColumnName != null) {
                        timeVal = rs.getString(this.timeColumnName);
                    }
                    boolean isTimeOnly = false;
                    if (dateVal != null && timeVal != null) {
                        dateStr = dateVal + timeVal;
                    } else if (dateVal != null) {
                        dateStr = dateVal;
                    } else {
                        dateStr = timeVal;
                        isTimeOnly = true;
                    }
                    date = dateFormat.parse(dateStr);
                    if (isTimeOnly) {
                        Calendar cal = Calendar.getInstance();
                        int year = cal.get(1);
                        int month = cal.get(2);
                        int day = cal.get(5);
                        cal.clear();
                        cal.setTime(date);
                        cal.set(1, year);
                        cal.set(2, month);
                        cal.set(5, day);
                        date = cal.getTime();
                    }
                } else if (this.dateColumnIndex > 0) {
                    date = rs.getDate(this.dateColumnIndex);
                } else if (this.dateColumnName != null) {
                    date = rs.getDate(this.dateColumnName);
                }
                if (date == null) {
                    throw new DatasetCreateException("date is null.");
                }
                if (this.openPriceColumnIndex > 0) {
                    openPrice = rs.getDouble(this.openPriceColumnIndex);
                } else if (this.openPriceColumnName != null) {
                    openPrice = rs.getDouble(this.openPriceColumnName);
                }
                if (rs.wasNull()) continue;
                if (this.highPriceColumnIndex > 0) {
                    highPrice = rs.getDouble(this.highPriceColumnIndex);
                } else if (this.highPriceColumnName != null) {
                    highPrice = rs.getDouble(this.highPriceColumnName);
                }
                if (rs.wasNull()) continue;
                if (this.lowPriceColumnIndex > 0) {
                    lowPrice = rs.getDouble(this.lowPriceColumnIndex);
                } else if (this.lowPriceColumnName != null) {
                    lowPrice = rs.getDouble(this.lowPriceColumnName);
                }
                if (rs.wasNull()) continue;
                if (this.closePriceColumnIndex > 0) {
                    closePrice = rs.getDouble(this.closePriceColumnIndex);
                } else if (this.closePriceColumnName != null) {
                    closePrice = rs.getDouble(this.closePriceColumnName);
                }
                if (rs.wasNull()) continue;
                if (this.volumeColumnIndex > 0) {
                    volume = rs.getDouble(this.volumeColumnIndex);
                } else if (this.volumeColumnName != null) {
                    volume = rs.getDouble(this.volumeColumnName);
                }
                if (rs.wasNull()) continue;
                OHLCDataItem item = new OHLCDataItem(date, openPrice, highPrice, lowPrice, closePrice, volume);
                list.add(item);
            }
        }
        catch (SQLException e) {
            throw new DatasetCreateException(e);
        }
        catch (ParseException e) {
            throw new DatasetCreateException(e);
        }
        return list.toArray(new OHLCDataItem[list.size()]);
    }
}

