/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveDaemonServiceMBean;
import jp.ossc.nimbus.util.CsvArrayList;

public class KeepAliveDaemonService
extends ServiceBase
implements KeepAliveDaemonServiceMBean,
DaemonRunnable {
    private static final String C_NAME = "Server name: ";
    private static final String C_STATUS = "status : ";
    private static final String C_RUNNING = "running";
    private static final String C_STOP = "stop";
    private static final String C_ALIVEKEY = "KEEPALIVE001";
    private static final String C_DEADKEY = "KEEPALIVE002";
    protected Hashtable mServerTbl = new Hashtable();
    protected Boolean mSyncObj = new Boolean(true);
    protected List mCheckerList = new ArrayList();
    protected volatile long mInterval;
    protected Daemon mDaemon;
    protected volatile int mRoundRobin;
    protected String aliveLogMessageId = "KEEPALIVE001";
    protected String deadLogMessageId = "KEEPALIVE002";
    protected boolean isOutputAliveLogMessage = true;
    protected boolean isOutputDeadLogMessage = true;

    public void createService() throws Exception {
        this.mDaemon = new Daemon(this);
        this.mDaemon.setName(this.getServiceName());
    }

    public void startService() throws Exception {
        this.mDaemon.start();
    }

    public void stopService() throws Exception {
        this.mDaemon.stop();
    }

    public void destroyService() throws Exception {
        this.mDaemon = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChekerServiceNames(ServiceName[] serviceNames) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            this.mCheckerList.clear();
            for (int cnt = 0; cnt < serviceNames.length; ++cnt) {
                this.mCheckerList.add(serviceNames[cnt]);
            }
        }
    }

    public ServiceName[] getChekerServiceNames() {
        return this.mCheckerList.toArray(new ServiceName[this.mCheckerList.size()]);
    }

    public void setIntervalTimeMillis(long miliseconds) {
        this.mInterval = miliseconds;
    }

    public long getIntervalTimeMillis() {
        return this.mInterval;
    }

    public String[] getStatusString() {
        CsvArrayList ret = new CsvArrayList();
        Map keepAlive = this.getKeepAliveMap();
        Iterator keys = keepAlive.keySet().iterator();
        while (keys.hasNext()) {
            String serverId = (String)keys.next();
            String servername = C_NAME + serverId;
            String status = C_STATUS;
            status = Boolean.TRUE.equals((Boolean)keepAlive.get(serverId)) ? status + C_RUNNING : status + C_STOP;
            ret.add(servername);
            ret.add(status);
        }
        return ret.toStringAry();
    }

    public void setAliveLogMessageId(String id) {
        this.aliveLogMessageId = id;
    }

    public String getAliveLogMessageId() {
        return this.aliveLogMessageId;
    }

    public void setDeadLogMessageId(String id) {
        this.deadLogMessageId = id;
    }

    public String getDeadLogMessageId() {
        return this.deadLogMessageId;
    }

    public void setOutputAliveLogMessage(boolean isOutput) {
        this.isOutputAliveLogMessage = isOutput;
    }

    public boolean isOutputAliveLogMessage() {
        return this.isOutputAliveLogMessage;
    }

    public void setOutputDeadLogMessage(boolean isOutput) {
        this.isOutputDeadLogMessage = isOutput;
    }

    public boolean isOutputDeadLogMessage() {
        return this.isOutputDeadLogMessage;
    }

    public boolean onStart() {
        Iterator iterator = this.mCheckerList.iterator();
        while (iterator.hasNext()) {
            ServiceName name = (ServiceName)iterator.next();
            KeepAliveChecker kac = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(name);
            boolean bret = kac.isAlive();
            this.updateTblStructure(name, bret);
        }
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Exception {
        Thread.sleep(this.mInterval);
        return null;
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        this.onStart();
    }

    public void garbage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTblStructure(Object msid, boolean keepAlive) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            Boolean bret = (Boolean)this.mServerTbl.get(msid);
            if (bret != null) {
                if (!bret.booleanValue() && keepAlive && this.isOutputAliveLogMessage) {
                    this.getLogger().write(this.aliveLogMessageId, msid);
                }
                if (bret.booleanValue() && !keepAlive && this.isOutputDeadLogMessage) {
                    this.getLogger().write(this.deadLogMessageId, msid);
                }
            }
            this.mServerTbl.put(msid, new Boolean(keepAlive));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getKeepAliveMap() {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            return (Map)this.mServerTbl.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTbl(Object msid, boolean keepAlive) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            Boolean bret = (Boolean)this.mServerTbl.get(msid);
            if (bret != null) {
                this.updateTblStructure(msid, keepAlive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPriolityAry() {
        CsvArrayList ret = new CsvArrayList();
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            ListIterator iterator = this.mCheckerList.listIterator();
            while (iterator.hasNext()) {
                ServiceName name = (ServiceName)iterator.next();
                Boolean bret = (Boolean)this.mServerTbl.get(name);
                if (!bret.booleanValue()) continue;
                ret.add(name);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPriolityAry(Set available) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            List ret = this.getPriolityAry();
            ListIterator iterator = ret.listIterator();
            while (iterator.hasNext()) {
                Object name = iterator.next();
                if (available.contains(name)) continue;
                ret.remove(name);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRoundrobinAry() {
        CsvArrayList ret = new CsvArrayList();
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            Boolean bret;
            ServiceName name;
            int cnt;
            for (cnt = this.mRoundRobin; cnt < this.mCheckerList.size(); ++cnt) {
                name = (ServiceName)this.mCheckerList.get(cnt);
                bret = (Boolean)this.mServerTbl.get(name);
                if (!bret.booleanValue()) continue;
                ret.add(name);
            }
            for (cnt = 0; cnt < this.mRoundRobin; ++cnt) {
                name = (ServiceName)this.mCheckerList.get(cnt);
                bret = (Boolean)this.mServerTbl.get(name);
                if (!bret.booleanValue()) continue;
                ret.add(name);
            }
            ++this.mRoundRobin;
            if (this.mCheckerList.size() <= this.mRoundRobin) {
                this.mRoundRobin = 0;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRoundrobinAry(Set available) {
        Boolean bl = this.mSyncObj;
        synchronized (bl) {
            List ret = this.getRoundrobinAry();
            ListIterator iterator = ret.listIterator();
            while (iterator.hasNext()) {
                Object name = iterator.next();
                if (available.contains(name)) continue;
                ret.remove(name);
            }
            return ret;
        }
    }
}

