/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive.smtp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.keepalive.smtp.SmtpCheckerServiceMBean;

public class SmtpCheckerService
extends ServiceBase
implements SmtpCheckerServiceMBean {
    protected static final String C_HELLOW = "HELO localhost\r\n";
    protected static final String C_EOF_KEY = "WOUGN0600002002";
    protected static final String C_WRONG_SIGN = "2";
    protected static final String C_ERRSTATE_KEY = "WOUGN0600002003";
    protected static final String C_NORMALSTATE_KEY = "WOUGN0600002004";
    protected static final String C_QUITE = "QUIT\r\n";
    protected static final String C_TIMEOUT_KEY = "WOUGN0600002005";
    protected static final String C_PROTOCOL_ERROR_KEY = "WOUGN0600002006";
    protected static final String C_IOERROR_KEY = "WOUGN0600002007";
    protected String mHostName;
    protected InetAddress mIp;
    protected volatile int mPort = 0;
    protected volatile int mTimeOut = 1000;
    protected String eofLogMessageId = "WOUGN0600002002";
    protected String errorStateLogMessageId = "WOUGN0600002003";
    protected String normalStateLogMessageId = "WOUGN0600002004";
    protected String timeoutLogMessageId = "WOUGN0600002005";
    protected String protocolErrorLogMessageId = "WOUGN0600002006";
    protected String ioErrorLogMessageId = "WOUGN0600002007";
    protected boolean isOutputEOFLogMessage;
    protected boolean isOutputErrorStateLogMessage;
    protected boolean isOutputNormalStateLogMessage;
    protected boolean isOutputTimeoutLogMessage;
    protected boolean isOutputProtocolErrorLogMessage;
    protected boolean isOutputIOErrorLogMessage;

    public void setHostName(String hostName) throws UnknownHostException {
        this.mHostName = hostName;
        this.mIp = InetAddress.getByName(hostName);
    }

    public String getHostName() {
        return this.mHostName;
    }

    public void setPort(int port) {
        this.mPort = port;
    }

    public int getPort() {
        return this.mPort;
    }

    public void setTimeoutMillis(int milisec) {
        this.mTimeOut = milisec;
    }

    public int getTimeoutMillis() {
        return this.mTimeOut;
    }

    public void setEOFLogMessageId(String id) {
        this.eofLogMessageId = id;
    }

    public String getEOFLogMessageId() {
        return this.eofLogMessageId;
    }

    public void setErrorStateLogMessageId(String id) {
        this.errorStateLogMessageId = id;
    }

    public String getErrorStateLogMessageId() {
        return this.errorStateLogMessageId;
    }

    public void setNormalStateLogMessageId(String id) {
        this.normalStateLogMessageId = id;
    }

    public String getNormalStateLogMessageId() {
        return this.normalStateLogMessageId;
    }

    public void setTimeoutLogMessageId(String id) {
        this.timeoutLogMessageId = id;
    }

    public String getTimeoutLogMessageId() {
        return this.timeoutLogMessageId;
    }

    public void setProtocolErrorLogMessageId(String id) {
        this.protocolErrorLogMessageId = id;
    }

    public String getProtocolErrorLogMessageId() {
        return this.protocolErrorLogMessageId;
    }

    public void setIOErrorLogMessageId(String id) {
        this.ioErrorLogMessageId = id;
    }

    public String getIOErrorLogMessageId() {
        return this.ioErrorLogMessageId;
    }

    public void setOutputEOFLogMessage(boolean isOutput) {
        this.isOutputEOFLogMessage = isOutput;
    }

    public boolean isOutputEOFLogMessage() {
        return this.isOutputEOFLogMessage;
    }

    public void setOutputErrorStateLogMessage(boolean isOutput) {
        this.isOutputErrorStateLogMessage = isOutput;
    }

    public boolean isOutputErrorStateLogMessage() {
        return this.isOutputErrorStateLogMessage;
    }

    public void setOutputNormalStateLogMessage(boolean isOutput) {
        this.isOutputNormalStateLogMessage = isOutput;
    }

    public boolean isOutputNormalStateLogMessage() {
        return this.isOutputNormalStateLogMessage;
    }

    public void setOutputTimeoutLogMessage(boolean isOutput) {
        this.isOutputTimeoutLogMessage = isOutput;
    }

    public boolean isOutputTimeoutLogMessage() {
        return this.isOutputTimeoutLogMessage;
    }

    public void setOutputProtocolErrorLogMessage(boolean isOutput) {
        this.isOutputProtocolErrorLogMessage = isOutput;
    }

    public boolean isOutputProtocolErrorLogMessage() {
        return this.isOutputProtocolErrorLogMessage;
    }

    public void setOutputIOErrorLogMessage(boolean isOutput) {
        this.isOutputIOErrorLogMessage = isOutput;
    }

    public boolean isOutputIOErrorLogMessage() {
        return this.isOutputIOErrorLogMessage;
    }

    public String getHostIp() {
        return this.mIp == null ? null : this.mIp.getHostAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isAlive() {
        boolean ret;
        block32: {
            Socket sock;
            block31: {
                ret = true;
                sock = null;
                int len = 1024;
                sock = new Socket(this.mIp, this.mPort);
                BufferedInputStream in = new BufferedInputStream(sock.getInputStream(), 1024);
                BufferedOutputStream out = new BufferedOutputStream(sock.getOutputStream(), 1024);
                out.write(C_HELLOW.getBytes(), 0, C_HELLOW.getBytes().length);
                out.flush();
                sock.setSoTimeout(this.mTimeOut);
                byte[] resBuf = new byte[1024];
                int readLen = in.read(resBuf, 0, 1024);
                if (readLen == -1) {
                    if (this.isOutputEOFLogMessage) {
                        this.getLogger().write(this.eofLogMessageId, (Object)this.mHostName);
                    }
                    ret = false;
                    break block31;
                }
                String retCode = new String(resBuf, 0, readLen);
                if (!retCode.startsWith(C_WRONG_SIGN)) {
                    if (this.isOutputErrorStateLogMessage) {
                        Object[] wd = new String[]{this.mHostName, retCode};
                        this.getLogger().write(this.errorStateLogMessageId, wd);
                    }
                    ret = false;
                } else if (this.isOutputNormalStateLogMessage) {
                    this.getLogger().write(this.normalStateLogMessageId, (Object)this.mHostName);
                }
                out.write(C_QUITE.getBytes(), 0, C_QUITE.getBytes().length);
                out.flush();
            }
            Object var11_13 = null;
            try {
                if (sock != null) {
                    sock.close();
                }
                break block32;
            }
            catch (IOException ex) {
                if (this.isOutputIOErrorLogMessage) {
                    this.getLogger().write(this.ioErrorLogMessageId, (Object)this.mHostName, (Throwable)ex);
                }
                ret = false;
            }
            break block32;
            {
                catch (InterruptedIOException e) {
                    if (this.isOutputTimeoutLogMessage) {
                        this.getLogger().write(this.timeoutLogMessageId, (Object)this.mHostName);
                    }
                    ret = false;
                    Object var11_14 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (this.isOutputIOErrorLogMessage) {
                            this.getLogger().write(this.ioErrorLogMessageId, (Object)this.mHostName, (Throwable)ex);
                        }
                        ret = false;
                    }
                    break block32;
                }
                catch (SocketException e) {
                    if (this.isOutputProtocolErrorLogMessage) {
                        this.getLogger().write(this.protocolErrorLogMessageId, (Object)this.mHostName, (Throwable)e);
                    }
                    ret = false;
                    Object var11_15 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (this.isOutputIOErrorLogMessage) {
                            this.getLogger().write(this.ioErrorLogMessageId, (Object)this.mHostName, (Throwable)ex);
                        }
                        ret = false;
                    }
                    break block32;
                }
                catch (IOException e) {
                    if (this.isOutputIOErrorLogMessage) {
                        this.getLogger().write(this.ioErrorLogMessageId, (Object)this.mHostName, (Throwable)e);
                    }
                    ret = false;
                    Object var11_16 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                        }
                        break block32;
                    }
                    catch (IOException ex) {
                        if (this.isOutputIOErrorLogMessage) {
                            this.getLogger().write(this.ioErrorLogMessageId, (Object)this.mHostName, (Throwable)ex);
                        }
                        ret = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException ex) {
                    if (this.isOutputIOErrorLogMessage) {
                        this.getLogger().write(this.ioErrorLogMessageId, (Object)this.mHostName, (Throwable)ex);
                    }
                    ret = false;
                }
                throw throwable;
            }
        }
        return ret;
    }
}

