/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import jp.ossc.nimbus.core.DeploymentException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MetaData
implements Serializable {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT_STRING = "    ";
    private MetaData parent;
    private String comment;

    public MetaData() {
    }

    public MetaData(MetaData parent) {
        this.parent = parent;
    }

    public MetaData getParent() {
        return this.parent;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void importXML(Element element) throws DeploymentException {
        this.comment = MetaData.getElementComment(element);
    }

    public StringBuffer toXML(StringBuffer buf) {
        return buf;
    }

    protected StringBuffer appendComment(StringBuffer buf) {
        String comment = this.getComment();
        if (comment != null) {
            buf.append("<!--");
            if (comment.indexOf(13) != -1 || comment.indexOf(10) != -1) {
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent(comment));
                buf.append(LINE_SEPARATOR);
            } else {
                buf.append(' ');
                buf.append(comment);
                buf.append(' ');
            }
            buf.append("-->");
            buf.append(LINE_SEPARATOR);
        }
        return buf;
    }

    protected StringBuffer addIndent(StringBuffer buf) {
        return this.setIndent(buf, 1);
    }

    protected String addIndent(String str) {
        return this.setIndent(str, 1);
    }

    protected StringBuffer setIndent(StringBuffer buf, int indent) {
        String str = buf.toString();
        buf.setLength(0);
        return buf.append(this.setIndent(str, indent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String setIndent(String str, int indent) {
        StringBuffer buf;
        block13: {
            if (str == null) {
                return null;
            }
            buf = new StringBuffer();
            for (int i = 0; i < indent; ++i) {
                buf.append(INDENT_STRING);
            }
            String indentString = buf.toString();
            buf.setLength(0);
            int length = str.length();
            if (length == 0) {
                return buf.toString();
            }
            StringReader sr = new StringReader(str);
            BufferedReader br = new BufferedReader(sr, length);
            String line = br.readLine();
            while (line != null) {
                buf.append(indentString).append(line);
                line = br.readLine();
                if (line == null) continue;
                buf.append(LINE_SEPARATOR);
            }
            Object var10_11 = null;
            try {
                br.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            sr.close();
            {
                break block13;
                catch (IOException e) {
                    e.printStackTrace();
                    Object var10_12 = null;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    sr.close();
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                sr.close();
                throw throwable;
            }
        }
        return buf.toString();
    }

    public static Iterator getChildren(Element element) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1) continue;
            result.add((Element)currentChild);
        }
        return result.iterator();
    }

    public static Iterator getChildrenByTagName(Element element, String tagName) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1 || !((Element)currentChild).getTagName().equals(tagName)) continue;
            result.add((Element)currentChild);
        }
        return result.iterator();
    }

    public static Iterator getChildrenWithoutTagName(Element element, String[] tagNames) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        ArrayList<Node> result = new ArrayList<Node>();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1) continue;
            boolean isMatch = false;
            for (int j = 0; j < tagNames.length; ++j) {
                if (!((Element)currentChild).getTagName().equals(tagNames[j])) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            result.add(currentChild);
        }
        return result.iterator();
    }

    public static Element getUniqueChild(Element element) throws DeploymentException {
        Element result = null;
        NodeList children = element.getChildNodes();
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1) continue;
            if (result != null) {
                throw new DeploymentException("Expected only one any tag");
            }
            result = (Element)currentChild;
        }
        if (result == null) {
            throw new DeploymentException("Expected one any tag");
        }
        return result;
    }

    public static Element getUniqueChild(Element element, String tagName) throws DeploymentException {
        Iterator children = MetaData.getChildrenByTagName(element, tagName);
        if (children != null && children.hasNext()) {
            Element child = (Element)children.next();
            if (children.hasNext()) {
                throw new DeploymentException("Expected only one " + tagName + " tag");
            }
            return child;
        }
        throw new DeploymentException("Expected one " + tagName + " tag");
    }

    public static Element getOptionalChild(Element element, String tagName) throws DeploymentException {
        return MetaData.getOptionalChild(element, tagName, null);
    }

    public static Element getOptionalChild(Element element, String tagName, Element defaultElement) throws DeploymentException {
        Iterator children = MetaData.getChildrenByTagName(element, tagName);
        if (children != null && children.hasNext()) {
            Element child = (Element)children.next();
            if (children.hasNext()) {
                throw new DeploymentException("Expected only one " + tagName + " tag");
            }
            return child;
        }
        return defaultElement;
    }

    public static String getElementContent(Element element) {
        return MetaData.getElementContent(element, null);
    }

    public static String getElementContent(Element element, String defaultStr) {
        if (element == null) {
            return defaultStr;
        }
        NodeList children = element.getChildNodes();
        String result = "";
        int max = children.getLength();
        for (int i = 0; i < max; ++i) {
            if (children.item(i).getNodeType() == 3 || children.item(i).getNodeType() == 4) {
                result = result + children.item(i).getNodeValue();
                continue;
            }
            if (children.item(i).getNodeType() == 8) continue;
            result = result + children.item(i).getFirstChild();
        }
        return MetaData.trim(result);
    }

    public static String getElementComment(Element element) {
        Node currentNode = element;
        boolean isComment = false;
        block4: while ((currentNode = currentNode.getPreviousSibling()) != null) {
            switch (currentNode.getNodeType()) {
                case 3: 
                case 4: {
                    continue block4;
                }
                case 8: {
                    isComment = true;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (!isComment) continue;
        }
        return currentNode == null ? null : MetaData.trim(currentNode.getNodeValue());
    }

    public static String trim(String str) {
        StringBuffer buf = new StringBuffer();
        int line = 0;
        boolean isFirst = true;
        int max = str.length();
        block6: for (int i = 0; i < max; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    if (line != 0 || !isFirst) {
                        buf.append(c);
                    }
                    if (i != max - 1 && str.charAt(i + 1) == '\n') {
                        if (line != 0 || !isFirst) {
                            buf.append('\n');
                        }
                        ++i;
                    }
                    isFirst = true;
                    ++line;
                    continue block6;
                }
                case '\n': {
                    if (line != 0 || !isFirst) {
                        buf.append(c);
                    }
                    ++line;
                    isFirst = true;
                    continue block6;
                }
                case '\t': {
                    if (isFirst) continue block6;
                    buf.append(c);
                    continue block6;
                }
                case ' ': {
                    if (isFirst) continue block6;
                    buf.append(c);
                    continue block6;
                }
                default: {
                    isFirst = false;
                    buf.append(c);
                }
            }
        }
        return buf.toString().trim();
    }

    public static String getUniqueChildContent(Element element, String tagName) throws DeploymentException {
        return MetaData.getElementContent(MetaData.getUniqueChild(element, tagName));
    }

    public static String getOptionalChildContent(Element element, String tagName) throws DeploymentException {
        return MetaData.getElementContent(MetaData.getOptionalChild(element, tagName));
    }

    public static boolean getOptionalChildBooleanContent(Element element, String name) throws DeploymentException {
        Element child = MetaData.getOptionalChild(element, name);
        if (child != null) {
            String value = MetaData.getElementContent(child).toLowerCase();
            return Boolean.valueOf(value) != false || value.equalsIgnoreCase("yes");
        }
        return false;
    }

    public static String getUniqueAttribute(Element element, String name) throws DeploymentException {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        throw new DeploymentException(name + " attribute is require.");
    }

    public static String getOptionalAttribute(Element element, String name) {
        return MetaData.getOptionalAttribute(element, name, null);
    }

    public static String getOptionalAttribute(Element element, String name, String defaultStr) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return defaultStr;
    }

    public static boolean getOptionalBooleanAttribute(Element element, String name) {
        String value = MetaData.getOptionalAttribute(element, name, null);
        if (value != null) {
            return Boolean.valueOf(value) != false || value.equalsIgnoreCase("yes");
        }
        return false;
    }

    public static boolean getOptionalBooleanAttribute(Element element, String name, boolean defaultVal) {
        String value = MetaData.getOptionalAttribute(element, name, null);
        if (value != null) {
            return Boolean.valueOf(value) != false || value.equalsIgnoreCase("yes");
        }
        return defaultVal;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

