/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.codemaster;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class CodeMasterNotifyBean
extends HashMap {
    private static final long serialVersionUID = 3508475057737920813L;
    private JndiFinder mTopicFinder = null;
    private TopicSession mRes = null;
    private String mFlowKey = null;
    private Date mDate = null;
    private Object mData = null;
    private String mTopicName = null;

    public void setTopicName(String name) {
        this.mTopicName = name;
    }

    public void setResource(TopicSession rc) {
        this.mRes = rc;
    }

    public void setMasterFlowKey(String masterKey) {
        this.mFlowKey = masterKey;
    }

    public void setDate(Date effectiveDate) {
        this.mDate = effectiveDate;
    }

    public void setData(Object data) {
        this.mData = data;
    }

    public void setJndiFinder(JndiFinder finder) {
        this.mTopicFinder = finder;
    }

    public void addMessage() {
        if (this.mFlowKey == null) {
            return;
        }
        this.put(this.mFlowKey, this.mData);
        this.put(this.mFlowKey + "$updateTime", this.mDate == null ? new Date() : this.mDate);
        this.mDate = null;
        this.mFlowKey = null;
    }

    public void send() throws JMSException, NamingException {
        if (this.size() == 0) {
            return;
        }
        TopicSession session = this.mRes;
        MapMessage msg = session.createMapMessage();
        Set set = this.keySet();
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            Object obj = this.get(key);
            if (obj instanceof Date) {
                Date dt = (Date)obj;
                msg.setLong(key, dt.getTime());
                continue;
            }
            if (obj == null) {
                msg.setString(key, null);
                continue;
            }
            msg.setObject(key, obj);
        }
        Topic tp = null;
        tp = this.mTopicName == null ? (Topic)this.mTopicFinder.lookup() : (Topic)this.mTopicFinder.lookup(this.mTopicName);
        TopicPublisher tpub = session.createPublisher(tp);
        msg.setJMSDeliveryMode(2);
        tpub.publish((Message)msg);
        this.clear();
    }

    public void addMessageAndSend() throws JMSException, NamingException {
        this.addMessage();
        this.send();
    }
}

