/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.jms;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.CacheMap;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.jms.JMSConnectionCreateException;
import jp.ossc.nimbus.service.jms.JMSConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class JMSConnectionFactoryService
extends ServiceBase
implements JMSConnectionFactoryServiceMBean,
CacheRemoveListener {
    private static final long serialVersionUID = -8996430918339950670L;
    protected ServiceName jndiFinderServiceName;
    protected JndiFinder jndiFinder;
    protected String userName;
    protected String password;
    protected String connectionFactoryName = "java:XAConnectionFactory";
    protected ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Set connections;
    protected boolean isSingleConnection = true;
    protected boolean isConnectionManagement;
    protected String connectionKey = "JMSConnection";
    protected ServiceName connectionCacheMapServiceName;
    protected CacheMap connectionCache;

    public void setConnectionManagement(boolean isManaged) {
        this.isConnectionManagement = isManaged;
    }

    public boolean isConnectionManagement() {
        return this.isConnectionManagement;
    }

    public void setSingleConnection(boolean isSingle) {
        this.isSingleConnection = isSingle;
    }

    public boolean isSingleConnection() {
        return this.isSingleConnection;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderServiceName;
    }

    public void setConnectionFactoryName(String name) {
        this.connectionFactoryName = name;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionKey(String key) {
        this.connectionKey = key;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public void setConnectionCacheMapServiceName(ServiceName name) {
        this.connectionCacheMapServiceName = name;
    }

    public ServiceName getConnectionCacheMapServiceName() {
        return this.connectionCacheMapServiceName;
    }

    public void setJndiFinder(JndiFinder jndiFinder) {
        this.jndiFinder = jndiFinder;
    }

    public void setCacheMap(CacheMap connectionCache) {
        this.connectionCache = connectionCache;
    }

    public void createService() throws Exception {
        this.connections = new HashSet();
    }

    public void startService() throws Exception {
        if (this.jndiFinderServiceName != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.jndiFinderServiceName);
        } else if (this.jndiFinder == null) {
            throw new IllegalArgumentException("JndiFinderServiceName or JndiFinder must be specified.");
        }
        if (this.connectionCacheMapServiceName != null) {
            this.connectionCache = (CacheMap)ServiceManagerFactory.getServiceObject(this.connectionCacheMapServiceName);
        }
        this.connectionFactory = (ConnectionFactory)this.jndiFinder.lookup(this.connectionFactoryName);
        if (this.isSingleConnection) {
            this.getConnection();
        }
    }

    public void stopService() throws Exception {
        this.connectionFactory = null;
        if (this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (JMSException e) {
                // empty catch block
            }
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        this.connection = null;
        if (this.connections != null && this.connections.size() != 0) {
            Iterator cons = this.connections.iterator();
            while (cons.hasNext()) {
                Connection con = (Connection)cons.next();
                try {
                    con.stop();
                }
                catch (JMSException e) {
                    // empty catch block
                }
                try {
                    con.close();
                }
                catch (JMSException jMSException) {}
            }
            this.connections.clear();
        }
        if (this.connectionCache != null) {
            this.connectionCache.remove(this.connectionKey);
        }
    }

    public void destroyService() throws Exception {
        this.connections = null;
    }

    public synchronized Connection getConnection() throws JMSConnectionCreateException {
        return this.getConnection(this.userName, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection getConnection(String user, String pwd) throws JMSConnectionCreateException {
        if (this.connectionFactory == null) {
            throw new JMSConnectionCreateException("ConnectionFactory is null.");
        }
        Connection con = null;
        if (this.isSingleConnection) {
            if (this.connectionCache != null) {
                con = (Connection)this.connectionCache.get(this.connectionKey);
                if (con != null) {
                    return con;
                }
            } else if (this.connection != null) {
                return this.connection;
            }
        }
        try {
            if (this.isSingleConnection) {
                ConnectionFactory connectionFactory = this.connectionFactory;
                synchronized (connectionFactory) {
                    if (this.connectionCache != null) {
                        con = (Connection)this.connectionCache.get(this.connectionKey);
                        if (con != null) {
                            return con;
                        }
                    } else if (this.connection != null) {
                        return this.connection;
                    }
                    if ((con = user != null ? this.connectionFactory.createConnection(user, pwd) : this.connectionFactory.createConnection()) != null) {
                        if (this.connectionCache != null) {
                            this.connectionCache.put(this.connectionKey, con);
                            this.connectionCache.getCachedReference(this.connectionKey).addCacheRemoveListener(this);
                        } else {
                            this.connection = con;
                        }
                    }
                }
            } else {
                con = user != null ? this.connectionFactory.createConnection(user, pwd) : this.connectionFactory.createConnection();
            }
            if (this.isConnectionManagement) {
                this.connections.add(con);
            }
        }
        catch (JMSException e) {
            throw new JMSConnectionCreateException(e);
        }
        return con;
    }

    public void removed(CachedReference ref) {
        Connection con = (Connection)ref.get();
        if (con != null) {
            try {
                con.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

