/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import org.w3c.dom.Element;

public class ManagerMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 710269838167389543L;
    public static final String MANAGER_TAG_NAME = "manager";
    private static final String REPOSITORY_TAG_NAME = "repository";
    private static final String LOG_TAG_NAME = "log";
    private static final String MESSAGE_TAG_NAME = "message";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String SHUTDOWN_HOOK_ATTRIBUTE_NAME = "shutdown-hook";
    private static final String MANAGER_PROPERTY_TAG_NAME = "manager-property";
    private String name;
    private boolean isExistShutdownHook;
    private final Map services = new LinkedHashMap();
    private ServiceNameMetaData repository;
    private ServiceNameMetaData log;
    private ServiceNameMetaData message;
    private ServiceLoader myLoader;
    private Map properties = new LinkedHashMap();

    public ManagerMetaData() {
    }

    public ManagerMetaData(ServiceLoader loader, MetaData parent) {
        super(parent);
        this.myLoader = loader;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public void setServiceLoader(ServiceLoader loader) {
        this.myLoader = loader;
    }

    public String getName() {
        if (this.name == null) {
            return "Nimbus";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExistShutdownHook() {
        return this.isExistShutdownHook;
    }

    public void setExistShutdownHook(boolean flg) {
        this.isExistShutdownHook = flg;
    }

    public ServiceNameMetaData getRepository() {
        return this.repository;
    }

    public void setRepository(ServiceNameMetaData data) {
        this.repository = data;
    }

    public ServiceNameMetaData getLog() {
        return this.log;
    }

    public void setLog(ServiceNameMetaData data) {
        this.log = data;
    }

    public ServiceNameMetaData getMessage() {
        return this.message;
    }

    public void setMessage(ServiceNameMetaData data) {
        this.message = data;
    }

    public ServiceMetaData getService(String name) {
        return (ServiceMetaData)this.services.get(name);
    }

    public Map getServices() {
        return this.services;
    }

    public void addService(ServiceMetaData service) {
        service.setServiceLoader(this.getServiceLoader());
        service.setManager(this);
        this.services.put(service.getName(), service);
    }

    public void removeService(String name) {
        this.services.remove(name);
    }

    public void clearServices() {
        this.services.clear();
    }

    public String getProperty(String property) {
        return (String)this.properties.get(property);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }

    public void setProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public void removeProperty(String property) {
        this.properties.remove(property);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public ServiceNameMetaData createRepositoryMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, REPOSITORY_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createLogMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, LOG_TAG_NAME, managerName, serviceName);
    }

    public ServiceNameMetaData createMessageMetaData(String managerName, String serviceName) {
        return new ServiceNameMetaData(this, MESSAGE_TAG_NAME, managerName, serviceName);
    }

    public void importXML(Element element) throws DeploymentException {
        Element messageElement;
        Element logElement;
        Element repositoryElement;
        super.importXML(element);
        if (!element.getTagName().equals(MANAGER_TAG_NAME)) {
            throw new DeploymentException("Tag must be manager : " + element.getTagName());
        }
        this.name = ManagerMetaData.getOptionalAttribute(element, NAME_ATTRIBUTE_NAME);
        String shutdownHook = ManagerMetaData.getOptionalAttribute(element, SHUTDOWN_HOOK_ATTRIBUTE_NAME);
        if (shutdownHook != null && shutdownHook.length() != 0) {
            this.isExistShutdownHook = Boolean.valueOf(shutdownHook);
        }
        if ((repositoryElement = ManagerMetaData.getOptionalChild(element, REPOSITORY_TAG_NAME)) != null) {
            this.repository = new ServiceNameMetaData(this, this.getName());
            this.repository.importXML(repositoryElement);
        }
        if ((logElement = ManagerMetaData.getOptionalChild(element, LOG_TAG_NAME)) != null) {
            this.log = new ServiceNameMetaData(this, this.getName());
            this.log.importXML(logElement);
        }
        if ((messageElement = ManagerMetaData.getOptionalChild(element, MESSAGE_TAG_NAME)) != null) {
            this.message = new ServiceNameMetaData(this);
            this.message.importXML(messageElement);
        }
        Iterator propElements = ManagerMetaData.getChildrenByTagName(element, MANAGER_PROPERTY_TAG_NAME);
        while (propElements.hasNext()) {
            Element propElement = (Element)propElements.next();
            String managerProp = ManagerMetaData.getElementContent(propElement);
            this.properties.put(ManagerMetaData.getUniqueAttribute(propElement, NAME_ATTRIBUTE_NAME), managerProp);
        }
        Iterator serviceElements = ManagerMetaData.getChildrenByTagName(element, "service");
        while (serviceElements.hasNext()) {
            ServiceMetaData serviceData = new ServiceMetaData(this.myLoader, (MetaData)this, this);
            serviceData.importXML((Element)serviceElements.next());
            if (this.services.containsKey(serviceData.getName())) {
                throw new DeploymentException("Dupulicated service name : " + serviceData.getName());
            }
            this.addService(serviceData);
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(MANAGER_TAG_NAME);
        if (this.name != null) {
            buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(this.name).append("\"");
        }
        if (this.isExistShutdownHook) {
            buf.append(' ').append(SHUTDOWN_HOOK_ATTRIBUTE_NAME).append("=\"").append(this.isExistShutdownHook).append("\"");
        }
        buf.append('>');
        if (this.properties.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator names = this.properties.keySet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                buf.append('<').append(MANAGER_PROPERTY_TAG_NAME);
                buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(name).append("\">");
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent((String)this.properties.get(name)));
                buf.append(LINE_SEPARATOR);
                buf.append("</").append(MANAGER_PROPERTY_TAG_NAME).append('>');
                if (!names.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        if (this.repository != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.repository.toXML(new StringBuffer())));
        }
        if (this.log != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.log.toXML(new StringBuffer())));
        }
        if (this.message != null) {
            buf.append(LINE_SEPARATOR);
            buf.append(this.addIndent(this.message.toXML(new StringBuffer())));
        }
        if (this.services.size() != 0) {
            buf.append(LINE_SEPARATOR);
            Iterator datas = this.services.values().iterator();
            while (datas.hasNext()) {
                buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                if (!datas.hasNext()) continue;
                buf.append(LINE_SEPARATOR);
            }
        }
        buf.append(LINE_SEPARATOR);
        buf.append("</").append(MANAGER_TAG_NAME).append('>');
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        if (this.getName() != null) {
            buf.append(NAME_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getName());
            buf.append(',');
        }
        buf.append(SHUTDOWN_HOOK_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.isExistShutdownHook);
        buf.append('}');
        return buf.toString();
    }
}

