/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.InvalidDataException;
import jp.ossc.nimbus.recset.RowData;
import jp.ossc.nimbus.recset.RowSchema;
import jp.ossc.nimbus.recset.RowVersionException;
import jp.ossc.nimbus.recset.SchemaManager;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;
import jp.ossc.nimbus.service.codemaster.PartUpdate;
import jp.ossc.nimbus.service.codemaster.PartUpdateRecords;
import jp.ossc.nimbus.service.crypt.Crypt;
import jp.ossc.nimbus.service.log.Logger;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class RecordSet
implements Serializable,
PartUpdate,
Cloneable {
    private static final long serialVersionUID = -7457366126244404177L;
    public static final String C_SEPARATOR = System.getProperty("line.separator");
    private static final String C_SET_TOKEN = " SET ";
    private static final String C_UPDATE_TOKEN = "UPDATE ";
    private static final String C_QUESTION_TOKEN = "?";
    private static final String C_EQUAL_TOKEN = "=";
    private static final String C_AND_TOKEN = " AND ";
    private static final String C_OR_TOKEN = " OR ";
    private static final String C_WHERE_TOKEN = " WHERE ";
    private static final String C_VALUES_TOKEN = " VALUES ";
    private static final String C_BRACKETS_END_TOKEN = " ) ";
    private static final String C_BRACKETS_BEGIN_TOKEN = " ( ";
    private static final String C_DELETE_TOKEN = "DELETE FROM ";
    private static final String C_INSERT_TOKEN = "INSERT INTO ";
    private static final String C_ORDER_TOKEN = " ORDER BY ";
    private static final String C_FROM_TOKEN = " FROM ";
    private static final String C_COMMA_TOKEN = ",";
    private static final String C_SELECT_TOKEN = "SELECT ";
    private static final String C_DISTINCT_TOKEN = " DISTINCT ";
    private static final String C_BLANK_TOKEN = " ";
    protected Crypt mCrypt;
    protected RowSchema mSchema;
    protected ArrayList mRows = new ArrayList();
    protected HashMap mHash = new HashMap();
    protected String mTableNames;
    protected String mUpdateTableNames;
    protected String mOrder;
    protected StringBuffer where;
    protected List bindDatas;
    protected transient Connection mCon;
    protected Logger mLogger;
    protected String mMessageCode;
    protected boolean mDistinctFlg = false;
    protected boolean isEnabledRowVersionCheck = true;
    protected Map dynamicSearchConditionMap;
    protected Map dynamicSearchConditionResultMap;
    protected Map dynamicSearchKeyMap;
    protected Map dynamicSearchMap;
    protected boolean isBatchExecute = true;
    protected int[] partUpdateOrderBy;
    protected boolean[] partUpdateIsAsc;

    public void setLogger(Logger lg) {
        this.mLogger = lg;
    }

    public void setMessageCode(String code) {
        this.mMessageCode = code;
    }

    public void setEnabledRowVersionCheck(boolean isEnabled) {
        this.isEnabledRowVersionCheck = isEnabled;
    }

    public boolean isEnabledRowVersionCheck() {
        return this.isEnabledRowVersionCheck;
    }

    public void initSchema(String schema) {
        this.mSchema = SchemaManager.findRowSchema(schema);
    }

    public void initFieldSchemata(String[] filedSchemata) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < filedSchemata.length; ++i) {
            buf.append(filedSchemata[i]);
            if (i == filedSchemata.length - 1) continue;
            buf.append(C_SEPARATOR);
        }
        this.initSchema(buf.toString());
    }

    public RowSchema getRowSchema() {
        return this.mSchema;
    }

    public void setFromTable(String tableStr) {
        this.mTableNames = tableStr;
    }

    public void setUpdateTable(String tableStr) {
        this.mUpdateTableNames = tableStr;
    }

    public void setOrderbyStr(String order) {
        this.mOrder = order;
    }

    public void setConnection(Connection con) {
        this.mCon = con;
    }

    public Connection getConnection() {
        return this.mCon;
    }

    public void setDistinctFlg(boolean flg) {
        this.mDistinctFlg = flg;
    }

    public void setCrypt(Crypt crypt) {
        this.mCrypt = crypt;
    }

    public Crypt getCrypt() {
        return this.mCrypt;
    }

    public void setBatchExecute(boolean isBatch) {
        this.isBatchExecute = isBatch;
    }

    public boolean isBatchExecute() {
        return this.isBatchExecute;
    }

    private int[] convertFromColNamesToColIndexes(String[] colNames) {
        if (colNames == null || colNames.length == 0) {
            return null;
        }
        if (this.mSchema == null) {
            throw new InvalidDataException("Schema not initalize.");
        }
        int[] colIndexes = new int[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            FieldSchema field = this.mSchema.get(colNames[i]);
            if (field == null) {
                throw new IllegalArgumentException("Field not found : " + colNames[i]);
            }
            colIndexes[i] = field.getIndex();
        }
        return colIndexes;
    }

    public void setDynamicSearchCondition(String condition) throws Exception {
        this.setDynamicSearchCondition(null, condition);
    }

    public void setDynamicSearchCondition(String condition, String[] orderBy) throws Exception {
        this.setDynamicSearchCondition(null, condition, orderBy);
    }

    public void setDynamicSearchCondition(String condition, int[] orderBy) throws Exception {
        this.setDynamicSearchCondition(null, condition, orderBy);
    }

    public void setDynamicSearchCondition(String condition, String[] orderBy, boolean[] isAsc) throws Exception {
        this.setDynamicSearchCondition(null, condition, orderBy, isAsc);
    }

    public void setDynamicSearchCondition(String condition, int[] orderBy, boolean[] isAsc) throws Exception {
        this.setDynamicSearchCondition(null, condition, orderBy, isAsc);
    }

    public void setDynamicSearchCondition(String name, String condition) throws Exception {
        this.setDynamicSearchCondition(name, condition, (int[])null, null);
    }

    public void setDynamicSearchCondition(String name, String condition, String[] orderBy) throws Exception {
        this.setDynamicSearchCondition(name, condition, this.convertFromColNamesToColIndexes(orderBy), null);
    }

    public void setDynamicSearchCondition(String name, String condition, int[] orderBy) throws Exception {
        this.setDynamicSearchCondition(name, condition, orderBy, null);
    }

    public void setDynamicSearchCondition(String name, String condition, String[] orderBy, boolean[] isAsc) throws Exception {
        this.setDynamicSearchCondition(name, condition, this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public void setDynamicSearchCondition(String name, String condition, int[] orderBy, boolean[] isAsc) throws Exception {
        if (this.dynamicSearchConditionMap == null) {
            this.dynamicSearchConditionMap = new HashMap();
        }
        if (this.mSchema == null) {
            throw new InvalidDataException("Schema not initalize.");
        }
        Expression exp = ExpressionFactory.createExpression((String)condition);
        JexlContext context = JexlHelper.createContext();
        int imax = this.mSchema.size();
        for (int i = 0; i < imax; ++i) {
            FieldSchema field = this.mSchema.get(i);
            String fieldName = field.getFieldName();
            int fieldType = field.getFieldType();
            Object val = null;
            switch (fieldType) {
                case 1: {
                    val = new Integer(0);
                    break;
                }
                case 8: {
                    val = new Long(0L);
                    break;
                }
                case 2: 
                case 3: {
                    val = new String();
                    break;
                }
                case 4: 
                case 9: {
                    val = new Date();
                    break;
                }
                case 5: {
                    val = new Float(0.0f);
                    break;
                }
                case 7: {
                    val = new Double(0.0);
                    break;
                }
                case 10: {
                    val = new byte[]{};
                    break;
                }
                case 11: {
                    val = new char[0];
                    break;
                }
            }
            context.getVars().put(fieldName, val);
        }
        Object ret = exp.evaluate(context);
        if (!(ret instanceof Boolean)) {
            throw new IllegalArgumentException("Condition is not boolean. condition=" + condition + ", return=" + ret);
        }
        this.dynamicSearchConditionMap.put(name, exp);
        if (this.dynamicSearchConditionResultMap == null) {
            this.dynamicSearchConditionResultMap = new HashMap();
        }
        this.dynamicSearchConditionResultMap.put(name, this.createOrderByMap(orderBy, isAsc));
    }

    private Map createOrderByMap(int[] orderBy, boolean[] isAsc) {
        Comparator comp = this.createOrderByComparator(orderBy, isAsc);
        if (comp == null) {
            return new LinkedHashMap();
        }
        return new TreeMap(comp);
    }

    private Comparator createOrderByComparator(int[] orderBy, boolean[] isAsc) {
        RowDataComparator comp = null;
        if (orderBy != null && orderBy.length != 0) {
            comp = new RowDataComparator(orderBy, isAsc);
        }
        return comp;
    }

    public void setDynamicSearchKey(String[] colNames) {
        this.setDynamicSearchKey(null, colNames);
    }

    public void setDynamicSearchKey(int[] colIndexes) {
        this.setDynamicSearchKey(null, colIndexes);
    }

    public void setDynamicSearchKey(String name, String[] colNames) {
        this.setDynamicSearchKey(name, this.convertFromColNamesToColIndexes(colNames));
    }

    public void setDynamicSearchKey(String name, int[] colIndexes) {
        this.setDynamicSearchKey(name, colIndexes, null);
    }

    public void setDynamicSearchKey(String name, String[] colNames, String[] orderBy) {
        this.setDynamicSearchKey(name, colNames, orderBy, null);
    }

    public void setDynamicSearchKey(String name, int[] colIndexes, int[] orderBy) {
        this.setDynamicSearchKey(name, colIndexes, orderBy, null);
    }

    public void setDynamicSearchKey(String name, String[] colNames, String[] orderBy, boolean[] isAsc) {
        this.setDynamicSearchKey(name, this.convertFromColNamesToColIndexes(colNames), this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public void setDynamicSearchKey(String name, int[] colIndexes, int[] orderBy, boolean[] isAsc) {
        if (colIndexes == null || colIndexes.length == 0) {
            throw new IllegalArgumentException("Column index array is empty.");
        }
        if (this.dynamicSearchKeyMap == null) {
            this.dynamicSearchKeyMap = new HashMap();
        }
        this.dynamicSearchKeyMap.put(name, new DynamicSearchKeyValue(colIndexes, orderBy, isAsc));
    }

    public RowData createNewRecord() {
        return new RowData(this.mSchema);
    }

    public void setWhere(String where) {
        this.where = new StringBuffer(where);
    }

    public void setWhere(RowData row) {
        if (row != null) {
            this.setWhere(row.createCodeMasterUpdateKey());
        }
    }

    public void setWhere(RowData[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        CodeMasterUpdateKey[] keys = new CodeMasterUpdateKey[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            keys[i] = rows[i].createCodeMasterUpdateKey();
        }
        this.setWhere(keys);
    }

    public void setWhere(CodeMasterUpdateKey key) {
        if (key == null || key.isRemove()) {
            return;
        }
        this.clearBindData();
        this.where = new StringBuffer(C_WHERE_TOKEN);
        Iterator entries = key.getKeyMap().entrySet().iterator();
        int index = 0;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String name = (String)entry.getKey();
            this.where.append(name);
            this.where.append(C_EQUAL_TOKEN);
            this.where.append(C_QUESTION_TOKEN);
            if (entries.hasNext()) {
                this.where.append(C_AND_TOKEN);
            }
            Object value = entry.getValue();
            this.setBindData(index++, value);
        }
    }

    public void setWhere(CodeMasterUpdateKey[] keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        this.clearBindData();
        StringBuffer where = new StringBuffer(C_WHERE_TOKEN);
        int index = 0;
        for (int i = 0; i < keys.length; ++i) {
            CodeMasterUpdateKey key = keys[i];
            if (key.isRemove()) continue;
            if (index != 0) {
                where.append(C_OR_TOKEN);
            }
            where.append(C_BRACKETS_BEGIN_TOKEN);
            Iterator entries = key.getKeyMap().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                where.append(name);
                where.append(C_EQUAL_TOKEN);
                where.append(C_QUESTION_TOKEN);
                if (entries.hasNext()) {
                    where.append(C_AND_TOKEN);
                }
                Object value = entry.getValue();
                this.setBindData(index++, value);
            }
            where.append(C_BRACKETS_END_TOKEN);
        }
        if (index != 0) {
            this.where = where;
        }
    }

    public void setWhere(PartUpdateRecords records) {
        if (records == null || records.size() == 0 || !records.containsAdd() && !records.containsUpdate() || records.isFilledRecord()) {
            return;
        }
        this.clearBindData();
        this.where = new StringBuffer(C_WHERE_TOKEN);
        Iterator keys = records.getKeys();
        int index = 0;
        while (keys.hasNext()) {
            CodeMasterUpdateKey key = (CodeMasterUpdateKey)keys.next();
            if (key.isRemove() || records.getRecord(key) != null) continue;
            if (index != 0) {
                this.where.append(C_OR_TOKEN);
            }
            this.where.append(C_BRACKETS_BEGIN_TOKEN);
            Iterator entries = key.getKeyMap().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                this.where.append(name);
                this.where.append(C_EQUAL_TOKEN);
                this.where.append(C_QUESTION_TOKEN);
                if (entries.hasNext()) {
                    this.where.append(C_AND_TOKEN);
                }
                Object value = entry.getValue();
                this.setBindData(index++, value);
            }
            this.where.append(C_BRACKETS_END_TOKEN);
        }
    }

    protected void addWhere(StringBuffer sb) {
        if (this.where != null) {
            sb.append(this.where.toString());
        }
    }

    public void setBindData(int index, Object val) {
        if (this.bindDatas == null) {
            this.bindDatas = new ArrayList();
        }
        if (this.bindDatas.size() < index) {
            for (int i = this.bindDatas.size(); i < index; ++i) {
                this.bindDatas.add(null);
            }
        }
        if (this.bindDatas.size() == index) {
            this.bindDatas.add(val);
        } else {
            this.bindDatas.set(index, val);
        }
    }

    public void clearBindData() {
        if (this.bindDatas != null) {
            this.bindDatas.clear();
        }
    }

    protected void addBindData(PreparedStatement ps) throws SQLException {
        if (this.bindDatas != null) {
            Iterator itr = this.bindDatas.iterator();
            int index = 0;
            while (itr.hasNext()) {
                Object bindData = itr.next();
                ++index;
                if (bindData == null) continue;
                ps.setObject(index, bindData);
            }
        }
    }

    public int search() throws SQLException {
        return this.search(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int search(int max) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(C_SELECT_TOKEN);
        if (this.mDistinctFlg) {
            sb.append(C_DISTINCT_TOKEN);
        }
        int imax = this.mSchema.size();
        for (int i = 0; i < imax; ++i) {
            if (this.mSchema.get(i).getFieldKey() == 4) continue;
            if (this.mSchema.get(i).getPysicalName() != null) {
                sb.append(this.mSchema.get(i).getPysicalName());
                sb.append(C_BLANK_TOKEN);
            }
            sb.append(this.mSchema.get(i).getFieldName());
            sb.append(C_COMMA_TOKEN);
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(C_FROM_TOKEN).append(this.mTableNames).append(' ');
        this.addWhere(sb);
        if (this.mOrder != null) {
            sb.append(C_ORDER_TOKEN).append(this.mOrder);
        }
        Statement ps = null;
        try {
            String statement = sb.toString();
            ps = this.mCon.prepareStatement(statement);
            if (this.mLogger != null && this.mMessageCode != null) {
                this.mLogger.write(this.mMessageCode, (Object)statement);
            }
            this.addBindData((PreparedStatement)ps);
            ResultSet rs = ps.executeQuery();
            int count = 0;
            ByteArrayOutputStream baos = null;
            CharArrayWriter caw = null;
            byte[] byteBuf = null;
            char[] charBuf = null;
            while (rs.next()) {
                RowData rd = this.createNewRecord();
                int rscnt = 1;
                int imax2 = this.mSchema.size();
                for (int i = 0; i < imax2; ++i) {
                    FieldSchema fs = this.mSchema.get(i);
                    if (fs.getFieldKey() == 4) continue;
                    Object obj = null;
                    switch (fs.getSqlType()) {
                        case 93: {
                            obj = rs.getTimestamp(rscnt);
                            if (obj == null) break;
                            obj = new Date(((Timestamp)obj).getTime());
                            break;
                        }
                        case 2004: {
                            InputStream is = rs.getBinaryStream(rscnt);
                            if (is == null) break;
                            if (baos == null) {
                                baos = new ByteArrayOutputStream();
                                byteBuf = new byte[1024];
                            }
                            try {
                                int readLength = 0;
                                while ((readLength = is.read(byteBuf)) != -1) {
                                    baos.write(byteBuf, 0, readLength);
                                }
                            }
                            catch (IOException e) {
                                throw new SQLException("I/O error in reading BLOB." + e.getMessage());
                            }
                            obj = baos.toByteArray();
                            baos.reset();
                            break;
                        }
                        case 2005: {
                            Reader reader = rs.getCharacterStream(rscnt);
                            if (reader == null) break;
                            if (caw == null) {
                                caw = new CharArrayWriter();
                                charBuf = new char[1024];
                            }
                            try {
                                int readLength = 0;
                                while ((readLength = reader.read(charBuf)) != -1) {
                                    caw.write(charBuf, 0, readLength);
                                }
                            }
                            catch (IOException e) {
                                throw new SQLException("I/O error in reading BLOB." + e.getMessage());
                            }
                            obj = caw.toCharArray();
                            caw.reset();
                            break;
                        }
                        default: {
                            obj = rs.getObject(rscnt);
                        }
                    }
                    if (fs.isCrypt()) {
                        obj = this.doEncrypt(obj);
                    }
                    rd.setValueNative(i, obj);
                    ++rscnt;
                }
                rd.setTransactionMode(0);
                this.addRecord(rd);
                if (max <= 0 || ++count < max) continue;
                break;
            }
            rs.close();
            int n = count;
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public Collection searchDynamicCondition() {
        return this.searchDynamicCondition(null);
    }

    public Collection searchDynamicCondition(String name) {
        if (this.dynamicSearchConditionResultMap == null || this.dynamicSearchConditionResultMap.size() == 0) {
            return new HashSet();
        }
        Map values = (Map)this.dynamicSearchConditionResultMap.get(name);
        if (values == null) {
            return new HashSet();
        }
        return values.values();
    }

    public RecordSet filterDynamicCondition() {
        return this.filterDynamicCondition(null);
    }

    public RecordSet filterDynamicCondition(String name) {
        Collection records = this.searchDynamicCondition(name);
        if (this.size() != records.size()) {
            this.clear();
            Iterator itr = records.iterator();
            while (itr.hasNext()) {
                this.addRecord((RowData)itr.next());
            }
        }
        return this;
    }

    public Collection searchDynamicConditionReal(String condition) throws Exception {
        return this.searchDynamicConditionReal(condition, (int[])null, (boolean[])null);
    }

    public Collection searchDynamicConditionReal(String condition, Map valueMap) throws Exception {
        return this.searchDynamicConditionReal(condition, (int[])null, (boolean[])null, valueMap);
    }

    public Collection searchDynamicConditionReal(String condition, String[] orderBy) throws Exception {
        return this.searchDynamicConditionReal(condition, orderBy, (boolean[])null);
    }

    public Collection searchDynamicConditionReal(String condition, String[] orderBy, Map valueMap) throws Exception {
        return this.searchDynamicConditionReal(condition, orderBy, (boolean[])null, valueMap);
    }

    public Collection searchDynamicConditionReal(String condition, int[] orderBy) throws Exception {
        return this.searchDynamicConditionReal(condition, orderBy, (boolean[])null);
    }

    public Collection searchDynamicConditionReal(String condition, int[] orderBy, Map valueMap) throws Exception {
        return this.searchDynamicConditionReal(condition, orderBy, (boolean[])null, valueMap);
    }

    public Collection searchDynamicConditionReal(String condition, String[] orderBy, boolean[] isAsc) throws Exception {
        return this.searchDynamicConditionReal(condition, orderBy, isAsc, null);
    }

    public Collection searchDynamicConditionReal(String condition, String[] orderBy, boolean[] isAsc, Map valueMap) throws Exception {
        return this.searchDynamicConditionReal(condition, this.convertFromColNamesToColIndexes(orderBy), isAsc, valueMap);
    }

    public Collection searchDynamicConditionReal(String condition, int[] orderBy, boolean[] isAsc) throws Exception {
        return this.searchDynamicConditionReal(condition, orderBy, isAsc, null);
    }

    public Collection searchDynamicConditionReal(String condition, int[] orderBy, boolean[] isAsc, Map valueMap) throws Exception {
        if (this.size() == 0) {
            return new HashSet();
        }
        Expression exp = ExpressionFactory.createExpression((String)condition);
        Map result = this.createOrderByMap(orderBy, isAsc);
        JexlContext context = JexlHelper.createContext();
        int imax = this.size();
        for (int i = 0; i < imax; ++i) {
            Boolean ret;
            RowData rd = this.get(i);
            int jmax = this.mSchema.size();
            for (int j = 0; j < jmax; ++j) {
                FieldSchema field = this.mSchema.get(j);
                String fieldName = field.getFieldName();
                context.getVars().put(fieldName, rd.get(j));
            }
            if (valueMap != null) {
                context.getVars().putAll(valueMap);
            }
            if ((ret = (Boolean)exp.evaluate(context)) == null || !ret.booleanValue()) continue;
            result.put(rd, rd);
        }
        return result.values();
    }

    public RecordSet filterDynamicConditionReal(String condition) throws Exception {
        return this.filterDynamicConditionReal(condition, (int[])null);
    }

    public RecordSet filterDynamicConditionReal(String condition, Map valueMap) throws Exception {
        return this.filterDynamicConditionReal(condition, (int[])null, valueMap);
    }

    public RecordSet filterDynamicConditionReal(String condition, String[] orderBy) throws Exception {
        return this.filterDynamicConditionReal(condition, orderBy, (boolean[])null);
    }

    public RecordSet filterDynamicConditionReal(String condition, String[] orderBy, Map valueMap) throws Exception {
        return this.filterDynamicConditionReal(condition, orderBy, (boolean[])null, valueMap);
    }

    public RecordSet filterDynamicConditionReal(String condition, int[] orderBy) throws Exception {
        return this.filterDynamicConditionReal(condition, orderBy, (boolean[])null);
    }

    public RecordSet filterDynamicConditionReal(String condition, int[] orderBy, Map valueMap) throws Exception {
        return this.filterDynamicConditionReal(condition, orderBy, (boolean[])null, valueMap);
    }

    public RecordSet filterDynamicConditionReal(String condition, String[] orderBy, boolean[] isAsc) throws Exception {
        return this.filterDynamicConditionReal(condition, orderBy, isAsc, null);
    }

    public RecordSet filterDynamicConditionReal(String condition, String[] orderBy, boolean[] isAsc, Map valueMap) throws Exception {
        return this.filterDynamicConditionReal(condition, this.convertFromColNamesToColIndexes(orderBy), isAsc, valueMap);
    }

    public RecordSet filterDynamicConditionReal(String condition, int[] orderBy, boolean[] isAsc) throws Exception {
        return this.filterDynamicConditionReal(condition, orderBy, isAsc, null);
    }

    public RecordSet filterDynamicConditionReal(String condition, int[] orderBy, boolean[] isAsc, Map valueMap) throws Exception {
        Collection records = this.searchDynamicConditionReal(condition, orderBy, isAsc, valueMap);
        if (this.size() != records.size()) {
            this.clear();
            Iterator itr = records.iterator();
            while (itr.hasNext()) {
                this.addRecord((RowData)itr.next());
            }
        }
        return this;
    }

    public Collection searchDynamicKey(RowData key) {
        return this.searchDynamicKey(null, key);
    }

    public Collection searchDynamicKey(String name, RowData key) {
        if (this.dynamicSearchKeyMap == null || this.dynamicSearchMap == null) {
            return new HashSet();
        }
        DynamicSearchKeyValue keyValue = (DynamicSearchKeyValue)this.dynamicSearchKeyMap.get(name);
        if (keyValue == null || keyValue.colIndexes == null) {
            return new HashSet();
        }
        Object values = this.dynamicSearchMap.get(key.getKey(keyValue.colIndexes));
        if (values == null) {
            return new HashSet();
        }
        if (values instanceof Map) {
            return ((Map)values).values();
        }
        HashSet result = new HashSet();
        result.add(values);
        return result;
    }

    public Collection searchDynamicKey(String name, RowData key, String[] orderBy, boolean[] isAsc) {
        return this.searchDynamicKey(name, key, this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public Collection searchDynamicKey(String name, RowData key, int[] orderBy, boolean[] isAsc) {
        Collection collection = this.searchDynamicKey(name, key);
        if (collection.size() < 2) {
            return collection;
        }
        ArrayList rows = new ArrayList(collection);
        Comparator comp = this.createOrderByComparator(orderBy, isAsc);
        if (comp == null) {
            if (this.mSchema == null) {
                throw new InvalidDataException("Schema not initalize.");
            }
            int[] colIndexes = new int[this.mSchema.getUniqueKeySize()];
            for (int i = 0; i < colIndexes.length; ++i) {
                colIndexes[i] = this.mSchema.getUniqueFieldSchema(i).getIndex();
            }
            comp = new RowDataComparator(colIndexes, isAsc);
        }
        Collections.sort(rows, comp);
        return rows;
    }

    public RecordSet filterDynamicKey(RowData key) {
        return this.filterDynamicKey(null, key);
    }

    public RecordSet filterDynamicKey(String name, RowData key) {
        Collection records = this.searchDynamicKey(name, key);
        if (this.size() != records.size()) {
            this.clear();
            Iterator itr = records.iterator();
            while (itr.hasNext()) {
                this.addRecord((RowData)itr.next());
            }
        }
        return this;
    }

    public Collection searchRecords(RecordSet recset) {
        return this.searchRecords(recset, (int[])null);
    }

    public Collection searchRecords(RecordSet recset, String[] orderBy) {
        return this.searchRecords(recset, orderBy, (boolean[])null);
    }

    public Collection searchRecords(RecordSet recset, int[] orderBy) {
        return this.searchRecords(recset, orderBy, (boolean[])null);
    }

    public Collection searchRecords(RecordSet recset, String[] orderBy, boolean[] isAsc) {
        return this.searchRecords(recset, this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public Collection searchRecords(RecordSet recset, int[] orderBy, boolean[] isAsc) {
        if (recset == null || recset.size() == 0) {
            return new HashSet();
        }
        if (this.mSchema == null) {
            throw new InvalidDataException("Schema not initalize.");
        }
        RowSchema keySchema = recset.getRowSchema();
        int uniqueKeySize = this.mSchema.getUniqueKeySize();
        int[] uniqueKeyIndexes = new int[uniqueKeySize];
        for (int i = 0; i < uniqueKeySize; ++i) {
            String colName = this.mSchema.getUniqueFieldSchema(i).getFieldName();
            FieldSchema field = keySchema.get(colName);
            if (field == null) {
                return new HashSet();
            }
            uniqueKeyIndexes[i] = field.getIndex();
        }
        Map records = this.createOrderByMap(orderBy, isAsc);
        int imax = recset.size();
        for (int i = 0; i < imax; ++i) {
            RowData key = recset.get(i);
            RowData rec = this.get(key.getKey(uniqueKeyIndexes));
            if (rec == null) continue;
            records.put(rec, rec);
        }
        return records.values();
    }

    public RecordSet filterRecords(RecordSet recset) {
        return this.filterRecords(recset, (int[])null);
    }

    public RecordSet filterRecords(RecordSet recset, String[] orderBy) {
        return this.filterRecords(recset, orderBy, (boolean[])null);
    }

    public RecordSet filterRecords(RecordSet recset, int[] orderBy) {
        return this.filterRecords(recset, orderBy, (boolean[])null);
    }

    public RecordSet filterRecords(RecordSet recset, String[] orderBy, boolean[] isAsc) {
        return this.filterRecords(recset, this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public RecordSet filterRecords(RecordSet recset, int[] orderBy, boolean[] isAsc) {
        Collection records = this.searchRecords(recset, orderBy, isAsc);
        if (this.size() != records.size()) {
            this.clear();
            Iterator itr = records.iterator();
            while (itr.hasNext()) {
                this.addRecord((RowData)itr.next());
            }
        }
        return this;
    }

    protected ArrayList getList() {
        return this.mRows;
    }

    protected HashMap getHash() {
        return this.mHash;
    }

    public RowData get(int index) {
        return (RowData)this.mRows.get(index);
    }

    public RowData get(String key) {
        return (RowData)this.mHash.get(key);
    }

    public RowData get(RowData key) {
        return this.get(key.getKey());
    }

    public RowData[] toArray() {
        return this.mRows.toArray(new RowData[this.mRows.size()]);
    }

    public List toList() {
        return new ArrayList(this.mRows);
    }

    public int size() {
        return this.mRows.size();
    }

    public void sort() {
        this.sort((int[])null);
    }

    public void sort(String[] orderBy) {
        this.sort(orderBy, null);
    }

    public void sort(int[] orderBy) {
        this.sort(orderBy, null);
    }

    public void sort(String[] orderBy, boolean[] isAsc) {
        this.sort(this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public void sort(int[] orderBy, boolean[] isAsc) {
        this.sort(orderBy, isAsc, true);
    }

    public void sort(String[] orderBy, boolean[] isAsc, boolean isSetRowNum) {
        this.sort(this.convertFromColNamesToColIndexes(orderBy), isAsc, isSetRowNum);
    }

    public void sort(int[] orderBy, boolean[] isAsc, boolean isSetRowNum) {
        if (this.mRows.size() < 2) {
            return;
        }
        Comparator comp = this.createOrderByComparator(orderBy, isAsc);
        if (comp == null) {
            if (this.mSchema == null) {
                throw new InvalidDataException("Schema not initalize.");
            }
            int[] colIndexes = new int[this.mSchema.getUniqueKeySize()];
            for (int i = 0; i < colIndexes.length; ++i) {
                colIndexes[i] = this.mSchema.getUniqueFieldSchema(i).getIndex();
            }
            comp = new RowDataComparator(colIndexes, isAsc);
        }
        Collections.sort(this.mRows, comp);
        if (isSetRowNum) {
            int imax = this.mRows.size();
            for (int i = 0; i < imax; ++i) {
                ((RowData)this.mRows.get(i)).setRowIndex(i);
            }
        }
    }

    public Comparator createRowComparator() {
        if (this.mSchema == null) {
            throw new InvalidDataException("Schema not initalize.");
        }
        int uniqueKeySize = this.mSchema.getUniqueKeySize();
        if (uniqueKeySize == 0) {
            throw new InvalidDataException("Unique key not found.");
        }
        int[] orderBy = new int[uniqueKeySize];
        for (int i = 0; i < uniqueKeySize; ++i) {
            FieldSchema fieldSchema = this.mSchema.getUniqueFieldSchema(i);
            orderBy[i] = fieldSchema.getIndex();
        }
        return this.createRowComparator(orderBy);
    }

    public Comparator createRowComparator(String[] orderBy) {
        return this.createRowComparator(orderBy, null);
    }

    public Comparator createRowComparator(int[] orderBy) {
        return this.createRowComparator(orderBy, null);
    }

    public Comparator createRowComparator(String[] orderBy, boolean[] isAsc) {
        return this.createRowComparator(this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public Comparator createRowComparator(int[] orderBy, boolean[] isAsc) {
        return new RowDataComparator(orderBy, isAsc);
    }

    public RecordSet makeGoneData() {
        RecordSet ret = this.cloneEmpty();
        int i = this.size();
        while (--i >= 0) {
            RowData rd = this.get(i);
            int tmode = rd.getTransactionMode();
            if (tmode != 2 && tmode != 3 && tmode != 1 && tmode != 4) continue;
            ret.addRecord(rd.makeGoneData(ret.mSchema));
        }
        return ret;
    }

    public void insertRecord(RowData rd) {
        rd.setTransactionMode(3);
        this.addRecord(rd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRecord(RowData rd) {
        Map.Entry entry;
        Iterator entries;
        String key = rd.getKey();
        if (rd.mRowSchema != this.mSchema && this.mSchema.equals(rd.mRowSchema)) {
            rd.mRowSchema = this.mSchema;
        }
        if (key != null && key.length() > 0) {
            Object tmp = this.mHash.get(key);
            if (tmp == null) {
                this.mHash.put(key, rd);
                this.mRows.add(rd);
            } else {
                RowData tmpRd = (RowData)tmp;
                if (tmpRd.getTransactionMode() == 2 && rd.getTransactionMode() == 3) {
                    this.mHash.remove(key);
                    this.mRows.remove(tmpRd);
                    this.mHash.put(key, rd);
                    this.mRows.add(rd);
                    rd.setTransactionModeForce(4);
                    rd.setRowIndex(tmpRd.getRowIndex());
                } else {
                    if (tmpRd.getTransactionMode() != 3 || rd.getTransactionMode() != 2) throw new InvalidDataException("key duplicate");
                    tmpRd.setTransactionModeForce(4);
                }
            }
        } else {
            this.mRows.add(rd);
        }
        rd.setRowIndex(this.mRows.size() - 1);
        if (this.dynamicSearchKeyMap != null && this.dynamicSearchKeyMap.size() != 0) {
            if (this.dynamicSearchMap == null) {
                this.dynamicSearchMap = new HashMap();
            }
            entries = this.dynamicSearchKeyMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                DynamicSearchKeyValue keyValue = (DynamicSearchKeyValue)entry.getValue();
                String myKey = rd.getKey(keyValue.colIndexes);
                Object values = this.dynamicSearchMap.get(myKey);
                if (values == null) {
                    this.dynamicSearchMap.put(myKey, rd);
                    continue;
                }
                if (values instanceof Map) {
                    ((Map)values).put(rd.getKey(), rd);
                    continue;
                }
                Map valMap = this.createOrderByMap(keyValue.orderBy, keyValue.isAsc);
                valMap.put(((RowData)values).getKey(), values);
                valMap.put(rd.getKey(), rd);
                this.dynamicSearchMap.put(myKey, valMap);
            }
        }
        if (this.dynamicSearchConditionMap == null || this.dynamicSearchConditionMap.size() == 0) return;
        entries = this.dynamicSearchConditionMap.entrySet().iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            String name = (String)entry.getKey();
            Expression exp = (Expression)entry.getValue();
            JexlContext context = JexlHelper.createContext();
            int imax = this.mSchema.size();
            for (int i = 0; i < imax; ++i) {
                FieldSchema field = this.mSchema.get(i);
                String fieldName = field.getFieldName();
                context.getVars().put(fieldName, rd.get(i));
            }
            Boolean ret = null;
            try {
                ret = (Boolean)exp.evaluate(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ret == null || !ret.booleanValue()) continue;
            Map values = (Map)this.dynamicSearchConditionResultMap.get(name);
            values.put(rd, rd);
        }
    }

    public void addAllRecord(RecordSet recset) {
        if (recset == null || recset.size() == 0) {
            return;
        }
        if (this.mSchema == null) {
            throw new InvalidDataException("Schema not initalize.");
        }
        if (!this.mSchema.equals(recset.getRowSchema())) {
            throw new InvalidDataException("Schema is unmatch.");
        }
        int imax = recset.size();
        for (int i = 0; i < imax; ++i) {
            this.addRecord(recset.get(i));
        }
    }

    public void clear() {
        this.mRows.clear();
        this.mHash.clear();
        if (this.bindDatas != null) {
            this.bindDatas.clear();
        }
        if (this.dynamicSearchConditionResultMap != null && this.dynamicSearchConditionResultMap.size() != 0) {
            Iterator itr = this.dynamicSearchConditionResultMap.values().iterator();
            while (itr.hasNext()) {
                ((Map)itr.next()).clear();
            }
        }
        if (this.dynamicSearchMap != null) {
            this.dynamicSearchMap.clear();
        }
    }

    public void updateRecord() throws SQLException, RowVersionException {
        this.updateRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateRecords() throws SQLException, RowVersionException {
        PreparedStatement psUpdate;
        PreparedStatement psDelete;
        int result;
        block21: {
            result = 0;
            int updateCnt = 0;
            int insertCnt = 0;
            int deleteCnt = 0;
            int imax = this.size();
            block8: for (int i = 0; i < imax; ++i) {
                RowData rd = this.get(i);
                switch (rd.getTransactionMode()) {
                    case 3: {
                        ++insertCnt;
                        continue block8;
                    }
                    case 2: {
                        ++deleteCnt;
                        continue block8;
                    }
                    case 1: {
                        ++updateCnt;
                        continue block8;
                    }
                    case 4: {
                        ++deleteCnt;
                        ++insertCnt;
                    }
                }
            }
            psDelete = null;
            PreparedStatement psInsert = null;
            psUpdate = null;
            try {
                if (deleteCnt > 0) {
                    int nowDeleteCnt = 0;
                    psDelete = this.createDeletePreparedStatement();
                    if (psDelete != null) {
                        nowDeleteCnt = this.executeDelete(psDelete);
                    }
                    if (this.isEnabledRowVersionCheck && nowDeleteCnt != deleteCnt) {
                        throw new RowVersionException("Delete count is unmatch : expected " + deleteCnt + ", but was " + nowDeleteCnt);
                    }
                    result += nowDeleteCnt;
                }
                if (insertCnt > 0 && (psInsert = this.createInsertPreparedStatement()) != null) {
                    result += this.executeInsert(psInsert);
                }
                if (updateCnt > 0) {
                    int nowUpdateCnt = 0;
                    psUpdate = this.createUpdatePreparedStatement();
                    if (psUpdate != null) {
                        nowUpdateCnt = this.executeUpdate(psUpdate);
                    }
                    if (this.isEnabledRowVersionCheck && nowUpdateCnt != updateCnt) {
                        throw new RowVersionException("Update count is unmatch : expected " + updateCnt + ", but was " + nowUpdateCnt);
                    }
                    result += nowUpdateCnt;
                }
                Object var10_11 = null;
                if (psInsert == null) break block21;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (psInsert != null) {
                    psInsert.close();
                }
                if (psUpdate != null) {
                    psUpdate.close();
                }
                if (psDelete != null) {
                    psDelete.close();
                }
                throw throwable;
            }
            psInsert.close();
        }
        if (psUpdate != null) {
            psUpdate.close();
        }
        if (psDelete != null) {
            psDelete.close();
        }
        return result;
    }

    protected PreparedStatement createInsertPreparedStatement() throws SQLException {
        int i;
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        sb.append(C_INSERT_TOKEN);
        sb.append(this.mUpdateTableNames == null ? this.mTableNames : this.mUpdateTableNames);
        sb.append(C_BRACKETS_BEGIN_TOKEN);
        int imax = this.mSchema.size();
        for (i = 0; i < imax; ++i) {
            if (!this.mSchema.get(i).isUpdateField()) continue;
            sb.append(this.mSchema.get(i).getFieldName());
            if (i == imax - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.delete(sb.length() - 1, sb.length());
        }
        this.addInsertColmun(sb);
        sb.append(C_BRACKETS_END_TOKEN);
        sb.append(C_VALUES_TOKEN);
        sb.append(C_BRACKETS_BEGIN_TOKEN);
        imax = this.mSchema.size();
        for (i = 0; i < imax; ++i) {
            if (!this.mSchema.get(i).isUpdateField()) continue;
            sb.append(C_QUESTION_TOKEN);
            if (i == imax - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.delete(sb.length() - 1, sb.length());
        }
        this.addInsertField(sb);
        sb.append(C_BRACKETS_END_TOKEN);
        ps = this.mCon.prepareStatement(sb.toString());
        if (this.mLogger != null && this.mMessageCode != null) {
            this.mLogger.write(this.mMessageCode, (Object)sb.toString());
        }
        return ps;
    }

    protected int executeInsert(PreparedStatement ps) throws SQLException {
        int insertCnt = 0;
        int imax = this.size();
        for (int i = 0; i < imax; ++i) {
            RowData rd = this.get(i);
            int param_idx = 1;
            if (rd.getTransactionMode() != 3 && rd.getTransactionMode() != 4) continue;
            int jmax = this.mSchema.size();
            block5: for (int j = 0; j < jmax; ++j) {
                FieldSchema fs = this.mSchema.get(j);
                if (!fs.isUpdateField()) continue;
                if (fs.isRowVersionField()) {
                    ps.setObject(param_idx++, new Integer(1));
                    continue;
                }
                Object o = rd.getSqlTypeValue(j);
                if (o == null) {
                    ps.setNull(param_idx++, fs.getSqlType());
                    continue;
                }
                switch (fs.getFieldType()) {
                    case 10: {
                        byte[] bytes = (byte[])o;
                        ps.setBinaryStream(param_idx++, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                        continue block5;
                    }
                    case 11: {
                        char[] chars = (char[])o;
                        ps.setCharacterStream(param_idx++, (Reader)new CharArrayReader(chars), chars.length);
                        continue block5;
                    }
                    default: {
                        if (fs.isCrypt()) {
                            o = this.doCrypt(o);
                        }
                        ps.setObject(param_idx++, o);
                    }
                }
            }
            this.addInsertBind(ps, param_idx);
            if (this.isBatchExecute) {
                ps.addBatch();
                continue;
            }
            insertCnt += ps.executeUpdate();
        }
        if (this.isBatchExecute) {
            int[] ret = ps.executeBatch();
            if (ret != null) {
                for (int i = 0; i < ret.length; ++i) {
                    if (ret[i] <= 0) continue;
                    insertCnt += ret[i];
                }
            }
            if (insertCnt == 0) {
                insertCnt = ps.getUpdateCount();
            }
        }
        return insertCnt;
    }

    protected void addInsertColmun(StringBuffer sb) {
    }

    protected void addInsertField(StringBuffer sb) {
    }

    protected void addInsertBind(PreparedStatement ps, int index) throws SQLException {
    }

    protected PreparedStatement createUpdatePreparedStatement() throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        sb.append(C_UPDATE_TOKEN);
        sb.append(this.mUpdateTableNames == null ? this.mTableNames : this.mUpdateTableNames);
        sb.append(C_SET_TOKEN);
        int imax = this.mSchema.size();
        for (int i = 0; i < imax; ++i) {
            if (!this.mSchema.get(i).isUpdateField() || this.mSchema.get(i).isUniqueKey()) continue;
            sb.append(this.mSchema.get(i).getFieldName());
            sb.append(C_EQUAL_TOKEN);
            sb.append(C_QUESTION_TOKEN);
            if (i == imax - 1) continue;
            sb.append(C_COMMA_TOKEN);
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.delete(sb.length() - 1, sb.length());
        }
        this.addUpdateField(sb);
        boolean whereFlg = false;
        int imax2 = this.mSchema.size();
        for (int i = 0; i < imax2; ++i) {
            FieldSchema fSchema = this.mSchema.get(i);
            if (!fSchema.isUniqueKey() && !fSchema.isRowVersionField()) continue;
            if (!whereFlg) {
                sb.append(C_WHERE_TOKEN);
                whereFlg = true;
            }
            sb.append(fSchema.getFieldName());
            sb.append(C_EQUAL_TOKEN);
            sb.append(C_QUESTION_TOKEN);
            sb.append(C_AND_TOKEN);
        }
        if (whereFlg) {
            sb.delete(sb.length() - 5, sb.length());
        }
        ps = this.mCon.prepareStatement(sb.toString());
        if (this.mLogger != null && this.mMessageCode != null) {
            this.mLogger.write(this.mMessageCode, (Object)sb.toString());
        }
        return ps;
    }

    protected int executeUpdate(PreparedStatement ps) throws SQLException {
        int updateCnt = 0;
        int imax = this.size();
        for (int i = 0; i < imax; ++i) {
            char[] chars;
            byte[] bytes;
            Object o;
            FieldSchema fs;
            int j;
            RowData rd = this.get(i);
            int param_idx = 1;
            if (rd.getTransactionMode() != 1) continue;
            int jmax = this.mSchema.size();
            block9: for (j = 0; j < jmax; ++j) {
                fs = this.mSchema.get(j);
                if (!fs.isUpdateField() || fs.isUniqueKey()) continue;
                if (fs.isRowVersionField()) {
                    ps.setObject(param_idx++, new Integer(rd.getIntValue(j) + 1));
                    continue;
                }
                o = rd.getSqlTypeValue(j);
                if (o == null) {
                    ps.setNull(param_idx++, fs.getSqlType());
                    continue;
                }
                switch (fs.getFieldType()) {
                    case 10: {
                        bytes = (byte[])o;
                        ps.setBinaryStream(param_idx++, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                        continue block9;
                    }
                    case 11: {
                        chars = (char[])o;
                        ps.setCharacterStream(param_idx++, (Reader)new CharArrayReader(chars), chars.length);
                        continue block9;
                    }
                    default: {
                        if (fs.isCrypt()) {
                            o = this.doCrypt(o);
                        }
                        ps.setObject(param_idx++, o);
                    }
                }
            }
            param_idx = this.addUpdateBind(ps, param_idx);
            jmax = this.mSchema.size();
            block10: for (j = 0; j < jmax; ++j) {
                fs = this.mSchema.get(j);
                if (!fs.isUniqueKey() && !this.mSchema.get(j).isRowVersionField()) continue;
                o = rd.getSqlTypeValue(j);
                if (o == null) {
                    ps.setNull(param_idx++, fs.getSqlType());
                    continue;
                }
                switch (fs.getFieldType()) {
                    case 10: {
                        bytes = (byte[])o;
                        ps.setBinaryStream(param_idx++, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                        continue block10;
                    }
                    case 11: {
                        chars = (char[])o;
                        ps.setCharacterStream(param_idx++, (Reader)new CharArrayReader(chars), chars.length);
                        continue block10;
                    }
                    default: {
                        if (fs.isCrypt()) {
                            o = this.doCrypt(o);
                        }
                        ps.setObject(param_idx++, o);
                    }
                }
            }
            if (this.isBatchExecute) {
                ps.addBatch();
                continue;
            }
            updateCnt += ps.executeUpdate();
        }
        if (this.isBatchExecute) {
            int[] ret = ps.executeBatch();
            if (ret != null) {
                for (int i = 0; i < ret.length; ++i) {
                    if (ret[i] <= 0) continue;
                    updateCnt += ret[i];
                }
            }
            if (updateCnt == 0) {
                updateCnt = ps.getUpdateCount();
            }
        }
        return updateCnt;
    }

    protected void addUpdateField(StringBuffer sb) {
    }

    protected int addUpdateBind(PreparedStatement ps, int index) throws SQLException {
        return index;
    }

    protected PreparedStatement createDeletePreparedStatement() throws SQLException {
        PreparedStatement ps = null;
        StringBuffer sb = new StringBuffer();
        sb.append(C_DELETE_TOKEN);
        sb.append(this.mUpdateTableNames == null ? this.mTableNames : this.mUpdateTableNames);
        boolean whereFlg = false;
        int imax = this.mSchema.size();
        for (int i = 0; i < imax; ++i) {
            if (!this.mSchema.get(i).isUniqueKey()) continue;
            if (!whereFlg) {
                sb.append(C_WHERE_TOKEN);
                whereFlg = true;
            }
            sb.append(this.mSchema.get(i).getFieldName());
            sb.append(C_EQUAL_TOKEN);
            sb.append(C_QUESTION_TOKEN);
            sb.append(C_AND_TOKEN);
        }
        if (whereFlg) {
            sb.delete(sb.length() - 5, sb.length());
        }
        ps = this.mCon.prepareStatement(sb.toString());
        if (this.mLogger != null && this.mMessageCode != null) {
            this.mLogger.write(this.mMessageCode, (Object)sb.toString());
        }
        return ps;
    }

    protected int executeDelete(PreparedStatement ps) throws SQLException {
        int deleteCnt = 0;
        int imax = this.size();
        for (int i = 0; i < imax; ++i) {
            RowData rd = this.get(i);
            int param_idx = 1;
            if (rd.getTransactionMode() != 2 && rd.getTransactionMode() != 4) continue;
            block5: for (int j = 0; j < this.mSchema.size(); ++j) {
                FieldSchema fs = this.mSchema.get(j);
                if (!this.mSchema.get(j).isUniqueKey()) continue;
                Object o = rd.getSqlTypeValue(j);
                if (o == null) {
                    ps.setNull(param_idx++, fs.getSqlType());
                    continue;
                }
                switch (fs.getFieldType()) {
                    case 10: {
                        byte[] bytes = (byte[])o;
                        ps.setBinaryStream(param_idx++, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
                        continue block5;
                    }
                    case 11: {
                        char[] chars = (char[])o;
                        ps.setCharacterStream(param_idx++, (Reader)new CharArrayReader(chars), chars.length);
                        continue block5;
                    }
                    default: {
                        if (fs.isCrypt()) {
                            o = this.doCrypt(o);
                        }
                        ps.setObject(param_idx++, rd.get(j));
                    }
                }
            }
            if (this.isBatchExecute) {
                ps.addBatch();
                continue;
            }
            deleteCnt += ps.executeUpdate();
        }
        if (this.isBatchExecute) {
            int[] ret = ps.executeBatch();
            if (ret != null) {
                for (int i = 0; i < ret.length; ++i) {
                    if (ret[i] <= 0) continue;
                    deleteCnt += ret[i];
                }
            }
            if (deleteCnt == 0) {
                deleteCnt = ps.getUpdateCount();
            }
        }
        return deleteCnt;
    }

    protected Object doEncrypt(Object obj) {
        if (this.mCrypt == null || obj == null) {
            return obj;
        }
        if (obj instanceof String) {
            obj = this.mCrypt.doDecode((String)obj);
        }
        return obj;
    }

    protected Object doCrypt(Object obj) {
        if (this.mCrypt == null || obj == null) {
            return obj;
        }
        if (obj instanceof String) {
            obj = this.mCrypt.doEncode((String)obj);
        }
        return obj;
    }

    public RecordSet cloneEmpty() {
        RecordSet newRecSet = null;
        try {
            newRecSet = (RecordSet)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        newRecSet.mRows = new ArrayList();
        newRecSet.mHash = new HashMap();
        if (this.where != null) {
            newRecSet.where = new StringBuffer(this.where.toString());
        }
        if (this.bindDatas != null) {
            newRecSet.bindDatas = new ArrayList(this.bindDatas);
        }
        if (this.dynamicSearchKeyMap != null) {
            newRecSet.dynamicSearchKeyMap = new HashMap(this.dynamicSearchKeyMap);
        }
        if (this.dynamicSearchConditionMap != null) {
            newRecSet.dynamicSearchConditionMap = new HashMap(this.dynamicSearchConditionMap);
        }
        if (this.dynamicSearchConditionResultMap != null) {
            newRecSet.dynamicSearchConditionResultMap = new HashMap();
            Iterator entries = this.dynamicSearchConditionResultMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                AbstractMap map = (LinkedHashMap)entry.getValue();
                map = map instanceof SortedMap ? new TreeMap(((SortedMap)((Object)map)).comparator()) : new LinkedHashMap();
                newRecSet.dynamicSearchConditionResultMap.put(entry.getKey(), map);
            }
        }
        newRecSet.dynamicSearchMap = null;
        if (this.partUpdateOrderBy != null) {
            newRecSet.partUpdateOrderBy = new int[this.partUpdateOrderBy.length];
            System.arraycopy(this.partUpdateOrderBy, 0, newRecSet.partUpdateOrderBy, 0, this.partUpdateOrderBy.length);
        }
        if (this.partUpdateIsAsc != null) {
            newRecSet.partUpdateIsAsc = new boolean[this.partUpdateIsAsc.length];
            System.arraycopy(this.partUpdateIsAsc, 0, newRecSet.partUpdateIsAsc, 0, this.partUpdateIsAsc.length);
        }
        return newRecSet;
    }

    public RecordSet shallowCopy() {
        Map.Entry entry;
        Iterator entries;
        RecordSet recset = this.cloneEmpty();
        recset.mRows = new ArrayList(this.mRows);
        recset.mHash = new HashMap(this.mHash);
        if (this.dynamicSearchMap != null) {
            recset.dynamicSearchMap = new HashMap();
            entries = this.dynamicSearchMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                if (entry.getValue() instanceof Map) {
                    recset.dynamicSearchMap.put(entry.getKey(), new LinkedHashMap((Map)entry.getValue()));
                    continue;
                }
                recset.dynamicSearchMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (recset.dynamicSearchConditionResultMap != null) {
            entries = recset.dynamicSearchConditionResultMap.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                Map src = (Map)this.dynamicSearchConditionResultMap.get(entry.getKey());
                ((Map)entry.getValue()).putAll(src);
            }
        }
        return recset;
    }

    public RecordSet deepCopy() {
        return (RecordSet)this.cloneAndUpdate(null);
    }

    public void setPartUpdateSort(String[] orderBy, boolean[] isAsc) {
        this.setPartUpdateSort(this.convertFromColNamesToColIndexes(orderBy), isAsc);
    }

    public void setPartUpdateSort(int[] orderBy, boolean[] isAsc) {
        this.partUpdateOrderBy = orderBy;
        this.partUpdateIsAsc = isAsc;
    }

    public PartUpdateRecords createPartUpdateRecords() {
        PartUpdateRecords records = new PartUpdateRecords();
        int i = this.size();
        while (--i >= 0) {
            RowData rd = this.get(i);
            int tmode = rd.getTransactionMode();
            if (tmode != 2 && tmode != 3 && tmode != 1 && tmode != 4) continue;
            records.addRecord(rd.createCodeMasterUpdateKey());
        }
        return records;
    }

    public PartUpdate cloneAndUpdate(PartUpdateRecords records) {
        RecordSet newRecSet = this.cloneEmpty();
        CodeMasterUpdateKey tmpKey = new CodeMasterUpdateKey();
        CodeMasterUpdateKey key = null;
        Iterator oldRows = this.mRows.iterator();
        block3: while (oldRows.hasNext()) {
            RowData oldRow = (RowData)oldRows.next();
            tmpKey = oldRow.createCodeMasterUpdateKey(tmpKey);
            key = records == null ? null : records.getKey(tmpKey);
            RowData newRow = null;
            if (key == null) {
                newRow = oldRow.cloneRowData();
            } else {
                switch (key.getUpdateType()) {
                    case 1: 
                    case 2: {
                        newRow = (RowData)records.removeRecord(key);
                        break;
                    }
                    default: {
                        records.removeRecord(key);
                        continue block3;
                    }
                }
            }
            if (newRow == null) continue;
            newRecSet.addRecord(newRow);
        }
        if (records != null && records.size() != 0) {
            Iterator entries = records.getRecords().entrySet().iterator();
            while (entries.hasNext()) {
                RowData row;
                Map.Entry entry = entries.next();
                if (((CodeMasterUpdateKey)entry.getKey()).getUpdateType() != 1 || (row = (RowData)entry.getValue()) == null) continue;
                newRecSet.addRecord(row);
            }
        }
        if (this.partUpdateOrderBy != null && this.partUpdateOrderBy.length != 0) {
            newRecSet.sort(this.partUpdateOrderBy, this.partUpdateIsAsc);
        }
        return newRecSet;
    }

    public PartUpdateRecords fillPartUpdateRecords(CodeMasterUpdateKey key) {
        PartUpdateRecords records = new PartUpdateRecords();
        records.addRecord(key);
        return this.fillPartUpdateRecords(records);
    }

    public PartUpdateRecords fillPartUpdateRecords(PartUpdateRecords records) {
        if (records == null || records.size() == 0 || !records.containsAdd() && !records.containsUpdate()) {
            return records;
        }
        RowData row = this.createNewRecord();
        CodeMasterUpdateKey[] keys = records.getKeyArray();
        for (int i = 0; i < keys.length; ++i) {
            CodeMasterUpdateKey key = keys[i];
            int updateType = key.getUpdateType();
            records.removeRecord(key);
            row.setCodeMasterUpdateKey(key);
            key = row.createCodeMasterUpdateKey(key);
            key.setUpdateType(updateType);
            if (key.isRemove()) {
                records.addRecord(key);
                continue;
            }
            RowData searchRow = this.get(row);
            if (searchRow == null) continue;
            records.addRecord(key, searchRow);
        }
        return records;
    }

    private class RowDataComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -9111641214052663144L;
        private int[] colIndexes;
        private boolean[] isAsc;

        public RowDataComparator(String[] colNames) {
            this(colNames, null);
        }

        public RowDataComparator(String[] colNames, boolean[] isAsc) {
            if (RecordSet.this.mSchema == null) {
                throw new InvalidDataException("Schema not initalize.");
            }
            if (colNames == null || colNames.length == 0) {
                throw new IllegalArgumentException("Column name array is empty.");
            }
            if (isAsc != null && colNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column name array and sort flag array is unmatch.");
            }
            this.colIndexes = new int[colNames.length];
            for (int i = 0; i < colNames.length; ++i) {
                FieldSchema field = RecordSet.this.mSchema.get(colNames[i]);
                if (field == null) {
                    throw new IllegalArgumentException("Field not found : " + colNames[i]);
                }
                this.colIndexes[i] = field.getIndex();
            }
            if (this.colIndexes == null || this.colIndexes.length == 0) {
                throw new IllegalArgumentException("Column index array is empty.");
            }
            this.isAsc = isAsc;
        }

        public RowDataComparator(int[] colIndexes) {
            this(colIndexes, null);
        }

        public RowDataComparator(int[] colIndexes, boolean[] isAsc) {
            if (colIndexes == null || colIndexes.length == 0) {
                throw new IllegalArgumentException("Column index array is empty.");
            }
            if (isAsc != null && colIndexes.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column index array and sort flag array is unmatch.");
            }
            this.colIndexes = colIndexes;
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            RowData rd1 = (RowData)o1;
            RowData rd2 = (RowData)o2;
            if (rd1 == null && rd2 == null) {
                return 0;
            }
            if (rd1 != null && rd2 == null) {
                return 1;
            }
            if (rd1 == null && rd2 != null) {
                return -1;
            }
            for (int i = 0; i < this.colIndexes.length; ++i) {
                Object val1 = rd1.get(this.colIndexes[i]);
                Object val2 = rd2.get(this.colIndexes[i]);
                if (val1 != null && val2 == null) {
                    return this.isAsc == null || this.isAsc[i] ? 1 : -1;
                }
                if (val1 == null && val2 != null) {
                    return this.isAsc == null || this.isAsc[i] ? -1 : 1;
                }
                if (val1 == null || val2 == null) continue;
                FieldSchema field = RecordSet.this.mSchema.get(this.colIndexes[i]);
                int fieldType = field.getFieldType();
                int comp = 0;
                switch (fieldType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: {
                        comp = ((Comparable)val1).compareTo(val2);
                        break;
                    }
                    default: {
                        comp = val1.hashCode() - val2.hashCode();
                    }
                }
                if (comp == 0) continue;
                return this.isAsc == null || this.isAsc[i] ? comp : -1 * comp;
            }
            return 0;
        }
    }

    private class DynamicSearchKeyValue
    implements Serializable {
        private static final long serialVersionUID = -2327997182252855059L;
        public int[] colIndexes;
        public int[] orderBy;
        public boolean[] isAsc;

        public DynamicSearchKeyValue(int[] colIndexes, int[] orderBy, boolean[] isAsc) {
            this.colIndexes = colIndexes;
            this.orderBy = orderBy;
            this.isAsc = isAsc;
        }
    }
}

