/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullNestPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class NestedProperty
implements Property,
Serializable {
    private static final long serialVersionUID = -8976001636216478152L;
    private static final String MSG_00001 = "Illegal NestedProperty : ";
    private static final String MSG_00002 = "Arguments is null.";
    protected Property thisProperty;
    protected Property nestProperty;

    public NestedProperty() {
    }

    public NestedProperty(Property prop, Property nestProp) throws IllegalArgumentException {
        if (prop == null || nestProp == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.thisProperty = prop;
        this.nestProperty = nestProp;
    }

    public void setThisProperty(Property prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.thisProperty = prop;
    }

    public Property getThisProperty() {
        return this.thisProperty;
    }

    public void setNestedProperty(Property nestProp) throws IllegalArgumentException {
        if (nestProp == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.nestProperty = nestProp;
    }

    public Property getNestedProperty() {
        return this.nestProperty;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int index = prop.indexOf(46);
        if (index == -1 || index == 0 || index == prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.thisProperty = PropertyFactory.createProperty(prop.substring(0, index));
        this.nestProperty = PropertyFactory.createProperty(prop.substring(index + 1));
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Object thisObj = this.thisProperty.getProperty(obj);
        if (thisObj == null) {
            throw new NullNestPropertyException(obj.getClass(), this.thisProperty.getPropertyName());
        }
        return this.nestProperty.getPropertyType(thisObj);
    }

    public boolean isReadable(Object obj) {
        Object thisObj = null;
        try {
            thisObj = this.thisProperty.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (thisObj == null) {
            return false;
        }
        return this.nestProperty.isReadable(thisObj);
    }

    public boolean isWritable(Object obj, Class clazz) {
        Object thisObj = null;
        try {
            thisObj = this.thisProperty.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (thisObj == null) {
            return false;
        }
        return this.nestProperty.isWritable(thisObj, clazz);
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Object thisObj = this.thisProperty.getProperty(obj);
        if (thisObj == null) {
            throw new NullNestPropertyException(obj.getClass(), this.thisProperty.getPropertyName());
        }
        return this.nestProperty.getProperty(thisObj);
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, null, value);
    }

    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Object thisObj = this.thisProperty.getProperty(obj);
        if (thisObj == null) {
            throw new NullNestPropertyException(obj.getClass(), this.thisProperty.getPropertyName());
        }
        this.nestProperty.setProperty(thisObj, type, value);
    }

    public String getPropertyName() {
        return this.thisProperty.getPropertyName() + '.' + this.nestProperty.getPropertyName();
    }

    public String toString() {
        return "NestedProperty{" + this.thisProperty.toString() + '.' + this.nestProperty.toString() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NestedProperty)) {
            return false;
        }
        NestedProperty comp = (NestedProperty)obj;
        if (this.thisProperty == null && comp.thisProperty != null || this.thisProperty != null && comp.thisProperty == null) {
            return false;
        }
        if (this.thisProperty != null && comp.thisProperty != null && !this.thisProperty.equals(comp.thisProperty)) {
            return false;
        }
        if (this.nestProperty == null && comp.nestProperty == null) {
            return true;
        }
        if (this.nestProperty == null) {
            return false;
        }
        return this.nestProperty.equals(comp.nestProperty);
    }

    public int hashCode() {
        return (this.thisProperty == null ? 0 : this.thisProperty.hashCode()) + (this.nestProperty == null ? 0 : this.nestProperty.hashCode()) + 3;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof NestedProperty)) {
            return 1;
        }
        NestedProperty comp = (NestedProperty)obj;
        if (this.thisProperty == null && comp.thisProperty != null) {
            return -1;
        }
        if (this.thisProperty != null && comp.thisProperty == null) {
            return 1;
        }
        if (this.thisProperty != null && comp.thisProperty != null) {
            if (this.thisProperty instanceof Comparable) {
                int val = ((Comparable)((Object)this.thisProperty)).compareTo(comp.thisProperty);
                if (val != 0) {
                    return val;
                }
            } else {
                return -1;
            }
        }
        if (this.nestProperty == null && comp.nestProperty == null) {
            return 0;
        }
        if (this.nestProperty == null) {
            return -1;
        }
        if (this.thisProperty instanceof Comparable) {
            return ((Comparable)((Object)this.nestProperty)).compareTo(comp.nestProperty);
        }
        return -1;
    }
}

