/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jp.ossc.nimbus.service.scheduler.DateEvaluator;

public class DateKey {
    public static final String WEEK_AT = "WEEK@";
    public static final String MONDAY = "MONDAY";
    public static final String TUESDAY = "TUESDAY";
    public static final String WEDNESDAY = "WEDNESDAY";
    public static final String THURSDAY = "THURSDAY";
    public static final String FRIDAY = "FRIDAY";
    public static final String SATURDAY = "SATURDAY";
    public static final String SUNDAY = "SUNDAY";
    public static final String YEAR_AT = "YEAR@";
    public static final String MONTH_AT = "MONTH@";
    public static final String DAY_AT = "DAY@";
    public static final String END = "END";
    public static final String AND = "AND";
    public static final String OR = "OR";
    protected Condition condition;
    protected DateEvaluator evaluator;
    private static final String OPEN = "(";
    private static final String CLOSE = ")";
    private static final String SPACE = " ";
    private static final String[] DELIMETERS = new String[]{"AND", "OR", "(", ")", "WEEK@", "YEAR@", "MONTH@", "DAY@", " "};

    public DateKey(String key) {
        this.condition = this.parse(key, 0);
    }

    public DateKey(String key, DateEvaluator evaluator) {
        this.evaluator = evaluator;
        this.condition = this.parse(key, 0);
    }

    public void setDateEvaluator(DateEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public DateEvaluator getDateEvaluator() {
        return this.evaluator;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List parseTokens(String str, String[] delims, List tokens) {
        int index = -1;
        int delimLength = 0;
        for (int i = 0; i < delims.length; ++i) {
            int tmp = str.indexOf(delims[i]);
            if (tmp == -1) continue;
            if (index == -1) {
                index = tmp;
                delimLength = delims[i].length();
                continue;
            }
            if (index <= tmp) continue;
            index = tmp;
            delimLength = delims[i].length();
        }
        if (index == -1) {
            tokens.add(str);
            return tokens;
        }
        if (index != 0) {
            tokens.add(str.substring(0, index));
            tokens.add(str.substring(index, index + delimLength));
            if (str.length() <= index + delimLength) return tokens;
            return this.parseTokens(str.substring(index + delimLength), delims, tokens);
        }
        if (str.length() == delimLength) {
            tokens.add(str);
            return tokens;
        }
        tokens.add(str.substring(0, delimLength));
        return this.parseTokens(str.substring(delimLength), delims, tokens);
    }

    protected Condition parse(String key, int index) {
        List tokenList = this.parseTokens(key, DELIMETERS, new ArrayList());
        Condition cond = null;
        try {
            Iterator tokens = tokenList.iterator();
            while (tokens.hasNext()) {
                String token = (String)tokens.next();
                Condition curCond = null;
                if (AND.equalsIgnoreCase(token)) {
                    curCond = new AndCondition(cond);
                    cond = null;
                } else if (OR.equalsIgnoreCase(token)) {
                    curCond = new OrCondition(cond);
                    cond = null;
                } else if (WEEK_AT.equalsIgnoreCase(token)) {
                    index += token.length();
                    token = (String)tokens.next();
                    curCond = new WeekCondition(token);
                } else if (YEAR_AT.equalsIgnoreCase(token)) {
                    index += token.length();
                    token = (String)tokens.next();
                    curCond = new YearCondition(token);
                } else if (MONTH_AT.equalsIgnoreCase(token)) {
                    index += token.length();
                    token = (String)tokens.next();
                    curCond = new MonthCondition(token);
                } else if (DAY_AT.equalsIgnoreCase(token)) {
                    index += token.length();
                    token = (String)tokens.next();
                    curCond = new DayCondition(token);
                } else if (OPEN.equals(token)) {
                    StringBuffer buf = new StringBuffer();
                    int tmpIndex = index;
                    while (!(token = (String)tokens.next()).equals(CLOSE)) {
                        index += token.length();
                        buf.append(token);
                    }
                    index += token.length();
                    curCond = this.parse(buf.toString(), tmpIndex);
                } else {
                    if (CLOSE.equals(token)) {
                        throw new IllegalArgumentException("Invalid potision" + token);
                    }
                    if (SPACE.equals(token)) continue;
                    throw new IllegalArgumentException("Invalid token " + token);
                }
                if (cond == null) {
                    cond = curCond;
                } else {
                    cond.add(curCond);
                }
                index += token.length();
            }
            cond.validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " : " + index);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The expected token is not found : " + index);
        }
        return cond;
    }

    public boolean equalsDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.condition.equalsDate(cal);
    }

    protected class OrCondition
    implements Condition {
        protected Condition condition1;
        protected Condition condition2;

        public OrCondition(Condition c) {
            if (c == null) {
                throw new IllegalArgumentException("expected expresion(WEEK@, YEAR@... etc.).");
            }
            this.condition1 = c;
        }

        public void add(Condition c) {
            if (this.condition2 != null) {
                throw new IllegalArgumentException("expected OR or AND.");
            }
            this.condition2 = c;
        }

        public boolean equalsDate(Calendar cal) {
            return this.condition1.equalsDate(cal) || this.condition2.equalsDate(cal);
        }

        public void validate() {
            if (this.condition1 == null && this.condition2 == null) {
                throw new IllegalArgumentException("Two operands are necessary for OR");
            }
            this.condition1.validate();
            this.condition2.validate();
        }
    }

    protected class AndCondition
    implements Condition {
        protected Condition condition1;
        protected Condition condition2;

        public AndCondition(Condition c) {
            if (c == null) {
                throw new IllegalArgumentException("expected expresion(WEEK@, YEAR@... etc.).");
            }
            this.condition1 = c;
        }

        public void add(Condition c) {
            if (this.condition2 != null) {
                throw new IllegalArgumentException("expected OR or AND.");
            }
            this.condition2 = c;
        }

        public boolean equalsDate(Calendar cal) {
            return this.condition1.equalsDate(cal) && this.condition2.equalsDate(cal);
        }

        public void validate() {
            if (this.condition1 == null && this.condition2 == null) {
                throw new IllegalArgumentException("Two operands are necessary for AND");
            }
            this.condition1.validate();
            this.condition2.validate();
        }
    }

    protected class DayCondition
    implements Condition {
        protected int day;
        protected boolean isEnd;
        protected String dateKey;

        public DayCondition(String key) {
            if (DateKey.END.equals(key)) {
                this.isEnd = true;
            } else {
                try {
                    this.day = Integer.parseInt(key);
                    if (this.day < 0 || this.day > 31) {
                        throw new IllegalArgumentException("expected number from 1 to 31");
                    }
                }
                catch (NumberFormatException e) {
                    if (DateKey.this.evaluator == null) {
                        throw new IllegalArgumentException("expected number or END");
                    }
                    DateKey.this.evaluator.equalsDate(key, Calendar.getInstance());
                    this.dateKey = key;
                }
            }
        }

        public boolean equalsDate(Calendar cal) {
            if (this.isEnd) {
                return cal.getActualMaximum(5) == this.day;
            }
            if (this.dateKey != null) {
                return DateKey.this.evaluator.equalsDate(this.dateKey, cal);
            }
            return cal.get(5) == this.day;
        }

        public void add(Condition c) {
            throw new IllegalArgumentException("expected OR or AND.");
        }

        public void validate() {
            if (this.day == 0 && !this.isEnd) {
                throw new IllegalArgumentException("DAY@ is null");
            }
        }
    }

    protected class MonthCondition
    implements Condition {
        protected int month;

        public MonthCondition(String key) {
            try {
                this.month = Integer.parseInt(key);
                if (this.month < 0 || this.month > 12) {
                    throw new IllegalArgumentException("expected number from 1 to 12");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("expected number");
            }
        }

        public boolean equalsDate(Calendar cal) {
            return cal.get(2) + 1 == this.month;
        }

        public void add(Condition c) {
            throw new IllegalArgumentException("expected OR or AND.");
        }

        public void validate() {
            if (this.month == 0) {
                throw new IllegalArgumentException("MONTH@ is null");
            }
        }
    }

    protected class YearCondition
    implements Condition {
        protected int year;

        public YearCondition(String key) {
            try {
                this.year = Integer.parseInt(key);
                if (this.year < 0) {
                    throw new IllegalArgumentException("expected number more than 1");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("expected number");
            }
        }

        public boolean equalsDate(Calendar cal) {
            return cal.get(1) == this.year;
        }

        public void add(Condition c) {
            throw new IllegalArgumentException("expected OR or AND.");
        }

        public void validate() {
            if (this.year == 0) {
                throw new IllegalArgumentException("YEAR@ is null");
            }
        }
    }

    protected class WeekCondition
    implements Condition {
        protected int numberOfWeek;
        protected int week;
        protected boolean isEnd;

        public WeekCondition(String key) {
            if (DateKey.END.equals(key)) {
                this.isEnd = true;
            } else if (DateKey.MONDAY.equalsIgnoreCase(key)) {
                this.week = 2;
            } else if (DateKey.TUESDAY.equalsIgnoreCase(key)) {
                this.week = 3;
            } else if (DateKey.WEDNESDAY.equalsIgnoreCase(key)) {
                this.week = 4;
            } else if (DateKey.THURSDAY.equalsIgnoreCase(key)) {
                this.week = 5;
            } else if (DateKey.FRIDAY.equalsIgnoreCase(key)) {
                this.week = 6;
            } else if (DateKey.SATURDAY.equalsIgnoreCase(key)) {
                this.week = 7;
            } else if (DateKey.SUNDAY.equalsIgnoreCase(key)) {
                this.week = 1;
            } else {
                try {
                    this.numberOfWeek = Integer.parseInt(key);
                    if (this.numberOfWeek < 1 || this.numberOfWeek > 6) {
                        throw new IllegalArgumentException("expected number from 1 to 6");
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("expected number or Week key(MONDAY,TUESDAY,...etc.) or END");
                }
            }
        }

        public boolean equalsDate(Calendar cal) {
            if (this.isEnd) {
                return cal.getActualMaximum(4) == cal.get(4);
            }
            if (this.numberOfWeek == 0) {
                return cal.get(7) == this.week;
            }
            return cal.get(4) == this.numberOfWeek;
        }

        public void add(Condition c) {
            throw new IllegalArgumentException("expected OR or AND.");
        }

        public void validate() {
            if (this.numberOfWeek == 0 && this.week == 0 && !this.isEnd) {
                throw new IllegalArgumentException("WEEK@ is null");
            }
        }
    }

    protected static interface Condition {
        public boolean equalsDate(Calendar var1);

        public void add(Condition var1);

        public void validate();
    }
}

