/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheAccessListener;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.LFUOverflowAlgorithmServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;

public class LFUOverflowAlgorithmService
extends ServiceBase
implements OverflowAlgorithm,
CacheRemoveListener,
CacheAccessListener,
Serializable,
LFUOverflowAlgorithmServiceMBean {
    private static final long serialVersionUID = -8742917099381213489L;
    private Map referenceMap;
    private SortedSet sortedReferenceSet;

    public int size() {
        return this.sortedReferenceSet == null ? 0 : this.sortedReferenceSet.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumReferenceCount() {
        if (this.referenceMap == null) {
            return 0;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return 0;
            }
            CounterCachedReference couterRef = (CounterCachedReference)this.sortedReferenceSet.last();
            return couterRef.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumReferenceCount() {
        if (this.referenceMap == null) {
            return 0;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return 0;
            }
            CounterCachedReference couterRef = (CounterCachedReference)this.sortedReferenceSet.first();
            return couterRef.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayReferenceCounts() {
        if (this.referenceMap == null) {
            return "";
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            CounterCachedReference couterRef = (CounterCachedReference)this.sortedReferenceSet.last();
            double unitCount = (double)couterRef.getCount() / 100.0;
            Iterator itr = this.sortedReferenceSet.iterator();
            while (itr.hasNext()) {
                couterRef = (CounterCachedReference)itr.next();
                int count = couterRef.getCount();
                int point = (int)((double)count / unitCount);
                for (int i = 0; i < point; ++i) {
                    pw.print('*');
                }
                pw.print(Integer.toString(count));
                pw.println("<br>");
            }
            return sw.toString();
        }
    }

    public void createService() throws Exception {
        this.referenceMap = Collections.synchronizedMap(new HashMap());
        this.sortedReferenceSet = Collections.synchronizedSortedSet(new TreeSet());
    }

    public void destroyService() throws Exception {
        this.reset();
        this.referenceMap = null;
        this.sortedReferenceSet = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.referenceMap == null || ref == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (!this.referenceMap.containsKey(ref)) {
                CounterCachedReference counterRef = new CounterCachedReference(ref);
                this.referenceMap.put(ref, counterRef);
                this.sortedReferenceSet.add(counterRef);
                ref.addCacheAccessListener(this);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.referenceMap == null || ref == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.containsKey(ref)) {
                CounterCachedReference counterRef = (CounterCachedReference)this.referenceMap.remove(ref);
                this.sortedReferenceSet.remove(counterRef);
                ref.removeCacheAccessListener(this);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedReference overflow() {
        if (this.referenceMap == null) {
            return null;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() != 0) {
                CounterCachedReference couterRef = (CounterCachedReference)this.sortedReferenceSet.first();
                this.sortedReferenceSet.remove(couterRef);
                this.referenceMap.remove(couterRef.getCachedReference());
                return couterRef.getCachedReference();
            }
            return null;
        }
    }

    public void reset() {
        if (this.referenceMap != null) {
            this.referenceMap.clear();
            this.sortedReferenceSet.clear();
        }
    }

    public void removed(CachedReference ref) {
        this.remove(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessed(CachedReference ref) {
        if (this.referenceMap == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap != null && this.referenceMap.containsKey(ref)) {
                CounterCachedReference counterRef = (CounterCachedReference)this.referenceMap.get(ref);
                this.sortedReferenceSet.remove(counterRef);
                if (!counterRef.increment()) {
                    Iterator counterRefs = this.referenceMap.values().iterator();
                    while (counterRefs.hasNext()) {
                        ((CounterCachedReference)counterRefs.next()).offset();
                    }
                    counterRef.increment();
                }
                this.sortedReferenceSet.add(counterRef);
            }
        }
    }

    private static class CounterCachedReference
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = -5670267780842863519L;
        private CachedReference reference;
        private int count;

        public CounterCachedReference(CachedReference ref) {
            this.reference = ref;
        }

        public CachedReference getCachedReference() {
            return this.reference;
        }

        public void offset() {
            this.count /= 1000;
        }

        public boolean increment() {
            if (this.count == Integer.MAX_VALUE) {
                return false;
            }
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }

        public int compareTo(Object o) {
            if (o == null || !(o instanceof CounterCachedReference)) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            CounterCachedReference comp = (CounterCachedReference)o;
            if (comp.getCount() == this.getCount()) {
                if (this.reference.equals(comp.getCachedReference())) {
                    return 0;
                }
                return this.hashCode() > comp.hashCode() ? -1 : 1;
            }
            if (comp.getCount() > this.getCount()) {
                return -1;
            }
            return 1;
        }
    }
}

