/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editorfinder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.journal.editorfinder.ObjectMappedEditorFinderServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ObjectMappedEditorFinderService
extends ServiceBase
implements EditorFinder,
ObjectMappedEditorFinderServiceMBean,
Serializable {
    private static final long serialVersionUID = 1524875427185813794L;
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    private EditorFinder mParentFinder = null;
    private ServiceName mFinderServiceName = null;
    private Map mEditorMap;
    private ClassMappingTree mEditorRepository = new ClassMappingTree();

    public void startService() throws Exception {
        if (this.mFinderServiceName != null) {
            this.mParentFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.mFinderServiceName);
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setServiceManagerName(this.getServiceManagerName());
        Iterator iterator = this.mEditorMap.keySet().iterator();
        while (iterator.hasNext()) {
            String classAndKey = (String)iterator.next();
            String key = null;
            String clsName = null;
            int index = classAndKey.indexOf(44);
            if (index == -1) {
                clsName = classAndKey;
            } else {
                clsName = classAndKey.substring(0, index);
                if (index != classAndKey.length() - 1) {
                    key = classAndKey.substring(index + 1);
                }
            }
            Class cls = this.convertStringToClass(clsName);
            JournalEditor journalEditor = null;
            Object value = this.mEditorMap.get(classAndKey);
            if (value instanceof String) {
                String serviceName = (String)value;
                editor.setAsText(serviceName);
                ServiceName name = (ServiceName)editor.getValue();
                journalEditor = (JournalEditor)ServiceManagerFactory.getServiceObject(name);
            } else if (value instanceof JournalEditor) {
                journalEditor = (JournalEditor)value;
            }
            HashMap<String, JournalEditor> keyEditorMap = (HashMap<String, JournalEditor>)this.mEditorRepository.getValueOf(cls);
            if (keyEditorMap == null) {
                keyEditorMap = new HashMap<String, JournalEditor>();
                this.mEditorRepository.add(cls, keyEditorMap);
            }
            keyEditorMap.put(key, journalEditor);
        }
    }

    public void stopService() throws Exception {
        this.mEditorRepository.clear();
    }

    public void destroyService() throws Exception {
        this.mParentFinder = null;
        this.mFinderServiceName = null;
        this.mParentFinder = null;
        this.mEditorRepository = null;
    }

    private Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = this.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    public JournalEditor findEditor(Class paramClass) {
        return this.findEditor(null, paramClass);
    }

    public JournalEditor findEditor(Object paramObj) {
        return this.findEditor(null, paramObj);
    }

    public JournalEditor findEditor(Object key, Class paramClass) {
        Map keyEditorMap = (Map)this.mEditorRepository.getValue(paramClass);
        if (keyEditorMap == null || this.mParentFinder != null) {
            return this.mParentFinder.findEditor(key, paramClass);
        }
        JournalEditor ret = (JournalEditor)keyEditorMap.get(key);
        if (ret == null && key != null) {
            ret = (JournalEditor)keyEditorMap.get(null);
        }
        if (ret == null && this.mParentFinder != null) {
            ret = this.mParentFinder.findEditor(key, paramClass);
        }
        return ret;
    }

    public JournalEditor findEditor(Object key, Object paramObj) {
        Class<?> cls = paramObj != null ? paramObj.getClass() : null;
        return this.findEditor(key, cls);
    }

    public void setEditorProperties(Properties prop) {
        this.mEditorMap = prop;
    }

    public void setParentEditorfinderServiceName(ServiceName name) {
        this.mFinderServiceName = name;
    }

    public void setEditorFinder(EditorFinder parentFinder) {
        this.mParentFinder = parentFinder;
    }

    public void setEditorMap(Map prop) {
        this.mEditorMap = prop;
    }
}

