/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    private static final long serialVersionUID = -408553618405283847L;
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected transient List waitThreads = Collections.synchronizedList(new ArrayList());
    protected transient Set wakeUpThreads = Collections.synchronizedSet(new HashSet());
    protected transient Set knockThreads = Collections.synchronizedSet(new HashSet());
    protected transient List usedThreads = new Vector();
    protected transient Map threadTasks = Collections.synchronizedMap(new HashMap());
    protected long sleepTime = 10000L;
    protected long checkInterval = -1L;
    protected transient ResourceChecker checker;
    protected transient Timer forceFreeTimer = new Timer(true);

    public boolean getResource() {
        return this.getResource(-1L);
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        return this.getResource(timeOutMiliSecond, maxWaitCount, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount, long forceFreeMiliSecond) {
        boolean bl;
        Thread current;
        block59: {
            if (maxWaitCount > 0 && this.waitThreads.size() >= maxWaitCount) {
                return false;
            }
            current = Thread.currentThread();
            List list = this.waitThreads;
            // MONITORENTER : list
            this.waitThreads.add(current);
            this.wakeUpThreads.add(current);
            // MONITOREXIT : list
            long timeOutMs = -1L;
            if (timeOutMiliSecond >= 0L) {
                timeOutMs = timeOutMiliSecond;
            }
            long processTime = 0L;
            boolean removeWait = false;
            try {
                while (!this.mFourceEndFlg) {
                    Thread thread;
                    long proc;
                    block58: {
                        if (this.mResourceCnt > 0) {
                            List list2 = this.waitThreads;
                            // MONITORENTER : list2
                            if (this.mResourceCnt > 0) {
                                if (this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                    --this.mResourceCnt;
                                    this.waitThreads.remove(current);
                                    this.wakeUpThreads.remove(current);
                                    removeWait = true;
                                    ForceFreeTimerTask task = null;
                                    if (forceFreeMiliSecond > 0L) {
                                        task = new ForceFreeTimerTask(current);
                                        this.forceFreeTimer.schedule((TimerTask)task, forceFreeMiliSecond);
                                    }
                                    this.usedThreads.add(current);
                                    if (this.threadTasks.containsKey(current)) {
                                        Object tasks = this.threadTasks.get(current);
                                        ArrayList<Object> taskList = null;
                                        if (tasks instanceof List) {
                                            taskList = (ArrayList<Object>)tasks;
                                        } else {
                                            taskList = new ArrayList<Object>();
                                            taskList.add(tasks);
                                            this.threadTasks.put(current, taskList);
                                        }
                                        taskList.add(task);
                                    } else {
                                        this.threadTasks.put(current, task);
                                    }
                                    if (this.mResourceCnt > 0 && this.waitThreads.size() != 0) {
                                        this.wakeUp();
                                    }
                                    boolean bl2 = true;
                                    // MONITOREXIT : list2
                                    Object var23_23 = null;
                                    if (!removeWait) {
                                        List list3 = this.waitThreads;
                                        // MONITORENTER : list3
                                        if (!removeWait) {
                                            this.waitThreads.remove(current);
                                            this.wakeUpThreads.remove(current);
                                        }
                                        // MONITOREXIT : list3
                                    }
                                    this.knockThreads.remove(current);
                                    return bl2;
                                }
                                if (this.waitThreads.size() != 0) {
                                    this.wakeUp();
                                }
                            }
                            // MONITOREXIT : list2
                        }
                        boolean isInterrupted = false;
                        proc = 0L;
                        Thread taskList = current;
                        // MONITORENTER : taskList
                        if (this.mFourceEndFlg || timeOutMs > 0L && timeOutMs <= processTime) {
                            // MONITOREXIT : taskList
                            break;
                        }
                        if (timeOutMs >= 0L) {
                            proc = System.currentTimeMillis();
                        }
                        isInterrupted = Thread.interrupted();
                        // MONITOREXIT : taskList
                        int priority = current.getPriority();
                        try {
                            if (isInterrupted || this.mResourceCnt > 0) break block58;
                            thread = current;
                            // MONITORENTER : thread
                            this.wakeUpThreads.remove(current);
                            // MONITOREXIT : thread
                            if (priority < 10) {
                                try {
                                    current.setPriority(priority + 1);
                                }
                                catch (SecurityException e) {
                                    // empty catch block
                                }
                            }
                            if (this.mResourceCnt <= 0 && !this.knockThreads.contains(current)) {
                                Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!this.knockThreads.contains(current)) {
                                boolean bl3 = false;
                                Object var23_24 = null;
                                if (!removeWait) {
                                    List list4 = this.waitThreads;
                                    // MONITORENTER : list4
                                    if (!removeWait) {
                                        this.waitThreads.remove(current);
                                        this.wakeUpThreads.remove(current);
                                    }
                                    // MONITOREXIT : list4
                                }
                                this.knockThreads.remove(current);
                                return bl3;
                            }
                        }
                        finally {
                            try {
                                current.setPriority(priority);
                            }
                            catch (SecurityException e) {
                            }
                        }
                    }
                    thread = current;
                    // MONITORENTER : thread
                    this.wakeUpThreads.add(current);
                    this.knockThreads.remove(current);
                    Thread.interrupted();
                    // MONITOREXIT : thread
                    if (timeOutMs < 0L) continue;
                    proc = System.currentTimeMillis() - proc;
                    processTime += proc;
                }
                bl = false;
                Object var23_25 = null;
                if (removeWait) break block59;
                List list5 = this.waitThreads;
            }
            catch (Throwable throwable) {
                Object var23_26 = null;
                if (!removeWait) {
                    List list6 = this.waitThreads;
                    // MONITORENTER : list6
                    if (!removeWait) {
                        this.waitThreads.remove(current);
                        this.wakeUpThreads.remove(current);
                    }
                    // MONITOREXIT : list6
                }
                this.knockThreads.remove(current);
                throw throwable;
            }
            if (!removeWait) {
                this.waitThreads.remove(current);
                this.wakeUpThreads.remove(current);
            }
            // MONITOREXIT : list5
        }
        this.knockThreads.remove(current);
        return bl;
    }

    public void freeResource() {
        this.freeResource(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeResource(Thread usedThread) {
        boolean isUsed = false;
        Object object = usedThread;
        synchronized (object) {
            if (this.usedThreads.contains(usedThread)) {
                isUsed = true;
                Object tasks = this.threadTasks.get(usedThread);
                if (tasks instanceof List) {
                    List taskList = (List)tasks;
                    TimerTask task = (TimerTask)taskList.remove(0);
                    if (task != null) {
                        task.cancel();
                    }
                    if (taskList.size() == 0) {
                        this.threadTasks.remove(usedThread);
                        this.usedThreads.remove(usedThread);
                    }
                } else {
                    TimerTask task = (TimerTask)tasks;
                    if (task != null) {
                        task.cancel();
                    }
                    this.threadTasks.remove(usedThread);
                    this.usedThreads.remove(usedThread);
                }
            }
        }
        if (isUsed && this.mResourceCnt < this.mInitialResource) {
            object = this.waitThreads;
            synchronized (object) {
                if (this.mResourceCnt < this.mInitialResource) {
                    ++this.mResourceCnt;
                }
            }
        }
        if (this.mResourceCnt > 0 && this.wakeUp()) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wakeUp() {
        if (this.waitThreads.size() != 0) {
            List list = this.waitThreads;
            synchronized (list) {
                if (this.waitThreads.size() != 0) {
                    Thread waitThread;
                    Thread thread = waitThread = (Thread)this.waitThreads.get(0);
                    synchronized (thread) {
                        if (!this.wakeUpThreads.contains(waitThread)) {
                            this.knockThreads.add(waitThread);
                            waitThread.interrupt();
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        List list = this.waitThreads;
        synchronized (list) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    public int getResourceRemain() {
        return this.mResourceCnt;
    }

    public int getWaitingCount() {
        return this.waitThreads.size();
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (this.checker != null) {
            this.checker.isStop = true;
            this.checker = null;
        }
        this.mFourceEndFlg = true;
        List list = this.waitThreads;
        synchronized (list) {
            while (this.usedThreads.size() != 0) {
                this.freeResource((Thread)this.usedThreads.get(0));
            }
            this.wakeUp();
            this.forceFreeTimer.cancel();
            this.forceFreeTimer = new Timer(true);
        }
    }

    public synchronized void accept() {
        this.mFourceEndFlg = false;
        if (this.checkInterval > 0L) {
            this.checker = new ResourceChecker();
            this.checker.start();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.waitThreads = Collections.synchronizedList(new ArrayList());
        this.wakeUpThreads = Collections.synchronizedSet(new HashSet());
        this.knockThreads = Collections.synchronizedSet(new HashSet());
        this.usedThreads = new Vector();
        this.threadTasks = Collections.synchronizedMap(new HashMap());
        this.forceFreeTimer = new Timer(true);
    }

    protected class ResourceChecker
    extends Thread {
        public boolean isStop;

        public ResourceChecker() {
            super("Nimbus SemaphoreResourceCheckDaemon");
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isStop && MemorySemaphore.this.checkInterval > 0L) {
                try {
                    Thread.sleep(MemorySemaphore.this.checkInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (MemorySemaphore.this.getResourceRemain() <= 0 || MemorySemaphore.this.getWaitingCount() <= 0) continue;
                MemorySemaphore.this.wakeUp();
            }
        }
    }

    protected class ForceFreeTimerTask
    extends TimerTask {
        protected Thread usedThread;

        public ForceFreeTimerTask(Thread usedThread) {
            this.usedThread = usedThread;
        }

        public void run() {
            MemorySemaphore.this.freeResource(this.usedThread);
        }
    }
}

