/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.queue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.IllegalServiceStateException;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.queue.DefaultQueueServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;

public class DefaultQueueService
extends ServiceBase
implements Queue,
CacheRemoveListener,
DefaultQueueServiceMBean,
Serializable {
    private static final long serialVersionUID = 4603365298600666516L;
    protected List queueElements;
    protected int initialCapacity = -1;
    protected int capacityIncrement = -1;
    protected ServiceName cacheServiceName;
    protected Cache cache;
    protected List waitThreads;
    protected Set wakeUpThreads;
    protected long sleepTime = 10000L;
    protected volatile boolean fourceEndFlg = false;
    protected long count = 0L;
    protected long countDelta = 0L;
    protected long lastPushedTime = 0L;
    protected long lastDepth = 0L;

    public void setInitialCapacity(int initial) {
        this.initialCapacity = initial;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setCapacityIncrement(int increment) {
        this.capacityIncrement = increment;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public void setCacheServiceName(ServiceName name) {
        this.cacheServiceName = name;
    }

    public ServiceName getCacheServiceName() {
        return this.cacheServiceName;
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void createService() throws Exception {
        this.waitThreads = Collections.synchronizedList(new ArrayList());
        this.wakeUpThreads = Collections.synchronizedSet(new HashSet());
    }

    public void startService() throws Exception {
        this.accept();
        if (this.queueElements == null) {
            this.queueElements = this.initialCapacity >= 0 ? (this.capacityIncrement >= 0 ? new Vector(this.initialCapacity, this.capacityIncrement) : Collections.synchronizedList(new ArrayList(this.initialCapacity))) : Collections.synchronizedList(new ArrayList());
        }
        if (this.cacheServiceName != null) {
            this.cache = (Cache)ServiceManagerFactory.getServiceObject(this.cacheServiceName);
        }
    }

    public void stopService() throws Exception {
        this.release();
    }

    public void destroyService() throws Exception {
        this.queueElements.clear();
        this.queueElements = null;
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Object item) {
        if (this.getState() != 3 || this.fourceEndFlg) {
            throw new IllegalServiceStateException(this);
        }
        if (this.cache == null) {
            this.queueElements.add(item);
        } else {
            CachedReference ref = this.cache.add(item);
            if (ref != null) {
                ref.addCacheRemoveListener(this);
                this.queueElements.add(ref);
            } else {
                this.queueElements.add(item);
            }
        }
        ++this.count;
        ++this.countDelta;
        this.lastPushedTime = System.currentTimeMillis();
        if (this.waitThreads != null) {
            List list = this.waitThreads;
            synchronized (list) {
                Thread waitThread;
                if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                    this.wakeUpThreads.add(waitThread);
                    waitThread.interrupt();
                }
            }
        }
    }

    public Object get(long timeOutMs) {
        return this.getQueueElement(timeOutMs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getQueueElement(long timeOutMs, boolean isRemove) {
        List list;
        boolean removeWait;
        Thread current;
        block29: {
            Object object;
            block28: {
                List list2;
                Object waitThread;
                block27: {
                    current = Thread.currentThread();
                    long processTime = 0L;
                    removeWait = false;
                    try {
                        if (this.waitThreads != null && isRemove) {
                            list = this.waitThreads;
                            synchronized (list) {
                                this.waitThreads.add(current);
                                this.wakeUpThreads.add(current);
                            }
                        }
                        while (!this.fourceEndFlg) {
                            if (this.queueElements != null && this.size() > 0 && this.waitThreads != null) {
                                list = this.waitThreads;
                                synchronized (list) {
                                    if (this.size() > 0) {
                                        Thread waitThread2;
                                        if (!isRemove || this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                            Object ret = this.getQueueElement(isRemove);
                                            if (isRemove) {
                                                this.waitThreads.remove(current);
                                                this.wakeUpThreads.remove(current);
                                                removeWait = true;
                                            }
                                            if (isRemove && this.queueElements != null && this.size() > 0 && this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread = (Thread)this.waitThreads.get(0))) {
                                                this.wakeUpThreads.add(waitThread);
                                                ((Thread)waitThread).interrupt();
                                            }
                                            waitThread = ret;
                                            // MONITOREXIT @DISABLED, blocks:[0, 8, 24, 25, 26, 15] lbl31 : MonitorExitStatement: MONITOREXIT : var8_6
                                            Object var13_11 = null;
                                            if (this.waitThreads == null) return waitThread;
                                            if (removeWait) return waitThread;
                                            if (!isRemove) return waitThread;
                                            list2 = this.waitThreads;
                                            break block27;
                                        }
                                        if (this.waitThreads.size() != 0 && !this.wakeUpThreads.contains(waitThread2 = (Thread)this.waitThreads.get(0))) {
                                            this.wakeUpThreads.add(waitThread2);
                                            waitThread2.interrupt();
                                        }
                                    }
                                }
                            }
                            if (this.fourceEndFlg || timeOutMs > 0L && timeOutMs <= processTime) break;
                            long proc = 0L;
                            if (timeOutMs >= 0L) {
                                proc = System.currentTimeMillis();
                            }
                            try {
                                if (!Thread.interrupted()) {
                                    this.wakeUpThreads.remove(current);
                                    Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                                    this.wakeUpThreads.add(current);
                                }
                            }
                            catch (InterruptedException e) {
                                if (!this.wakeUpThreads.contains(current)) {
                                    Object var11_21 = null;
                                    Object var13_12 = null;
                                    if (this.waitThreads == null) return var11_21;
                                    if (removeWait) return var11_21;
                                    if (!isRemove) return var11_21;
                                    List list3 = this.waitThreads;
                                    synchronized (list3) {
                                        this.waitThreads.remove(current);
                                        this.wakeUpThreads.remove(current);
                                        return var11_21;
                                    }
                                }
                                Thread.interrupted();
                            }
                            if (timeOutMs < 0L) continue;
                            proc = System.currentTimeMillis() - proc;
                            processTime += proc;
                        }
                        if (this.fourceEndFlg) {
                            Object ret;
                            object = ret = this.getQueueElement(isRemove);
                            break block28;
                        }
                        list = null;
                        break block29;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (this.waitThreads == null) throw throwable;
                        if (removeWait) throw throwable;
                        if (!isRemove) throw throwable;
                        List list4 = this.waitThreads;
                        synchronized (list4) {
                            this.waitThreads.remove(current);
                            this.wakeUpThreads.remove(current);
                            throw throwable;
                        }
                    }
                }
                synchronized (list2) {
                    this.waitThreads.remove(current);
                    this.wakeUpThreads.remove(current);
                    return waitThread;
                }
            }
            Object var13_13 = null;
            if (this.waitThreads == null) return object;
            if (removeWait) return object;
            if (!isRemove) return object;
            List list5 = this.waitThreads;
            synchronized (list5) {
                this.waitThreads.remove(current);
                this.wakeUpThreads.remove(current);
                return object;
            }
        }
        Object var13_14 = null;
        if (this.waitThreads == null) return list;
        if (removeWait) return list;
        if (!isRemove) return list;
        List list6 = this.waitThreads;
        synchronized (list6) {
            this.waitThreads.remove(current);
            this.wakeUpThreads.remove(current);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getQueueElement(boolean isRemove) {
        List list = this.queueElements;
        synchronized (list) {
            if (this.queueElements == null || this.size() == 0) {
                return null;
            }
            Object element = null;
            if (this.size() != 0) {
                element = isRemove ? this.queueElements.remove(0) : this.queueElements.get(0);
            }
            if (element == null) {
                return null;
            }
            if (this.cache == null) {
                return element;
            }
            if (element instanceof CachedReference) {
                CachedReference ref = element;
                if (ref != null) {
                    Object obj = ref.get();
                    if (isRemove) {
                        this.cache.remove(ref);
                    }
                    return obj;
                }
                return null;
            }
            return element;
        }
    }

    public Object get() {
        return this.get(-1L);
    }

    public Object peek(long timeOutMs) {
        return this.getQueueElement(timeOutMs, false);
    }

    public Object peek() {
        return this.peek(-1L);
    }

    public void remove(Object item) {
        if (this.cache == null) {
            this.queueElements.remove(item);
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (element instanceof CachedReference) {
                    CachedReference ref = (CachedReference)element;
                    Object obj = ref.get(this, false);
                    if ((item != null || obj != null) && (item == null || !item.equals(obj))) continue;
                    this.cache.remove(ref);
                    break;
                }
                if ((item != null || element != null) && (item == null || !item.equals(element))) continue;
                this.queueElements.remove(element);
                break;
            }
        }
    }

    public void clear() {
        if (this.cache == null) {
            this.queueElements.clear();
        } else {
            Object[] elements = this.queueElements.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                if (!(element instanceof CachedReference)) continue;
                CachedReference ref = (CachedReference)element;
                this.cache.remove(ref);
            }
            this.queueElements.clear();
        }
    }

    public int size() {
        if (this.queueElements == null) {
            return 0;
        }
        return this.queueElements.size();
    }

    public void accept() {
        this.fourceEndFlg = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.fourceEndFlg = true;
        if (this.waitThreads != null) {
            while (true) {
                Thread waitThread = null;
                List list = this.waitThreads;
                synchronized (list) {
                    if (this.waitThreads.size() == 0) {
                        break;
                    }
                    waitThread = (Thread)this.waitThreads.get(0);
                    this.wakeUpThreads.add(waitThread);
                    waitThread.interrupt();
                }
            }
        }
    }

    public List elements() {
        if (this.queueElements == null) {
            return new ArrayList();
        }
        return new ArrayList(this.queueElements);
    }

    public void removed(CachedReference ref) {
        if (this.queueElements == null) {
            return;
        }
        this.queueElements.remove(ref);
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        long delta = this.countDelta;
        this.countDelta = 0L;
        return delta;
    }

    public long getLastPushedTimeMillis() {
        return this.lastPushedTime;
    }

    public Date getLastPushedTime() {
        return new Date(this.lastPushedTime);
    }

    public long getDepth() {
        return this.size();
    }

    public long getDepthDelta() {
        long depth = this.size();
        long delta = this.lastDepth - depth;
        this.lastDepth = depth;
        return delta;
    }
}

