/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.util.List;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertyGetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaCheckException;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertySetException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.beans.dataset.RecordList;

public class RecordListPropertySchema
implements PropertySchema {
    private static final long serialVersionUID = -4263284765094524721L;
    protected String schema;
    protected String name;
    protected String recordListName;

    public RecordListPropertySchema() {
    }

    public RecordListPropertySchema(String schema) throws PropertySchemaDefineException {
        this.setSchema(schema);
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        List schemata = DefaultPropertySchema.parseCSV(schema);
        if (schemata.size() != 2) {
            throw new PropertySchemaDefineException("Name and Schema must be specified.");
        }
        this.schema = schema;
        this.name = (String)schemata.get(0);
        this.recordListName = (String)schemata.get(1);
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return RecordList.class;
    }

    public Object set(Object val) throws PropertySetException {
        if (val == null) {
            return null;
        }
        if (!(val instanceof RecordList)) {
            throw new PropertySchemaCheckException((PropertySchema)this, "The type is unmatch. type=" + val.getClass().getName());
        }
        RecordList list = (RecordList)val;
        if (!this.recordListName.equals(list.getName())) {
            throw new PropertySchemaCheckException((PropertySchema)this, "Name of RecordList is unmatch. name=" + list.getName());
        }
        return val;
    }

    public Object get(Object val) throws PropertyGetException {
        return val;
    }

    public Object format(Object val) throws PropertyGetException {
        return val;
    }

    public Object parse(Object val) throws PropertySetException {
        return val;
    }

    public boolean validate(Object val) throws PropertyValidateException {
        return true;
    }

    public String getRecordListName() {
        return this.recordListName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(",recordListName=").append(this.recordListName);
        buf.append('}');
        return buf.toString();
    }
}

