/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.AttributeMetaData;
import jp.ossc.nimbus.core.ConstructorMetaData;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.FieldMetaData;
import jp.ossc.nimbus.core.InvokeMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ServiceLoader;
import org.w3c.dom.Element;

public class ObjectMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 1822804096588017217L;
    public static final String OBJECT_TAG_NAME = "object";
    protected static final String CODE_ATTRIBUTE_NAME = "code";
    protected String managerName;
    protected String code;
    protected ConstructorMetaData constructor;
    protected final Map fields = new LinkedHashMap();
    protected final Map attributes = new LinkedHashMap();
    protected final List invokes = new ArrayList();
    protected ServiceLoader myLoader;

    public ObjectMetaData() {
    }

    public ObjectMetaData(ServiceLoader loader, MetaData parent, String manager) {
        super(parent);
        this.myLoader = loader;
        this.managerName = manager;
    }

    public ServiceLoader getServiceLoader() {
        return this.myLoader;
    }

    public void setServiceLoader(ServiceLoader loader) {
        this.myLoader = loader;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String name) {
        this.managerName = name;
    }

    public Collection getFields() {
        return this.fields.values();
    }

    public FieldMetaData getField(String name) {
        return (FieldMetaData)this.fields.get(name);
    }

    public void addField(FieldMetaData field) {
        this.fields.put(field.getName(), field);
    }

    public void removeField(String name) {
        this.fields.remove(name);
    }

    public void clearFields() {
        this.fields.clear();
    }

    public Collection getAttributes() {
        return this.attributes.values();
    }

    public AttributeMetaData getAttribute(String name) {
        return (AttributeMetaData)this.attributes.get(name);
    }

    public void addAttribute(AttributeMetaData attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public Collection getInvokes() {
        return this.invokes;
    }

    public void addInvoke(InvokeMetaData invoke) {
        this.invokes.add(invoke);
    }

    public void removeInvoke(InvokeMetaData invoke) {
        this.invokes.remove(invoke);
    }

    public void clearInvokes() {
        this.invokes.clear();
    }

    protected void checkTagName(Element element) throws DeploymentException {
        if (!element.getTagName().equals(OBJECT_TAG_NAME)) {
            throw new DeploymentException("Tag must be object : " + element.getTagName());
        }
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        this.checkTagName(element);
        this.code = ObjectMetaData.getUniqueAttribute(element, CODE_ATTRIBUTE_NAME);
        Element constElement = ObjectMetaData.getOptionalChild(element, "constructor");
        if (constElement != null) {
            ConstructorMetaData constData = new ConstructorMetaData(this);
            constData.importXML(constElement);
            this.constructor = constData;
        }
        Iterator fieldElements = ObjectMetaData.getChildrenByTagName(element, "field");
        while (fieldElements.hasNext()) {
            FieldMetaData fieldData = new FieldMetaData(this);
            fieldData.importXML((Element)fieldElements.next());
            this.addField(fieldData);
        }
        Iterator attributeElements = ObjectMetaData.getChildrenByTagName(element, "attribute");
        while (attributeElements.hasNext()) {
            AttributeMetaData attributeData = new AttributeMetaData(this);
            attributeData.importXML((Element)attributeElements.next());
            this.addAttribute(attributeData);
        }
        Iterator invokeElements = ObjectMetaData.getChildrenByTagName(element, "invoke");
        while (invokeElements.hasNext()) {
            InvokeMetaData invokeData = new InvokeMetaData(this);
            invokeData.importXML((Element)invokeElements.next());
            if (invokeData.getTarget() != null) {
                throw new DeploymentException("target element must not specified. : " + invokeData);
            }
            this.addInvoke(invokeData);
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(OBJECT_TAG_NAME);
        if (this.code != null) {
            buf.append(' ').append(CODE_ATTRIBUTE_NAME).append("=\"").append(this.code).append("\"");
        }
        if (this.constructor == null && this.fields.size() == 0 && this.attributes.size() == 0 && this.invokes.size() == 0) {
            buf.append("/>");
        } else {
            Iterator<Object> datas;
            buf.append('>');
            if (this.constructor != null) {
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent(this.constructor.toXML(new StringBuffer())));
            }
            if (this.fields.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.fields.values().iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            if (this.attributes.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.attributes.values().iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            if (this.invokes.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.invokes.iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            buf.append(LINE_SEPARATOR);
            buf.append("</").append(OBJECT_TAG_NAME).append('>');
        }
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        buf.append(CODE_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(this.getCode());
        buf.append('}');
        return buf.toString();
    }
}

