/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CSVReader
extends LineNumberReader {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_SEPARATOR_ESCAPE = '\\';
    public static final char DEFAULT_ENCLOSURE = '\"';
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private char separator = (char)44;
    private char separatorEscape = (char)92;
    private char enclosure = (char)34;
    private boolean isIgnoreEmptyLine;
    private boolean isIgnoreLineEndSeparator;
    private boolean isEnclosed;
    private String nullValue;
    private CSVIterator iterator;

    public CSVReader(Reader reader) {
        super(reader);
    }

    public CSVReader(Reader reader, int size) {
        super(reader, size);
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparatorEscape(char escape) {
        this.separatorEscape = escape;
    }

    public char getSeparatorEscape() {
        return this.separatorEscape;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setIgnoreEmptyLine(boolean isIgnore) {
        this.isIgnoreEmptyLine = isIgnore;
    }

    public boolean isIgnoreEmptyLine() {
        return this.isIgnoreEmptyLine;
    }

    public void setIgnoreLineEndSeparator(boolean isIgnore) {
        this.isIgnoreLineEndSeparator = isIgnore;
    }

    public boolean isIgnoreLineEndSeparator() {
        return this.isIgnoreLineEndSeparator;
    }

    public void setEnclosed(boolean isEnclosed) {
        this.isEnclosed = isEnclosed;
    }

    public boolean isEnclosed() {
        return this.isEnclosed;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public long skipLine(long line) throws IOException {
        int result = 0;
        result = 0;
        while ((long)result < line && super.readLine() != null) {
            ++result;
        }
        return result;
    }

    public long skipCSVLine(long line) throws IOException {
        List csv = null;
        int result = 0;
        result = 0;
        while ((long)result < line && (csv = this.readCSVLineList(csv)) != null) {
            ++result;
        }
        return result;
    }

    public String[] readCSVLine() throws IOException {
        List csv = this.readCSVLineList();
        return csv == null ? null : csv.toArray(new String[csv.size()]);
    }

    public List readCSVLineList() throws IOException {
        return this.readCSVLineList(null);
    }

    public List readCSVLineList(List csv) throws IOException {
        String line = null;
        do {
            if ((line = super.readLine()) == null) {
                if (csv != null) {
                    csv.clear();
                }
                return null;
            }
            if (!this.isIgnoreEmptyLine || line.length() != 0) continue;
            line = null;
            this.setLineNumber(this.getLineNumber() - 1);
        } while (line == null);
        if (csv == null) {
            csv = new ArrayList<String>();
        } else {
            csv.clear();
        }
        if (line.length() == 0) {
            return csv;
        }
        StringBuffer buf = new StringBuffer();
        boolean inEnclosure = false;
        do {
            if (inEnclosure) {
                line = super.readLine();
                if (line == null) break;
                this.setLineNumber(this.getLineNumber() - 1);
                buf.append(LINE_SEPARATOR);
            }
            char c = '\u0000';
            int imax = line.length();
            for (int i = 0; i < imax; ++i) {
                c = line.charAt(i);
                if (c == this.enclosure) {
                    if (this.isEnclosed) {
                        if (inEnclosure && imax - 1 != i && line.charAt(i + 1) == this.enclosure) {
                            buf.append(this.enclosure);
                            ++i;
                            continue;
                        }
                        if (i > 2 && line.charAt(i - 1) != this.separator && imax - 1 != i && line.charAt(i + 1) != this.separator || !inEnclosure && imax - 1 == i) {
                            buf.append(c);
                            continue;
                        }
                        inEnclosure = !inEnclosure;
                        continue;
                    }
                    buf.append(c);
                    continue;
                }
                if (c == this.separator) {
                    if (inEnclosure) {
                        buf.append(c);
                        continue;
                    }
                    String element = buf.toString();
                    if (this.nullValue == null) {
                        csv.add(element);
                    } else if (this.nullValue.equals(element)) {
                        csv.add(null);
                    } else {
                        csv.add(element);
                    }
                    buf.setLength(0);
                    continue;
                }
                if (c == this.separatorEscape) {
                    if (!inEnclosure && imax - 1 != i) {
                        char nextChar = line.charAt(i + 1);
                        if (nextChar == this.separator || nextChar == this.separatorEscape) {
                            buf.append(nextChar);
                            ++i;
                            continue;
                        }
                        if (nextChar == 'r') {
                            buf.append('\r');
                            ++i;
                            continue;
                        }
                        if (nextChar == 'n') {
                            buf.append('\n');
                            ++i;
                            continue;
                        }
                        buf.append(c);
                        continue;
                    }
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            if (inEnclosure || c == this.separator && this.isIgnoreLineEndSeparator && buf.length() == 0) continue;
            String element = buf.toString();
            if (this.nullValue == null) {
                csv.add(element);
                continue;
            }
            if (this.nullValue.equals(element)) {
                csv.add(null);
                continue;
            }
            csv.add(element);
        } while (inEnclosure);
        return csv;
    }

    public CSVIterator iterator() {
        if (this.iterator == null) {
            this.iterator = new CSVIterator();
        }
        return this.iterator;
    }

    public class CSVElements
    extends ArrayList {
        private static final long serialVersionUID = 6079322185163530516L;
        private boolean wasNull;

        private CSVElements() {
        }

        public void clear() {
            this.wasNull = false;
            super.clear();
        }

        public boolean wasNull() {
            return this.wasNull;
        }

        public Object get(int index) {
            Object obj = super.get(index);
            this.wasNull = obj == null;
            return obj;
        }

        public String getString(int index) {
            String str = (String)this.get(index);
            this.wasNull = str == null;
            return str;
        }

        public byte getByte(int index) throws NumberFormatException {
            return this.getByte(index, 10);
        }

        public byte getByte(int index, int radix) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Byte.parseByte(str, radix);
        }

        public short getShort(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Short.parseShort(str);
        }

        public char getChar(int index) {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return '\u0000';
            }
            return str.charAt(0);
        }

        public int getInt(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0;
            }
            return Integer.parseInt(str);
        }

        public long getLong(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0L;
            }
            return Long.parseLong(str);
        }

        public float getFloat(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0.0f;
            }
            return Float.parseFloat(str);
        }

        public double getDouble(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return 0.0;
            }
            return Double.parseDouble(str);
        }

        public boolean getBoolean(int index) {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return false;
            }
            return Boolean.valueOf(str);
        }

        public BigInteger getBigInteger(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return null;
            }
            return new BigInteger(str);
        }

        public BigDecimal getBigDecimal(int index) throws NumberFormatException {
            String str = this.getString(index);
            if (str == null || str.length() == 0) {
                this.wasNull = true;
                return null;
            }
            return new BigDecimal(str);
        }
    }

    public class CSVIterator {
        private boolean hasNext = false;
        private CSVElements elements = new CSVElements();

        private CSVIterator() {
        }

        public boolean hasNext() throws IOException {
            if (this.hasNext) {
                return this.hasNext;
            }
            List result = CSVReader.this.readCSVLineList(this.elements);
            this.hasNext = result != null;
            return this.hasNext;
        }

        public Object next() throws IOException {
            return this.nextElements();
        }

        public CSVElements nextElements() throws IOException {
            if (!this.hasNext && !this.hasNext()) {
                return null;
            }
            this.hasNext = false;
            return this.elements;
        }
    }
}

