/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVWriter
extends BufferedWriter {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_SEPARATOR_ESCAPE = '\\';
    public static final char DEFAULT_ENCLOSURE = '\"';
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String REPLACE_CR = "\\r";
    private static final String REPLACE_LF = "\\n";
    private char separator = (char)44;
    private char separatorEscape = (char)92;
    private char enclosure = (char)34;
    private boolean isEnclose;
    private String lineSeparator = DEFAULT_LINE_SEPARATOR;
    private boolean isAppendElement;
    private String nullValue;

    public CSVWriter(Writer writer) {
        super(writer);
    }

    public CSVWriter(Writer writer, int size) {
        super(writer, size);
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparatorEscape(char escape) {
        this.separatorEscape = escape;
    }

    public char getSeparatorEscape() {
        return this.separatorEscape;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setEnclose(boolean isEnclose) {
        this.isEnclose = isEnclose;
    }

    public boolean isEnclose() {
        return this.isEnclose;
    }

    public void setNullValue(String value) {
        this.nullValue = value;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void newLine() throws IOException {
        super.write(this.lineSeparator);
        this.isAppendElement = false;
    }

    public void writeElement(String element) throws IOException {
        if (this.isAppendElement) {
            super.write(this.separator);
        }
        if (this.isEnclose) {
            super.write(this.enclosure);
        }
        super.write(this.escape(element));
        if (this.isEnclose) {
            super.write(this.enclosure);
        }
        this.isAppendElement = true;
    }

    public void writeElement(boolean element) throws IOException {
        this.writeElement(Boolean.toString(element));
    }

    public void writeElement(byte element) throws IOException {
        this.writeElement(Byte.toString(element));
    }

    public void writeElement(char element) throws IOException {
        this.writeElement(Character.toString(element));
    }

    public void writeElement(short element) throws IOException {
        this.writeElement(Short.toString(element));
    }

    public void writeElement(int element) throws IOException {
        this.writeElement(Integer.toString(element));
    }

    public void writeElement(long element) throws IOException {
        this.writeElement(Long.toString(element));
    }

    public void writeElement(float element) throws IOException {
        this.writeElement(Float.toString(element));
    }

    public void writeElement(double element) throws IOException {
        this.writeElement(Double.toString(element));
    }

    public void writeElement(Object element) throws IOException {
        this.writeElement(element == null ? (String)null : element.toString());
    }

    private String escape(String element) throws IOException {
        if (element == null) {
            return this.nullValue;
        }
        if (this.isEnclose) {
            int i;
            int index = element.indexOf(this.enclosure);
            if (index == -1) {
                return element;
            }
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < index; ++i) {
                char c = element.charAt(i);
                buf.append(c);
            }
            int imax = element.length();
            for (i = index; i < imax; ++i) {
                char c = element.charAt(i);
                if (c == this.enclosure) {
                    buf.append(this.enclosure);
                }
                buf.append(c);
            }
            element = buf.toString();
        } else {
            int i;
            int index;
            int index1 = element.indexOf(this.separator);
            int index2 = element.indexOf(this.separatorEscape);
            int index3 = element.indexOf(13);
            int index4 = element.indexOf(10);
            if (index1 == -1 && index2 == -1 && index3 == -1 && index4 == -1) {
                return element;
            }
            int n = index1 == -1 ? index2 : (index = index2 == -1 ? index1 : Math.min(index1, index2));
            int n2 = index == -1 ? index3 : (index = index3 == -1 ? index : Math.min(index, index3));
            index = index == -1 ? index4 : (index4 == -1 ? index : Math.min(index, index4));
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < index; ++i) {
                char c = element.charAt(i);
                buf.append(c);
            }
            int imax = element.length();
            for (i = index; i < imax; ++i) {
                char c = element.charAt(i);
                if (c == this.separator || c == this.separatorEscape) {
                    buf.append(this.separatorEscape);
                    buf.append(c);
                    continue;
                }
                if (c == '\r') {
                    buf.append(REPLACE_CR);
                    continue;
                }
                if (c == '\n') {
                    buf.append(REPLACE_LF);
                    continue;
                }
                buf.append(c);
            }
            element = buf.toString();
        }
        return element;
    }

    public void writeCSV(String[] elements) throws IOException {
        for (int i = 0; i < elements.length; ++i) {
            this.writeElement(elements[i]);
        }
        this.newLine();
    }

    public void writeCSV(Object[] elements) throws IOException {
        for (int i = 0; i < elements.length; ++i) {
            this.writeElement(elements[i]);
        }
        this.newLine();
    }

    public void writeCSV(List elements) throws IOException {
        int imax = elements.size();
        for (int i = 0; i < imax; ++i) {
            this.writeElement(elements.get(i));
        }
        this.newLine();
    }
}

