/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.connection;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.DataSourceConnectionFactoryServiceMBean;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.jndi.JndiFinder;

public class DataSourceConnectionFactoryService
extends ServiceBase
implements DataSourceConnectionFactoryServiceMBean,
Serializable {
    private static final long serialVersionUID = -5837939620922806932L;
    private String dataSourceName;
    private JndiFinder jndiFinder;
    private ServiceName jndiFinderName;
    private Context context;
    private ServiceName contextName;
    private String dataSourceNameKey = DEFAULT_DATASOURCE_NAME_KEY;

    public void setName(String name) {
        this.dataSourceName = name;
    }

    public String getName() {
        return this.dataSourceName;
    }

    public void setJndiFinderServiceName(ServiceName name) {
        this.jndiFinderName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.jndiFinderName;
    }

    public JndiFinder getJndiFinderService() {
        return this.jndiFinder;
    }

    public void setJndiFinderService(JndiFinder finder) {
        this.jndiFinder = finder;
    }

    public void setContextServiceName(ServiceName name) {
        this.contextName = name;
    }

    public ServiceName getContextServiceName() {
        return this.contextName;
    }

    public Context getContextService() {
        return this.context;
    }

    public void setContextService(Context context) {
        this.context = context;
    }

    public void setDataSourceNameKey(String key) {
        this.dataSourceNameKey = key;
    }

    public String getDataSourceNameKey() {
        return this.dataSourceNameKey;
    }

    public void startService() throws Exception {
        if (this.getJndiFinderServiceName() != null) {
            this.jndiFinder = (JndiFinder)ServiceManagerFactory.getServiceObject(this.getJndiFinderServiceName());
        } else if (this.jndiFinder == null) {
            throw new IllegalArgumentException("Argument : JndiFinderName or JndiFinder is null.");
        }
        if (this.getContextServiceName() != null) {
            this.context = (Context)ServiceManagerFactory.getServiceObject(this.getContextServiceName());
        }
        if (this.context == null && this.getName() == null) {
            throw new IllegalArgumentException("DataSource name is null.");
        }
    }

    public Connection getConnection() throws ConnectionFactoryException {
        Connection con = null;
        try {
            String tmpName;
            String name = this.getName();
            if (this.context != null && (tmpName = (String)this.context.get(this.getDataSourceNameKey())) != null) {
                name = tmpName;
            }
            DataSource dataSource = (DataSource)this.jndiFinder.lookup(name);
            con = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionFactoryException(e);
        }
        catch (NamingException e) {
            throw new ConnectionFactoryException(e);
        }
        return con;
    }
}

