/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.graph;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.graph.DatabaseDatasetFactoryService;
import jp.ossc.nimbus.service.graph.DatabaseOHLCDatasetFactoryServiceMBean;
import jp.ossc.nimbus.service.graph.DatasetCondition;
import jp.ossc.nimbus.service.graph.DatasetCreateException;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultOHLCDataset;
import org.jfree.data.xy.OHLCDataItem;

public class DatabaseOHLCDatasetFactoryService
extends DatabaseDatasetFactoryService
implements DatabaseOHLCDatasetFactoryServiceMBean {
    private static final long serialVersionUID = -3149613092108949933L;
    private String dateFormatPattern;
    private String dateColumnName;
    private String timeColumnName;
    private String openPriceColumnName;
    private String highPriceColumnName;
    private String lowPriceColumnName;
    private String closePriceColumnName;
    private String volumeColumnName;
    private int dateColumnIndex = -1;
    private int timeColumnIndex = -1;
    private int openPriceColumnIndex = -1;
    private int highPriceColumnIndex = -1;
    private int lowPriceColumnIndex = -1;
    private int closePriceColumnIndex = -1;
    private int volumeColumnIndex = -1;
    private ServiceName dateFormatServiceName;
    private int collateDataField = 14;
    private int collateDataPeriod = 1;
    private int collateDataDateType = 1;

    public void createService() throws Exception {
        super.createService();
    }

    public void startService() throws Exception {
        super.startService();
        if (this.dateFormatPattern != null) {
            new SimpleDateFormat(this.dateFormatPattern);
        }
        if (this.dateColumnName == null && this.dateColumnIndex <= 0 && this.timeColumnName == null && this.timeColumnIndex <= 0) {
            throw new IllegalArgumentException("dateColumnName or dateColumnIndex or timeColumnName or timeColumnIndex must be specified.");
        }
        if (this.openPriceColumnName == null && this.openPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("openPriceColumnName or openPriceColumnIndex must be specified.");
        }
        if (this.highPriceColumnName == null && this.highPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("highPriceColumnName or highPriceColumnIndex must be specified.");
        }
        if (this.lowPriceColumnName == null && this.lowPriceColumnIndex <= 0) {
            throw new IllegalArgumentException("lowPriceColumnName or lowPriceColumnIndex must be specified.");
        }
        if (this.closePriceColumnName == null && this.closePriceColumnIndex <= 0) {
            throw new IllegalArgumentException("closePriceColumnName or closePriceColumnIndex must be specified.");
        }
    }

    public void stopService() throws Exception {
        super.stopService();
    }

    public void destroyService() throws Exception {
        super.destroyService();
    }

    public void setDateFormatPattern(String pattern) {
        this.dateFormatPattern = pattern;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateColumnName(String columnName) {
        this.dateColumnName = columnName;
    }

    public String getDateColumnName() {
        return this.dateColumnName;
    }

    public void setTimeColumnName(String columnName) {
        this.timeColumnName = columnName;
    }

    public String getTimeColumnName() {
        return this.timeColumnName;
    }

    public void setOpenPriceColumnName(String columnName) {
        this.openPriceColumnName = columnName;
    }

    public String getOpenPriceColumnName() {
        return this.openPriceColumnName;
    }

    public void setHighPriceColumnName(String columnName) {
        this.highPriceColumnName = columnName;
    }

    public String getHighPriceColumnName() {
        return this.highPriceColumnName;
    }

    public void setLowPriceColumnName(String columnName) {
        this.lowPriceColumnName = columnName;
    }

    public String getLowPriceColumnName() {
        return this.lowPriceColumnName;
    }

    public void setClosePriceColumnName(String columnName) {
        this.closePriceColumnName = columnName;
    }

    public String getClosePriceColumnName() {
        return this.closePriceColumnName;
    }

    public void setVolumeColumnName(String columnName) {
        this.volumeColumnName = columnName;
    }

    public String getVolumeColumnName() {
        return this.volumeColumnName;
    }

    public void setDateColumnIndex(int index) {
        this.dateColumnIndex = index;
    }

    public int getDateColumnIndex() {
        return this.dateColumnIndex;
    }

    public void setTimeColumnIndex(int index) {
        this.timeColumnIndex = index;
    }

    public int getTimeColumnIndex() {
        return this.timeColumnIndex;
    }

    public void setOpenPriceColumnIndex(int index) {
        this.openPriceColumnIndex = index;
    }

    public int getOpenPriceColumnIndex() {
        return this.openPriceColumnIndex;
    }

    public void setHighPriceColumnIndex(int index) {
        this.highPriceColumnIndex = index;
    }

    public int getHighPriceColumnIndex() {
        return this.highPriceColumnIndex;
    }

    public void setLowPriceColumnIndex(int index) {
        this.lowPriceColumnIndex = index;
    }

    public int getLowPriceColumnIndex() {
        return this.lowPriceColumnIndex;
    }

    public void setClosePriceColumnIndex(int index) {
        this.closePriceColumnIndex = index;
    }

    public int getClostePriceColumnIndex() {
        return this.closePriceColumnIndex;
    }

    public void setVolumeColumnIndex(int index) {
        this.volumeColumnIndex = index;
    }

    public int getVolumeColumnIndex() {
        return this.volumeColumnIndex;
    }

    public void setDateFormatServiceName(ServiceName serviceName) {
        this.dateFormatServiceName = serviceName;
    }

    public ServiceName getDateFormatServiceName() {
        return this.dateFormatServiceName;
    }

    public void setCollateDataPeriod(int field, int period) {
        this.collateDataField = field;
        this.collateDataPeriod = period;
    }

    public void setCollateDataDateType(int type) {
        this.collateDataDateType = type;
    }

    public int getCollateDataDateType() {
        return this.collateDataDateType;
    }

    protected Dataset createDataset(DatasetCondition[] dsConditions, String[] seriesArray, ResultSet[] rSets) throws DatasetCreateException {
        if (seriesArray == null || seriesArray.length == 0 || rSets == null || rSets.length == 0) {
            return null;
        }
        String series = seriesArray[0];
        ResultSet rs = rSets[0];
        return new DefaultOHLCDataset((Comparable)((Object)series), this.createDataItems(dsConditions, series, rs));
    }

    private long getStartMillis(Calendar cal, Date date) {
        cal.setTime(date);
        int currVal = cal.get(this.collateDataField);
        switch (this.collateDataField) {
            case 13: {
                cal.set(14, 0);
                break;
            }
            case 12: {
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 10: 
            case 11: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 2: 
            case 5: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
            case 1: {
                cal.set(2, 0);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                break;
            }
        }
        cal.set(this.collateDataField, currVal - currVal % this.collateDataPeriod);
        return cal.getTimeInMillis();
    }

    protected OHLCDataItem[] createDataItems(DatasetCondition[] dsConditions, String series, ResultSet rs) throws DatasetCreateException {
        DateFormat dateFormat = null;
        if (this.dateFormatServiceName != null) {
            dateFormat = (DateFormat)ServiceManagerFactory.getServiceObject(this.dateFormatServiceName);
        } else if (this.dateFormatPattern != null) {
            dateFormat = new SimpleDateFormat(this.dateFormatPattern);
        }
        Calendar cal = Calendar.getInstance();
        ArrayList<OHLCDataItem> list = new ArrayList<OHLCDataItem>();
        try {
            long periodStartMillis = -1L;
            long prePeriodStartMillis = -1L;
            double openPrice = Double.NaN;
            double highPrice = Double.NaN;
            double lowPrice = Double.NaN;
            double closePrice = Double.NaN;
            double volume = 0.0;
            long period = 0L;
            block1 : switch (this.collateDataDateType) {
                case 2: {
                    switch (this.collateDataField) {
                        case 13: {
                            period = 1000L;
                            break block1;
                        }
                        case 12: {
                            period = 60000L;
                            break block1;
                        }
                        case 10: {
                            period = 3600000L;
                            break block1;
                        }
                        case 5: {
                            period = 86400000L;
                            break block1;
                        }
                        case 2: {
                            cal.setTimeInMillis(periodStartMillis);
                            long dayOfMonth = cal.getActualMaximum(5);
                            period = dayOfMonth * 24L * 60L * 60L * 1000L;
                            break block1;
                        }
                        case 1: {
                            cal.setTimeInMillis(periodStartMillis);
                            long dayOfYear = cal.getActualMaximum(6);
                            period = dayOfYear * 24L * 60L * 60L * 1000L;
                            break block1;
                        }
                    }
                    period = 1L;
                    break;
                }
            }
            while (rs.next()) {
                Date date = null;
                if (dateFormat != null) {
                    String dateStr = null;
                    String dateVal = null;
                    String timeVal = null;
                    if (this.dateColumnIndex > 0) {
                        dateVal = rs.getString(this.dateColumnIndex);
                    } else if (this.dateColumnName != null) {
                        dateVal = rs.getString(this.dateColumnName);
                    }
                    if (this.timeColumnIndex > 0) {
                        timeVal = rs.getString(this.timeColumnIndex);
                    } else if (this.timeColumnName != null) {
                        timeVal = rs.getString(this.timeColumnName);
                    }
                    boolean isTimeOnly = false;
                    if (dateVal != null && timeVal != null) {
                        dateStr = dateVal + timeVal;
                    } else if (dateVal != null) {
                        dateStr = dateVal;
                    } else {
                        dateStr = timeVal;
                        isTimeOnly = true;
                    }
                    date = dateFormat.parse(dateStr);
                    if (isTimeOnly) {
                        cal.clear();
                        cal.setTimeInMillis(System.currentTimeMillis());
                        int year = cal.get(1);
                        int month = cal.get(2);
                        int day = cal.get(5);
                        cal.clear();
                        cal.setTime(date);
                        cal.set(1, year);
                        cal.set(2, month);
                        cal.set(5, day);
                        date = cal.getTime();
                    }
                } else if (this.dateColumnIndex > 0) {
                    date = rs.getDate(this.dateColumnIndex);
                } else if (this.dateColumnName != null) {
                    date = rs.getDate(this.dateColumnName);
                }
                if (date == null) {
                    throw new DatasetCreateException("date is null.");
                }
                periodStartMillis = this.getStartMillis(cal, date);
                if (prePeriodStartMillis != -1L && prePeriodStartMillis != periodStartMillis) {
                    Date itemDate = null;
                    switch (this.collateDataDateType) {
                        case 2: {
                            itemDate = new Date(prePeriodStartMillis + period * (long)(this.collateDataPeriod - 1));
                            break;
                        }
                        default: {
                            itemDate = new Date(prePeriodStartMillis);
                        }
                    }
                    OHLCDataItem item = new OHLCDataItem(itemDate, openPrice, highPrice, lowPrice, closePrice, volume);
                    list.add(item);
                    openPrice = Double.NaN;
                    highPrice = Double.NaN;
                    lowPrice = Double.NaN;
                    closePrice = Double.NaN;
                    volume = Double.NaN;
                    prePeriodStartMillis = periodStartMillis;
                }
                double val = Double.NaN;
                val = this.openPriceColumnIndex > 0 ? rs.getDouble(this.openPriceColumnIndex) : (this.openPriceColumnName != null ? rs.getDouble(this.openPriceColumnName) : Double.NaN);
                if (!Double.isNaN(val) && rs.wasNull()) continue;
                if (!Double.isNaN(val) && Double.isNaN(openPrice)) {
                    openPrice = val;
                }
                if (!Double.isNaN(val = this.highPriceColumnIndex > 0 ? rs.getDouble(this.highPriceColumnIndex) : (this.highPriceColumnName != null ? rs.getDouble(this.highPriceColumnName) : Double.NaN)) && rs.wasNull()) continue;
                if (!Double.isNaN(val) && (Double.isNaN(highPrice) || highPrice < val)) {
                    highPrice = val;
                }
                if (!Double.isNaN(val = this.lowPriceColumnIndex > 0 ? rs.getDouble(this.lowPriceColumnIndex) : (this.lowPriceColumnName != null ? rs.getDouble(this.lowPriceColumnName) : Double.NaN)) && rs.wasNull()) continue;
                if (!Double.isNaN(val) && (Double.isNaN(lowPrice) || lowPrice > val)) {
                    lowPrice = val;
                }
                if (!Double.isNaN(val = this.closePriceColumnIndex > 0 ? rs.getDouble(this.closePriceColumnIndex) : (this.closePriceColumnName != null ? rs.getDouble(this.closePriceColumnName) : Double.NaN)) && rs.wasNull()) continue;
                if (!Double.isNaN(val)) {
                    closePrice = val;
                }
                if (!Double.isNaN(val = this.volumeColumnIndex > 0 ? rs.getDouble(this.volumeColumnIndex) : (this.volumeColumnName != null ? rs.getDouble(this.volumeColumnName) : Double.NaN)) && rs.wasNull()) continue;
                if (!Double.isNaN(val)) {
                    volume = Double.isNaN(volume) ? val : (volume += val);
                }
                if (prePeriodStartMillis != -1L) continue;
                prePeriodStartMillis = periodStartMillis;
            }
            if (periodStartMillis != -1L && prePeriodStartMillis == periodStartMillis) {
                Date itemDate = null;
                switch (this.collateDataDateType) {
                    case 2: {
                        itemDate = new Date(periodStartMillis + period * (long)(this.collateDataPeriod - 1));
                        break;
                    }
                    default: {
                        itemDate = new Date(prePeriodStartMillis);
                    }
                }
                OHLCDataItem item = new OHLCDataItem(itemDate, openPrice, highPrice, lowPrice, closePrice, volume);
                list.add(item);
            }
        }
        catch (SQLException e) {
            throw new DatasetCreateException(e);
        }
        catch (ParseException e) {
            throw new DatasetCreateException(e);
        }
        return list.toArray(new OHLCDataItem[list.size()]);
    }
}

