/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.ioccall.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.CommandBase;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aspect.interfaces.Interceptor;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChain;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.ioccall.interceptor.ExceptionHandler;
import jp.ossc.nimbus.service.ioccall.interceptor.ExceptionHandlingInterceptorServiceMBean;
import jp.ossc.nimbus.util.ClassMappingTree;

public class ExceptionHandlingInterceptorService
extends ServiceBase
implements ExceptionHandlingInterceptorServiceMBean,
Interceptor,
jp.ossc.nimbus.service.aop.Interceptor {
    private static final long serialVersionUID = 346215587946433868L;
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    private static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    private static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    protected Properties exceptionAndHandlerMapping;
    protected ClassMappingTree exceptionMapForHandler;
    protected ServiceName defaultExceptionHandlerServiceName;
    protected ExceptionHandler defaultExceptionHandler;

    public void setExceptionAndHandlerMapping(Properties map) {
        this.exceptionAndHandlerMapping = map;
    }

    public Properties getExceptionAndHandlerMapping() {
        return this.exceptionAndHandlerMapping;
    }

    public void setDefaultExceptionHandlerServiceName(ServiceName name) {
        this.defaultExceptionHandlerServiceName = name;
    }

    public ServiceName getDefaultExceptionHandlerServiceName() {
        return this.defaultExceptionHandlerServiceName;
    }

    public void startService() throws Exception {
        if (this.exceptionAndHandlerMapping != null) {
            this.exceptionMapForHandler = new ClassMappingTree();
            NimbusClassLoader loader = NimbusClassLoader.getInstance();
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            Iterator<Object> exNames = this.exceptionAndHandlerMapping.keySet().iterator();
            while (exNames.hasNext()) {
                String exName = (String)exNames.next();
                Class<?> clazz = Class.forName(exName, true, loader);
                String name = (String)this.exceptionAndHandlerMapping.get(exName);
                editor.setAsText(name);
                ServiceName serviceName = (ServiceName)editor.getValue();
                this.exceptionMapForHandler.add(clazz, ServiceManagerFactory.getServiceObject(serviceName));
            }
        }
        if (this.defaultExceptionHandlerServiceName != null) {
            this.defaultExceptionHandler = (ExceptionHandler)ServiceManagerFactory.getServiceObject(this.defaultExceptionHandlerServiceName);
        }
    }

    protected ExceptionHandler getTargetExceptionHandlerCause(Throwable th) {
        ExceptionHandler handler = (ExceptionHandler)this.getTargetHandlerCause(this.exceptionMapForHandler, th);
        return handler == null ? this.defaultExceptionHandler : handler;
    }

    protected Object getTargetHandlerCause(ClassMappingTree handlers, Throwable th) {
        if (handlers == null) {
            return null;
        }
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return handler;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetHandlerCause(handlers, cause);
    }

    protected Throwable getTargetException(ClassMappingTree handlers, Throwable th) {
        if (handlers == null) {
            return th;
        }
        Object handler = handlers.getValue(th.getClass());
        if (handler != null) {
            return th;
        }
        Throwable cause = this.getCause(th);
        return cause == null ? null : this.getTargetException(handlers, cause);
    }

    protected Throwable getCause(Throwable th) {
        Throwable cause = null;
        String thClassName = th.getClass().getName();
        if (thClassName.equals(SERVLET_EXCEPTION_NAME)) {
            try {
                cause = (Throwable)th.getClass().getMethod(GET_ROOT_CAUSE_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else if (thClassName.equals(JMS_EXCEPTION_NAME)) {
            try {
                cause = (Exception)th.getClass().getMethod(GET_LINKED_EXCEPTION_METHOD, null).invoke((Object)th, null);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {}
        } else {
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }

    public Object invokeChain(Object inputObj, InterceptorChain interceptChain) throws InterceptorException, TargetCheckedException, TargetUncheckedException {
        try {
            return this.invokeInternal(inputObj, interceptChain, null);
        }
        catch (InterceptorException e) {
            throw e;
        }
        catch (TargetCheckedException e) {
            throw e;
        }
        catch (TargetUncheckedException e) {
            throw e;
        }
        catch (Throwable th) {
            throw new InterceptorException(th);
        }
    }

    public Object invoke(InvocationContext context, jp.ossc.nimbus.service.aop.InterceptorChain chain) throws Throwable {
        return this.invokeInternal(context, null, chain);
    }

    protected Object invokeInternal(Object inputObj, InterceptorChain interceptChain, jp.ossc.nimbus.service.aop.InterceptorChain chain) throws Throwable {
        Object input = inputObj;
        if (chain != null) {
            input = ((MethodInvocationContext)input).getParameters()[0];
        }
        if (this.getState() == 3) {
            Throwable[] ths;
            CommandBase comBase;
            Object ret = null;
            try {
                ret = interceptChain != null ? interceptChain.invokeChain(input) : chain.invokeNext((InvocationContext)inputObj);
            }
            catch (Throwable th) {
                if (!this.handleException(th, input, null)) {
                    throw th;
                }
                ret = input;
            }
            if (ret != null && ret instanceof CommandBase && (comBase = (CommandBase)ret).getStatus() == 1 && (ths = comBase.getExceptions()) != null && ths.length != 0) {
                for (int i = 0; i < ths.length; ++i) {
                    this.handleException(ths[i], input, comBase);
                }
            }
            return ret;
        }
        if (interceptChain != null) {
            return interceptChain.invokeChain(input);
        }
        return chain.invokeNext((InvocationContext)inputObj);
    }

    protected boolean handleException(Throwable th, Object input, Object output) throws Throwable {
        ExceptionHandler handler = this.getTargetExceptionHandlerCause(th);
        if (handler != null) {
            Throwable targetTh = this.getTargetException(this.exceptionMapForHandler, th);
            if (targetTh == null) {
                targetTh = th;
            }
            handler.handleException(targetTh, input, output);
            return true;
        }
        return false;
    }
}

