/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.keepalive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.keepalive.AbstractKeepAliveCheckerSelectorServiceMBean;
import jp.ossc.nimbus.service.keepalive.KeepAliveChecker;
import jp.ossc.nimbus.service.keepalive.KeepAliveCheckerSelector;

public abstract class AbstractKeepAliveCheckerSelectorService
extends ServiceBase
implements KeepAliveCheckerSelector,
DaemonRunnable,
AbstractKeepAliveCheckerSelectorServiceMBean {
    private static final long serialVersionUID = 1452664941582086362L;
    protected ServiceName[] selectableCheckerServiceNames;
    protected long checkInterval = -1L;
    protected List aliveCheckers;
    protected Daemon daemon;
    protected String aliveLogMessageId = "KACS_00001";
    protected String deadLogMessageId = "KACS_00002";
    protected boolean isOutputAliveLogMessage = true;
    protected boolean isOutputDeadLogMessage = true;

    public void setSelectableCheckerServiceNames(ServiceName[] names) {
        this.selectableCheckerServiceNames = names;
    }

    public ServiceName[] getSelectableCheckerServiceNames() {
        return this.selectableCheckerServiceNames;
    }

    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setAliveLogMessageId(String id) {
        this.aliveLogMessageId = id;
    }

    public String getAliveLogMessageId() {
        return this.aliveLogMessageId;
    }

    public void setDeadLogMessageId(String id) {
        this.deadLogMessageId = id;
    }

    public String getDeadLogMessageId() {
        return this.deadLogMessageId;
    }

    public void setOutputAliveLogMessage(boolean isOutput) {
        this.isOutputAliveLogMessage = isOutput;
    }

    public boolean isOutputAliveLogMessage() {
        return this.isOutputAliveLogMessage;
    }

    public void setOutputDeadLogMessage(boolean isOutput) {
        this.isOutputDeadLogMessage = isOutput;
    }

    public boolean isOutputDeadLogMessage() {
        return this.isOutputDeadLogMessage;
    }

    public void createService() throws Exception {
        this.aliveCheckers = Collections.synchronizedList(new ArrayList());
    }

    public void startService() throws Exception {
        if (this.checkInterval > 0L) {
            this.daemon = new Daemon(this);
            this.daemon.setName("Nimbus KeepAliveCheckDaemon " + this.getServiceNameObject());
            this.daemon.start();
        }
    }

    public void stopService() throws Exception {
        if (this.daemon != null) {
            this.daemon.stop();
        }
        this.aliveCheckers.clear();
    }

    public void destroyService() throws Exception {
        this.aliveCheckers = null;
    }

    public KeepAliveChecker[] getSelectableCheckers() {
        if (this.checkInterval <= 0L) {
            this.updateChekerStates(false);
        }
        ServiceName[] names = this.aliveCheckers.toArray(new ServiceName[this.aliveCheckers.size()]);
        ArrayList<KeepAliveChecker> list = new ArrayList<KeepAliveChecker>();
        KeepAliveChecker checker = null;
        for (int i = 0; i < names.length; ++i) {
            try {
                Service service = ServiceManagerFactory.getService(names[i]);
                if (service.getState() != 3) continue;
                checker = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(names[i]);
                list.add(checker);
                continue;
            }
            catch (ServiceNotFoundException e) {
                // empty catch block
            }
        }
        return list.toArray(new KeepAliveChecker[list.size()]);
    }

    protected void updateChekerStates(boolean init) {
        if (this.aliveCheckers == null) {
            return;
        }
        for (int i = 0; i < this.selectableCheckerServiceNames.length; ++i) {
            try {
                Service service = ServiceManagerFactory.getService(this.selectableCheckerServiceNames[i]);
                KeepAliveChecker checker = (KeepAliveChecker)ServiceManagerFactory.getServiceObject(this.selectableCheckerServiceNames[i]);
                if (service.getState() == 3 && checker.isAlive()) {
                    if (this.aliveCheckers.contains(this.selectableCheckerServiceNames[i])) continue;
                    this.aliveCheckers.add(this.selectableCheckerServiceNames[i]);
                    if (init || !this.isOutputAliveLogMessage) continue;
                    this.getLogger().write(this.aliveLogMessageId, this.selectableCheckerServiceNames[i]);
                    continue;
                }
                if (!this.aliveCheckers.contains(this.selectableCheckerServiceNames[i])) continue;
                this.aliveCheckers.remove(this.selectableCheckerServiceNames[i]);
                if (init || !this.isOutputDeadLogMessage) continue;
                this.getLogger().write(this.deadLogMessageId, this.selectableCheckerServiceNames[i]);
                continue;
            }
            catch (ServiceNotFoundException e) {
                this.aliveCheckers.remove(this.selectableCheckerServiceNames[i]);
            }
        }
    }

    public boolean onStart() {
        this.updateChekerStates(true);
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Exception {
        if (this.checkInterval >= 0L) {
            Thread.sleep(this.checkInterval);
        } else {
            ctrl.setRunning(false);
        }
        return null;
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws Exception {
        this.updateChekerStates(false);
    }

    public void garbage() {
    }
}

