/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.scheduler2.AbstractSchedulerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleExecutor;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;
import jp.ossc.nimbus.service.scheduler2.Scheduler;
import jp.ossc.nimbus.service.sequence.Sequence;

public abstract class AbstractSchedulerService
extends ServiceBase
implements AbstractSchedulerServiceMBean,
Scheduler {
    private static final long serialVersionUID = 6938915052580428501L;
    protected static final String TRANSACTION_MANAGER_JNDI_NAME = "java:/TransactionManager";
    protected long scheduleTickerInterval = 1000L;
    protected ServiceName scheduleManagerServiceName;
    protected ScheduleManager scheduleManager;
    protected ServiceName scheduleExecutorServiceName;
    protected ScheduleExecutor scheduleExecutor;
    protected Daemon scheduleTicker;
    protected boolean isTransactionControl;
    protected TransactionManager transactionManager;
    protected String executorKey;
    protected ServiceName threadContextServiceName;
    protected Context threadContext;
    protected ServiceName sequenceServiceName;
    protected Sequence sequence;

    public void setScheduleTickerInterval(long interval) {
        this.scheduleTickerInterval = interval;
    }

    public long getScheduleTickerInterval() {
        return this.scheduleTickerInterval;
    }

    public void setScheduleManagerServiceName(ServiceName name) {
        this.scheduleManagerServiceName = name;
    }

    public ServiceName getScheduleManagerServiceName() {
        return this.scheduleManagerServiceName;
    }

    public void setScheduleExecutorServiceName(ServiceName name) {
        this.scheduleExecutorServiceName = name;
    }

    public ServiceName getScheduleExecutorServiceName() {
        return this.scheduleExecutorServiceName;
    }

    public void setThreadContextServiceName(ServiceName name) {
        this.threadContextServiceName = name;
    }

    public ServiceName getThreadContextServiceName() {
        return this.threadContextServiceName;
    }

    public void setSequenceServiceName(ServiceName name) {
        this.sequenceServiceName = name;
    }

    public ServiceName getSequenceServiceName() {
        return this.sequenceServiceName;
    }

    public void setTransactionControl(boolean isControl) {
        this.isTransactionControl = isControl;
    }

    public boolean isTransactionControl() {
        return this.isTransactionControl;
    }

    public void setExecutorKey(String key) {
        this.executorKey = key;
    }

    public String getExecutorKey() {
        return this.executorKey;
    }

    public void preCreateService() throws Exception {
        super.preCreateService();
    }

    public void preStartService() throws Exception {
        super.preStartService();
        if (this.isTransactionControl) {
            InitialContext context = new InitialContext();
            this.transactionManager = (TransactionManager)context.lookup(TRANSACTION_MANAGER_JNDI_NAME);
        }
        if (this.scheduleExecutorServiceName != null) {
            this.scheduleExecutor = (ScheduleExecutor)ServiceManagerFactory.getServiceObject(this.scheduleExecutorServiceName);
        }
        if (this.scheduleExecutor == null) {
            throw new IllegalArgumentException("ScheduleExecutor is null.");
        }
        if (this.scheduleManagerServiceName != null) {
            this.scheduleManager = (ScheduleManager)ServiceManagerFactory.getServiceObject(this.scheduleManagerServiceName);
        }
        if (this.scheduleManager == null) {
            throw new IllegalArgumentException("ScheduleManager is null.");
        }
        if (this.threadContextServiceName != null) {
            this.threadContext = (Context)ServiceManagerFactory.getServiceObject(this.threadContextServiceName);
        }
        if (this.sequenceServiceName != null) {
            this.sequence = (Sequence)ServiceManagerFactory.getServiceObject(this.sequenceServiceName);
        }
    }

    public void postStartService() throws Exception {
        this.scheduleManager.addScheduleControlListener(this);
        this.scheduleTicker = new Daemon(new ScheduleTicker());
        this.scheduleTicker.setName(this.getServiceNameObject() + " ScheduleTicker");
        this.scheduleTicker.start();
        super.postStartService();
    }

    public void preStopService() throws Exception {
        if (this.scheduleTicker != null) {
            this.scheduleTicker.stop();
        }
        this.scheduleManager.removeScheduleControlListener(this);
        super.preStopService();
    }

    public void postStopService() throws Exception {
        super.postStopService();
    }

    public void postDestroyService() throws Exception {
        this.scheduleTicker = null;
        super.postDestroyService();
    }

    public void setThreadContext(Context context) {
        this.threadContext = context;
    }

    public Context getThreadContext() {
        return this.threadContext;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public void setScheduleManager(ScheduleManager manager) {
        this.scheduleManager = manager;
    }

    public ScheduleExecutor getScheduleExecutor() {
        return this.scheduleExecutor;
    }

    public void setScheduleExecutor(ScheduleExecutor executor) {
        this.scheduleExecutor = executor;
    }

    public void startEntry() {
        if (this.scheduleTicker != null) {
            this.scheduleTicker.suspend();
        }
    }

    public void stopEntry() {
        if (this.scheduleTicker != null) {
            this.scheduleTicker.resume();
        }
    }

    public void changedControlState(String id, int state) throws ScheduleStateControlException {
        this.scheduleExecutor.controlState(id, state);
    }

    protected abstract boolean isTransactableQueue();

    protected abstract void entrySchedule(ScheduleRequest var1) throws Throwable;

    protected void dispatchSchedule(ScheduleRequest request) {
        if (this.threadContext != null) {
            this.threadContext.clear();
        }
        if (this.threadContext != null && request.getRequestId() != null) {
            this.threadContext.put("REQUEST_ID", request.getRequestId());
        }
        Schedule schedule = request.getSchedule();
        schedule.setRetry(false);
        schedule.setOutput(null);
        try {
            schedule = this.scheduleExecutor.execute(schedule);
        }
        catch (Throwable th) {
            this.getLogger().write("AS___00002", new Object[]{schedule.getId(), schedule.getTaskName()}, th);
            try {
                this.scheduleManager.changeState(schedule.getId(), 5);
            }
            catch (ScheduleStateControlException e) {
                this.getLogger().write("AS___00001", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(5)}, (Throwable)e);
            }
            return;
        }
    }

    protected static class ScheduleRequest
    implements Serializable {
        private static final long serialVersionUID = 8405850740460011444L;
        protected Schedule schedule;
        protected String requestId;

        public ScheduleRequest(Schedule schedule) {
            this.schedule = schedule;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public void setSchedule(Schedule schedule) {
            this.schedule = schedule;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String id) {
            this.requestId = id;
        }
    }

    protected class ScheduleTicker
    implements DaemonRunnable {
        protected ScheduleTicker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(AbstractSchedulerService.this.getScheduleTickerInterval());
            return null;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void consume(Object schedules, DaemonControl ctrl) throws Throwable {
            block33: {
                block32: {
                    block31: {
                        rollbackMark = false;
                        scheduleList = null;
                        scheduleRequests = null;
                        try {
                            try {
                                block36: {
                                    block35: {
                                        if (AbstractSchedulerService.this.isTransactionControl) {
                                            AbstractSchedulerService.this.transactionManager.begin();
                                        }
                                        try {
                                            scheduleList = AbstractSchedulerService.this.executorKey == null ? AbstractSchedulerService.this.scheduleManager.findExecutableSchedules(new Date()) : AbstractSchedulerService.this.scheduleManager.findExecutableSchedules(new Date(), AbstractSchedulerService.this.executorKey);
                                        }
                                        catch (ScheduleManageException e) {
                                            AbstractSchedulerService.this.getLogger().write("AS___00004", e);
                                            rollbackMark = true;
                                            var12_10 = null;
                                            if (AbstractSchedulerService.this.isTransactionControl == false) return;
                                            transaction = AbstractSchedulerService.this.transactionManager.getTransaction();
                                            if (rollbackMark) {
                                                transaction.rollback();
                                                return;
                                            }
                                            transaction.commit();
                                            return;
                                        }
                                        if (scheduleList == null) break block35;
                                        if (scheduleList.size() != 0) break block36;
                                    }
                                    var12_11 = null;
                                    if (AbstractSchedulerService.this.isTransactionControl == false) return;
                                    break block31;
                                }
                                scheduleRequests = new ArrayList<ScheduleRequest>();
                                itr = scheduleList.iterator();
                                while (itr.hasNext()) {
                                    block34: {
                                        schedule = (Schedule)itr.next();
                                        request = new ScheduleRequest(schedule);
                                        if (AbstractSchedulerService.this.sequence != null) {
                                            request.setRequestId(AbstractSchedulerService.this.sequence.increment());
                                            if (AbstractSchedulerService.this.threadContext != null) {
                                                AbstractSchedulerService.this.threadContext.put("REQUEST_ID", request.getRequestId());
                                            }
                                        }
                                        scheduleRequests.add(request);
                                        try {
                                            nowState = AbstractSchedulerService.this.scheduleManager.getState(schedule.getId());
                                            switch (nowState) {
                                                case 1: 
                                                case 8: {
                                                    ** break;
                                                }
                                            }
                                            AbstractSchedulerService.this.getLogger().write("AS___00006", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(nowState), new Integer(2)});
                                            break block32;
                                        }
                                        catch (ScheduleStateControlException e) {
                                            AbstractSchedulerService.this.getLogger().write("AS___00001", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(2)}, (Throwable)e);
                                            rollbackMark = true;
                                            break block33;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            isChanged = AbstractSchedulerService.this.scheduleManager.changeState(schedule.getId(), nowState, 2);
                                            if (isChanged) break block34;
                                            itr.remove();
                                            AbstractSchedulerService.this.getLogger().write("AS___00006", new Object[]{schedule.getId(), schedule.getTaskName(), new Integer(nowState), new Integer(2)});
                                            continue;
                                        }
                                    }
                                    if (AbstractSchedulerService.this.isTransactionControl && !AbstractSchedulerService.this.isTransactableQueue()) continue;
                                    AbstractSchedulerService.this.getLogger().write("AS___00003", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()});
                                    try {
                                        AbstractSchedulerService.this.entrySchedule(request);
                                    }
                                    catch (Throwable th) {
                                        AbstractSchedulerService.this.getLogger().write("AS___00007", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()}, th);
                                        rollbackMark = true;
                                        break block33;
                                    }
                                }
                                break block33;
                            }
                            catch (Throwable th) {
                                AbstractSchedulerService.this.getLogger().write("AS___00005", th);
                                if (AbstractSchedulerService.this.isTransactionControl == false) throw th;
                                transaction = AbstractSchedulerService.this.transactionManager.getTransaction();
                                transaction.rollback();
                                throw th;
                            }
                        }
                        catch (Throwable var11_30) {
                            var12_14 = null;
                            if (AbstractSchedulerService.this.isTransactionControl == false) throw var11_30;
                            transaction = AbstractSchedulerService.this.transactionManager.getTransaction();
                            if (rollbackMark) {
                                transaction.rollback();
                                throw var11_30;
                            }
                            transaction.commit();
                            throw var11_30;
                        }
                    }
                    transaction = AbstractSchedulerService.this.transactionManager.getTransaction();
                    if (rollbackMark) {
                        transaction.rollback();
                        return;
                    }
                    transaction.commit();
                    return;
                }
                var12_12 = null;
                if (AbstractSchedulerService.this.isTransactionControl == false) return;
                transaction = AbstractSchedulerService.this.transactionManager.getTransaction();
                if (rollbackMark) {
                    transaction.rollback();
                    return;
                }
                transaction.commit();
                return;
            }
            var12_13 = null;
            if (AbstractSchedulerService.this.isTransactionControl) {
                transaction = AbstractSchedulerService.this.transactionManager.getTransaction();
                if (rollbackMark) {
                    transaction.rollback();
                } else {
                    transaction.commit();
                }
            }
            if (scheduleRequests == null) return;
            if (scheduleRequests.size() == 0) return;
            if (AbstractSchedulerService.this.isTransactionControl == false) return;
            if (AbstractSchedulerService.this.isTransactableQueue() != false) return;
            if (rollbackMark != false) return;
            i = 0;
            imax = scheduleRequests.size();
            while (i < imax) {
                request = (ScheduleRequest)scheduleRequests.get(i);
                if (AbstractSchedulerService.this.threadContext != null && request.getRequestId() != null) {
                    AbstractSchedulerService.this.threadContext.put("REQUEST_ID", request.getRequestId());
                }
                schedule = request.getSchedule();
                AbstractSchedulerService.this.getLogger().write("AS___00003", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()});
                try {
                    AbstractSchedulerService.this.entrySchedule(request);
                }
                catch (Throwable th) {
                    AbstractSchedulerService.this.getLogger().write("AS___00007", new Object[]{schedule.getId(), schedule.getTaskName(), schedule.getInput()}, th);
                }
                ++i;
            }
        }

        public void garbage() {
        }
    }
}

