/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.util.sql.StatementWrapper;

public class WrappedStatement
extends StatementWrapper {
    private static final long serialVersionUID = -9161665514224368780L;
    protected static final String DEFAULT_REQUEST_ID_KEY = "REQUEST_ID";
    protected static final String DEFAULT_JOURNAL_EXECUTE = "Execute";
    protected static final String DEFAULT_JOURNAL_SQL = "SQL";
    protected static final String SQL_SEPARATOR = ";";
    protected Journal journal;
    protected Context threadContext;
    protected String requestIDKey = "REQUEST_ID";
    protected Sequence sequence;
    protected String journalKeyExecute = "Execute";
    protected String journalKeySQL = "SQL";
    protected EditorFinder editorFinderForExecute;
    protected String requestId;
    protected StringBuffer batchSQL;

    public WrappedStatement(Statement st) {
        super(st);
    }

    public WrappedStatement(Connection con, Statement st) {
        super(con, st);
    }

    public void setJournal(Journal jnl) {
        this.journal = jnl;
    }

    public void setThreadContext(Context ctx) {
        this.threadContext = ctx;
    }

    public void setRequestIDKey(String key) {
        this.requestIDKey = key;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
    }

    public void setJournalKeyExecute(String key) {
        this.journalKeyExecute = key;
    }

    public void setEditorFinderForExecute(EditorFinder finder) {
        this.editorFinderForExecute = finder;
    }

    public void setJournalKeySQL(String key) {
        this.journalKeySQL = key;
    }

    protected void setRequestID() {
        if (this.journal == null) {
            return;
        }
        if (this.requestId == null) {
            if (this.threadContext != null && this.requestIDKey != null) {
                this.requestId = (String)this.threadContext.get(this.requestIDKey);
            }
            if (this.requestId == null && this.sequence != null) {
                this.requestId = this.sequence.increment();
                if (this.threadContext != null && this.requestIDKey != null) {
                    this.threadContext.put(this.requestIDKey, this.requestId);
                }
            }
        }
        if (this.requestId != null) {
            this.journal.setRequestId(this.requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            boolean bl = super.execute(arg0);
            Object var4_3 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0, int arg1) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            boolean bl = super.execute(arg0, arg1);
            Object var5_4 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            boolean bl = super.execute(arg0, arg1);
            Object var5_4 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            boolean bl = super.execute(arg0, arg1);
            Object var5_4 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            int n = super.executeUpdate(arg0);
            Object var4_3 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return n;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            int n = super.executeUpdate(arg0, arg1);
            Object var5_4 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return n;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            int n = super.executeUpdate(arg0, arg1);
            Object var5_4 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return n;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            int n = super.executeUpdate(arg0, arg1);
            Object var5_4 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return n;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String arg0) throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                this.journal.addInfo(this.journalKeySQL, arg0);
            }
            ResultSet resultSet = super.executeQuery(arg0);
            Object var4_3 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (this.journal == null) break block4;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    public void addBatch(String arg0) throws SQLException {
        super.addBatch(arg0);
        if (this.batchSQL == null) {
            this.batchSQL = new StringBuffer();
        }
        this.batchSQL.append(arg0).append(SQL_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            if (this.journal != null) {
                this.setRequestID();
                this.journal.startJournal(this.journalKeyExecute, this.editorFinderForExecute);
                if (this.batchSQL != null) {
                    this.journal.addInfo(this.journalKeySQL, this.batchSQL.toString());
                    this.batchSQL.setLength(0);
                }
            }
            int[] nArray = super.executeBatch();
            Object var3_2 = null;
            if (this.journal != null) {
                this.journal.endJournal();
            }
            return nArray;
        }
        catch (Throwable throwable) {
            block5: {
                Object var3_3 = null;
                if (this.journal == null) break block5;
                this.journal.endJournal();
            }
            throw throwable;
        }
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        if (this.batchSQL != null) {
            this.batchSQL.setLength(0);
        }
    }
}

