/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.beancontrol;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRequiredException;
import jp.ossc.nimbus.beans.NestedProperty;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.NullKeyPropertyException;
import jp.ossc.nimbus.beans.NullNestPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.recset.RecordSet;
import jp.ossc.nimbus.recset.RowData;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerAccess;
import jp.ossc.nimbus.service.beancontrol.BeanFlowInvokerFactoryCallBack;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitor;
import jp.ossc.nimbus.service.beancontrol.BeanFlowMonitorStopException;
import jp.ossc.nimbus.service.beancontrol.UnavailableFlowException;
import jp.ossc.nimbus.service.beancontrol.UnavailableStepException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanControlUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.beancontrol.interfaces.InvalidConfigurationException;
import jp.ossc.nimbus.service.beancontrol.resource.ResourceManager;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.semaphore.MemorySemaphore;
import jp.ossc.nimbus.service.semaphore.Semaphore;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.w3c.dom.Element;

public class BeanFlowInvokerAccessImpl2
extends MetaData
implements BeanFlowInvokerAccess {
    private static final long serialVersionUID = -9167347647817538189L;
    public static final String REQUIRED = "Required";
    public static final String REQUIRESNEW = "RequiresNew";
    public static final String SUPPORTS = "Supports";
    public static final String MANDATORY = "Mandatory";
    public static final String NEVER = "Never";
    public static final String NOT_SUPPORTED = "NotSupported";
    private static final String ARRAY_CLASS_SUFFIX = "[]";
    private static final String ALIAS_ELEMENT = "alias";
    private static final String RESOURCE_ELEMENT = "resource";
    private static final String RESOURCE_REF_ELEMENT = "resource-ref";
    private static final String STEP_ELEMENT = "step";
    private static final String SWITCH_ELEMENT = "switch";
    private static final String CASE_ELEMENT = "case";
    private static final String DEFAULT_ELEMENT = "default";
    private static final String IF_ELEMENT = "if";
    private static final String TARGET_ELEMENT = "target";
    private static final String INPUT_ELEMENT = "input";
    private static final String RESULT_ELEMENT = "result";
    private static final String THIS_ELEMENT = "this";
    private static final String CALL_FLOW_ELEMENT = "callflow";
    private static final String STEP_REF_ELEMENT = "step-ref";
    private static final String RETURN_ELEMENT = "return";
    private static final String FOR_ELEMENT = "for";
    private static final String VAR_ELEMENT = "var";
    private static final String CONTINUE_ELEMENT = "continue";
    private static final String BREAK_ELEMENT = "break";
    private static final String CATCH_ELEMENT = "catch";
    private static final String FINALLY_ELEMENT = "finally";
    private static final String THROW_ELEMENT = "throw";
    private static final String EXPRESSION_ELEMENT = "expression";
    private static final String WHILE_ELEMENT = "while";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String STEPNAME_ATTRIBUTE = "stepname";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String TRANSACTION_ATTRIBUTE = "transaction";
    private static final String TRANTIMEOUT_ATTRIBUTE = "trantimeout";
    private static final String TRANCONTROL_ATTRIBUTE = "trancontrol";
    private static final String TRANCLOSE_ATTRIBUTE = "tranclose";
    private static final String TEST_ATTRIBUTE = "test";
    private static final String EXCEPTION_ATTRIBUTE = "exception";
    private static final String INDEX_ATTRIBUTE = "index";
    private static final String BEGIN_ATTRIBUTE = "begin";
    private static final String END_ATTRIBUTE = "end";
    private static final String VAR_ATTRIBUTE = "var";
    private static final String RAW_ATTRIBUTE = "raw";
    private static final String MAX_RUN_THREADS_ATTRIBUTE = "maxRunThreads";
    private static final String MAX_WAIT_THREADS_ATTRIBUTE = "maxWaitThreads";
    private static final String TIMEOUT_ATTRIBUTE = "timeout";
    private static final String FORCE_FREE_TIMEOUT_ATTRIBUTE = "forceFreeTimeout";
    private static final String JOURNAL_ATTRIBUTE = "journal";
    private static final String DO_ATTRIBUTE = "do";
    private static final String SUSPEND_ATTRIBUTE = "suspend";
    private static final String STOP_ATTRIBUTE = "stop";
    private static final String FACTORY_ATTRIBUTE = "factory";
    private static final String NULLCHECK_ATTRIBUTE = "nullCheck";
    private static final String NARROWCAST_ATTRIBUTE = "narrowCast";
    private static final String JOURNAL_KEY_FLOW = "Flow";
    private static final String JOURNAL_KEY_FLOW_NAME = "Name";
    private static final String JOURNAL_KEY_FLOW_INPUT = "Input";
    private static final String JOURNAL_KEY_FLOW_EXCEPTION = "Exception";
    private static final String JOURNAL_KEY_FLOW_OUTPUT = "Output";
    private static final String JOURNAL_KEY_RESOURCE = "Resource";
    private static final String JOURNAL_KEY_STEP = "Step";
    private static final String JOURNAL_KEY_STEP_NAME = "Name";
    private static final String JOURNAL_KEY_STEP_TARGET = "Target";
    private static final String JOURNAL_KEY_STEP_RESULT = "Result";
    private static final String JOURNAL_KEY_STEP_EXCEPTION = "Exception";
    private static final String JOURNAL_KEY_IF = "If";
    private static final String JOURNAL_KEY_TEST = "Test";
    private static final String JOURNAL_KEY_CATCH = "Catch";
    private static final String JOURNAL_KEY_CATCH_EXCEPTION = "Exception";
    private static final String JOURNAL_KEY_FINALLY = "Finally";
    private static final String JOURNAL_KEY_OBJECT = "Object";
    private static final String JOURNAL_KEY_INSTANCE = "Instance";
    private static final String JOURNAL_KEY_CLASS = "Class";
    private static final String JOURNAL_KEY_FIELD = "Field:";
    private static final String JOURNAL_KEY_ATTRIBUTE = "Attribute:";
    private static final String JOURNAL_KEY_INVOKE = "Invoke:";
    private static final String JOURNAL_KEY_STATIC_INVOKE = "StaticInvoke:";
    private static final String JOURNAL_KEY_WHILE = "While";
    private static final int REQUIRED_VALUE = 0;
    private static final int REQUIRESNEW_VALUE = 1;
    private static final int SUPPORTS_VALUE = 2;
    private static final int MANDATORY_VALUE = 3;
    private static final int NEVER_VALUE = 4;
    private static final int NOT_SUPPORTED_VALUE = 5;
    private static final String TRANSACTION_MANAGER_JNDI_NAME = "java:/TransactionManager";
    protected String flowName;
    protected List aliasNames = new ArrayList();
    protected Map resources;
    protected List jobSteps;
    protected List catchSteps;
    protected FinallyMetaData finallyStep;
    protected Semaphore semaphore;
    protected int maxWaitCount = -1;
    protected long timeout = -1L;
    protected long forceFreeTimeout = -1L;
    protected int transactionType = 2;
    protected int transactionTimeout = -1;
    protected static final ThreadLocal transaction;
    protected boolean isJournal = true;
    protected boolean isSuspend = true;
    protected boolean isStop = true;
    protected TransactionManager tranManager;
    protected BeanFlowInvokerFactoryCallBack factoryCallBack;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$SimpleProperty;
    static /* synthetic */ Class class$java$lang$Exception;

    public void fillInstance(Element element, BeanFlowInvokerFactoryCallBack callBack) {
        try {
            MetaData step;
            String stopStr;
            String suspendStr;
            String journalStr;
            String transactionTimeoutStr;
            String transactionStr;
            String forceFreeTimeoutStr;
            String maxWaitCountStr;
            String timeoutStr;
            this.factoryCallBack = callBack;
            this.flowName = MetaData.getUniqueAttribute(element, NAME_ATTRIBUTE);
            String maxThreadsStr = MetaData.getOptionalAttribute(element, MAX_RUN_THREADS_ATTRIBUTE);
            if (maxThreadsStr != null) {
                try {
                    int maxThreads = Integer.parseInt(maxThreadsStr);
                    this.semaphore = new MemorySemaphore();
                    this.semaphore.setResourceCapacity(maxThreads);
                    this.semaphore.accept();
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxThreads is number " + maxThreadsStr);
                }
            }
            if ((timeoutStr = MetaData.getOptionalAttribute(element, TIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.timeout = Long.parseLong(timeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("timeout is number " + timeoutStr);
                }
            }
            if ((maxWaitCountStr = MetaData.getOptionalAttribute(element, MAX_WAIT_THREADS_ATTRIBUTE)) != null) {
                try {
                    this.maxWaitCount = Integer.parseInt(maxWaitCountStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxWaitThreads is number " + maxWaitCountStr);
                }
            }
            if ((forceFreeTimeoutStr = MetaData.getOptionalAttribute(element, FORCE_FREE_TIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.forceFreeTimeout = Long.parseLong(forceFreeTimeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("forceFreeTimeout is number " + forceFreeTimeoutStr);
                }
            }
            if ((transactionStr = MetaData.getOptionalAttribute(element, TRANSACTION_ATTRIBUTE)) != null) {
                if (REQUIRED.equals(transactionStr)) {
                    this.transactionType = 0;
                } else if (REQUIRESNEW.equals(transactionStr)) {
                    this.transactionType = 1;
                } else if (SUPPORTS.equals(transactionStr)) {
                    this.transactionType = 2;
                } else if (MANDATORY.equals(transactionStr)) {
                    this.transactionType = 3;
                } else if (NEVER.equals(transactionStr)) {
                    this.transactionType = 4;
                } else if (NOT_SUPPORTED.equals(transactionStr)) {
                    this.transactionType = 5;
                } else {
                    throw new InvalidConfigurationException("Invalid transaction : " + transactionStr);
                }
                if (this.transactionType != 2) {
                    try {
                        InitialContext context = new InitialContext();
                        this.tranManager = (TransactionManager)context.lookup(this.getTransactionManagerJndiName());
                    }
                    catch (NamingException e) {
                        throw new DeploymentException(e);
                    }
                }
            }
            if ((transactionTimeoutStr = MetaData.getOptionalAttribute(element, TRANTIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.transactionTimeout = Integer.parseInt(transactionTimeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("trantimeout is number " + transactionTimeoutStr);
                }
            }
            if ((journalStr = MetaData.getOptionalAttribute(element, JOURNAL_ATTRIBUTE)) != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            if ((suspendStr = MetaData.getOptionalAttribute(element, SUSPEND_ATTRIBUTE)) != null) {
                this.isSuspend = Boolean.valueOf(suspendStr);
            }
            if ((stopStr = MetaData.getOptionalAttribute(element, STOP_ATTRIBUTE)) != null) {
                this.isStop = Boolean.valueOf(stopStr);
            }
            Iterator aliasElements = MetaData.getChildrenByTagName(element, ALIAS_ELEMENT);
            while (aliasElements.hasNext()) {
                this.aliasNames.add(MetaData.getUniqueAttribute((Element)aliasElements.next(), NAME_ATTRIBUTE));
            }
            ServiceNameEditor editor = new ServiceNameEditor();
            Iterator resourceElements = MetaData.getChildrenByTagName(element, RESOURCE_ELEMENT);
            while (resourceElements.hasNext()) {
                Element resourceElement = (Element)resourceElements.next();
                String name = MetaData.getUniqueAttribute(resourceElement, NAME_ATTRIBUTE);
                String key = MetaData.getOptionalAttribute(resourceElement, KEY_ATTRIBUTE);
                String serviceNameStr = MetaData.getUniqueAttribute(resourceElement, SERVICE_ATTRIBUTE);
                editor.setAsText(serviceNameStr);
                ServiceName serviceName = (ServiceName)editor.getValue();
                boolean isTranControl = MetaData.getOptionalBooleanAttribute(resourceElement, TRANCONTROL_ATTRIBUTE);
                boolean isTranClose = MetaData.getOptionalBooleanAttribute(resourceElement, TRANCLOSE_ATTRIBUTE, true);
                ResourceInfo resourceInfo = new ResourceInfo();
                resourceInfo.name = name;
                resourceInfo.key = key;
                resourceInfo.serviceName = serviceName;
                resourceInfo.isTranControl = isTranControl;
                resourceInfo.isTranClose = isTranClose;
                if (this.resources == null) {
                    this.resources = new HashMap();
                }
                this.resources.put(name, resourceInfo);
            }
            Iterator catchElements = MetaData.getChildrenByTagName(element, CATCH_ELEMENT);
            while (catchElements.hasNext()) {
                Element catchElement = (Element)catchElements.next();
                step = new CatchMetaData(this);
                ((CatchMetaData)step).importXML(catchElement);
                if (this.catchSteps == null) {
                    this.catchSteps = new ArrayList();
                }
                this.catchSteps.add(step);
            }
            Element finallyElement = MetaData.getOptionalChild(element, FINALLY_ELEMENT);
            if (finallyElement != null) {
                step = new FinallyMetaData(this);
                ((FinallyMetaData)step).importXML(finallyElement);
                this.finallyStep = step;
            }
            Iterator children = MetaData.getChildrenWithoutTagName(element, new String[]{ALIAS_ELEMENT, RESOURCE_ELEMENT, CATCH_ELEMENT, FINALLY_ELEMENT});
            boolean isReturn = false;
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step2 = new StepMetaData(this);
                    step2.importXML(currentElement);
                    stepObj = step2;
                } else if (CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData(this);
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData(this);
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData(this);
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (WHILE_ELEMENT.equals(tagName)) {
                    WhileMetaData whileData = new WhileMetaData(this);
                    whileData.importXML(currentElement);
                    stepObj = whileData;
                } else if (RETURN_ELEMENT.equals(tagName)) {
                    ReturnMetaData returnData = new ReturnMetaData(this);
                    returnData.importXML(currentElement);
                    stepObj = returnData;
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of flow tag : " + tagName);
                }
                if (stepObj == null) continue;
                if (this.jobSteps == null) {
                    this.jobSteps = new ArrayList();
                }
                this.jobSteps.add(stepObj);
            }
        }
        catch (DeploymentException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    public String getFlowName() {
        return this.flowName;
    }

    public List getAiliasFlowNames() {
        return this.aliasNames;
    }

    public BeanFlowMonitor createMonitor() {
        return new BeanFlowMonitor(this.flowName);
    }

    public Object invokeFlow(Object input) throws Exception {
        return this.invokeFlow(input, null);
    }

    public Object invokeFlow(Object input, BeanFlowMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new BeanFlowMonitor();
        }
        if (monitor.getCurrentFlowName() == null) {
            monitor.setFlowName(this.flowName);
        }
        monitor.setCurrentFlowName(this.flowName);
        TransactionInfo info = (TransactionInfo)transaction.get();
        return this.invokeFlowWithTransaction(input, monitor, info.transactionType >= 0 ? info.transactionType : this.transactionType, info.transactionTimeout > 0 ? info.transactionTimeout : this.transactionTimeout, info.tranManager != null ? info.tranManager : this.tranManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeFlowWithTransaction(Object input, BeanFlowMonitor monitor, int transactionType, int transactionTimeout, TransactionManager tranManager) throws Exception {
        monitor.setStartTime(System.currentTimeMillis());
        try {
            Object result = null;
            Transaction oldTransaction = tranManager == null ? null : tranManager.getTransaction();
            Transaction newTransaction = null;
            switch (transactionType) {
                case 0: {
                    if (transactionTimeout != -1 && oldTransaction == null) {
                        tranManager.setTransactionTimeout(transactionTimeout);
                    }
                    if (oldTransaction == null) {
                        tranManager.begin();
                        newTransaction = tranManager.getTransaction();
                    }
                    try {
                        result = this.invokeFlowInternal(input, monitor, false);
                    }
                    catch (Exception e) {
                        if (newTransaction != null) {
                            tranManager.rollback();
                        }
                        throw e;
                    }
                    catch (Error err) {
                        if (newTransaction != null) {
                            tranManager.rollback();
                        }
                        throw err;
                    }
                    if (newTransaction == null) break;
                    tranManager.commit();
                    break;
                }
                case 1: {
                    tranManager.suspend();
                    try {
                        if (transactionTimeout != -1) {
                            tranManager.setTransactionTimeout(transactionTimeout);
                        }
                        tranManager.begin();
                        newTransaction = tranManager.getTransaction();
                        try {
                            result = this.invokeFlowInternal(input, monitor, false);
                        }
                        catch (Exception e) {
                            tranManager.rollback();
                            throw e;
                        }
                        catch (Error err) {
                            tranManager.rollback();
                            throw err;
                        }
                        tranManager.commit();
                        break;
                    }
                    finally {
                        if (oldTransaction != null) {
                            tranManager.resume(oldTransaction);
                        }
                    }
                }
                case 5: {
                    tranManager.suspend();
                    try {
                        result = this.invokeFlowInternal(input, monitor, false);
                        break;
                    }
                    finally {
                        if (oldTransaction != null) {
                            tranManager.resume(oldTransaction);
                        }
                    }
                }
                case 3: {
                    if (oldTransaction == null) {
                        throw new BeanControlUncheckedException((Throwable)new TransactionRequiredException("Require transaction. flowName=" + this.flowName));
                    }
                    result = this.invokeFlowInternal(input, monitor, false);
                    break;
                }
                case 4: {
                    if (oldTransaction != null) {
                        throw new BeanControlUncheckedException("Must not allow transaction. flowName=" + this.flowName);
                    }
                    result = this.invokeFlowInternal(input, monitor, true);
                    break;
                }
                default: {
                    result = this.invokeFlowInternal(input, monitor, true);
                }
            }
            return result;
        }
        catch (HeuristicMixedException e) {
            throw new BeanControlUncheckedException("flowName=" + this.flowName, e);
        }
        catch (HeuristicRollbackException e) {
            throw new BeanControlUncheckedException("flowName=" + this.flowName, e);
        }
        catch (NotSupportedException e) {
            throw new BeanControlUncheckedException("flowName=" + this.flowName, e);
        }
        catch (RollbackException e) {
            throw new BeanControlUncheckedException("flowName=" + this.flowName, e);
        }
        catch (InvalidTransactionException e) {
            throw new BeanControlUncheckedException("flowName=" + this.flowName, e);
        }
        catch (SystemException e) {
            throw new BeanControlUncheckedException("flowName=" + this.flowName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object invokeFlowInternal(Object input, BeanFlowMonitor monitor, boolean isTranControl) throws Exception {
        if (this.factoryCallBack.isManageExecBeanFlow()) {
            this.factoryCallBack.addExcecFlow(monitor);
        }
        FlowContext flowContext = null;
        Journal journal = this.isJournal ? this.factoryCallBack.getJournal() : null;
        try {
            try {
                block44: {
                    Throwable throwable;
                    ResourceManager rm;
                    block43: {
                        if (this.semaphore != null && !this.semaphore.getResource(this.timeout, this.maxWaitCount, this.forceFreeTimeout)) {
                            throw new UnavailableFlowException(this.flowName);
                        }
                        if (journal != null) {
                            String requestId;
                            journal.startJournal(JOURNAL_KEY_FLOW, this.factoryCallBack.getEditorFinder());
                            Context threadContext = this.factoryCallBack.getThreadContext();
                            if (threadContext != null && (requestId = (String)threadContext.get("REQUEST_ID")) != null) {
                                journal.setRequestId(requestId);
                            }
                            journal.addInfo("Name", this.flowName);
                            journal.addInfo(JOURNAL_KEY_FLOW_INPUT, input);
                        }
                        rm = this.factoryCallBack.createResourceManager();
                        if (this.resources != null) {
                            Iterator ite = this.resources.keySet().iterator();
                            while (ite.hasNext()) {
                                String name = (String)ite.next();
                                ResourceInfo resourceInfo = (ResourceInfo)this.resources.get(name);
                                rm.addResource(name, resourceInfo.key, resourceInfo.serviceName, isTranControl ? resourceInfo.isTranControl : false, resourceInfo.isTranClose);
                                if (journal == null) continue;
                                journal.addInfo(JOURNAL_KEY_RESOURCE, name);
                            }
                        }
                        flowContext = new FlowContext(input, rm, monitor);
                        throwable = null;
                        if (this.jobSteps != null) {
                            Step jobStep;
                            StepContext stepContext;
                            int max = this.jobSteps.size();
                            for (int i = 0; i < max && (stepContext = (jobStep = (Step)this.jobSteps.get(i)).invokeStep(flowContext)) != null; ++i) {
                            }
                        }
                        Object var15_23 = null;
                        if (this.finallyStep == null) break block43;
                        try {
                            this.finallyStep.invokeStep(flowContext);
                        }
                        catch (Throwable th2) {
                            throwable = th2;
                            this.endJob(th2, rm, monitor, this.flowName);
                            this.throwException(th2);
                        }
                    }
                    this.endJob(throwable, rm, monitor, this.flowName);
                    {
                        break block44;
                        catch (UnavailableFlowException e) {
                            throwable = e;
                            throw e;
                        }
                        catch (BeanFlowMonitorStopException e) {
                            throwable = e;
                            throw e;
                        }
                        catch (Exception e) {
                            Throwable th = e;
                            if (e instanceof InvocationTargetException) {
                                th = ((InvocationTargetException)e).getTargetException();
                            } else if (e instanceof BeanControlUncheckedException) {
                                th = ((BeanControlUncheckedException)e).getCause();
                            }
                            boolean isCatch = false;
                            if (this.catchSteps != null && th instanceof Exception) {
                                try {
                                    int imax = this.catchSteps.size();
                                    for (int i = 0; i < imax; ++i) {
                                        CatchMetaData catchStep = (CatchMetaData)this.catchSteps.get(i);
                                        if (!catchStep.isMatch(flowContext, (Exception)th)) continue;
                                        catchStep.invokeStep(flowContext);
                                        isCatch = true;
                                        break;
                                    }
                                }
                                catch (Throwable th2) {
                                    throwable = th2;
                                    this.throwException(th2);
                                }
                            }
                            if (!isCatch) {
                                throwable = th;
                                this.throwException(th);
                            }
                            Object var15_24 = null;
                            if (this.finallyStep != null) {
                                try {
                                    this.finallyStep.invokeStep(flowContext);
                                }
                                catch (Throwable th2) {
                                    throwable = th2;
                                    this.endJob(th2, rm, monitor, this.flowName);
                                    this.throwException(th2);
                                }
                            }
                            this.endJob(throwable, rm, monitor, this.flowName);
                            break block44;
                        }
                        catch (Error e) {
                            throwable = e;
                            throw e;
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var15_25 = null;
                        if (this.finallyStep != null) {
                            try {
                                this.finallyStep.invokeStep(flowContext);
                            }
                            catch (Throwable th2) {
                                throwable = th2;
                                this.endJob(th2, rm, monitor, this.flowName);
                                this.throwException(th2);
                            }
                        }
                        this.endJob(throwable, rm, monitor, this.flowName);
                        throw throwable2;
                    }
                }
                Object var18_32 = null;
                if (journal != null) {
                    journal.addInfo(JOURNAL_KEY_FLOW_OUTPUT, flowContext == null ? null : (flowContext.current == null ? null : flowContext.current.result));
                    journal.endJournal();
                }
                if (this.semaphore != null) {
                    this.semaphore.freeResource();
                }
            }
            catch (Throwable th) {
                if (journal != null) {
                    Throwable th2 = th;
                    if (th2 instanceof InvocationTargetException) {
                        th2 = ((InvocationTargetException)th2).getTargetException();
                    } else if (th2 instanceof BeanControlUncheckedException) {
                        th2 = ((BeanControlUncheckedException)th2).getCause();
                    }
                    journal.addInfo("Exception", th2);
                }
                this.throwException(th);
                Object var18_33 = null;
                if (journal != null) {
                    journal.addInfo(JOURNAL_KEY_FLOW_OUTPUT, flowContext == null ? null : (flowContext.current == null ? null : flowContext.current.result));
                    journal.endJournal();
                }
                if (this.semaphore != null) {
                    this.semaphore.freeResource();
                }
            }
        }
        catch (Throwable throwable) {
            Object var18_34 = null;
            if (journal != null) {
                journal.addInfo(JOURNAL_KEY_FLOW_OUTPUT, flowContext == null ? null : (flowContext.current == null ? null : flowContext.current.result));
                journal.endJournal();
            }
            if (this.semaphore != null) {
                this.semaphore.freeResource();
            }
            throw throwable;
        }
        return flowContext.current == null ? null : flowContext.current.result;
    }

    protected void throwException(Throwable th) throws Exception {
        if (th instanceof InvocationTargetException) {
            th = ((InvocationTargetException)th).getTargetException();
        }
        if (th instanceof BeanControlUncheckedException) {
            throw (BeanControlUncheckedException)th;
        }
        if (th instanceof UnavailableFlowException) {
            throw (UnavailableFlowException)th;
        }
        if (th instanceof BeanFlowMonitorStopException) {
            ((BeanFlowMonitorStopException)th).setFlowName(this.flowName);
            throw (BeanFlowMonitorStopException)th;
        }
        if (th instanceof RuntimeException) {
            throw new BeanControlUncheckedException("Target Error occured. flowName=" + this.flowName, th);
        }
        if (th instanceof Exception) {
            throw (Exception)th;
        }
        throw (Error)th;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endJob(Throwable e, ResourceManager rm, BeanFlowMonitor monitor, String name) {
        try {
            if (e == null) {
                rm.commitAllResources();
            } else {
                rm.rollbbackAllResources();
            }
            Object var6_5 = null;
            monitor.end();
            if (this.factoryCallBack.isManageExecBeanFlow()) {
                this.factoryCallBack.removeExecFlow(monitor);
            }
            rm.terminateResourceManager();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            monitor.end();
            if (this.factoryCallBack.isManageExecBeanFlow()) {
                this.factoryCallBack.removeExecFlow(monitor);
            }
            rm.terminateResourceManager();
            throw throwable;
        }
    }

    protected String getTransactionManagerJndiName() {
        return TRANSACTION_MANAGER_JNDI_NAME;
    }

    private String replaceProperty(String textValue) {
        textValue = Utility.replaceServiceLoderConfig(textValue, this.factoryCallBack.getServiceLoader().getConfig());
        textValue = Utility.replaceManagerProperty(this.factoryCallBack.getServiceManager(), textValue);
        textValue = Utility.replaceSystemProperty(textValue);
        textValue = Utility.replaceServerProperty(textValue);
        return textValue;
    }

    private static Class convertStringToClass(String typeStr) throws ClassNotFoundException {
        Class<Comparable<Byte>> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else if (Boolean.TYPE.getName().equals(typeStr)) {
                type = Boolean.TYPE;
            } else if (typeStr.endsWith(ARRAY_CLASS_SUFFIX) && typeStr.length() > 2) {
                Class elementType = BeanFlowInvokerAccessImpl2.convertStringToClass(typeStr.substring(0, typeStr.length() - 2));
                type = Array.newInstance(elementType, 0).getClass();
            } else {
                type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
            }
        }
        return type;
    }

    private static boolean isNarrowCast(Class from, Class to) {
        if (from == null || to == null || !Number.class.isAssignableFrom(from) || !Number.class.isAssignableFrom(to) && (!to.isPrimitive() || to.equals(Boolean.TYPE)) || from.equals(to)) {
            return false;
        }
        if (Byte.class.equals(from) && !Byte.TYPE.equals(to)) {
            return true;
        }
        if (Short.class.equals(from) && !Short.TYPE.equals(to) && (Byte.TYPE.equals(to) || Byte.class.equals(to))) {
            return true;
        }
        if (Integer.class.equals(from) && !Integer.TYPE.equals(to) && (Short.TYPE.equals(to) || Short.class.equals(to) || Byte.TYPE.equals(to) || Byte.class.equals(to))) {
            return true;
        }
        if (Long.class.equals(from) && !Long.TYPE.equals(to) && (Integer.TYPE.equals(to) || Integer.class.equals(to) || Short.TYPE.equals(to) || Short.class.equals(to) || Byte.TYPE.equals(to) || Byte.class.equals(to))) {
            return true;
        }
        if (Float.class.equals(from) && !Float.TYPE.equals(to) && (Long.TYPE.equals(to) || Long.class.equals(to) || Integer.TYPE.equals(to) || Integer.class.equals(to) || Short.TYPE.equals(to) || Short.class.equals(to) || Byte.TYPE.equals(to) || Byte.class.equals(to))) {
            return true;
        }
        if (Double.class.equals(from) && !Double.TYPE.equals(to) && (Float.TYPE.equals(to) || Float.class.equals(to) || Long.TYPE.equals(to) || Long.class.equals(to) || Integer.TYPE.equals(to) || Integer.class.equals(to) || Short.TYPE.equals(to) || Short.class.equals(to) || Byte.TYPE.equals(to) || Byte.class.equals(to))) {
            return true;
        }
        if (BigInteger.class.equals(from) && !Double.TYPE.equals(to) && (Double.class.equals(to) || Float.TYPE.equals(to) || Float.class.equals(to) || Long.TYPE.equals(to) || Long.class.equals(to) || Integer.TYPE.equals(to) || Integer.class.equals(to) || Short.TYPE.equals(to) || Short.class.equals(to) || Byte.TYPE.equals(to) || Byte.class.equals(to))) {
            return true;
        }
        return BigDecimal.class.equals(from) && !BigInteger.class.equals(to) && (Double.TYPE.equals(to) || Double.class.equals(to) || Float.TYPE.equals(to) || Float.class.equals(to) || Long.TYPE.equals(to) || Long.class.equals(to) || Integer.TYPE.equals(to) || Integer.class.equals(to) || Short.TYPE.equals(to) || Short.class.equals(to) || Byte.TYPE.equals(to) || Byte.class.equals(to));
    }

    private static Number castPrimitiveWrapper(Class clazz, Number val) {
        if (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz)) {
            return new Byte(val.byteValue());
        }
        if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            return new Short(val.shortValue());
        }
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            return new Integer(val.intValue());
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return new Long(val.longValue());
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return new Float(val.floatValue());
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return new Double(val.doubleValue());
        }
        if (BigInteger.class.equals(clazz)) {
            return BigInteger.valueOf(val.longValue());
        }
        if (BigDecimal.class.equals(clazz)) {
            if (val instanceof BigInteger) {
                return new BigDecimal((BigInteger)val);
            }
            return new BigDecimal(val.doubleValue());
        }
        return val;
    }

    private Journal getJournal(MetaData data) {
        if (!this.isJournal) {
            return null;
        }
        if (data instanceof Journaling && !((Journaling)((Object)data)).isJournal()) {
            return null;
        }
        MetaData parent = data;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof Journaling) || ((Journaling)((Object)parent)).isJournal()) continue;
            return null;
        }
        return this.factoryCallBack.getJournal();
    }

    static {
        NimbusEntityResolver.registerDTD("-//Nimbus//DTD Nimbus Bean Flow 1.0//JA", "jp/ossc/nimbus/service/beancontrol/beanflow_1_0.dtd");
        transaction = new ThreadLocal(){

            protected Object initialValue() {
                return new TransactionInfo();
            }
        };
    }

    private static class TransactionInfo
    implements Serializable {
        private static final long serialVersionUID = 5508331194991502653L;
        public int transactionType = -1;
        public int transactionTimeout = -1;
        public TransactionManager tranManager;

        private TransactionInfo() {
        }

        public void clear() {
            this.transactionType = -1;
            this.transactionTimeout = -1;
            this.tranManager = null;
        }
    }

    private static class Test
    implements Serializable {
        private static final long serialVersionUID = 5508331194991502652L;
        private transient List properties;
        private transient Expression expression;
        private transient List keyList;
        private String condStr;
        private boolean nullCheck = false;
        private static final String INPUT = "input";
        private static final String THIS = "this";
        private static final String VAR = "var";
        private static final String TARGET = "target";
        private static final String RESULT = "result";
        private static final String DELIMITER = "@";

        public Test(String cond, boolean nullCheck) throws Exception {
            this.nullCheck = nullCheck;
            this.initCondition(cond);
        }

        private void initCondition(String cond) throws Exception {
            this.condStr = cond;
            this.keyList = new ArrayList();
            this.properties = new ArrayList();
            StringTokenizer token = new StringTokenizer(cond, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null && !DELIMITER.equals(beforeToken)) {
                        String tmpKey = "_evaluatectgyserv" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        if (!(beforeToken.startsWith("input") || beforeToken.startsWith("var") || beforeToken.startsWith("this"))) {
                            int index = 0;
                            int dotIndex = beforeToken.indexOf(46);
                            int braket1Index = beforeToken.indexOf(40);
                            int braket2Index = beforeToken.indexOf(91);
                            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                                beforeToken = beforeToken + '.' + "result";
                            } else {
                                String tmp;
                                if (dotIndex == beforeToken.length() - 1 || braket1Index == beforeToken.length() - 1 || braket2Index == beforeToken.length() - 1) {
                                    throw new DeploymentException("Invalid key of test : " + beforeToken);
                                }
                                index = dotIndex;
                                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                                    index = braket1Index;
                                }
                                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                                    index = braket2Index;
                                }
                                if (!((tmp = beforeToken.substring(index + 1)).startsWith("target") || tmp.startsWith("target.") || tmp.startsWith("target(") || tmp.startsWith("target[") || tmp.startsWith("result") || tmp.startsWith("result.") || tmp.startsWith("result(") || tmp.startsWith("result["))) {
                                    beforeToken = beforeToken.substring(0, index) + '.' + "result" + beforeToken.substring(index);
                                }
                            }
                        }
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            if (this.keyList.size() == 0) {
                throw new IllegalArgumentException(cond);
            }
            this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
            this.evaluate("", true);
        }

        public boolean evaluate(Object object) throws Exception {
            return this.evaluate(object, false);
        }

        protected boolean evaluate(Object object, boolean isTest) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            int size = this.keyList.size();
            for (int i = 0; i < size; ++i) {
                Object val;
                String keyString;
                block18: {
                    keyString = (String)this.keyList.get(i);
                    Property property = (Property)this.properties.get(i);
                    val = null;
                    try {
                        if (property instanceof NestedProperty) {
                            NestedProperty nestedProp = (NestedProperty)property;
                            Property thisProp = nestedProp.getFirstThisProperty();
                            val = thisProp.getProperty(object);
                            if (val != null) {
                                val = nestedProp.getProperty(object);
                            }
                        } else {
                            val = property.getProperty(object);
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable th = e.getCause();
                        if (th == null) {
                            throw e;
                        }
                        if (th instanceof Exception) {
                            throw (Exception)th;
                        }
                        if (th instanceof Error) {
                            throw (Error)th;
                        }
                        throw e;
                    }
                    catch (NullIndexPropertyException e) {
                        if (!isTest && this.nullCheck) {
                            throw e;
                        }
                    }
                    catch (NullKeyPropertyException e) {
                        if (!isTest && this.nullCheck) {
                            throw e;
                        }
                    }
                    catch (NullNestPropertyException e) {
                        if (!isTest && this.nullCheck) {
                            throw e;
                        }
                    }
                    catch (NoSuchPropertyException e) {
                        if (isTest) break block18;
                        throw e;
                    }
                }
                jexlContext.getVars().put(keyString, val);
            }
            Object exp = this.expression.evaluate(jexlContext);
            if (exp instanceof Boolean) {
                return (Boolean)exp;
            }
            if (exp == null && isTest) {
                return true;
            }
            throw new IllegalArgumentException("expression is not boolean : " + this.expression.getExpression());
        }

        public String toString() {
            return this.condStr;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            try {
                this.initCondition(this.condStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class StepContext
    implements Serializable {
        private static final long serialVersionUID = 5508331194991502651L;
        public Object target;
        public Object result;
        public boolean isContinue = false;
        public boolean isBreak = false;

        public Object getTarget() {
            return this.target;
        }

        public Object getResult() {
            return this.result;
        }
    }

    public static class FlowContext
    extends HashMap {
        private static final long serialVersionUID = -5942654431725540562L;
        public Object input;
        public ResourceManager resourceManager;
        public BeanFlowMonitor monitor;
        public StepContext current;
        private Map vars;

        public FlowContext(Object in, ResourceManager rm, BeanFlowMonitor monitor) {
            this.input = in;
            this.resourceManager = rm;
            this.monitor = monitor;
        }

        public Object getThis() {
            return this.current == null ? null : this.current.target;
        }

        public Object getInput() {
            return this.input;
        }

        public Object getVar(String name) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(name);
        }

        public void setVar(String name, Object var) {
            if (this.vars == null) {
                this.vars = new HashMap();
            }
            this.vars.put(name, var);
        }
    }

    private class ExpressionMetaData
    extends MetaData
    implements ReturnValue {
        private static final long serialVersionUID = -7154397109317362889L;
        private static final String INPUT = "input";
        private static final String THIS = "this";
        private static final String VAR = "var";
        private static final String TARGET = "target";
        private static final String RESULT = "result";
        private static final String DELIMITER = "@";
        private List properties;
        private Expression expression;
        private List keyList;
        private boolean nullCheck;

        public void importXML(Element element) throws DeploymentException {
            String nullCheckAttribute = ExpressionMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE);
            if (nullCheckAttribute != null) {
                this.nullCheck = Boolean.valueOf(nullCheckAttribute);
            }
            this.importString(ExpressionMetaData.getElementContent(element));
        }

        public void importString(String condStr) throws DeploymentException {
            if (condStr == null || condStr.length() == 0) {
                throw new DeploymentException("Content of expression is null.");
            }
            StringTokenizer token = new StringTokenizer(condStr, DELIMITER, true);
            boolean keyFlg = false;
            String beforeToken = null;
            StringBuffer condBuf = new StringBuffer();
            while (token.hasMoreTokens()) {
                String str = token.nextToken();
                if (!keyFlg) {
                    if (DELIMITER.equals(str)) {
                        keyFlg = true;
                    } else {
                        condBuf.append(str);
                    }
                } else if (DELIMITER.equals(str)) {
                    keyFlg = false;
                    if (beforeToken != null && !DELIMITER.equals(beforeToken)) {
                        if (this.keyList == null) {
                            this.keyList = new ArrayList();
                        }
                        String tmpKey = "_expressionParam" + this.keyList.size();
                        this.keyList.add(tmpKey);
                        condBuf.append(tmpKey);
                        if (!(beforeToken.startsWith("input") || beforeToken.startsWith("var") || beforeToken.startsWith("this"))) {
                            int index = 0;
                            int dotIndex = beforeToken.indexOf(46);
                            int braket1Index = beforeToken.indexOf(40);
                            int braket2Index = beforeToken.indexOf(91);
                            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                                beforeToken = beforeToken + '.' + "result";
                            } else {
                                String tmp;
                                if (dotIndex == beforeToken.length() - 1 || braket1Index == beforeToken.length() - 1 || braket2Index == beforeToken.length() - 1) {
                                    throw new DeploymentException("Invalid key of test : " + beforeToken);
                                }
                                index = dotIndex;
                                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                                    index = braket1Index;
                                }
                                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                                    index = braket2Index;
                                }
                                if (!((tmp = beforeToken.substring(index + 1)).startsWith("target") || tmp.startsWith("target.") || tmp.startsWith("target(") || tmp.startsWith("target[") || tmp.startsWith("result") || tmp.startsWith("result.") || tmp.startsWith("result(") || tmp.startsWith("result["))) {
                                    beforeToken = beforeToken.substring(0, index) + '.' + "result" + beforeToken.substring(index);
                                }
                            }
                        }
                        if (this.properties == null) {
                            this.properties = new ArrayList();
                        }
                        this.properties.add(PropertyFactory.createProperty(beforeToken));
                    } else {
                        condBuf.append(str);
                    }
                }
                beforeToken = str;
            }
            try {
                this.expression = ExpressionFactory.createExpression((String)condBuf.toString());
                this.getValueInternal("");
            }
            catch (NoSuchPropertyException e) {
            }
            catch (Exception e) {
                throw new DeploymentException("Illegal expression : " + condStr, e);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            return this.getValueInternal(context);
        }

        protected Object getValueInternal(Object object) throws Exception {
            JexlContext jexlContext = JexlHelper.createContext();
            if (this.keyList != null) {
                int size = this.keyList.size();
                for (int i = 0; i < size; ++i) {
                    String keyString = (String)this.keyList.get(i);
                    Property property = (Property)this.properties.get(i);
                    Object val = null;
                    try {
                        if (property instanceof NestedProperty) {
                            NestedProperty nestedProp = (NestedProperty)property;
                            Property thisProp = nestedProp.getFirstThisProperty();
                            val = thisProp.getProperty(object);
                            if (val != null) {
                                val = nestedProp.getProperty(object);
                            }
                        } else {
                            val = property.getProperty(object);
                        }
                    }
                    catch (NullIndexPropertyException e) {
                        if (this.nullCheck) {
                            throw e;
                        }
                    }
                    catch (NullKeyPropertyException e) {
                        if (this.nullCheck) {
                            throw e;
                        }
                    }
                    catch (NullNestPropertyException e) {
                        if (this.nullCheck) {
                            throw e;
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable th = e.getCause();
                        if (th == null) {
                            throw e;
                        }
                        if (th instanceof Exception) {
                            throw (Exception)th;
                        }
                        if (th instanceof Error) {
                            throw (Error)th;
                        }
                        throw e;
                    }
                    jexlContext.getVars().put(keyString, val);
                }
            }
            return this.expression.evaluate(jexlContext);
        }
    }

    private static class ContinueMetaData
    extends MetaData
    implements Step {
        private static final long serialVersionUID = 5508331194991502650L;

        public void importXML(Element element) throws DeploymentException {
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext = context.current;
            if (stepContext == null) {
                stepContext = new StepContext();
            }
            stepContext.isContinue = true;
            return stepContext;
        }
    }

    private static class BreakMetaData
    extends MetaData
    implements Step {
        private static final long serialVersionUID = 7546910423657644942L;

        public void importXML(Element element) throws DeploymentException {
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext = context.current;
            if (stepContext == null) {
                stepContext = new StepContext();
            }
            stepContext.isBreak = true;
            return stepContext;
        }
    }

    private class ReturnMetaData
    extends MetaData
    implements Step {
        private static final long serialVersionUID = -714587366723247275L;
        private Object retValue;

        public ReturnMetaData(MetaData parent) {
            super(parent);
        }

        public void importXML(Element element) throws DeploymentException {
            Element retElement = MetaData.getOptionalChild(element);
            if (retElement == null) {
                this.retValue = ReturnMetaData.getElementContent(element);
            } else {
                String tagName = retElement.getTagName();
                MetaData targetData = null;
                if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName)) {
                    targetData = new InputMetaData();
                    targetData.importXML(retElement);
                } else if ("object".equals(tagName)) {
                    targetData = new ObjectMetaData(this);
                    targetData.importXML(retElement);
                } else if ("service-ref".equals(tagName)) {
                    targetData = new ServiceRefMetaData(this);
                    targetData.importXML(retElement);
                } else if ("static-invoke".equals(tagName)) {
                    targetData = new StaticInvokeMetaData(this);
                    targetData.importXML(retElement);
                } else if ("static-field-ref".equals(tagName)) {
                    targetData = new StaticFieldRefMetaData(this);
                    targetData.importXML(retElement);
                } else if (BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT.equals(tagName)) {
                    targetData = new ResourceRefMetaData();
                    targetData.importXML(retElement);
                } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                    targetData = new StepRefMetaData();
                    targetData.importXML(retElement);
                } else if ("var".equals(tagName)) {
                    targetData = new VarMetaData();
                    targetData.importXML(retElement);
                } else if (BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT.equals(tagName)) {
                    targetData = new ExpressionMetaData();
                    targetData.importXML(retElement);
                } else {
                    throw new DeploymentException("Invalid child tag of result tag : " + tagName);
                }
                this.retValue = targetData;
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            if (this.retValue != null) {
                Object ret;
                Object object = ret = this.retValue instanceof ReturnValue ? ((ReturnValue)this.retValue).getValue(context) : this.retValue;
                if (ret != null) {
                    if (context.current == null) {
                        context.current = new StepContext();
                    }
                    context.current.result = ret;
                }
            }
            return null;
        }
    }

    private class ThrowMetaData
    extends MetaData
    implements Step {
        private static final long serialVersionUID = 6963691939437133793L;
        private String varName;
        private ReturnValue throwValue;

        public void importXML(Element element) throws DeploymentException {
            this.varName = ThrowMetaData.getOptionalAttribute(element, "var");
            if (this.varName == null) {
                Element throwElement = MetaData.getUniqueChild(element);
                String tagName = throwElement.getTagName();
                MetaData targetData = null;
                if ("object".equals(tagName)) {
                    targetData = new ObjectMetaData(this);
                    targetData.importXML(throwElement);
                } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                    targetData = new StepRefMetaData();
                    targetData.importXML(throwElement);
                } else if ("var".equals(tagName)) {
                    targetData = new VarMetaData();
                    targetData.importXML(throwElement);
                } else {
                    throw new DeploymentException("Invalid child tag of result tag : " + tagName);
                }
                this.throwValue = (ReturnValue)((Object)targetData);
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            if (this.varName != null) {
                throw (Exception)context.getVar(this.varName);
            }
            throw (Exception)this.throwValue.getValue(context);
        }
    }

    private class FinallyMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = -81748614779496143L;
        private List steps;
        private boolean isJournal;

        public FinallyMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            boolean isReturn = false;
            Iterator children = FinallyMetaData.getChildren(element);
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData(this);
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData(this);
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData(this);
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (BeanFlowInvokerAccessImpl2.WHILE_ELEMENT.equals(tagName)) {
                    WhileMetaData whileData = new WhileMetaData(this);
                    whileData.importXML(currentElement);
                    stepObj = whileData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData(this);
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.BREAK_ELEMENT.equals(tagName)) {
                    BreakMetaData breakData = new BreakMetaData();
                    breakData.importXML(currentElement);
                    stepObj = breakData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.CONTINUE_ELEMENT.equals(tagName)) {
                    ContinueMetaData continueData = new ContinueMetaData();
                    continueData.importXML(currentElement);
                    stepObj = continueData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.RETURN_ELEMENT.equals(tagName)) {
                    ReturnMetaData returnData = new ReturnMetaData(this);
                    returnData.importXML(currentElement);
                    stepObj = returnData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.THROW_ELEMENT.equals(tagName)) {
                    ThrowMetaData throwData = new ThrowMetaData();
                    throwData.importXML(currentElement);
                    stepObj = throwData;
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                this.steps.add(stepObj);
            }
            if (this.steps == null) {
                throw new DeploymentException("if body is empty.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
            StepContext inStepContext = context.current;
            StepContext stepContext = null;
            try {
                if (journal != null) {
                    journal.addStartStep(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_FINALLY, BeanFlowInvokerAccessImpl2.this.factoryCallBack.getEditorFinder());
                }
                Iterator itr = this.steps.iterator();
                while (itr.hasNext()) {
                    Step step = (Step)itr.next();
                    stepContext = step.invokeStep(context);
                    if (stepContext == null) {
                        StepContext stepContext2 = null;
                        return stepContext2;
                    }
                    if (!stepContext.isContinue && !stepContext.isBreak) continue;
                    StepContext stepContext3 = stepContext;
                    return stepContext3;
                }
                context.current = inStepContext;
            }
            finally {
                if (journal != null) {
                    journal.addEndStep();
                }
            }
            return inStepContext;
        }
    }

    private class CatchMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = 2837596969479923991L;
        private Class catchExceptionClass;
        private List steps;
        private String varName;
        private boolean isJournal;

        public CatchMetaData(MetaData parent) {
            super(parent);
            this.catchExceptionClass = class$java$lang$Exception == null ? (class$java$lang$Exception = BeanFlowInvokerAccessImpl2.class$("java.lang.Exception")) : class$java$lang$Exception;
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            String exceptionAttribute = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.EXCEPTION_ATTRIBUTE);
            if (exceptionAttribute != null) {
                try {
                    this.catchExceptionClass = BeanFlowInvokerAccessImpl2.convertStringToClass(exceptionAttribute);
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentException(e);
                }
            }
            this.varName = CatchMetaData.getOptionalAttribute(element, "var");
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            boolean isReturn = false;
            Iterator children = CatchMetaData.getChildren(element);
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData(this);
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData(this);
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData(this);
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (BeanFlowInvokerAccessImpl2.WHILE_ELEMENT.equals(tagName)) {
                    WhileMetaData whileData = new WhileMetaData(this);
                    whileData.importXML(currentElement);
                    stepObj = whileData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData(this);
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.BREAK_ELEMENT.equals(tagName)) {
                    BreakMetaData breakData = new BreakMetaData();
                    breakData.importXML(currentElement);
                    stepObj = breakData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.CONTINUE_ELEMENT.equals(tagName)) {
                    ContinueMetaData continueData = new ContinueMetaData();
                    continueData.importXML(currentElement);
                    stepObj = continueData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.RETURN_ELEMENT.equals(tagName)) {
                    ReturnMetaData returnData = new ReturnMetaData(this);
                    returnData.importXML(currentElement);
                    stepObj = returnData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.THROW_ELEMENT.equals(tagName)) {
                    ThrowMetaData throwData = new ThrowMetaData();
                    throwData.importXML(currentElement);
                    stepObj = throwData;
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                this.steps.add(stepObj);
            }
        }

        public boolean isMatch(FlowContext context, Exception exception) {
            if (this.catchExceptionClass.isAssignableFrom(exception.getClass())) {
                if (this.varName != null) {
                    context.setVar(this.varName, exception);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext inStepContext;
            block9: {
                inStepContext = context.current;
                StepContext stepContext = null;
                Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
                try {
                    if (journal != null) {
                        journal.addStartStep(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_CATCH, BeanFlowInvokerAccessImpl2.this.factoryCallBack.getEditorFinder());
                        Exception exception = (Exception)context.getVar(this.varName);
                        journal.addInfo("Exception", exception);
                    }
                    if (this.steps == null) break block9;
                    Iterator itr = this.steps.iterator();
                    while (itr.hasNext()) {
                        Step step = (Step)itr.next();
                        stepContext = step.invokeStep(context);
                        if (stepContext == null) {
                            StepContext stepContext2 = null;
                            return stepContext2;
                        }
                        if (!stepContext.isContinue && !stepContext.isBreak) continue;
                        StepContext stepContext3 = stepContext;
                        return stepContext3;
                    }
                    context.current = inStepContext;
                }
                finally {
                    if (journal != null) {
                        journal.addEndStep();
                    }
                }
            }
            return inStepContext;
        }
    }

    private class IfMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = -7154397109317362880L;
        private Test test;
        private List steps;
        private boolean isJournal;

        public IfMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            String journalStr;
            String tagName = element.getTagName();
            if (!BeanFlowInvokerAccessImpl2.DEFAULT_ELEMENT.equals(tagName)) {
                String nullCheckAttribute = IfMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE);
                boolean nullCheck = false;
                if (nullCheckAttribute != null) {
                    nullCheck = Boolean.valueOf(nullCheckAttribute);
                }
                String testAttribute = IfMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.TEST_ATTRIBUTE);
                try {
                    this.test = new Test(testAttribute, nullCheck);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            if ((journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE)) != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            boolean isReturn = false;
            Iterator children = IfMetaData.getChildren(element);
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData(this);
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData(this);
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData(this);
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (BeanFlowInvokerAccessImpl2.WHILE_ELEMENT.equals(tagName)) {
                    WhileMetaData whileData = new WhileMetaData(this);
                    whileData.importXML(currentElement);
                    stepObj = whileData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData(this);
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.BREAK_ELEMENT.equals(tagName)) {
                    BreakMetaData breakData = new BreakMetaData();
                    breakData.importXML(currentElement);
                    stepObj = breakData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.CONTINUE_ELEMENT.equals(tagName)) {
                    ContinueMetaData continueData = new ContinueMetaData();
                    continueData.importXML(currentElement);
                    stepObj = continueData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.RETURN_ELEMENT.equals(tagName)) {
                    ReturnMetaData returnData = new ReturnMetaData(this);
                    returnData.importXML(currentElement);
                    stepObj = returnData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.THROW_ELEMENT.equals(tagName)) {
                    ThrowMetaData throwData = new ThrowMetaData();
                    throwData.importXML(currentElement);
                    stepObj = throwData;
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                this.steps.add(stepObj);
            }
            if (this.steps == null) {
                throw new DeploymentException("if body is empty.");
            }
        }

        public boolean isMatch(FlowContext context) throws Exception {
            return this.test == null ? true : this.test.evaluate(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext;
            block11: {
                stepContext = null;
                Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
                try {
                    if (journal != null) {
                        journal.addStartStep(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_IF, BeanFlowInvokerAccessImpl2.this.factoryCallBack.getEditorFinder());
                    }
                    if (this.isMatch(context)) {
                        if (journal != null) {
                            journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_TEST, this.test == null ? BeanFlowInvokerAccessImpl2.DEFAULT_ELEMENT : '\"' + this.test.toString() + '\"');
                        }
                        Iterator itr = this.steps.iterator();
                        while (itr.hasNext()) {
                            Step step = (Step)itr.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                StepContext stepContext2 = null;
                                return stepContext2;
                            }
                            if (!stepContext.isContinue && !stepContext.isBreak) continue;
                            StepContext stepContext3 = stepContext;
                            return stepContext3;
                        }
                        break block11;
                    }
                    stepContext = new StepContext();
                }
                finally {
                    if (journal != null) {
                        journal.addEndStep();
                    }
                }
            }
            return stepContext;
        }
    }

    private class SwitchMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = -5017056531829628019L;
        private List cases;
        private IfMetaData defaultData;
        private boolean isJournal;

        public SwitchMetaData(MetaData parent) {
            super(parent);
            this.cases = new ArrayList();
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            Iterator children = SwitchMetaData.getChildren(element);
            while (children.hasNext()) {
                IfMetaData ifData;
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                if (BeanFlowInvokerAccessImpl2.CASE_ELEMENT.equals(tagName)) {
                    ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    this.cases.add(ifData);
                    continue;
                }
                if (BeanFlowInvokerAccessImpl2.DEFAULT_ELEMENT.equals(tagName)) {
                    ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    this.defaultData = ifData;
                    continue;
                }
                throw new DeploymentException("Invalid child tag of switch : " + tagName);
            }
            if (this.cases.size() == 0) {
                throw new DeploymentException("Case tag dose not exist.");
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            Iterator itr = this.cases.iterator();
            while (itr.hasNext()) {
                IfMetaData ifData = (IfMetaData)itr.next();
                if (!ifData.isMatch(context)) continue;
                return ifData.invokeStep(context);
            }
            if (this.defaultData == null) {
                return new StepContext();
            }
            return this.defaultData.invokeStep(context);
        }
    }

    private class WhileMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = -2324182374245423781L;
        protected Test test;
        protected List steps;
        protected boolean isJournal;
        protected boolean isDo;

        public WhileMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
            this.isDo = false;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            String journalStr;
            String doAttribute;
            String testAttribute;
            String nullCheckAttribute = WhileMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE);
            boolean nullCheck = false;
            if (nullCheckAttribute != null) {
                nullCheck = Boolean.valueOf(nullCheckAttribute);
            }
            if ((testAttribute = WhileMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.TEST_ATTRIBUTE)) != null) {
                try {
                    this.test = new Test(testAttribute, nullCheck);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            if ((doAttribute = WhileMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.DO_ATTRIBUTE)) != null) {
                this.isDo = Boolean.valueOf(doAttribute);
            }
            if ((journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE)) != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            String tagName = null;
            boolean isReturn = false;
            Iterator children = WhileMetaData.getChildren(element);
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData(this);
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData(this);
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData(this);
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (BeanFlowInvokerAccessImpl2.WHILE_ELEMENT.equals(tagName)) {
                    WhileMetaData whileData = new WhileMetaData(this);
                    whileData.importXML(currentElement);
                    stepObj = whileData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData(this);
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.BREAK_ELEMENT.equals(tagName)) {
                    BreakMetaData breakData = new BreakMetaData();
                    breakData.importXML(currentElement);
                    stepObj = breakData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.CONTINUE_ELEMENT.equals(tagName)) {
                    ContinueMetaData continueData = new ContinueMetaData();
                    continueData.importXML(currentElement);
                    stepObj = continueData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.RETURN_ELEMENT.equals(tagName)) {
                    ReturnMetaData returnData = new ReturnMetaData(this);
                    returnData.importXML(currentElement);
                    stepObj = returnData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.THROW_ELEMENT.equals(tagName)) {
                    ThrowMetaData throwData = new ThrowMetaData();
                    throwData.importXML(currentElement);
                    stepObj = throwData;
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                this.steps.add(stepObj);
            }
            if (this.steps == null) {
                throw new DeploymentException("if body is empty.");
            }
        }

        public boolean isMatch(FlowContext context) throws Exception {
            return this.test == null ? true : this.test.evaluate(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext;
            block17: {
                stepContext = new StepContext();
                Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
                try {
                    if (journal != null) {
                        journal.addStartStep(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_WHILE, BeanFlowInvokerAccessImpl2.this.factoryCallBack.getEditorFinder());
                    }
                    if (this.isDo) {
                        do {
                            Iterator itr = this.steps.iterator();
                            while (itr.hasNext()) {
                                Step step = (Step)itr.next();
                                stepContext = step.invokeStep(context);
                                if (stepContext == null) {
                                    StepContext stepContext2 = null;
                                    return stepContext2;
                                }
                                if (!stepContext.isContinue && !stepContext.isBreak) continue;
                                StepContext stepContext3 = stepContext;
                                return stepContext3;
                            }
                            if (journal == null) continue;
                            journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_TEST, this.test == null ? null : '\"' + this.test.toString() + '\"');
                        } while (this.isMatch(context));
                        break block17;
                    }
                    while (this.isMatch(context)) {
                        if (journal != null) {
                            journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_TEST, this.test == null ? null : '\"' + this.test.toString() + '\"');
                        }
                        Iterator itr = this.steps.iterator();
                        while (itr.hasNext()) {
                            Step step = (Step)itr.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                StepContext stepContext4 = null;
                                return stepContext4;
                            }
                            if (!stepContext.isContinue && !stepContext.isBreak) continue;
                            StepContext stepContext5 = stepContext;
                            return stepContext5;
                        }
                    }
                }
                finally {
                    if (journal != null) {
                        journal.addEndStep();
                    }
                }
            }
            return stepContext;
        }
    }

    private class ForMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = 7638469212499612542L;
        private MetaData targetData;
        private String varName;
        private String indexName;
        private int begin;
        private ExpressionMetaData beginExp;
        private int end;
        private ExpressionMetaData endExp;
        private List steps;
        private boolean isJournal;

        public ForMetaData(MetaData parent) {
            super(parent);
            this.begin = 0;
            this.end = -1;
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            Element targetElement;
            String journalStr;
            String endStr;
            this.indexName = ForMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.INDEX_ATTRIBUTE);
            String beginStr = ForMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.BEGIN_ATTRIBUTE);
            if (beginStr != null) {
                try {
                    this.begin = Integer.parseInt(beginStr);
                }
                catch (NumberFormatException e) {
                    ExpressionMetaData expData = new ExpressionMetaData();
                    expData.importString(beginStr);
                    this.beginExp = expData;
                }
            }
            if ((endStr = ForMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.END_ATTRIBUTE)) != null) {
                try {
                    this.end = Integer.parseInt(endStr);
                }
                catch (NumberFormatException e) {
                    ExpressionMetaData expData = new ExpressionMetaData();
                    expData.importString(endStr);
                    this.endExp = expData;
                }
            }
            if ((journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE)) != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            if ((targetElement = ForMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.TARGET_ELEMENT)) == null) {
                if (this.end < 0 && this.endExp == null) {
                    throw new DeploymentException("it is necessary to specify \"end\" when you do not specify <target>.");
                }
            } else {
                this.varName = ForMetaData.getUniqueAttribute(element, "var");
                Element childElement = ForMetaData.getUniqueChild(targetElement);
                String tagName = childElement.getTagName();
                if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName)) {
                    this.targetData = new InputMetaData();
                    this.targetData.importXML(childElement);
                } else if ("object".equals(tagName)) {
                    this.targetData = new ObjectMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("service-ref".equals(tagName)) {
                    this.targetData = new ServiceRefMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("static-invoke".equals(tagName)) {
                    this.targetData = new StaticInvokeMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("static-field-ref".equals(tagName)) {
                    this.targetData = new StaticFieldRefMetaData(this);
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT.equals(tagName)) {
                    this.targetData = new ResourceRefMetaData();
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                    this.targetData = new StepRefMetaData();
                    this.targetData.importXML(childElement);
                } else if ("var".equals(tagName)) {
                    this.targetData = new VarMetaData();
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT.equals(tagName)) {
                    this.targetData = new ExpressionMetaData();
                    this.targetData.importXML(childElement);
                } else {
                    throw new DeploymentException("Invalid child tag of target tag : " + tagName);
                }
            }
            Iterator children = ForMetaData.getChildrenWithoutTagName(element, new String[]{BeanFlowInvokerAccessImpl2.TARGET_ELEMENT});
            boolean isReturn = false;
            while (children.hasNext()) {
                Element currentElement = (Element)children.next();
                String tagName = currentElement.getTagName();
                if (isReturn) {
                    throw new DeploymentException("Unreachable element : " + tagName);
                }
                MetaData stepObj = null;
                if (BeanFlowInvokerAccessImpl2.STEP_ELEMENT.equals(tagName)) {
                    StepMetaData step = new StepMetaData(this);
                    step.importXML(currentElement);
                    stepObj = step;
                } else if (BeanFlowInvokerAccessImpl2.SWITCH_ELEMENT.equals(tagName)) {
                    SwitchMetaData sw = new SwitchMetaData(this);
                    sw.importXML(currentElement);
                    stepObj = sw;
                } else if (BeanFlowInvokerAccessImpl2.IF_ELEMENT.equals(tagName)) {
                    IfMetaData ifData = new IfMetaData(this);
                    ifData.importXML(currentElement);
                    stepObj = ifData;
                } else if (BeanFlowInvokerAccessImpl2.CALL_FLOW_ELEMENT.equals(tagName)) {
                    CallFlowMetaData callFlowData = new CallFlowMetaData(this);
                    callFlowData.importXML(currentElement);
                    stepObj = callFlowData;
                } else if (BeanFlowInvokerAccessImpl2.FOR_ELEMENT.equals(tagName)) {
                    ForMetaData forData = new ForMetaData(this);
                    forData.importXML(currentElement);
                    stepObj = forData;
                } else if (BeanFlowInvokerAccessImpl2.WHILE_ELEMENT.equals(tagName)) {
                    WhileMetaData whileData = new WhileMetaData(this);
                    whileData.importXML(currentElement);
                    stepObj = whileData;
                } else if (BeanFlowInvokerAccessImpl2.BREAK_ELEMENT.equals(tagName)) {
                    BreakMetaData breakData = new BreakMetaData();
                    breakData.importXML(currentElement);
                    stepObj = breakData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.CONTINUE_ELEMENT.equals(tagName)) {
                    ContinueMetaData continueData = new ContinueMetaData();
                    continueData.importXML(currentElement);
                    stepObj = continueData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.RETURN_ELEMENT.equals(tagName)) {
                    ReturnMetaData returnData = new ReturnMetaData(this);
                    returnData.importXML(currentElement);
                    stepObj = returnData;
                    isReturn = true;
                } else if (BeanFlowInvokerAccessImpl2.THROW_ELEMENT.equals(tagName)) {
                    ThrowMetaData throwData = new ThrowMetaData();
                    throwData.importXML(currentElement);
                    stepObj = throwData;
                    isReturn = true;
                } else {
                    throw new DeploymentException("Invalid child tag of if : " + tagName);
                }
                if (this.steps == null) {
                    this.steps = new ArrayList();
                }
                if (stepObj == null) continue;
                this.steps.add(stepObj);
            }
            if (this.steps == null) {
                throw new DeploymentException("for body is empty.");
            }
        }

        public StepContext invokeStep(FlowContext context) throws Exception {
            Object target = this.targetData == null ? null : ((ReturnValue)((Object)this.targetData)).getValue(context);
            StepContext stepContext = null;
            int beginVal = this.begin;
            if (this.beginExp != null) {
                Object val = this.beginExp.getValue(context);
                if (val instanceof Number) {
                    beginVal = ((Number)val).intValue();
                } else {
                    throw new IllegalArgumentException("Expression of 'begin' is not number.");
                }
            }
            int endVal = this.end;
            if (this.endExp != null) {
                Object val = this.endExp.getValue(context);
                if (val instanceof Number) {
                    endVal = ((Number)val).intValue();
                } else {
                    throw new IllegalArgumentException("Expression of 'begin' is not number.");
                }
            }
            if (target == null) {
                block0: for (int i = beginVal; i < endVal; ++i) {
                    if (this.indexName != null) {
                        context.setVar(this.indexName, new Integer(i));
                    }
                    Iterator itr = this.steps.iterator();
                    while (itr.hasNext()) {
                        Step step = (Step)itr.next();
                        stepContext = step.invokeStep(context);
                        if (stepContext == null) {
                            return null;
                        }
                        if (stepContext.isContinue) {
                            stepContext.isContinue = false;
                            continue block0;
                        }
                        if (!stepContext.isBreak) continue;
                        stepContext.isBreak = false;
                        return stepContext;
                    }
                }
            } else if (target.getClass().isArray()) {
                int length = Array.getLength(target);
                if (beginVal < length) {
                    int max;
                    int n = max = endVal > 0 && endVal < length ? endVal : length;
                    block2: for (int i = beginVal; i < max; ++i) {
                        if (this.indexName != null) {
                            context.setVar(this.indexName, new Integer(i));
                        }
                        Object var = Array.get(target, i);
                        context.setVar(this.varName, var);
                        Iterator itr = this.steps.iterator();
                        while (itr.hasNext()) {
                            Step step = (Step)itr.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (stepContext.isContinue) {
                                stepContext.isContinue = false;
                                continue block2;
                            }
                            if (!stepContext.isBreak) continue;
                            stepContext.isBreak = false;
                            return stepContext;
                        }
                    }
                }
            } else if (target instanceof ResultSet) {
                ResultSet resultSet = (ResultSet)target;
                int index = 0;
                while (resultSet.next()) {
                    if (this.indexName != null) {
                        context.setVar(this.indexName, new Integer(index));
                    }
                    context.setVar(this.varName, resultSet);
                    if (index >= beginVal) {
                        Iterator itr2 = this.steps.iterator();
                        while (itr2.hasNext()) {
                            Step step = (Step)itr2.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (stepContext.isContinue) {
                                stepContext.isContinue = false;
                                break;
                            }
                            if (!stepContext.isBreak) continue;
                            stepContext.isBreak = false;
                            return stepContext;
                        }
                    }
                    if (endVal == -1 || index < endVal) {
                        ++index;
                        continue;
                    }
                    break;
                }
            } else if (target instanceof RecordSet) {
                RecordSet recSet = (RecordSet)target;
                int length = recSet.size();
                if (beginVal < length) {
                    int max;
                    int n = max = endVal > 0 && endVal < length ? endVal : length;
                    block6: for (int i = beginVal; i < max; ++i) {
                        if (this.indexName != null) {
                            context.setVar(this.indexName, new Integer(i));
                        }
                        RowData row = recSet.get(i);
                        context.setVar(this.varName, row);
                        Iterator itr = this.steps.iterator();
                        while (itr.hasNext()) {
                            Step step = (Step)itr.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (stepContext.isContinue) {
                                stepContext.isContinue = false;
                                continue block6;
                            }
                            if (!stepContext.isBreak) continue;
                            stepContext.isBreak = false;
                            return stepContext;
                        }
                    }
                }
            } else if (target instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)target;
                int index = 0;
                while (enumeration.hasMoreElements()) {
                    if (this.indexName != null) {
                        context.setVar(this.indexName, new Integer(index));
                    }
                    Object var = enumeration.nextElement();
                    context.setVar(this.varName, var);
                    if (index >= beginVal) {
                        Iterator itr2 = this.steps.iterator();
                        while (itr2.hasNext()) {
                            Step step = (Step)itr2.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (stepContext.isContinue) {
                                stepContext.isContinue = false;
                                break;
                            }
                            if (!stepContext.isBreak) continue;
                            stepContext.isBreak = false;
                            return stepContext;
                        }
                    }
                    if (endVal == -1 || index < endVal) {
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                Collection col = (Collection)target;
                int index = 0;
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    if (this.indexName != null) {
                        context.setVar(this.indexName, new Integer(index));
                    }
                    Object var = itr.next();
                    context.setVar(this.varName, var);
                    if (index >= beginVal) {
                        Iterator itr2 = this.steps.iterator();
                        while (itr2.hasNext()) {
                            Step step = (Step)itr2.next();
                            stepContext = step.invokeStep(context);
                            if (stepContext == null) {
                                return null;
                            }
                            if (stepContext.isContinue) {
                                stepContext.isContinue = false;
                                break;
                            }
                            if (!stepContext.isBreak) continue;
                            stepContext.isBreak = false;
                            return stepContext;
                        }
                    }
                    if (endVal == -1 || index < endVal) {
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            if (stepContext == null) {
                stepContext = new StepContext();
            }
            return stepContext;
        }
    }

    private class CallFlowMetaData
    extends MetaData
    implements Step {
        private static final long serialVersionUID = -1896083944181448036L;
        private String name;
        private String stepName;
        private List inputData;
        private int transactionType;
        private int transactionTimeout;
        private ServiceName factoryName;

        public CallFlowMetaData(MetaData parent) {
            super(parent);
            this.transactionType = -1;
            this.transactionTimeout = -1;
        }

        public void importXML(Element element) throws DeploymentException {
            String factoryStr;
            String transactionTimeoutStr;
            this.name = CallFlowMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            this.stepName = CallFlowMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.STEPNAME_ATTRIBUTE, this.name);
            String transactionStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.TRANSACTION_ATTRIBUTE);
            if (transactionStr != null) {
                if (BeanFlowInvokerAccessImpl2.REQUIRED.equals(transactionStr)) {
                    this.transactionType = 0;
                } else if (BeanFlowInvokerAccessImpl2.REQUIRESNEW.equals(transactionStr)) {
                    this.transactionType = 1;
                } else if (BeanFlowInvokerAccessImpl2.SUPPORTS.equals(transactionStr)) {
                    this.transactionType = 2;
                } else if (BeanFlowInvokerAccessImpl2.MANDATORY.equals(transactionStr)) {
                    this.transactionType = 3;
                } else if (BeanFlowInvokerAccessImpl2.NEVER.equals(transactionStr)) {
                    this.transactionType = 4;
                } else if (BeanFlowInvokerAccessImpl2.NOT_SUPPORTED.equals(transactionStr)) {
                    this.transactionType = 5;
                } else {
                    throw new InvalidConfigurationException("Invalid transaction : " + transactionStr);
                }
                if (this.transactionType != 2) {
                    try {
                        InitialContext context = new InitialContext();
                        BeanFlowInvokerAccessImpl2.this.tranManager = (TransactionManager)context.lookup(BeanFlowInvokerAccessImpl2.this.getTransactionManagerJndiName());
                    }
                    catch (NamingException e) {
                        throw new DeploymentException(e);
                    }
                }
            }
            if ((transactionTimeoutStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.TRANTIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.transactionTimeout = Integer.parseInt(transactionTimeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("trantimeout is number " + transactionTimeoutStr);
                }
            }
            if ((factoryStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.FACTORY_ATTRIBUTE)) != null) {
                ServiceNameEditor editor = new ServiceNameEditor();
                editor.setAsText(factoryStr);
                this.factoryName = (ServiceName)editor.getValue();
            }
            Iterator argElements = CallFlowMetaData.getChildrenByTagName(element, "argument");
            while (argElements.hasNext()) {
                ArgumentMetaData argData = new ArgumentMetaData(this, null);
                argData.importXML((Element)argElements.next());
                if (this.inputData == null) {
                    this.inputData = new ArrayList();
                }
                this.inputData.add(argData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            StepContext stepContext;
            context.monitor.setCurrentStepName(this.stepName);
            context.current = stepContext = new StepContext();
            Object[] input = null;
            if (this.inputData != null && this.inputData.size() != 0) {
                if (this.inputData.size() == 1) {
                    input = ((ReturnValue)this.inputData.get(0)).getValue(context);
                } else {
                    Object[] inputs = new Object[this.inputData.size()];
                    for (int i = 0; i < inputs.length; ++i) {
                        inputs[i] = ((ReturnValue)this.inputData.get(i)).getValue(context);
                    }
                    input = inputs;
                }
            }
            BeanFlowInvoker invoker = null;
            invoker = this.factoryName == null ? BeanFlowInvokerAccessImpl2.this.factoryCallBack.createFlow(this.name) : ((BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.factoryName)).createFlow(this.name);
            TransactionInfo info = (TransactionInfo)transaction.get();
            info.transactionType = this.transactionType;
            info.transactionTimeout = this.transactionTimeout;
            info.tranManager = BeanFlowInvokerAccessImpl2.this.tranManager;
            String flowName = context.monitor.getCurrentFlowName();
            try {
                stepContext.result = invoker.invokeFlow(input, context.monitor);
                Object var8_8 = null;
                context.monitor.setCurrentFlowName(flowName);
                context.monitor.setCurrentStepName(this.stepName);
                info.clear();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                context.monitor.setCurrentFlowName(flowName);
                context.monitor.setCurrentStepName(this.stepName);
                info.clear();
                throw throwable;
            }
            context.put(this.stepName, stepContext);
            return stepContext;
        }
    }

    private static class StepRefMetaData
    extends MetaData
    implements ReturnValue {
        private static final long serialVersionUID = -983973047312150748L;
        private static final String TARGET = "target";
        private static final String RESULT = "result";
        private Property property;
        private boolean nullCheck;

        public void importXML(Element element) throws DeploymentException {
            String val;
            String nullCheckAttribute = StepRefMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE);
            if (nullCheckAttribute != null) {
                this.nullCheck = Boolean.valueOf(nullCheckAttribute);
            }
            if ((val = StepRefMetaData.getElementContent(element)) == null) {
                throw new DeploymentException("Content of step-result is null.");
            }
            int index = 0;
            int dotIndex = val.indexOf(46);
            int braket1Index = val.indexOf(40);
            int braket2Index = val.indexOf(91);
            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                val = val + '.' + "result";
            } else {
                String tmp;
                if (dotIndex == val.length() - 1 || braket1Index == val.length() - 1 || braket2Index == val.length() - 1) {
                    throw new DeploymentException("Invalid content of step-result : " + val);
                }
                index = dotIndex;
                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                    index = braket1Index;
                }
                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                    index = braket2Index;
                }
                if (!((tmp = val.substring(index + 1)).startsWith("target") || tmp.startsWith("target.") || tmp.startsWith("target(") || tmp.startsWith("target[") || tmp.startsWith("result") || tmp.startsWith("result.") || tmp.startsWith("result(") || tmp.startsWith("result["))) {
                    val = val.substring(0, index) + '.' + "result" + val.substring(index);
                }
            }
            try {
                this.property = PropertyFactory.createProperty(val);
            }
            catch (Exception e) {
                throw new DeploymentException(e);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            try {
                Object val = null;
                if (this.property instanceof NestedProperty) {
                    NestedProperty nestedProp = (NestedProperty)this.property;
                    Property thisProp = nestedProp.getFirstThisProperty();
                    val = thisProp.getProperty(context);
                    if (val != null) {
                        val = nestedProp.getProperty(context);
                    }
                } else {
                    val = this.property.getProperty(context);
                }
                return val;
            }
            catch (NullIndexPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullKeyPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullNestPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
            return null;
        }
    }

    private static class VarMetaData
    extends MetaData
    implements ReturnValue {
        private static final long serialVersionUID = -2037473595575858803L;
        private String name;
        private Property property;
        private boolean nullCheck;

        public void importXML(Element element) throws DeploymentException {
            String val;
            String nullCheckAttribute = VarMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE);
            if (nullCheckAttribute != null) {
                this.nullCheck = Boolean.valueOf(nullCheckAttribute);
            }
            if ((val = VarMetaData.getElementContent(element)) == null) {
                throw new DeploymentException("Var name is null.");
            }
            int dotIndex = val.indexOf(46);
            int braket1Index = val.indexOf(40);
            int braket2Index = val.indexOf(91);
            if (dotIndex == -1 && braket1Index == -1 && braket2Index == -1) {
                this.name = val;
            } else {
                int index = dotIndex;
                int index2 = dotIndex + 1;
                if (index == -1 || braket1Index != -1 && index > braket1Index) {
                    index = braket1Index;
                    index2 = braket1Index;
                }
                if (index == -1 || braket2Index != -1 && index > braket2Index) {
                    index = braket2Index;
                    index2 = braket2Index;
                }
                this.name = val.substring(0, index);
                if (index < val.length() - 1) {
                    String prop = val.substring(index2);
                    try {
                        this.property = PropertyFactory.createProperty(prop);
                    }
                    catch (Exception e) {
                        throw new DeploymentException(e);
                    }
                }
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Object var = context.getVar(this.name);
            if (var == null) {
                return null;
            }
            if (this.property == null) {
                return var;
            }
            try {
                return this.property.getProperty(var);
            }
            catch (NullIndexPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullKeyPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullNestPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
            return null;
        }
    }

    private static class ThisMetaData
    extends MetaData
    implements ReturnValue {
        private static final long serialVersionUID = -581510918646973596L;
        private Property property;
        private boolean nullCheck;

        public void importXML(Element element) throws DeploymentException {
            String val;
            String nullCheckAttribute = ThisMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE);
            if (nullCheckAttribute != null) {
                this.nullCheck = Boolean.valueOf(nullCheckAttribute);
            }
            if ((val = ThisMetaData.getElementContent(element)) != null && val.length() != 0) {
                try {
                    this.property = PropertyFactory.createProperty(val);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Object target = context.current.target;
            if (target == null) {
                return null;
            }
            if (this.property == null) {
                return target;
            }
            try {
                return this.property.getProperty(target);
            }
            catch (NullIndexPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullKeyPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullNestPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
            return null;
        }
    }

    private static class ResourceRefMetaData
    extends MetaData
    implements ReturnValue {
        private static final long serialVersionUID = -7785759414964084633L;
        private String name;
        private boolean isRaw;

        public ResourceRefMetaData() {
            super(null);
        }

        public void importXML(Element element) throws DeploymentException {
            this.name = ResourceRefMetaData.getElementContent(element);
            if (this.name == null) {
                throw new DeploymentException("Resource name is null.");
            }
            this.isRaw = ResourceRefMetaData.getOptionalBooleanAttribute(element, BeanFlowInvokerAccessImpl2.RAW_ATTRIBUTE, false);
        }

        public Object getValue(FlowContext context) throws Exception {
            TransactionResource resource = (TransactionResource)context.resourceManager.getResource(this.name);
            return this.isRaw ? resource : (resource == null ? null : resource.getObject());
        }
    }

    private static class StaticFieldRefMetaData
    extends jp.ossc.nimbus.core.StaticFieldRefMetaData
    implements ReturnValue {
        private static final long serialVersionUID = 3242136305224262415L;

        public StaticFieldRefMetaData(MetaData parent) {
            super(parent);
        }

        public Object getValue(FlowContext context) throws Exception {
            Class clazz = BeanFlowInvokerAccessImpl2.convertStringToClass(this.getCode());
            Field field = clazz.getField(this.getName());
            return field.get(null);
        }
    }

    private static class ServiceRefMetaData
    extends jp.ossc.nimbus.core.ServiceRefMetaData
    implements ReturnValue {
        private static final long serialVersionUID = -1606807882399104294L;

        public ServiceRefMetaData(MetaData parent) {
            super(parent);
        }

        public Object getValue(FlowContext context) throws Exception {
            return ServiceManagerFactory.getServiceObject(this.getManagerName(), this.getServiceName());
        }
    }

    private class StaticInvokeMetaData
    extends jp.ossc.nimbus.core.StaticInvokeMetaData
    implements ReturnValue,
    Journaling {
        private static final long serialVersionUID = 37922080913464606L;
        private boolean isJournal;

        public StaticInvokeMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("static-invoke")) {
                throw new DeploymentException("Tag must be static-invoke : " + element.getTagName());
            }
            this.code = StaticInvokeMetaData.getUniqueAttribute(element, "code");
            this.name = StaticInvokeMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            Iterator argElements = StaticInvokeMetaData.getChildrenByTagName(element, "argument");
            while (argElements.hasNext()) {
                ArgumentMetaData argData = new ArgumentMetaData(this, null);
                argData.importXML((Element)argElements.next());
                this.addArgument(argData);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Class targetClass = BeanFlowInvokerAccessImpl2.convertStringToClass(this.getCode());
            ArrayList paramTypes = new ArrayList();
            ArrayList<Object> params = new ArrayList<Object>();
            Iterator argDatas = this.getArguments().iterator();
            while (argDatas.hasNext()) {
                ArgumentMetaData argData = (ArgumentMetaData)argDatas.next();
                Object arg = argData.getValue(context);
                Class<?> typeClass = argData.getTypeClass();
                if (typeClass == null) {
                    if (arg == null) {
                        throw new InvalidConfigurationException("Type is unknown : " + argData);
                    }
                    typeClass = arg.getClass();
                }
                params.add(arg);
                paramTypes.add(typeClass);
            }
            Method method = targetClass.getMethod(this.name, paramTypes.toArray(new Class[paramTypes.size()]));
            Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
            if (journal != null) {
                journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_STATIC_INVOKE + this.getSignature(params), params);
            }
            try {
                return method.invoke(null, params.toArray());
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
        }

        protected String getSignature(List params) throws Exception {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getCode());
            buf.append('#');
            buf.append(this.getName());
            buf.append('(');
            if (this.arguments.size() != 0) {
                Iterator args = this.arguments.iterator();
                int index = 0;
                while (args.hasNext()) {
                    Object param;
                    ArgumentMetaData argData = (ArgumentMetaData)args.next();
                    Class<?> type = null;
                    try {
                        type = argData.getTypeClass();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (type == null && (param = params.get(index)) != null) {
                        type = param.getClass();
                    }
                    if (type != null) {
                        buf.append(type.getName());
                    }
                    if (args.hasNext()) {
                        buf.append(',');
                    }
                    ++index;
                }
            }
            buf.append(')');
            return buf.toString();
        }
    }

    private class InvokeMetaData
    extends jp.ossc.nimbus.core.InvokeMetaData
    implements ReturnValue,
    Journaling {
        private static final long serialVersionUID = 3949770023966053314L;
        private boolean isJournal;

        public InvokeMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("invoke")) {
                throw new DeploymentException("Tag must be invoke : " + element.getTagName());
            }
            this.name = InvokeMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            Iterator argElements = InvokeMetaData.getChildrenByTagName(element, "argument");
            while (argElements.hasNext()) {
                ArgumentMetaData argData = new ArgumentMetaData(this, null);
                argData.importXML((Element)argElements.next());
                this.addArgument(argData);
            }
        }

        private boolean isAccessableClass(Class clazz) {
            int modifier = clazz.getModifiers();
            return Modifier.isPublic(modifier) || (Modifier.isProtected(modifier) || !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier)) && (class$jp$ossc$nimbus$beans$SimpleProperty == null ? (class$jp$ossc$nimbus$beans$SimpleProperty = BeanFlowInvokerAccessImpl2.class$("jp.ossc.nimbus.beans.SimpleProperty")) : class$jp$ossc$nimbus$beans$SimpleProperty).getPackage().equals(clazz.getPackage());
        }

        public Object getValue(FlowContext context) throws Exception {
            return this.getValue(context.current.target, context);
        }

        public Object getValue(Object target, FlowContext context) throws Exception {
            ArrayList paramTypes = new ArrayList();
            ArrayList<Object> params = new ArrayList<Object>();
            Iterator argDatas = this.getArguments().iterator();
            while (argDatas.hasNext()) {
                ArgumentMetaData argData = (ArgumentMetaData)argDatas.next();
                Object arg = argData.getValue(context);
                Class<?> typeClass = argData.getTypeClass();
                if (typeClass == null) {
                    if (arg == null) {
                        throw new InvalidConfigurationException("Type is unknown : " + argData);
                    }
                    typeClass = arg.getClass();
                }
                params.add(arg);
                paramTypes.add(typeClass);
            }
            Class<?> targetClass = target.getClass();
            Class[] paramTypeArray = paramTypes.toArray(new Class[paramTypes.size()]);
            Method method = null;
            block5: do {
                if (this.isAccessableClass(targetClass)) {
                    method = targetClass.getMethod(this.name, paramTypeArray);
                    continue;
                }
                Class<?>[] interfaces = targetClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!this.isAccessableClass(interfaces[i])) continue;
                    try {
                        method = interfaces[i].getMethod(this.name, paramTypeArray);
                        continue block5;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
            } while (method == null && (targetClass = targetClass.getSuperclass()) != null);
            if (method == null) {
                throw new NoSuchMethodException(target.getClass().getName() + '#' + this.getSignature(params));
            }
            Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
            if (journal != null) {
                journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_INVOKE + this.getSignature(params), params);
            }
            try {
                return method.invoke(target, params.toArray());
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
        }

        protected String getSignature(List params) throws Exception {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getName());
            buf.append('(');
            if (this.arguments.size() != 0) {
                Iterator args = this.arguments.iterator();
                int index = 0;
                while (args.hasNext()) {
                    Object param;
                    ArgumentMetaData argData = (ArgumentMetaData)args.next();
                    Class<?> type = null;
                    try {
                        type = argData.getTypeClass();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (type == null && (param = params.get(index)) != null) {
                        type = param.getClass();
                    }
                    if (type != null) {
                        buf.append(type.getName());
                    }
                    if (args.hasNext()) {
                        buf.append(',');
                    }
                    ++index;
                }
            }
            buf.append(')');
            return buf.toString();
        }
    }

    private class AttributeMetaData
    extends jp.ossc.nimbus.core.AttributeMetaData
    implements ReturnValue,
    SetValue,
    Journaling {
        private static final long serialVersionUID = -5735499988722712700L;
        private static final String TYPE_ATTRIBUTE_NULL_VALUE = "nullValue";
        private boolean isNullValue;
        private boolean isJournal;

        public AttributeMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("attribute")) {
                throw new DeploymentException("Tag must be attribute : " + element.getTagName());
            }
            this.name = AttributeMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            this.type = AttributeMetaData.getOptionalAttribute(element, "type");
            this.isNullValue = AttributeMetaData.getOptionalBooleanAttribute(element, TYPE_ATTRIBUTE_NULL_VALUE, false);
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = BeanFlowInvokerAccessImpl2.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).getName().equals(this.type)) {
                Element valueElement = AttributeMetaData.getOptionalChild(element);
                if (valueElement != null) {
                    this.value = valueElement.cloneNode(true);
                }
                return;
            }
            Element serviceRefElement = AttributeMetaData.getOptionalChild(element, "service-ref");
            if (serviceRefElement != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this);
                serviceRefData.importXML(serviceRefElement);
                this.value = serviceRefData;
                return;
            }
            Element staticInvokeElement = AttributeMetaData.getOptionalChild(element, "static-invoke");
            if (staticInvokeElement != null) {
                StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
                staticInvokeData.importXML(staticInvokeElement);
                this.value = staticInvokeData;
                return;
            }
            Element staticFieldRefElement = AttributeMetaData.getOptionalChild(element, "static-field-ref");
            if (staticFieldRefElement != null) {
                StaticFieldRefMetaData staticFieldRefData = new StaticFieldRefMetaData(this);
                staticFieldRefData.importXML(staticFieldRefElement);
                this.value = staticFieldRefData;
                return;
            }
            Element objectElement = AttributeMetaData.getOptionalChild(element, "object");
            if (objectElement != null) {
                ObjectMetaData objectData = new ObjectMetaData(this);
                objectData.importXML(objectElement);
                this.value = objectData;
                return;
            }
            Element inputElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.INPUT_ELEMENT);
            if (inputElement != null) {
                InputMetaData inputData = new InputMetaData();
                inputData.importXML(inputElement);
                this.value = inputData;
                return;
            }
            Element stepRefElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT);
            if (stepRefElement != null) {
                StepRefMetaData stepRefData = new StepRefMetaData();
                stepRefData.importXML(stepRefElement);
                this.value = stepRefData;
                return;
            }
            Element thisElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.THIS_ELEMENT);
            if (thisElement != null) {
                ThisMetaData thisData = new ThisMetaData();
                thisData.importXML(thisElement);
                this.value = thisData;
                return;
            }
            Element resourceRefElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT);
            if (resourceRefElement != null) {
                ResourceRefMetaData resourceRefData = new ResourceRefMetaData();
                resourceRefData.importXML(resourceRefElement);
                this.value = resourceRefData;
                return;
            }
            Element varElement = AttributeMetaData.getOptionalChild(element, "var");
            if (varElement != null) {
                VarMetaData varData = new VarMetaData();
                varData.importXML(varElement);
                this.value = varData;
                return;
            }
            Element expElement = AttributeMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT);
            if (expElement != null) {
                ExpressionMetaData expData = new ExpressionMetaData();
                expData.importXML(expElement);
                this.value = expData;
                return;
            }
            this.value = AttributeMetaData.getElementContent(element);
        }

        public void setValue(FlowContext context) throws Exception {
            this.setValue(context.current.target, context);
        }

        public void setValue(Object target, FlowContext context) throws Exception {
            String name = this.getName();
            Property prop = PropertyFactory.createProperty(name);
            Object val = this.getSetValue(target, context);
            Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
            if (journal != null) {
                journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_ATTRIBUTE + this.getName(), val);
            }
            Class<?> type = null;
            if (this.getType() != null) {
                type = BeanFlowInvokerAccessImpl2.convertStringToClass(this.getType());
            } else if (val != null) {
                type = val.getClass();
            }
            try {
                prop.setProperty(target, type, val);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
        }

        public Object getSetValue(FlowContext context) throws Exception {
            return this.getSetValue(context.current.target, context);
        }

        public Object getSetValue(Object target, FlowContext context) throws Exception {
            if (this.isNullValue) {
                return null;
            }
            if ((class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = BeanFlowInvokerAccessImpl2.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element).getName().equals(this.getType())) {
                return this.value;
            }
            Object value = this.value;
            if (value instanceof ReturnValue) {
                value = ((ReturnValue)value).getValue(context);
            } else {
                PropertyEditor editor;
                Class type = null;
                if (this.getType() != null) {
                    type = BeanFlowInvokerAccessImpl2.convertStringToClass(this.getType());
                } else {
                    Property prop = PropertyFactory.createProperty(this.name);
                    try {
                        type = prop.getPropertyType(target);
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                if (type == null || (class$java$lang$Object == null ? (class$java$lang$Object = BeanFlowInvokerAccessImpl2.class$("java.lang.Object")) : class$java$lang$Object).equals(type)) {
                    Class clazz = type = class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
                }
                if ((editor = BeanFlowInvokerAccessImpl2.this.factoryCallBack.findPropEditor(type)) == null) {
                    throw new InvalidConfigurationException("PropertyEditor not found : " + type.getName());
                }
                editor.setAsText(BeanFlowInvokerAccessImpl2.this.replaceProperty((String)value));
                value = editor.getValue();
            }
            return value;
        }

        public Object getValue(FlowContext context) throws Exception {
            return this.getValue(context.current.target);
        }

        protected Object getValue(Object target) throws Exception {
            String name = this.getName();
            Property prop = PropertyFactory.createProperty(name);
            try {
                return prop.getProperty(target);
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
        }
    }

    private class FieldMetaData
    extends jp.ossc.nimbus.core.FieldMetaData
    implements ReturnValue,
    SetValue,
    Journaling {
        private static final long serialVersionUID = 8319123524651491880L;
        private static final String TYPE_ATTRIBUTE_NULL_VALUE = "nullValue";
        private boolean isNullValue;
        private boolean isJournal;

        public FieldMetaData(MetaData parent) {
            super(parent);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            Element serviceRefElement;
            if (!element.getTagName().equals("field")) {
                throw new DeploymentException("Tag must be field : " + element.getTagName());
            }
            this.name = FieldMetaData.getUniqueAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            this.type = FieldMetaData.getOptionalAttribute(element, "type");
            this.isNullValue = FieldMetaData.getOptionalBooleanAttribute(element, TYPE_ATTRIBUTE_NULL_VALUE, false);
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            if ((serviceRefElement = FieldMetaData.getOptionalChild(element, "service-ref")) != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this);
                serviceRefData.importXML(serviceRefElement);
                this.value = serviceRefData;
                return;
            }
            Element staticInvokeElement = FieldMetaData.getOptionalChild(element, "static-invoke");
            if (staticInvokeElement != null) {
                StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
                staticInvokeData.importXML(staticInvokeElement);
                this.value = staticInvokeData;
                return;
            }
            Element staticFieldRefElement = FieldMetaData.getOptionalChild(element, "static-field-ref");
            if (staticFieldRefElement != null) {
                StaticFieldRefMetaData staticFieldRefData = new StaticFieldRefMetaData(this);
                staticFieldRefData.importXML(staticFieldRefElement);
                this.value = staticFieldRefData;
                return;
            }
            Element objectElement = FieldMetaData.getOptionalChild(element, "object");
            if (objectElement != null) {
                ObjectMetaData objectData = new ObjectMetaData(this);
                objectData.importXML(objectElement);
                this.value = objectData;
                return;
            }
            Element inputElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.INPUT_ELEMENT);
            if (inputElement != null) {
                InputMetaData inputData = new InputMetaData();
                inputData.importXML(inputElement);
                this.value = inputData;
                return;
            }
            Element stepRefElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT);
            if (stepRefElement != null) {
                StepRefMetaData stepRefData = new StepRefMetaData();
                stepRefData.importXML(stepRefElement);
                this.value = stepRefData;
                return;
            }
            Element thisElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.THIS_ELEMENT);
            if (thisElement != null) {
                ThisMetaData thisData = new ThisMetaData();
                thisData.importXML(thisElement);
                this.value = thisData;
                return;
            }
            Element resourceRefElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT);
            if (resourceRefElement != null) {
                ResourceRefMetaData resourceRefData = new ResourceRefMetaData();
                resourceRefData.importXML(resourceRefElement);
                this.value = resourceRefData;
                return;
            }
            Element varElement = FieldMetaData.getOptionalChild(element, "var");
            if (varElement != null) {
                VarMetaData varData = new VarMetaData();
                varData.importXML(varElement);
                this.value = varData;
                return;
            }
            Element expElement = FieldMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT);
            if (expElement != null) {
                ExpressionMetaData expData = new ExpressionMetaData();
                expData.importXML(expElement);
                this.value = expData;
                return;
            }
            this.value = FieldMetaData.getElementContent(element);
        }

        public void setValue(FlowContext context) throws Exception {
            this.setValue(context.current.target);
        }

        public void setValue(Object target, FlowContext context) throws Exception {
            Object val = this.getSetValue(target, context);
            Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
            if (journal != null) {
                journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_FIELD + this.getName(), val);
            }
            this.getField(target).set(target, val);
        }

        protected Field getField(Object target) throws Exception {
            String name = this.getName();
            Class<?> targetClazz = target.getClass();
            Field f = null;
            try {
                f = targetClazz.getField(name);
            }
            catch (NoSuchFieldException e) {
                if (name.length() != 0 && Character.isUpperCase(name.charAt(0))) {
                    StringBuffer tmpName = new StringBuffer();
                    tmpName.append(Character.toLowerCase(name.charAt(0)));
                    if (name.length() > 1) {
                        tmpName.append(name.substring(1));
                    }
                    f = targetClazz.getField(tmpName.toString());
                }
                throw e;
            }
            return f;
        }

        public Object getSetValue(FlowContext context) throws Exception {
            return this.getSetValue(context.current.target, context);
        }

        protected Object getSetValue(Object target, FlowContext context) throws Exception {
            if (this.isNullValue) {
                return null;
            }
            Object value = this.value;
            if (value instanceof ReturnValue) {
                value = ((ReturnValue)value).getValue(context);
            } else {
                PropertyEditor editor;
                Class type = null;
                type = this.getType() != null ? BeanFlowInvokerAccessImpl2.convertStringToClass(this.getType()) : this.getField(target).getType();
                if (type == null || (class$java$lang$Object == null ? (class$java$lang$Object = BeanFlowInvokerAccessImpl2.class$("java.lang.Object")) : class$java$lang$Object).equals(type)) {
                    Class clazz = type = class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
                }
                if ((editor = BeanFlowInvokerAccessImpl2.this.factoryCallBack.findPropEditor(type)) == null) {
                    throw new InvalidConfigurationException("PropertyEditor not found : " + type.getName());
                }
                editor.setAsText(BeanFlowInvokerAccessImpl2.this.replaceProperty((String)value));
                value = editor.getValue();
            }
            return value;
        }

        public Object getValue(FlowContext context) throws Exception {
            return this.getValue(context.current.target);
        }

        protected Object getValue(Object target) throws Exception {
            String name = this.getName();
            Class<?> targetClazz = target.getClass();
            Field f = null;
            try {
                f = targetClazz.getField(name);
            }
            catch (NoSuchFieldException e) {
                if (name.length() != 0 && Character.isUpperCase(name.charAt(0))) {
                    StringBuffer tmpName = new StringBuffer();
                    tmpName.append(Character.toLowerCase(name.charAt(0)));
                    if (name.length() > 1) {
                        tmpName.append(name.substring(1));
                    }
                    f = targetClazz.getField(tmpName.toString());
                }
                throw e;
            }
            return f.get(target);
        }
    }

    private class ArgumentMetaData
    extends jp.ossc.nimbus.core.ArgumentMetaData
    implements ReturnValue {
        private static final long serialVersionUID = 3844640387973215685L;
        private boolean isNarrowCast;

        public ArgumentMetaData(MetaData parent, ObjectMetaData objData) {
            super(parent, objData);
        }

        public Class getTypeClass() throws Exception {
            if (this.type != null) {
                return BeanFlowInvokerAccessImpl2.convertStringToClass(this.type);
            }
            if (this.valueType != null) {
                return BeanFlowInvokerAccessImpl2.convertStringToClass(this.valueType);
            }
            if (this.value instanceof String) {
                return class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
            }
            return null;
        }

        public Class getValueTypeClass() throws Exception {
            if (this.valueType != null) {
                return BeanFlowInvokerAccessImpl2.convertStringToClass(this.valueType);
            }
            if (this.type != null) {
                return BeanFlowInvokerAccessImpl2.convertStringToClass(this.type);
            }
            if (this.value instanceof String) {
                return class$java$lang$String == null ? (class$java$lang$String = BeanFlowInvokerAccessImpl2.class$("java.lang.String")) : class$java$lang$String;
            }
            return null;
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("argument")) {
                throw new DeploymentException("Tag must be argument : " + element.getTagName());
            }
            this.type = ArgumentMetaData.getOptionalAttribute(element, "type");
            this.valueType = ArgumentMetaData.getOptionalAttribute(element, "valueType");
            this.isNullValue = ArgumentMetaData.getOptionalBooleanAttribute(element, "nullValue", false);
            this.isNarrowCast = ArgumentMetaData.getOptionalBooleanAttribute(element, BeanFlowInvokerAccessImpl2.NARROWCAST_ATTRIBUTE, false);
            Element serviceRefElement = ArgumentMetaData.getOptionalChild(element, "service-ref");
            if (serviceRefElement != null) {
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this);
                serviceRefData.importXML(serviceRefElement);
                this.value = serviceRefData;
                return;
            }
            Element staticInvokeElement = ArgumentMetaData.getOptionalChild(element, "static-invoke");
            if (staticInvokeElement != null) {
                StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
                staticInvokeData.importXML(staticInvokeElement);
                this.value = staticInvokeData;
                return;
            }
            Element staticFieldRefElement = ArgumentMetaData.getOptionalChild(element, "static-field-ref");
            if (staticFieldRefElement != null) {
                StaticFieldRefMetaData staticFieldRefData = new StaticFieldRefMetaData(this);
                staticFieldRefData.importXML(staticFieldRefElement);
                this.value = staticFieldRefData;
                return;
            }
            Element objectElement = ArgumentMetaData.getOptionalChild(element, "object");
            if (objectElement != null) {
                ObjectMetaData objectData = new ObjectMetaData(this);
                objectData.importXML(objectElement);
                this.value = objectData;
                return;
            }
            Element inputElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.INPUT_ELEMENT);
            if (inputElement != null) {
                InputMetaData inputData = new InputMetaData();
                inputData.importXML(inputElement);
                this.value = inputData;
                return;
            }
            Element stepRefElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT);
            if (stepRefElement != null) {
                StepRefMetaData stepRefData = new StepRefMetaData();
                stepRefData.importXML(stepRefElement);
                this.value = stepRefData;
                return;
            }
            Element thisElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.THIS_ELEMENT);
            if (thisElement != null) {
                ThisMetaData thisData = new ThisMetaData();
                thisData.importXML(thisElement);
                this.value = thisData;
                return;
            }
            Element resourceRefElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT);
            if (resourceRefElement != null) {
                ResourceRefMetaData resourceRefData = new ResourceRefMetaData();
                resourceRefData.importXML(resourceRefElement);
                this.value = resourceRefData;
                return;
            }
            Element varElement = ArgumentMetaData.getOptionalChild(element, "var");
            if (varElement != null) {
                VarMetaData varData = new VarMetaData();
                varData.importXML(varElement);
                this.value = varData;
                return;
            }
            Element expElement = ArgumentMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT);
            if (expElement != null) {
                ExpressionMetaData expData = new ExpressionMetaData();
                expData.importXML(expElement);
                this.value = expData;
                return;
            }
            this.value = ArgumentMetaData.getElementContent(element);
        }

        public Object getValue(FlowContext context) throws Exception {
            Class typeClass;
            if (this.isNullValue) {
                return null;
            }
            if (this.value instanceof ReturnValue) {
                Class typeClass2;
                Object ret = ((ReturnValue)this.value).getValue(context);
                if (ret != null && this.isNarrowCast && (typeClass2 = this.getTypeClass()) != null && BeanFlowInvokerAccessImpl2.isNarrowCast(ret.getClass(), typeClass2)) {
                    ret = BeanFlowInvokerAccessImpl2.castPrimitiveWrapper(typeClass2, (Number)ret);
                }
                return ret;
            }
            Class valueTypeClass = this.getValueTypeClass();
            if (valueTypeClass == null) {
                throw new InvalidConfigurationException("Type is unknown : " + this);
            }
            PropertyEditor editor = BeanFlowInvokerAccessImpl2.this.factoryCallBack.findPropEditor(valueTypeClass);
            if (editor == null) {
                throw new InvalidConfigurationException("PropertyEditor not found : " + valueTypeClass.getName());
            }
            editor.setAsText(BeanFlowInvokerAccessImpl2.this.replaceProperty((String)this.value));
            Object ret = editor.getValue();
            if (ret != null && this.isNarrowCast && (typeClass = this.getTypeClass()) != null && BeanFlowInvokerAccessImpl2.isNarrowCast(ret.getClass(), typeClass)) {
                ret = BeanFlowInvokerAccessImpl2.castPrimitiveWrapper(typeClass, (Number)ret);
            }
            return ret;
        }
    }

    private class ConstructorMetaData
    extends jp.ossc.nimbus.core.ConstructorMetaData
    implements ReturnValue {
        private static final long serialVersionUID = -1958316450069744646L;

        public ConstructorMetaData(ObjectMetaData parent) {
            super(parent);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals("constructor")) {
                throw new DeploymentException("Tag must be constructor : " + element.getTagName());
            }
            Element staticInvokeElement = ConstructorMetaData.getOptionalChild(element, "static-invoke");
            if (staticInvokeElement != null) {
                StaticInvokeMetaData staticInvokeData = new StaticInvokeMetaData(this);
                staticInvokeData.importXML(staticInvokeElement);
                this.staticInvoke = staticInvokeData;
                return;
            }
            Element staticFieldRefElement = ConstructorMetaData.getOptionalChild(element, "static-field-ref");
            if (staticFieldRefElement != null) {
                StaticFieldRefMetaData staticFieldRefData = new StaticFieldRefMetaData(this);
                staticFieldRefData.importXML(staticFieldRefElement);
                this.staticFieldRef = staticFieldRefData;
                return;
            }
            Iterator argElements = ConstructorMetaData.getChildrenByTagName(element, "argument");
            while (argElements.hasNext()) {
                ArgumentMetaData argData = new ArgumentMetaData(this, (ObjectMetaData)this.getParent());
                argData.importXML((Element)argElements.next());
                this.addArgument(argData);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            if (this.getStaticFieldRef() != null) {
                return ((StaticFieldRefMetaData)this.getStaticFieldRef()).getValue(context);
            }
            if (this.getStaticInvoke() != null) {
                return ((StaticInvokeMetaData)this.getStaticInvoke()).getValue(context);
            }
            ObjectMetaData objectData = (ObjectMetaData)this.getParent();
            Class clazz = objectData.getObjectClass();
            if (clazz.isArray()) {
                Class<?> elementType = clazz.getComponentType();
                Collection argCollection = this.getArguments();
                Object argVals = Array.newInstance(elementType, argCollection.size());
                Iterator args = argCollection.iterator();
                int i = 0;
                while (args.hasNext()) {
                    ArgumentMetaData argData = (ArgumentMetaData)args.next();
                    Array.set(argVals, i, argData.getValue(context));
                    ++i;
                }
                return argVals;
            }
            ArrayList paramTypes = new ArrayList();
            ArrayList<Object> params = new ArrayList<Object>();
            Iterator argDatas = this.getArguments().iterator();
            while (argDatas.hasNext()) {
                ArgumentMetaData argData = (ArgumentMetaData)argDatas.next();
                Object arg = argData.getValue(context);
                Class<?> typeClass = argData.getTypeClass();
                if (typeClass == null) {
                    if (arg == null) {
                        throw new InvalidConfigurationException("Type is unknown : " + argData);
                    }
                    typeClass = arg.getClass();
                }
                params.add(arg);
                paramTypes.add(typeClass);
            }
            Constructor c = clazz.getConstructor(paramTypes.toArray(new Class[paramTypes.size()]));
            return c.newInstance(params.toArray());
        }
    }

    private class ObjectMetaData
    extends jp.ossc.nimbus.core.ObjectMetaData
    implements ReturnValue,
    Journaling {
        private static final long serialVersionUID = -7179571475429331574L;
        private boolean isJournal;

        public ObjectMetaData(MetaData parent) {
            super(null, parent, null);
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            Element constElement;
            if (!element.getTagName().equals("object")) {
                throw new DeploymentException("Tag must be object : " + element.getTagName());
            }
            this.code = ObjectMetaData.getUniqueAttribute(element, "code");
            String journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE);
            if (journalStr != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            if ((constElement = ObjectMetaData.getOptionalChild(element, "constructor")) != null) {
                ConstructorMetaData constData = new ConstructorMetaData(this);
                constData.importXML(constElement);
                this.constructor = constData;
            }
            Iterator fieldElements = ObjectMetaData.getChildrenByTagName(element, "field");
            while (fieldElements.hasNext()) {
                FieldMetaData fieldData = new FieldMetaData(this);
                fieldData.importXML((Element)fieldElements.next());
                this.addField(fieldData);
            }
            Iterator attributeElements = ObjectMetaData.getChildrenByTagName(element, "attribute");
            while (attributeElements.hasNext()) {
                AttributeMetaData attributeData = new AttributeMetaData(this);
                attributeData.importXML((Element)attributeElements.next());
                this.addAttribute(attributeData);
            }
            Iterator invokeElements = ObjectMetaData.getChildrenByTagName(element, "invoke");
            while (invokeElements.hasNext()) {
                InvokeMetaData invokeData = new InvokeMetaData(this);
                invokeData.importXML((Element)invokeElements.next());
                this.addInvoke(invokeData);
            }
        }

        public Class getObjectClass() throws Exception {
            return BeanFlowInvokerAccessImpl2.convertStringToClass(this.code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(FlowContext context) throws Exception {
            Journal journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
            if (journal != null) {
                journal.addStartStep(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_OBJECT, BeanFlowInvokerAccessImpl2.this.factoryCallBack.getEditorFinder());
            }
            try {
                Object obj = null;
                if (this.constructor == null) {
                    Class clazz = this.getObjectClass();
                    if (journal != null) {
                        journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_CLASS, clazz);
                    }
                    if (clazz.isArray()) {
                        Class<?> elementType = clazz.getComponentType();
                        obj = Array.newInstance(elementType, 0);
                    } else {
                        obj = clazz.newInstance();
                    }
                } else {
                    obj = ((ReturnValue)((Object)this.constructor)).getValue(context);
                }
                Iterator fields = this.getFields().iterator();
                while (fields.hasNext()) {
                    FieldMetaData field = (FieldMetaData)fields.next();
                    field.setValue(obj, context);
                }
                Iterator attributes = this.getAttributes().iterator();
                while (attributes.hasNext()) {
                    AttributeMetaData attribute = (AttributeMetaData)attributes.next();
                    attribute.setValue(obj, context);
                }
                Iterator invokes = this.getInvokes().iterator();
                while (invokes.hasNext()) {
                    jp.ossc.nimbus.core.InvokeMetaData invoke;
                    MetaData invokeData = (MetaData)invokes.next();
                    if (invokeData instanceof InvokeMetaData) {
                        invoke = (InvokeMetaData)invokeData;
                        ((InvokeMetaData)invoke).getValue(obj, context);
                        continue;
                    }
                    if (!(invokeData instanceof StaticInvokeMetaData)) continue;
                    invoke = (StaticInvokeMetaData)invokeData;
                    ((StaticInvokeMetaData)invoke).getValue(context);
                }
                if (journal != null) {
                    journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_INSTANCE, obj);
                }
                Object object = obj;
                return object;
            }
            finally {
                if (journal != null) {
                    journal.addEndStep();
                }
            }
        }
    }

    private static class InputMetaData
    extends MetaData
    implements ReturnValue {
        private static final long serialVersionUID = -3006340756672859712L;
        private Property property;
        private boolean nullCheck = false;

        public void importXML(Element element) throws DeploymentException {
            String nullCheckAttribute;
            String val = InputMetaData.getElementContent(element);
            if (val != null && val.length() != 0) {
                try {
                    this.property = PropertyFactory.createProperty(val);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
            if ((nullCheckAttribute = InputMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NULLCHECK_ATTRIBUTE)) != null) {
                this.nullCheck = Boolean.valueOf(nullCheckAttribute);
            }
        }

        public Object getValue(FlowContext context) throws Exception {
            Object input = context.input;
            if (input == null) {
                return null;
            }
            if (this.property == null) {
                return input;
            }
            try {
                return this.property.getProperty(input);
            }
            catch (NullIndexPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullKeyPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (NullNestPropertyException e) {
                if (this.nullCheck) {
                    throw e;
                }
            }
            catch (InvocationTargetException e) {
                Throwable th = e.getCause();
                if (th == null) {
                    throw e;
                }
                if (th instanceof Exception) {
                    throw (Exception)th;
                }
                if (th instanceof Error) {
                    throw (Error)th;
                }
                throw e;
            }
            return null;
        }
    }

    private static interface SetValue {
        public void setValue(FlowContext var1) throws Exception;
    }

    private static interface ReturnValue {
        public Object getValue(FlowContext var1) throws Exception;
    }

    private class StepMetaData
    extends MetaData
    implements Step,
    Journaling {
        private static final long serialVersionUID = 3152910895585634923L;
        private String name;
        private MetaData targetData;
        private List childDatas;
        private Object resultData;
        private Semaphore semaphore;
        private long timeout;
        private long forceFreeTimeout;
        private int maxWaitCount;
        private boolean isJournal;
        protected List catchSteps;
        protected FinallyMetaData finallyStep;

        public StepMetaData(MetaData parent) {
            super(parent);
            this.timeout = -1L;
            this.forceFreeTimeout = -1L;
            this.maxWaitCount = -1;
            this.isJournal = true;
        }

        public boolean isJournal() {
            return this.isJournal;
        }

        public void importXML(Element element) throws DeploymentException {
            MetaData step;
            Element targetElement;
            String journalStr;
            String forceFreeTimeoutStr;
            String maxWaitCountStr;
            String timeoutStr;
            this.name = StepMetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.NAME_ATTRIBUTE);
            String maxThreadsStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.MAX_RUN_THREADS_ATTRIBUTE);
            if (maxThreadsStr != null) {
                try {
                    int maxThreads = Integer.parseInt(maxThreadsStr);
                    this.semaphore = new MemorySemaphore();
                    this.semaphore.setResourceCapacity(maxThreads);
                    this.semaphore.accept();
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxThreads is number " + maxThreadsStr);
                }
            }
            if ((timeoutStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.TIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.timeout = Long.parseLong(timeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("timeout is number " + timeoutStr);
                }
            }
            if ((maxWaitCountStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.MAX_WAIT_THREADS_ATTRIBUTE)) != null) {
                try {
                    this.maxWaitCount = Integer.parseInt(maxWaitCountStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("maxWaitThreads is number " + maxWaitCountStr);
                }
            }
            if ((forceFreeTimeoutStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.FORCE_FREE_TIMEOUT_ATTRIBUTE)) != null) {
                try {
                    this.forceFreeTimeout = Long.parseLong(forceFreeTimeoutStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidConfigurationException("forceFreeTimeout is number " + forceFreeTimeoutStr);
                }
            }
            if ((journalStr = MetaData.getOptionalAttribute(element, BeanFlowInvokerAccessImpl2.JOURNAL_ATTRIBUTE)) != null) {
                this.isJournal = Boolean.valueOf(journalStr);
            }
            if ((targetElement = StepMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.TARGET_ELEMENT)) == null) {
                this.targetData = new InputMetaData();
            } else {
                Element childElement = StepMetaData.getUniqueChild(targetElement);
                String tagName = childElement.getTagName();
                if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName)) {
                    this.targetData = new InputMetaData();
                    this.targetData.importXML(childElement);
                } else if ("object".equals(tagName)) {
                    this.targetData = new ObjectMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("service-ref".equals(tagName)) {
                    this.targetData = new ServiceRefMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("static-invoke".equals(tagName)) {
                    this.targetData = new StaticInvokeMetaData(this);
                    this.targetData.importXML(childElement);
                } else if ("static-field-ref".equals(tagName)) {
                    this.targetData = new StaticFieldRefMetaData(this);
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.RESOURCE_REF_ELEMENT.equals(tagName)) {
                    this.targetData = new ResourceRefMetaData();
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                    this.targetData = new StepRefMetaData();
                    this.targetData.importXML(childElement);
                } else if ("var".equals(tagName)) {
                    this.targetData = new VarMetaData();
                    this.targetData.importXML(childElement);
                } else if (BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT.equals(tagName)) {
                    this.targetData = new ExpressionMetaData();
                    this.targetData.importXML(childElement);
                } else {
                    throw new DeploymentException("Invalid child tag of target tag : " + tagName);
                }
            }
            Iterator catchElements = MetaData.getChildrenByTagName(element, BeanFlowInvokerAccessImpl2.CATCH_ELEMENT);
            while (catchElements.hasNext()) {
                Element catchElement = (Element)catchElements.next();
                step = new CatchMetaData(this);
                ((CatchMetaData)step).importXML(catchElement);
                if (this.catchSteps == null) {
                    this.catchSteps = new ArrayList();
                }
                this.catchSteps.add(step);
            }
            Element finallyElement = MetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.FINALLY_ELEMENT);
            if (finallyElement != null) {
                step = new FinallyMetaData(this);
                ((FinallyMetaData)step).importXML(finallyElement);
                this.finallyStep = step;
            }
            Iterator children = StepMetaData.getChildrenWithoutTagName(element, new String[]{BeanFlowInvokerAccessImpl2.TARGET_ELEMENT, BeanFlowInvokerAccessImpl2.RESULT_ELEMENT, BeanFlowInvokerAccessImpl2.CATCH_ELEMENT, BeanFlowInvokerAccessImpl2.FINALLY_ELEMENT});
            while (children.hasNext()) {
                if (this.childDatas == null) {
                    this.childDatas = new ArrayList();
                }
                Element childElement = (Element)children.next();
                String tagName = childElement.getTagName();
                MetaData childData = null;
                if ("attribute".equals(tagName)) {
                    childData = new AttributeMetaData(this);
                    childData.importXML(childElement);
                } else if ("field".equals(tagName)) {
                    childData = new FieldMetaData(this);
                    childData.importXML(childElement);
                } else if ("invoke".equals(tagName)) {
                    childData = new InvokeMetaData(this);
                    childData.importXML(childElement);
                } else if ("static-invoke".equals(tagName)) {
                    childData = new StaticInvokeMetaData(this);
                    childData.importXML(childElement);
                } else {
                    throw new DeploymentException("Invalid child tag of step tag : " + tagName);
                }
                this.childDatas.add(childData);
            }
            Element resultElement = StepMetaData.getOptionalChild(element, BeanFlowInvokerAccessImpl2.RESULT_ELEMENT);
            if (resultElement != null) {
                Element retElement = StepMetaData.getOptionalChild(resultElement);
                if (retElement == null) {
                    this.resultData = StepMetaData.getElementContent(resultElement);
                } else {
                    String tagName = retElement.getTagName();
                    if ("attribute".equals(tagName)) {
                        this.resultData = new AttributeMetaData(this);
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if ("field".equals(tagName)) {
                        this.resultData = new FieldMetaData(this);
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if ("invoke".equals(tagName)) {
                        this.resultData = new InvokeMetaData(this);
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if ("static-invoke".equals(tagName)) {
                        this.resultData = new StaticInvokeMetaData(this);
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if ("static-field-ref".equals(tagName)) {
                        this.resultData = new StaticFieldRefMetaData(this);
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if (BeanFlowInvokerAccessImpl2.THIS_ELEMENT.equals(tagName)) {
                        this.resultData = new ThisMetaData();
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if (BeanFlowInvokerAccessImpl2.INPUT_ELEMENT.equals(tagName)) {
                        this.resultData = new InputMetaData();
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if ("object".equals(tagName)) {
                        this.resultData = new ObjectMetaData(this);
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if (BeanFlowInvokerAccessImpl2.EXPRESSION_ELEMENT.equals(tagName)) {
                        this.resultData = new ExpressionMetaData();
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if (BeanFlowInvokerAccessImpl2.STEP_REF_ELEMENT.equals(tagName)) {
                        this.resultData = new StepRefMetaData();
                        ((MetaData)this.resultData).importXML(retElement);
                    } else if ("var".equals(tagName)) {
                        this.resultData = new VarMetaData();
                        ((MetaData)this.resultData).importXML(retElement);
                    } else {
                        throw new DeploymentException("Invalid child tag of result tag : " + tagName);
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public StepContext invokeStep(FlowContext context) throws Exception {
            Journal journal;
            StepContext stepContext;
            block34: {
                stepContext = new StepContext();
                journal = BeanFlowInvokerAccessImpl2.this.getJournal(this);
                try {
                    try {
                        Object target;
                        context.monitor.setCurrentStepName(this.name);
                        if (journal != null) {
                            journal.addStartStep(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_STEP, BeanFlowInvokerAccessImpl2.this.factoryCallBack.getEditorFinder());
                            journal.addInfo("Name", this.name);
                        }
                        if (BeanFlowInvokerAccessImpl2.this.isSuspend) {
                            context.monitor.checkSuspend();
                        }
                        if (BeanFlowInvokerAccessImpl2.this.isStop) {
                            context.monitor.checkStop();
                        }
                        if (this.semaphore != null && !this.semaphore.getResource(this.timeout, this.maxWaitCount, this.forceFreeTimeout)) {
                            throw new UnavailableStepException("flowName=" + BeanFlowInvokerAccessImpl2.this.flowName + ", stepName=" + this.name);
                        }
                        context.current = stepContext;
                        stepContext.target = target = ((ReturnValue)((Object)this.targetData)).getValue(context);
                        if (journal != null) {
                            journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_STEP_TARGET, stepContext.target);
                        }
                        if (this.childDatas != null) {
                            Iterator children = this.childDatas.iterator();
                            while (children.hasNext()) {
                                Object child = children.next();
                                if (child instanceof SetValue) {
                                    ((SetValue)child).setValue(context);
                                    continue;
                                }
                                if (child instanceof InvokeMetaData) {
                                    ((InvokeMetaData)child).getValue(context);
                                    continue;
                                }
                                if (!(child instanceof StaticInvokeMetaData)) continue;
                                ((StaticInvokeMetaData)child).getValue(context);
                            }
                        }
                        if (this.resultData != null) {
                            if (this.resultData instanceof ReturnValue) {
                                stepContext.result = ((ReturnValue)this.resultData).getValue(context);
                            } else {
                                Object object = stepContext.result = this.resultData == null ? null : this.resultData.toString();
                            }
                        }
                        if (this.name != null) {
                            context.put(this.name, stepContext);
                        }
                        if (journal != null) {
                            journal.addInfo(BeanFlowInvokerAccessImpl2.JOURNAL_KEY_STEP_RESULT, stepContext.result);
                        }
                    }
                    catch (Exception e) {
                        Throwable th = e;
                        if (th instanceof InvocationTargetException) {
                            th = ((InvocationTargetException)th).getTargetException();
                        } else if (th instanceof BeanControlUncheckedException) {
                            th = ((BeanControlUncheckedException)th).getCause();
                        } else if (th instanceof BeanFlowMonitorStopException) {
                            ((BeanFlowMonitorStopException)th).setStepName(this.name);
                        }
                        if (journal != null) {
                            journal.addInfo("Exception", th);
                        }
                        boolean isCatch = false;
                        if (this.catchSteps != null && th instanceof Exception) {
                            int imax = this.catchSteps.size();
                            for (int i = 0; i < imax; ++i) {
                                CatchMetaData catchStep = (CatchMetaData)this.catchSteps.get(i);
                                if (!catchStep.isMatch(context, (Exception)th)) continue;
                                catchStep.invokeStep(context);
                                isCatch = true;
                                break;
                            }
                        }
                        if (!isCatch) {
                            BeanFlowInvokerAccessImpl2.this.throwException(th);
                        }
                        Object var11_12 = null;
                        if (this.finallyStep != null) {
                            this.finallyStep.invokeStep(context);
                        }
                        if (this.semaphore != null) {
                            this.semaphore.freeResource();
                        }
                        if (journal == null) return stepContext;
                        journal.addEndStep();
                        return stepContext;
                    }
                    catch (Error e) {
                        if (journal == null) throw e;
                        journal.addInfo("Exception", e);
                        throw e;
                    }
                    Object var11_11 = null;
                    if (this.finallyStep == null) break block34;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (this.finallyStep != null) {
                        this.finallyStep.invokeStep(context);
                    }
                    if (this.semaphore != null) {
                        this.semaphore.freeResource();
                    }
                    if (journal == null) throw throwable;
                    journal.addEndStep();
                    throw throwable;
                }
                this.finallyStep.invokeStep(context);
            }
            if (this.semaphore != null) {
                this.semaphore.freeResource();
            }
            if (journal == null) return stepContext;
            journal.addEndStep();
            return stepContext;
        }
    }

    private static interface Journaling {
        public boolean isJournal();
    }

    private static interface Step {
        public StepContext invokeStep(FlowContext var1) throws Exception;
    }

    private static class ResourceInfo
    implements Serializable {
        private static final long serialVersionUID = 3152910895585634920L;
        public String name;
        public String key;
        public ServiceName serviceName;
        public boolean isTranControl;
        public boolean isTranClose;

        private ResourceInfo() {
        }
    }
}

