/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.Header;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.RecordList;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class DataSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 452460154073106633L;
    protected String name;
    protected Map headerMap;
    protected Map recordListMap;
    protected transient Map nestedRecordListMap;

    public DataSet() {
    }

    public DataSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHeaderSchema(String schema) throws PropertySchemaDefineException {
        this.setHeaderSchema(null, schema);
    }

    public void setHeaderSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.headerMap.put(name, new Header(name, schema));
    }

    public void setHeaderSchema(RecordSchema schema) {
        this.setHeaderSchema(null, schema);
    }

    public void setHeaderSchema(String name, RecordSchema schema) {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.headerMap.put(name, new Header(name, schema));
    }

    public void setRecordListSchema(String schema) throws PropertySchemaDefineException {
        this.setRecordListSchema(null, schema);
    }

    public void setRecordListSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.recordListMap == null) {
            this.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.recordListMap.put(name, new RecordList(name, schema));
    }

    public void setRecordListSchema(RecordSchema schema) {
        this.setRecordListSchema(null, schema);
    }

    public void setRecordListSchema(String name, RecordSchema schema) {
        if (this.recordListMap == null) {
            this.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.recordListMap.put(name, new RecordList(name, schema));
    }

    public void setNestedRecordListSchema(String name, String schema) throws PropertySchemaDefineException {
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        RecordSchema recSchema = RecordSchema.getInstance(schema);
        this.nestedRecordListMap.put(name, recSchema.getSchema());
    }

    public void setNestedRecordListSchema(String name, RecordSchema schema) {
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.nestedRecordListMap.put(name, schema.getSchema());
    }

    public RecordSchema getNestedRecordListSchema(String name) throws PropertySchemaDefineException {
        if (this.nestedRecordListMap == null) {
            return null;
        }
        String schema = (String)this.nestedRecordListMap.get(name);
        return schema == null ? null : RecordSchema.getInstance(schema);
    }

    public String[] getNestedRecordListSchemaNames() {
        return this.nestedRecordListMap == null ? new String[]{} : this.nestedRecordListMap.keySet().toArray(new String[this.nestedRecordListMap.size()]);
    }

    public int getNestedRecordListSchemaSize() {
        return this.nestedRecordListMap == null ? 0 : this.nestedRecordListMap.size();
    }

    public Map getNestedRecordListSchemaMap() {
        if (this.nestedRecordListMap == null) {
            this.nestedRecordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        return this.nestedRecordListMap;
    }

    public void setSchema(String headerSchema, String recordListSchema) throws PropertySchemaDefineException {
        this.setSchema(null, headerSchema, recordListSchema);
    }

    public void setSchema(String name, RecordSchema headerSchema, RecordSchema recordListSchema) {
        if (headerSchema != null) {
            this.setHeaderSchema(name, headerSchema);
        }
        if (recordListSchema != null) {
            this.setRecordListSchema(name, recordListSchema);
        }
    }

    public void setSchema(RecordSchema headerSchema, RecordSchema recordListSchema) {
        this.setSchema(null, headerSchema, recordListSchema);
    }

    public void setSchema(String name, String headerSchema, String recordListSchema) throws PropertySchemaDefineException {
        if (headerSchema != null) {
            this.setHeaderSchema(name, headerSchema);
        }
        if (recordListSchema != null) {
            this.setRecordListSchema(name, recordListSchema);
        }
    }

    public Header getHeader() {
        return this.getHeader(null);
    }

    public Header getHeader(String name) {
        return this.headerMap == null ? null : (Header)this.headerMap.get(name);
    }

    public String[] getHeaderNames() {
        return this.headerMap == null ? new String[]{} : this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
    }

    public int getHeaderSize() {
        return this.headerMap == null ? 0 : this.headerMap.size();
    }

    public Map getHeaderMap() {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        return this.headerMap;
    }

    public void addHeader(Header header) {
        if (this.headerMap == null) {
            this.headerMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.headerMap.put(header.getName(), header);
    }

    public RecordList getRecordList() {
        return this.getRecordList(null);
    }

    public RecordList getRecordList(String name) {
        return this.recordListMap == null ? null : (RecordList)this.recordListMap.get(name);
    }

    public String[] getRecordListNames() {
        return this.recordListMap == null ? new String[]{} : this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
    }

    public int getRecordListSize() {
        return this.recordListMap == null ? 0 : this.recordListMap.size();
    }

    public Map getRecordListMap() {
        if (this.recordListMap == null) {
            this.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        return this.recordListMap;
    }

    public void addRecordList(RecordList recList) {
        if (this.recordListMap == null) {
            this.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
        }
        this.recordListMap.put(recList.getName(), recList);
    }

    public RecordList createNestedRecordList(String name) {
        if (this.nestedRecordListMap == null || !this.nestedRecordListMap.containsKey(name)) {
            return null;
        }
        return new RecordList(name, RecordSchema.getInstance((String)this.nestedRecordListMap.get(name)));
    }

    public void clear() {
        int i;
        if (this.headerMap != null && this.headerMap.size() != 0) {
            String[] headerNames = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
            for (i = 0; i < headerNames.length; ++i) {
                Header header = this.getHeader(headerNames[i]);
                if (header == null) continue;
                header.clear();
            }
        }
        if (this.recordListMap != null && this.recordListMap.size() != 0) {
            String[] recListNames = this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
            for (i = 0; i < recListNames.length; ++i) {
                RecordList recList = this.getRecordList(recListNames[i]);
                if (recList == null) continue;
                recList.clear();
            }
        }
    }

    public DataSet cloneSchema() {
        return this.cloneDataSet(false);
    }

    public DataSet cloneDataSet() {
        return this.cloneDataSet(true);
    }

    protected DataSet cloneDataSet(boolean hasData) {
        int i;
        DataSet dataSet = null;
        try {
            dataSet = (DataSet)super.clone();
            dataSet.headerMap = null;
            dataSet.recordListMap = null;
            dataSet.nestedRecordListMap = null;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (this.headerMap != null && this.headerMap.size() != 0) {
            String[] headerNames = this.headerMap.keySet().toArray(new String[this.headerMap.size()]);
            dataSet.headerMap = Collections.synchronizedMap(new LinkedHashMap());
            for (i = 0; i < headerNames.length; ++i) {
                Header header = this.getHeader(headerNames[i]);
                if (header == null) continue;
                dataSet.headerMap.put(headerNames[i], hasData ? header.cloneRecord() : header.cloneSchema());
            }
        }
        if (this.recordListMap != null && this.recordListMap.size() != 0) {
            String[] recListNames = this.recordListMap.keySet().toArray(new String[this.recordListMap.size()]);
            dataSet.recordListMap = Collections.synchronizedMap(new LinkedHashMap());
            for (i = 0; i < recListNames.length; ++i) {
                RecordList recList = this.getRecordList(recListNames[i]);
                if (recList == null) continue;
                dataSet.recordListMap.put(recListNames[i], hasData ? recList.cloneRecordList() : recList.cloneSchema());
            }
        }
        if (this.nestedRecordListMap != null && this.nestedRecordListMap.size() != 0) {
            dataSet.nestedRecordListMap = Collections.synchronizedMap(new LinkedHashMap());
            dataSet.nestedRecordListMap.putAll(this.nestedRecordListMap);
        }
        return dataSet;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.cloneDataSet();
    }

    public String toString() {
        return super.toString() + "{name=" + this.name + '}';
    }
}

