/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import jp.ossc.nimbus.core.Utility;
import org.w3c.dom.Element;

public class ServiceMetaData
extends ObjectMetaData
implements Serializable {
    private static final long serialVersionUID = 1524948064493968357L;
    public static final String SERVICE_TAG_NAME = "service";
    public static final String INSTANCE_TYPE_SINGLETON = "singleton";
    public static final String INSTANCE_TYPE_FACTORY = "factory";
    public static final String INSTANCE_TYPE_THREADLOCAL = "threadlocal";
    private static final String DEPENDS_TAG_NAME = "depends";
    private static final String OPT_CONF_TAG_NAME = "optional-config";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String INIT_STATE_ATTRIBUTE_NAME = "initState";
    private static final String INSTANCE_ATTRIBUTE_NAME = "instance";
    private static final String MANAGEMENT_ATTRIBUTE_NAME = "management";
    private static final String CREATE_TEMPLATE_ATTRIBUTE_NAME = "createTemplate";
    private String name;
    private String initState = Service.STATES[3];
    private int initStateValue = 3;
    private String instance = "singleton";
    private boolean isFactory;
    private boolean isManagement;
    private boolean isCreateTemplate = true;
    private transient Element optionalConfig;
    private final List depends = new ArrayList();
    private ManagerMetaData manager;

    public ServiceMetaData() {
    }

    public ServiceMetaData(String name, String code) {
        this.setName(name);
        this.setCode(code);
    }

    public ServiceMetaData(ServiceLoader loader, MetaData parent, ManagerMetaData manager) {
        super(loader, parent, manager.getName());
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInitState() {
        return this.initState;
    }

    public void setInitState(String state) {
        for (int i = 0; i < Service.STATES.length; ++i) {
            if (!Service.STATES[i].equals(state)) continue;
            this.initStateValue = i;
            this.initState = state;
            return;
        }
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String val) {
        if (INSTANCE_TYPE_SINGLETON.equals(val)) {
            this.instance = val;
        } else if (INSTANCE_TYPE_FACTORY.equals(val) || INSTANCE_TYPE_THREADLOCAL.equals(val)) {
            this.isFactory = true;
            this.instance = val;
        } else {
            throw new IllegalArgumentException(val);
        }
    }

    public boolean isFactory() {
        return this.isFactory;
    }

    public void setFactory(boolean isFactory) {
        this.isFactory = isFactory;
    }

    public boolean isManagement() {
        return this.isManagement;
    }

    public void setManagement(boolean flg) {
        this.isManagement = flg;
    }

    public boolean isCreateTemplate() {
        return this.isCreateTemplate;
    }

    public void setCreateTemplate(boolean flg) {
        this.isCreateTemplate = flg;
    }

    public int getInitStateValue() {
        return this.initStateValue;
    }

    public void setInitStateValue(int state) {
        if (state >= 0 && Service.STATES.length > state) {
            this.initStateValue = state;
            this.initState = Service.STATES[state];
        }
    }

    public Element getOptionalConfig() {
        return this.optionalConfig;
    }

    public void setOptionalConfig(Element option) {
        this.optionalConfig = option;
    }

    public List getDepends() {
        return this.depends;
    }

    public void addDepends(DependsMetaData depends) {
        this.depends.add(depends);
    }

    public void removeDepends(DependsMetaData depends) {
        this.depends.remove(depends);
    }

    public void clearDepends() {
        this.depends.clear();
    }

    public ManagerMetaData getManager() {
        return this.manager;
    }

    public void setManager(ManagerMetaData manager) {
        this.manager = manager;
    }

    public DependsMetaData createDependsMetaData(String managerName, String serviceName) {
        return new DependsMetaData(managerName, serviceName);
    }

    protected void checkTagName(Element element) throws DeploymentException {
        if (!element.getTagName().equals(SERVICE_TAG_NAME)) {
            throw new DeploymentException("Tag must be service : " + element.getTagName());
        }
    }

    public void importXML(Element element) throws DeploymentException {
        String createTemplate;
        super.importXML(element);
        this.name = ServiceMetaData.getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        String tmpInitState = ServiceMetaData.getOptionalAttribute(element, INIT_STATE_ATTRIBUTE_NAME);
        if (tmpInitState != null) {
            if (this.getServiceLoader() != null) {
                tmpInitState = Utility.replaceServiceLoderConfig(tmpInitState, this.getServiceLoader().getConfig());
            }
            tmpInitState = Utility.replaceSystemProperty(tmpInitState);
            tmpInitState = Utility.replaceServerProperty(tmpInitState);
        }
        if (Service.STATES[1].equals(tmpInitState)) {
            this.initState = ServiceMetaData.getOptionalAttribute(element, INIT_STATE_ATTRIBUTE_NAME);
            this.initStateValue = 1;
        } else if (Service.STATES[3].equals(tmpInitState)) {
            this.initState = ServiceMetaData.getOptionalAttribute(element, INIT_STATE_ATTRIBUTE_NAME);
            this.initStateValue = 3;
        }
        this.setInstance(ServiceMetaData.getOptionalAttribute(element, INSTANCE_ATTRIBUTE_NAME, INSTANCE_TYPE_SINGLETON));
        String management = ServiceMetaData.getOptionalAttribute(element, MANAGEMENT_ATTRIBUTE_NAME);
        if (management != null) {
            this.isManagement = Boolean.valueOf(management);
        }
        if ((createTemplate = ServiceMetaData.getOptionalAttribute(element, CREATE_TEMPLATE_ATTRIBUTE_NAME)) != null) {
            this.isCreateTemplate = Boolean.valueOf(createTemplate);
        }
        this.optionalConfig = ServiceMetaData.getOptionalChild(element, OPT_CONF_TAG_NAME);
        Iterator dependsElements = ServiceMetaData.getChildrenByTagName(element, DEPENDS_TAG_NAME);
        while (dependsElements.hasNext()) {
            Element dependsElement = (Element)dependsElements.next();
            DependsMetaData dependsData = new DependsMetaData(this.manager.getName());
            dependsData.importXML(dependsElement);
            this.depends.add(dependsData);
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        this.appendComment(buf);
        buf.append('<').append(SERVICE_TAG_NAME);
        if (this.name != null) {
            buf.append(' ').append(NAME_ATTRIBUTE_NAME).append("=\"").append(this.name).append("\"");
        }
        if (this.code != null) {
            buf.append(' ').append("code").append("=\"").append(this.code).append("\"");
        }
        if (this.initState != null && !Service.STATES[3].equals(this.initState)) {
            buf.append(' ').append(INIT_STATE_ATTRIBUTE_NAME).append("=\"").append(this.initState).append("\"");
        }
        if (this.instance != null && !INSTANCE_TYPE_SINGLETON.equals(this.instance)) {
            buf.append(' ').append(INSTANCE_ATTRIBUTE_NAME).append("=\"").append(this.instance).append("\"");
        }
        if (this.isManagement) {
            buf.append(' ').append(MANAGEMENT_ATTRIBUTE_NAME).append("=\"").append(this.isManagement).append("\"");
        }
        if (!this.isCreateTemplate) {
            buf.append(' ').append(CREATE_TEMPLATE_ATTRIBUTE_NAME).append("=\"").append(this.isCreateTemplate).append("\"");
        }
        if (this.constructor == null && this.fields.size() == 0 && this.attributes.size() == 0 && this.invokes.size() == 0 && this.depends.size() == 0) {
            buf.append("/>");
        } else {
            Iterator<Object> datas;
            buf.append('>');
            if (this.constructor != null) {
                buf.append(LINE_SEPARATOR);
                buf.append(this.addIndent(this.constructor.toXML(new StringBuffer())));
            }
            if (this.fields.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.fields.values().iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            if (this.attributes.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.attributes.values().iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            if (this.invokes.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.invokes.iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            if (this.depends.size() != 0) {
                buf.append(LINE_SEPARATOR);
                datas = this.depends.iterator();
                while (datas.hasNext()) {
                    buf.append(this.addIndent(((MetaData)datas.next()).toXML(new StringBuffer())));
                    if (!datas.hasNext()) continue;
                    buf.append(LINE_SEPARATOR);
                }
            }
            buf.append(LINE_SEPARATOR);
            buf.append("</").append(SERVICE_TAG_NAME).append('>');
        }
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName());
        buf.append('@');
        buf.append(this.hashCode());
        buf.append('{');
        if (this.getName() != null) {
            buf.append(NAME_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getName());
            buf.append(',');
        }
        buf.append("code");
        buf.append('=');
        buf.append(this.getCode());
        buf.append('}');
        return buf.toString();
    }

    public class DependsMetaData
    extends ServiceNameMetaData
    implements Serializable {
        private static final long serialVersionUID = -2867707582371947233L;

        public DependsMetaData(String manager) {
            super(ServiceMetaData.this, manager);
        }

        public DependsMetaData(String manager, String service) {
            super(ServiceMetaData.this, ServiceMetaData.DEPENDS_TAG_NAME, manager, service);
        }

        public void importXML(Element element) throws DeploymentException {
            if (!element.getTagName().equals(ServiceMetaData.DEPENDS_TAG_NAME)) {
                throw new DeploymentException("Tag must be depends : " + element.getTagName());
            }
            this.tagName = element.getTagName();
            Element serviceElement = DependsMetaData.getOptionalChild(element, ServiceMetaData.SERVICE_TAG_NAME);
            if (serviceElement == null) {
                ServiceMetaData parent = (ServiceMetaData)this.getParent();
                if (parent != null) {
                    this.setManagerName(parent.getManager().getName());
                }
                super.importXML(element);
            } else {
                ServiceMetaData serviceData = new ServiceMetaData(ServiceMetaData.this.myLoader, (MetaData)this, ServiceMetaData.this.manager);
                serviceData.importXML(serviceElement);
                this.setServiceName(serviceData.getName());
                if (ServiceMetaData.this.manager.getService(serviceData.getName()) != null) {
                    throw new DeploymentException("Dupulicated service name : " + serviceData.getName());
                }
                ServiceMetaData.this.manager.addService(serviceData);
                this.setManagerName(ServiceMetaData.this.manager.getName());
            }
        }
    }
}

