/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.InvalidSchemaException;
import jp.ossc.nimbus.util.CsvArrayList;

public class RowSchema
implements Serializable {
    private static final long serialVersionUID = 2519505358076142786L;
    private HashMap mFieldHash = new HashMap();
    private ArrayList mFieldAry = new ArrayList();
    private ArrayList mUniqueKeyAry = new ArrayList();
    private int mHashCode = 0;

    public int getUniqueKeySize() {
        return this.mUniqueKeyAry.size();
    }

    public FieldSchema getUniqueFieldSchema(int index) {
        return (FieldSchema)this.mUniqueKeyAry.get(index);
    }

    public RowSchema makeGoneSchema() {
        RowSchema ret = new RowSchema();
        for (int rcnt = 0; rcnt < this.mFieldAry.size(); ++rcnt) {
            FieldSchema fs = this.get(rcnt);
            FieldSchema newFs = new FieldSchema();
            newFs.setFieldName(fs.getFieldName());
            newFs.setFieldType(fs.getFieldType());
            newFs.setFieldLength(fs.getFieldLength());
            newFs.setFieldKey(fs.getFieldKey());
            newFs.setCrypt(fs.isCrypt());
            if (!fs.isUpdateField()) continue;
            ret.add(newFs);
        }
        return ret;
    }

    public Integer getHashCodeObject() {
        return new Integer(this.mHashCode);
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object another) {
        if (another == null) {
            return false;
        }
        if (this == another) {
            return true;
        }
        return another instanceof RowSchema && this.mHashCode == another.hashCode();
    }

    public void initSchema(String schema) {
        if (this.mFieldAry.size() == 0) {
            CsvArrayList parser = new CsvArrayList();
            parser.splitCL(schema);
            ListIterator ite = parser.listIterator();
            while (ite.hasNext()) {
                String fieldStr = (String)ite.next();
                FieldSchema field = this.makeFieldSchema(fieldStr);
                if (field == null) continue;
                this.add(field);
            }
            this.mHashCode = schema.hashCode();
        }
        this.mFieldAry.trimToSize();
        this.mUniqueKeyAry.trimToSize();
    }

    private FieldSchema makeFieldSchema(String fieldInf) {
        if (fieldInf == null || fieldInf.length() == 0) {
            return null;
        }
        CsvArrayList colInf = new CsvArrayList();
        int sz = colInf.split(fieldInf);
        if (sz < 4) {
            throw new InvalidSchemaException(fieldInf + "invalid");
        }
        FieldSchema field = new FieldSchema();
        field.setFieldName(colInf.getStr(0));
        String tp = colInf.getStr(1);
        field.setFieldType(FieldSchema.getFieldTypeValue(tp));
        field.setFieldLength(Integer.parseInt(colInf.getStr(2)));
        field.setFieldKey(Integer.parseInt(colInf.getStr(3)));
        if (sz > 4) {
            field.setCrypt(Integer.parseInt(colInf.getStr(4)) > 0);
        }
        return field;
    }

    public int size() {
        if (this.mFieldAry == null) {
            return 0;
        }
        return this.mFieldAry.size();
    }

    public FieldSchema get(int index) {
        if (index < 0 || index >= this.mFieldAry.size()) {
            return null;
        }
        return (FieldSchema)this.mFieldAry.get(index);
    }

    public FieldSchema get(String name) {
        return (FieldSchema)this.mFieldHash.get(name);
    }

    public ListIterator listIterator() {
        return this.mFieldAry.listIterator();
    }

    private void add(FieldSchema scm) {
        if (this.mFieldHash.containsKey(scm.getFieldName())) {
            throw new InvalidSchemaException(scm.getFieldName() + "is duplicate");
        }
        this.mFieldHash.put(scm.getFieldName(), scm);
        this.mFieldAry.add(scm);
        scm.setIndex(this.mFieldAry.size() - 1);
        if (scm.isUniqueKey()) {
            this.mUniqueKeyAry.add(scm);
        }
    }
}

