/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.HttpSessionCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ImmutableJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpSessionCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements HttpSessionCSVJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = 3580094015782307984L;
    private static final String ATTRIBUTE_VALUE_SEPARATOR = "=";
    private static final String ATTRIBUTE_SEPARATOR = ",";
    private static final String DEFAULT_SECRET_STRING = "******";
    private String secretString = "******";
    private String[] secretAttributes;
    private Set secretAttributeSet;
    private String[] enabledAttributes;
    private Set enabledAttributeSet;
    private final Map outputElements = new HashMap();
    private String[] outputElementKeys = new String[]{"ID", "CREATION_TIME", "LAST_ACCESSED_TIME", "IS_NEW", "ATTRIBUTES"};

    public HttpSessionCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementEditor("ID", new ElementEditor(){
            private static final long serialVersionUID = 9001837786273205836L;

            protected StringBuffer toString(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
                return HttpSessionCSVJournalEditorService.this.makeIdFormat(finder, key, session, buf);
            }
        });
        this.defineElementEditor("CREATION_TIME", new ElementEditor(){
            private static final long serialVersionUID = 671412588313496349L;

            protected StringBuffer toString(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
                return HttpSessionCSVJournalEditorService.this.makeCreationTimeFormat(finder, key, session, buf);
            }
        });
        this.defineElementEditor("LAST_ACCESSED_TIME", new ElementEditor(){
            private static final long serialVersionUID = -8771078115952112858L;

            protected StringBuffer toString(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
                return HttpSessionCSVJournalEditorService.this.makeLastAccessedTimeFormat(finder, key, session, buf);
            }
        });
        this.defineElementEditor("MAX_INACTIVE_INTERVAL", new ElementEditor(){
            private static final long serialVersionUID = -7031670685353367251L;

            protected StringBuffer toString(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
                return HttpSessionCSVJournalEditorService.this.makeMaxInactiveIntervalFormat(finder, key, session, buf);
            }
        });
        this.defineElementEditor("IS_NEW", new ElementEditor(){
            private static final long serialVersionUID = -822308326118465960L;

            protected StringBuffer toString(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
                return HttpSessionCSVJournalEditorService.this.makeIsNewFormat(finder, key, session, buf);
            }
        });
        this.defineElementEditor("ATTRIBUTES", new ElementEditor(){
            private static final long serialVersionUID = 5294667762611932210L;

            protected StringBuffer toString(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
                return HttpSessionCSVJournalEditorService.this.makeAttributesFormat(finder, key, session, buf);
            }
        });
    }

    protected void defineElementEditor(String key, ElementEditor editor) {
        this.outputElements.put(key, editor);
    }

    protected JournalEditor findElementEditor(String key) {
        return (JournalEditor)this.outputElements.get(key);
    }

    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    public void setSecretString(String str) {
        this.secretString = str;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void createService() {
        this.secretAttributeSet = new HashSet();
        this.enabledAttributeSet = new HashSet();
    }

    public void startService() {
        int i;
        if (this.secretAttributes != null) {
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null) {
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
    }

    public void stopService() {
        this.secretAttributeSet.clear();
        this.enabledAttributeSet.clear();
    }

    public void destroyService() {
        this.secretAttributeSet = null;
        this.enabledAttributeSet = null;
    }

    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            JournalEditor editor = this.findElementEditor(this.outputElementKeys[i]);
            this.addElement(editor.toObject(finder, key, value));
        }
    }

    protected StringBuffer makeIdFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        return buf.append(session.getId());
    }

    protected StringBuffer makeCreationTimeFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        this.makeObjectFormat(finder, key, new Date(session.getCreationTime()), buf);
        return buf;
    }

    protected StringBuffer makeLastAccessedTimeFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        this.makeObjectFormat(finder, key, new Date(session.getLastAccessedTime()), buf);
        return buf;
    }

    protected StringBuffer makeMaxInactiveIntervalFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        return buf.append(session.getMaxInactiveInterval());
    }

    protected StringBuffer makeIsNewFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        return buf.append(session.isNew());
    }

    protected StringBuffer makeAttributesFormat(EditorFinder finder, Object key, HttpSession session, StringBuffer buf) {
        Enumeration attrNames = session.getAttributeNames();
        if (!attrNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        while (attrNames.hasMoreElements()) {
            String name = (String)attrNames.nextElement();
            if (!this.enabledAttributeSet.isEmpty() && !this.enabledAttributeSet.contains(name)) continue;
            buf.append(name);
            buf.append(ATTRIBUTE_VALUE_SEPARATOR);
            if (this.secretAttributeSet.contains(name)) {
                buf.append(this.getSecretString());
            } else {
                this.makeObjectFormat(finder, null, session.getAttribute(name), buf);
            }
            if (!attrNames.hasMoreElements()) continue;
            buf.append(ATTRIBUTE_SEPARATOR);
        }
        return buf;
    }

    protected abstract class ElementEditor
    extends ImmutableJournalEditorServiceBase
    implements Serializable {
        private static final long serialVersionUID = 4112780370192221152L;

        protected ElementEditor() {
        }

        public String toString(EditorFinder finder, Object key, Object value) {
            StringBuffer buf = new StringBuffer(super.toString(finder, key, value));
            return this.toString(finder, key, (HttpSession)value, buf).toString();
        }

        protected abstract StringBuffer toString(EditorFinder var1, Object var2, HttpSession var3, StringBuffer var4);
    }
}

