/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.scheduler2.DatabaseScheduleManagerServiceMBean;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedule;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMakerService;
import jp.ossc.nimbus.service.scheduler2.DefaultScheduleMaster;
import jp.ossc.nimbus.service.scheduler2.Schedule;
import jp.ossc.nimbus.service.scheduler2.ScheduleControlListener;
import jp.ossc.nimbus.service.scheduler2.ScheduleMakeException;
import jp.ossc.nimbus.service.scheduler2.ScheduleMaker;
import jp.ossc.nimbus.service.scheduler2.ScheduleManageException;
import jp.ossc.nimbus.service.scheduler2.ScheduleManager;
import jp.ossc.nimbus.service.scheduler2.ScheduleStateControlException;

public class DatabaseScheduleManagerService
extends ServiceBase
implements ScheduleManager,
DatabaseScheduleManagerServiceMBean {
    private static final long serialVersionUID = -768179222440496616L;
    protected Properties scheduleMakerTypeMapping;
    protected Map addedScheduleMakerMap;
    protected Map scheduleMakerMap;
    protected ServiceName defaultScheduleMakerServiceName;
    protected ScheduleMaker defaultScheduleMaker;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    protected ScheduleMasterTableSchema scheduleMasterTableSchema = new ScheduleMasterTableSchema();
    protected ScheduleDependsMasterTableSchema scheduleDependsMasterTableSchema = new ScheduleDependsMasterTableSchema();
    protected ScheduleTableSchema scheduleTableSchema = new ScheduleTableSchema();
    protected ScheduleDependsTableSchema scheduleDependsTableSchema = new ScheduleDependsTableSchema();
    protected String nextScheduleIdSelectQuery;
    protected String dateFormat = "yyyyMMdd";
    protected String timeFormat = "HHmmssSSS";
    protected String updateUserId;
    protected Set scheduleControlListeners;
    protected boolean isMakeScheduleOnStart = true;
    protected long controlStateCheckInterval = 1000L;
    protected Daemon controlStateChecker;
    protected long timeoverCheckInterval = 1000L;
    protected Daemon timeoverChecker;
    protected boolean isLockForFindExecutable;

    public void setDefaultScheduleMakerServiceName(ServiceName name) {
        this.defaultScheduleMakerServiceName = name;
    }

    public ServiceName getDefaultScheduleMakerServiceName() {
        return this.defaultScheduleMakerServiceName;
    }

    public void setScheduleMakerTypeMapping(Properties mapping) {
        this.scheduleMakerTypeMapping = mapping;
    }

    public Properties getScheduleMakerTypeMapping() {
        return this.scheduleMakerTypeMapping;
    }

    public void setConnectionFactoryServiceName(ServiceName name) {
        this.connectionFactoryServiceName = name;
    }

    public ServiceName getConnectionFactoryServiceName() {
        return this.connectionFactoryServiceName;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setUpdateUserId(String id) {
        this.updateUserId = id;
    }

    public String getUpdateUserId() {
        return this.updateUserId;
    }

    public ScheduleMasterTableSchema getScheduleMasterTableSchema() {
        return this.scheduleMasterTableSchema;
    }

    public void setScheduleMasterTableSchema(ScheduleMasterTableSchema schema) {
        this.scheduleMasterTableSchema = schema;
    }

    public ScheduleDependsMasterTableSchema getScheduleDependsMasterTableSchema() {
        return this.scheduleDependsMasterTableSchema;
    }

    public void setScheduleDependsMasterTableSchema(ScheduleDependsMasterTableSchema schema) {
        this.scheduleDependsMasterTableSchema = schema;
    }

    public ScheduleTableSchema getScheduleTableSchema() {
        return this.scheduleTableSchema;
    }

    public void setScheduleTableSchema(ScheduleTableSchema schema) {
        this.scheduleTableSchema = schema;
    }

    public ScheduleDependsTableSchema getScheduleDependsTableSchema() {
        return this.scheduleDependsTableSchema;
    }

    public void setScheduleDependsTableSchema(ScheduleDependsTableSchema schema) {
        this.scheduleDependsTableSchema = schema;
    }

    public void setNextScheduleIdSelectQuery(String query) {
        this.nextScheduleIdSelectQuery = query;
    }

    public String getNextScheduleIdSelectQuery() {
        return this.nextScheduleIdSelectQuery;
    }

    public void setMakeScheduleOnStart(boolean isMake) {
        this.isMakeScheduleOnStart = isMake;
    }

    public boolean isMakeScheduleOnStart() {
        return this.isMakeScheduleOnStart;
    }

    public void setControlStateCheckInterval(long interval) {
        this.controlStateCheckInterval = interval;
    }

    public long getControlStateCheckInterval() {
        return this.controlStateCheckInterval;
    }

    public void setTimeoverCheckInterval(long interval) {
        this.timeoverCheckInterval = interval;
    }

    public long getTimeoverCheckInterval() {
        return this.timeoverCheckInterval;
    }

    public void setLockForFindExecutable(boolean isLock) {
        this.isLockForFindExecutable = isLock;
    }

    public boolean isLockForFindExecutable() {
        return this.isLockForFindExecutable;
    }

    public void createService() throws Exception {
        this.scheduleMakerMap = new HashMap();
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = Collections.synchronizedSet(new LinkedHashSet());
    }

    public void startService() throws Exception {
        Date now;
        List oldScheduleList;
        if (this.scheduleMakerTypeMapping != null && this.scheduleMakerTypeMapping.size() != 0) {
            ServiceNameEditor editor = new ServiceNameEditor();
            editor.setServiceManagerName(this.getServiceManagerName());
            Iterator<Map.Entry<Object, Object>> entries = this.scheduleMakerTypeMapping.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, Object> entry = entries.next();
                editor.setAsText((String)entry.getValue());
                ServiceName scheduleMakerServiceName = (ServiceName)editor.getValue();
                ScheduleMaker scheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(scheduleMakerServiceName);
                if (this.scheduleMakerMap.containsKey(entry.getKey())) {
                    throw new IllegalArgumentException("Dupulicate scheduleMakerTypeMapping : " + entry.getKey());
                }
                this.scheduleMakerMap.put(entry.getKey(), scheduleMaker);
            }
        }
        if (this.defaultScheduleMakerServiceName != null) {
            this.defaultScheduleMaker = (ScheduleMaker)ServiceManagerFactory.getServiceObject(this.defaultScheduleMakerServiceName);
        }
        if (this.defaultScheduleMaker == null) {
            DefaultScheduleMakerService defaultScheduleMakerService = new DefaultScheduleMakerService();
            defaultScheduleMakerService.create();
            defaultScheduleMakerService.start();
            this.defaultScheduleMaker = defaultScheduleMakerService;
        }
        if (this.connectionFactoryServiceName != null) {
            this.connectionFactory = (ConnectionFactory)ServiceManagerFactory.getServiceObject(this.connectionFactoryServiceName);
        }
        if (this.connectionFactory == null) {
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if (this.updateUserId == null) {
            this.updateUserId = InetAddress.getLocalHost().getHostName();
        }
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        format.applyPattern(this.timeFormat);
        if (this.isMakeScheduleOnStart && ((oldScheduleList = this.findSchedules(now = new Date())) == null || oldScheduleList.size() == 0)) {
            this.makeSchedule(now);
        }
        if (this.controlStateCheckInterval > 0L && this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus SchedulerManagerControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.start();
        }
        if (this.timeoverCheckInterval > 0L) {
            this.timeoverChecker = new Daemon(new TimeoverChecker());
            this.timeoverChecker.setName("Nimbus SchedulerManagerTimeoverChecker " + this.getServiceNameObject());
            this.timeoverChecker.start();
        }
    }

    public void stopService() throws Exception {
        if (this.controlStateChecker != null) {
            this.controlStateChecker.stop();
            this.controlStateChecker = null;
        }
        if (this.timeoverChecker != null) {
            this.timeoverChecker.stop();
            this.timeoverChecker = null;
        }
        if (this.scheduleMakerMap != null) {
            this.scheduleMakerMap.clear();
        }
    }

    public void destroyService() throws Exception {
        this.scheduleMakerMap = null;
        this.addedScheduleMakerMap = null;
        this.scheduleControlListeners = null;
    }

    /*
     * Loose catch block
     */
    public void makeSchedule(Date date) throws ScheduleMakeException {
        block49: {
            SQLException e32;
            ResultSet rs;
            Statement ps2;
            Statement ps1;
            Statement st;
            Connection con;
            block45: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleMakeException(e2);
                }
                st = null;
                ps1 = null;
                ps2 = null;
                rs = null;
                HashMap<String, HashSet<String>> dependsMasterMap = new HashMap<String, HashSet<String>>();
                st = con.createStatement();
                rs = st.executeQuery("select * from " + this.scheduleDependsMasterTableSchema.table);
                while (rs.next()) {
                    String id = rs.getString(this.scheduleDependsMasterTableSchema.id);
                    HashSet<String> dependsIdSet = (HashSet<String>)dependsMasterMap.get(id);
                    if (dependsIdSet == null) {
                        dependsIdSet = new HashSet<String>();
                        dependsMasterMap.put(id, dependsIdSet);
                    }
                    dependsIdSet.add(rs.getString(this.scheduleDependsMasterTableSchema.dependsId));
                }
                rs.close();
                rs = null;
                if (st == null) {
                    st = con.createStatement();
                }
                rs = st.executeQuery("select * from " + this.scheduleMasterTableSchema.table);
                st = con.createStatement();
                ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
                ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,'0','" + this.updateUserId + "',?)");
                SimpleDateFormat timeFormatter = new SimpleDateFormat(this.timeFormat);
                while (rs.next()) {
                    Schedule[] schedules;
                    ScheduleMaker maker;
                    DefaultScheduleMaster scheduleMaster = new DefaultScheduleMaster();
                    scheduleMaster.setId(rs.getString(this.scheduleMasterTableSchema.id));
                    scheduleMaster.setTaskName(rs.getString(this.scheduleMasterTableSchema.taskName));
                    scheduleMaster.setScheduleType(rs.getString(this.scheduleMasterTableSchema.scheduleType));
                    scheduleMaster.setInput(rs.getObject(this.scheduleMasterTableSchema.input));
                    String str = rs.getString(this.scheduleMasterTableSchema.startTime);
                    if (str != null) {
                        scheduleMaster.setStartTime(timeFormatter.parse(str));
                    }
                    if ((str = rs.getString(this.scheduleMasterTableSchema.endTime)) != null) {
                        scheduleMaster.setEndTime(timeFormatter.parse(str));
                    }
                    long longVal = rs.getLong(this.scheduleMasterTableSchema.repeatInterval);
                    if (!rs.wasNull()) {
                        scheduleMaster.setRepeatInterval(longVal);
                    }
                    longVal = rs.getLong(this.scheduleMasterTableSchema.retryInterval);
                    if (!rs.wasNull()) {
                        scheduleMaster.setRetryInterval(longVal);
                    }
                    if ((str = rs.getString(this.scheduleMasterTableSchema.retryEndTime)) != null) {
                        scheduleMaster.setRetryEndTime(timeFormatter.parse(str));
                    }
                    longVal = rs.getLong(this.scheduleMasterTableSchema.maxDelayTime);
                    if (!rs.wasNull()) {
                        scheduleMaster.setMaxDelayTime(longVal);
                    }
                    Object obj = rs.getObject(this.scheduleMasterTableSchema.enable);
                    boolean isEnabled = true;
                    isEnabled = obj instanceof Boolean ? (Boolean)obj : (obj instanceof Number ? ((Number)obj).intValue() != 0 : (obj == null ? false : Boolean.valueOf(obj.toString())));
                    scheduleMaster.setEnabled(isEnabled);
                    Set dependsIdSet = (Set)dependsMasterMap.get(scheduleMaster.getId());
                    if (dependsIdSet != null) {
                        scheduleMaster.setDepends(dependsIdSet.toArray(new String[dependsIdSet.size()]));
                    }
                    if ((maker = (ScheduleMaker)this.scheduleMakerMap.get(scheduleMaster.getScheduleType())) == null) {
                        maker = this.defaultScheduleMaker;
                    }
                    if (!scheduleMaster.isEnabled() || (schedules = maker.makeSchedule(date, scheduleMaster)) == null || schedules.length == 0) continue;
                    for (int i = 0; i < schedules.length; ++i) {
                        this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, schedules[i]);
                    }
                }
                Object var20_22 = null;
                if (st == null) break block45;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block49;
            {
                catch (ScheduleManageException e4) {
                    throw new ScheduleMakeException(e4);
                }
                catch (ParseException e5) {
                    throw new ScheduleMakeException(e5);
                }
                catch (SQLException e6) {
                    throw new ScheduleMakeException(e6);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var20_23 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (ps1 != null) {
                    try {
                        ps1.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected void addSchedule(Schedule schedule, boolean isCreateId) throws ScheduleManageException {
        block29: {
            SQLException e32;
            Statement ps2;
            Statement ps1;
            Statement st;
            Connection con;
            block26: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                ps1 = null;
                ps2 = null;
                if (isCreateId) {
                    st = con.createStatement();
                }
                ps1 = con.prepareStatement("insert into " + this.scheduleTableSchema.table + " (" + this.scheduleTableSchema.id + ',' + this.scheduleTableSchema.masterId + ',' + this.scheduleTableSchema.date + ',' + this.scheduleTableSchema.time + ',' + this.scheduleTableSchema.taskName + ',' + this.scheduleTableSchema.input + ',' + this.scheduleTableSchema.output + ',' + this.scheduleTableSchema.initialDate + ',' + this.scheduleTableSchema.initialTime + ',' + this.scheduleTableSchema.retryInterval + ',' + this.scheduleTableSchema.retryEndTime + ',' + this.scheduleTableSchema.maxDelayTime + ',' + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.checkState + ',' + this.scheduleTableSchema.executorKey + ',' + this.scheduleTableSchema.executeStartTime + ',' + this.scheduleTableSchema.executeEndTime + ',' + this.scheduleTableSchema.rowVersion + ',' + this.scheduleTableSchema.updateUserId + ',' + this.scheduleTableSchema.updateTime + ") values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'0','" + this.updateUserId + "',?)");
                ps2 = con.prepareStatement("insert into " + this.scheduleDependsTableSchema.table + " (" + this.scheduleDependsTableSchema.id + ',' + this.scheduleDependsTableSchema.dependsId + ',' + this.scheduleDependsTableSchema.rowVersion + ',' + this.scheduleDependsTableSchema.updateUserId + ',' + this.scheduleDependsTableSchema.updateTime + ") values(?,?,'0','" + this.updateUserId + "',?)");
                this.addSchedule(st, (PreparedStatement)ps1, (PreparedStatement)ps2, schedule);
                Object var9_8 = null;
                if (st == null) break block26;
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (ps2 != null) {
                try {
                    ps2.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block29;
            {
                catch (SQLException e4) {
                    throw new ScheduleManageException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var9_9 = null;
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (ps1 != null) {
                    try {
                        ps1.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (ps2 != null) {
                    try {
                        ps2.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addSchedule(Statement nextScheduleIdStatement, PreparedStatement scheduleInsertStatement, PreparedStatement scheduleDependsInsertStatement, Schedule schedule) throws ScheduleManageException {
        ResultSet rs = null;
        try {
            try {
                Date initialTime;
                if (nextScheduleIdStatement != null) {
                    rs = nextScheduleIdStatement.executeQuery(this.nextScheduleIdSelectQuery);
                    rs.next();
                    schedule.setId(rs.getObject(1).toString());
                    rs.close();
                    rs = null;
                }
                scheduleInsertStatement.setString(1, schedule.getId());
                scheduleInsertStatement.setString(2, schedule.getMasterId());
                SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
                if (schedule.getTime() == null) {
                    scheduleInsertStatement.setNull(3, 1);
                } else {
                    scheduleInsertStatement.setString(3, format.format(schedule.getTime()));
                }
                format.applyPattern(this.timeFormat);
                if (schedule.getTime() == null) {
                    scheduleInsertStatement.setNull(4, 1);
                } else {
                    scheduleInsertStatement.setString(4, format.format(schedule.getTime()));
                }
                scheduleInsertStatement.setString(5, schedule.getTaskName());
                if (schedule.getInput() == null) {
                    scheduleInsertStatement.setNull(6, 12);
                } else {
                    scheduleInsertStatement.setString(6, schedule.getInput().toString());
                }
                if (schedule.getOutput() == null) {
                    scheduleInsertStatement.setNull(7, 12);
                } else {
                    scheduleInsertStatement.setString(7, schedule.getOutput().toString());
                }
                format.applyPattern(this.dateFormat);
                Date date = initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                if (initialTime == null) {
                    scheduleInsertStatement.setNull(8, 1);
                } else {
                    scheduleInsertStatement.setString(8, format.format(initialTime));
                }
                format.applyPattern(this.timeFormat);
                if (initialTime == null) {
                    scheduleInsertStatement.setNull(9, 1);
                } else {
                    scheduleInsertStatement.setString(9, format.format(initialTime));
                }
                if (schedule.getRetryInterval() > 0L) {
                    scheduleInsertStatement.setLong(10, schedule.getRetryInterval());
                } else {
                    scheduleInsertStatement.setNull(10, 3);
                }
                if (schedule.getRetryEndTime() == null) {
                    scheduleInsertStatement.setNull(11, 1);
                } else {
                    scheduleInsertStatement.setString(11, format.format(schedule.getRetryEndTime()));
                }
                if (schedule.getMaxDelayTime() > 0L) {
                    scheduleInsertStatement.setLong(12, schedule.getMaxDelayTime());
                } else {
                    scheduleInsertStatement.setNull(12, 3);
                }
                scheduleInsertStatement.setString(13, this.scheduleTableSchema.getStateString(schedule.getState()));
                scheduleInsertStatement.setString(14, this.scheduleTableSchema.getControlStateString(schedule.getControlState()));
                scheduleInsertStatement.setString(15, this.scheduleTableSchema.getCheckStateString(schedule.getCheckState()));
                if (schedule.getExecutorKey() == null) {
                    scheduleInsertStatement.setNull(16, 12);
                } else {
                    scheduleInsertStatement.setString(16, schedule.getExecutorKey());
                }
                format.applyPattern(this.dateFormat + this.timeFormat);
                if (schedule.getExecuteStartTime() == null) {
                    scheduleInsertStatement.setNull(17, 1);
                } else {
                    scheduleInsertStatement.setString(17, format.format(schedule.getExecuteStartTime()));
                }
                if (schedule.getExecuteEndTime() == null) {
                    scheduleInsertStatement.setNull(18, 1);
                } else {
                    scheduleInsertStatement.setString(18, format.format(schedule.getExecuteEndTime()));
                }
                Timestamp now = new Timestamp(System.currentTimeMillis());
                scheduleInsertStatement.setTimestamp(19, now);
                scheduleInsertStatement.executeUpdate();
                String[] depends = schedule.getDepends();
                if (depends != null && depends.length != 0) {
                    if (scheduleDependsInsertStatement == null) {
                        throw new ScheduleManageException("ScheduleDependsInsertQuery is null.");
                    }
                    for (int i = 0; i < depends.length; ++i) {
                        scheduleDependsInsertStatement.setString(1, schedule.getId());
                        scheduleDependsInsertStatement.setString(2, depends[i]);
                        scheduleDependsInsertStatement.setTimestamp(3, now);
                        scheduleDependsInsertStatement.executeUpdate();
                    }
                }
                Object var12_12 = null;
                if (rs == null) return;
            }
            catch (SQLException e) {
                throw new ScheduleManageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        rs.close();
        return;
    }

    public void setScheduleMaker(String scheduleType, ScheduleMaker maker) throws IllegalArgumentException {
        if (this.addedScheduleMakerMap == null) {
            this.addedScheduleMakerMap = new HashMap();
        }
        if (this.addedScheduleMakerMap.containsKey(scheduleType)) {
            throw new IllegalArgumentException("Dupulicate scheduleType : " + scheduleType);
        }
        this.addedScheduleMakerMap.put(scheduleType, maker);
    }

    public ScheduleMaker getScheduleMaker(String scheduleType) {
        return (ScheduleMaker)this.scheduleMakerMap.get(scheduleType);
    }

    public void setDefaultScheduleMaker(ScheduleMaker maker) {
        this.defaultScheduleMaker = maker;
    }

    public ScheduleMaker getDefaultScheduleMaker() {
        return this.defaultScheduleMaker;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findAllSchedules() throws ScheduleManageException {
        block25: {
            block21: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e) {
                    throw new ScheduleManageException(e);
                }
                st = null;
                rs = null;
                try {
                    try {
                        st = con.createStatement();
                        rs = st.executeQuery("select * from " + this.scheduleTableSchema.table);
                        result = new ArrayList<Schedule>();
                        while (rs.next()) {
                            result.add(this.createSchedule(rs));
                        }
                        var5_8 = result;
                        var7_9 = null;
                        if (rs == null) break block21;
                    }
                    catch (ParseException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (SQLException e) {
                        throw new ScheduleManageException(e);
                    }
                }
                catch (Throwable var6_13) {
                    var7_10 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (con == null) throw var6_13;
                    try {
                        con.close();
                        throw var6_13;
                    }
                    catch (SQLException e) {
                        throw var6_13;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [5 : 150->159)] { 
lbl52:
                // 1 sources

                rs.close();
                break block21;
lbl54:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 165->174)] { 
lbl59:
                // 1 sources

                st.close();
                break block25;
lbl61:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var5_8;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var5_8;
        }
        con.close();
        return var5_8;
    }

    protected Schedule createSchedule(ResultSet rs) throws SQLException, ParseException {
        String executeEndTimeStr;
        String retryEndTimeStr;
        DefaultSchedule schedule = new DefaultSchedule();
        schedule.setId(rs.getString(this.scheduleTableSchema.id));
        schedule.setMasterId(rs.getString(this.scheduleTableSchema.masterId));
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
        String str = rs.getString(this.scheduleTableSchema.date) + rs.getString(this.scheduleTableSchema.time);
        schedule.setTime(format.parse(str));
        schedule.setTaskName(rs.getString(this.scheduleTableSchema.taskName));
        schedule.setInput(rs.getObject(this.scheduleTableSchema.input));
        schedule.setOutput(rs.getObject(this.scheduleTableSchema.output));
        str = rs.getString(this.scheduleTableSchema.initialDate) + rs.getString(this.scheduleTableSchema.initialTime);
        schedule.setInitialTime(format.parse(str));
        long longVal = rs.getLong(this.scheduleTableSchema.retryInterval);
        if (!rs.wasNull()) {
            schedule.setRetryInterval(longVal);
        }
        if ((retryEndTimeStr = rs.getString(this.scheduleTableSchema.retryEndTime)) != null) {
            str = rs.getString(this.scheduleTableSchema.date) + retryEndTimeStr;
            schedule.setRetryEndTime(format.parse(str));
        }
        longVal = rs.getLong(this.scheduleTableSchema.maxDelayTime);
        if (!rs.wasNull()) {
            schedule.setMaxDelayTime(longVal);
        }
        schedule.setState(this.scheduleTableSchema.getState(rs.getString(this.scheduleTableSchema.state)));
        schedule.setControlState(this.scheduleTableSchema.getControlState(rs.getString(this.scheduleTableSchema.controlState)));
        schedule.setCheckState(this.scheduleTableSchema.getCheckState(rs.getString(this.scheduleTableSchema.checkState)));
        schedule.setExecutorKey(rs.getString(this.scheduleTableSchema.executorKey));
        String executeStartTimeStr = rs.getString(this.scheduleTableSchema.executeStartTime);
        if (executeStartTimeStr != null) {
            schedule.setExecuteStartTime(format.parse(executeStartTimeStr));
        }
        if ((executeEndTimeStr = rs.getString(this.scheduleTableSchema.executeEndTime)) != null) {
            schedule.setExecuteEndTime(format.parse(executeEndTimeStr));
        }
        return schedule;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schedule findSchedule(String id) throws ScheduleManageException {
        block33: {
            block32: {
                block28: {
                    block31: {
                        block26: {
                            block27: {
                                con = null;
                                try {
                                    con = this.connectionFactory.getConnection();
                                }
                                catch (ConnectionFactoryException e) {
                                    throw new ScheduleManageException(e);
                                }
                                st = null;
                                rs = null;
                                try {
                                    try {
                                        st = con.prepareStatement("select * from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                        st.setString(1, id);
                                        rs = st.executeQuery();
                                        if (!rs.next()) {
                                            var5_6 = null;
                                            var7_10 = null;
                                            if (rs == null) break block26;
                                            break block27;
                                        }
                                        var5_7 = this.createSchedule(rs);
                                        break block28;
                                    }
                                    catch (ParseException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                    catch (SQLException e) {
                                        throw new ScheduleManageException(e);
                                    }
                                }
                                catch (Throwable var6_16) {
                                    var7_12 = null;
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (st != null) {
                                        try {
                                            st.close();
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (con == null) throw var6_16;
                                    try {
                                        con.close();
                                        throw var6_16;
                                    }
                                    catch (SQLException e) {
                                        throw var6_16;
                                    }
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [8 : 172->182)] { 
lbl52:
                            // 1 sources

                            rs.close();
                            break block26;
lbl54:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            ** try [egrp 4[TRYBLOCK] [9 : 188->197)] { 
lbl59:
                            // 1 sources

                            st.close();
                            break block31;
lbl61:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var5_6;
                    ** try [egrp 5[TRYBLOCK] [10 : 203->212)] { 
lbl66:
                    // 1 sources

                    con.close();
                    return var5_6;
lbl68:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var5_6;
                }
                var7_11 = null;
                if (rs != null) {
                    ** try [egrp 3[TRYBLOCK] [8 : 172->182)] { 
lbl75:
                    // 1 sources

                    rs.close();
                    break block32;
lbl77:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [9 : 188->197)] { 
lbl82:
                // 1 sources

                st.close();
                break block33;
lbl84:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var5_7;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var5_7;
        }
        con.close();
        return var5_7;
    }

    public List findSchedules(Date date) throws ScheduleManageException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date from = cal.getTime();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        Date to = cal.getTime();
        return this.findSchedules(from, to);
    }

    public List findSchedules(Date from, Date to) throws ScheduleManageException {
        return this.findSchedules(from, to, null);
    }

    public List findSchedules(int[] states) throws ScheduleManageException {
        return this.findSchedules(null, null, states);
    }

    public List findSchedules(Date from, Date to, int[] states) throws ScheduleManageException {
        return this.findSchedules(from, to, states, null, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List findSchedules(Date from, Date to, int[] states, String executorKey, boolean isLock) throws ScheduleManageException {
        block44: {
            block40: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e) {
                    throw new ScheduleManageException(e);
                }
                st = null;
                rs = null;
                try {
                    try {
                        buf = new StringBuffer();
                        buf.append("select * from ");
                        buf.append(this.scheduleTableSchema.table);
                        isAppendWhere = false;
                        if (from != null) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            }
                            buf.append(this.scheduleTableSchema.date);
                            buf.append("||");
                            buf.append(this.scheduleTableSchema.time);
                            buf.append(">=?");
                        }
                        if (to != null) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and ");
                            }
                            buf.append(this.scheduleTableSchema.date);
                            buf.append("||");
                            buf.append(this.scheduleTableSchema.time);
                            buf.append("<=?");
                        }
                        if (states != null && states.length != 0) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and (");
                            }
                            for (i = 0; i < states.length; ++i) {
                                buf.append(this.scheduleTableSchema.state);
                                buf.append("=?");
                                if (i == states.length - 1) continue;
                                buf.append(" or ");
                            }
                            if (from != null || to != null) {
                                buf.append(')');
                            }
                        }
                        if (executorKey != null) {
                            if (!isAppendWhere) {
                                buf.append(" where ");
                                isAppendWhere = true;
                            } else {
                                buf.append(" and (");
                            }
                            buf.append(this.scheduleTableSchema.executorKey);
                            buf.append(" is null or ");
                            buf.append(this.scheduleTableSchema.executorKey);
                            buf.append(" =?)");
                        }
                        if (isLock) {
                            buf.append(" for update");
                        }
                        st = con.prepareStatement(buf.toString());
                        buf = null;
                        format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
                        index = 0;
                        if (from != null) {
                            st.setString(++index, format.format(from));
                        }
                        if (to != null) {
                            st.setString(++index, format.format(to));
                        }
                        if (states != null && states.length != 0) {
                            for (i = 0; i < states.length; ++i) {
                                st.setString(++index, this.scheduleTableSchema.getStateString(states[i]));
                            }
                        }
                        if (executorKey != null) {
                            st.setString(++index, executorKey);
                        }
                        rs = st.executeQuery();
                        result = new ArrayList<Schedule>();
                        while (rs.next()) {
                            result.add(this.createSchedule(rs));
                        }
                        Collections.sort(result);
                        var14_19 = result;
                        var16_20 = null;
                        if (rs == null) break block40;
                    }
                    catch (ParseException e) {
                        throw new ScheduleManageException(e);
                    }
                    catch (SQLException e) {
                        throw new ScheduleManageException(e);
                    }
                }
                catch (Throwable var15_24) {
                    var16_21 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (con == null) throw var15_24;
                    try {
                        con.close();
                        throw var15_24;
                    }
                    catch (SQLException e) {
                        throw var15_24;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [5 : 675->685)] { 
lbl140:
                // 1 sources

                rs.close();
                break block40;
lbl142:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (st != null) {
                ** try [egrp 4[TRYBLOCK] [6 : 692->702)] { 
lbl147:
                // 1 sources

                st.close();
                break block44;
lbl149:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return var14_19;
        try {}
        catch (SQLException e) {
            // empty catch block
            return var14_19;
        }
        con.close();
        return var14_19;
    }

    public List findExecutableSchedules(Date date) throws ScheduleManageException {
        return this.findExecutableSchedules(date, null);
    }

    /*
     * Loose catch block
     */
    public List findExecutableSchedules(Date date, String executorKey) throws ScheduleManageException {
        SQLException e32;
        List list;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            List result = this.findSchedules(null, date, new int[]{1, 8}, executorKey, this.isLockForFindExecutable);
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select count(1) from " + this.scheduleTableSchema.table + " A, (select " + this.scheduleDependsTableSchema.dependsId + " from " + this.scheduleDependsTableSchema.table + " where " + this.scheduleDependsTableSchema.id + "=?) B where A." + this.scheduleTableSchema.masterId + "=B." + this.scheduleDependsTableSchema.dependsId + " and A." + this.scheduleTableSchema.state + "<>'" + this.scheduleTableSchema.stateString_END + '\'' + " and A." + this.scheduleTableSchema.initialDate + "||A." + this.scheduleTableSchema.initialTime + "<=?");
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            Iterator itr = result.iterator();
            while (itr.hasNext()) {
                Schedule schedule = (Schedule)itr.next();
                st.setString(1, schedule.getId());
                Date initialTime = schedule.getInitialTime() == null ? schedule.getTime() : schedule.getInitialTime();
                st.setString(2, format.format(initialTime));
                rs = st.executeQuery();
                rs.next();
                if (rs.getInt(1) == 0) continue;
                itr.remove();
            }
            Collections.sort(result);
            list = result;
            Object var12_13 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return list;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var12_14 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    public void addSchedule(Schedule schedule) throws ScheduleManageException {
        this.addSchedule(schedule, true);
    }

    public void addSchedule(String masterId, Date time, String taskName, Object input, String[] depends, long retryInterval, Date retryEndTime, long maxDelayTime) throws ScheduleManageException {
        this.addSchedule(new DefaultSchedule(masterId, time, taskName, input, depends, retryInterval, retryEndTime, maxDelayTime));
    }

    /*
     * Loose catch block
     */
    public boolean reschedule(String id, Date time) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select " + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            int rowVersion = rs.getInt(1);
            rs.close();
            rs = null;
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.date + "=?, " + this.scheduleTableSchema.time + "=?," + this.scheduleTableSchema.checkState + "='" + this.scheduleTableSchema.getCheckStateString(1) + "'," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
            st.setString(1, format.format(time));
            format.applyPattern(this.timeFormat);
            st.setString(2, format.format(time));
            st.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            st.setString(4, id);
            bl = st.executeUpdate() != 0;
            Object var10_11 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var10_12 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean removeSchedule(String id) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        Statement st;
        Connection con;
        block14: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            bl = st.executeUpdate() != 0;
            Object var6_7 = null;
            if (st == null) break block14;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block16: {
                    SQLException e32;
                    Object var6_8 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block16;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean removeScheduleByMasterId(String masterId) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        Statement st;
        Connection con;
        block14: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.masterId + "=?");
            st.setString(1, masterId);
            bl = st.executeUpdate() != 0;
            Object var6_7 = null;
            if (st == null) break block14;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block16: {
                    SQLException e32;
                    Object var6_8 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block16;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean removeSchedule(Date date) throws ScheduleManageException {
        SQLException e32;
        boolean bl;
        Statement st;
        Connection con;
        block14: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleManageException(e2);
            }
            st = null;
            st = con.prepareStatement("delete from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.date + "=?");
            st.setString(1, new SimpleDateFormat(this.dateFormat).format(date));
            bl = st.executeUpdate() != 0;
            Object var6_7 = null;
            if (st == null) break block14;
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleManageException(e4);
            }
            catch (Throwable throwable) {
                block16: {
                    SQLException e32;
                    Object var6_8 = null;
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block16;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public void setExecutorKey(String id, String key) throws ScheduleManageException {
        block24: {
            SQLException e32;
            ResultSet rs;
            Statement st;
            Connection con;
            block22: {
                con = null;
                try {
                    con = this.connectionFactory.getConnection();
                }
                catch (ConnectionFactoryException e2) {
                    throw new ScheduleManageException(e2);
                }
                st = null;
                rs = null;
                st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.executorKey + "=?," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
                if (key == null) {
                    st.setNull(1, 12);
                } else {
                    st.setString(1, key);
                }
                st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                st.setString(3, id);
                st.executeUpdate();
                Object var8_7 = null;
                if (rs == null) break block22;
                try {
                    rs.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e32) {
                    // empty catch block
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e32) {}
            }
            break block24;
            {
                catch (SQLException e4) {
                    throw new ScheduleManageException(e4);
                }
            }
            catch (Throwable throwable) {
                SQLException e32;
                Object var8_8 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getState(String id) throws ScheduleStateControlException {
        SQLException e32;
        int n;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleStateControlException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select " + this.scheduleTableSchema.state + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            n = this.scheduleTableSchema.getState(rs.getString(1));
            Object var7_8 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return n;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var7_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public int getControlState(String id) throws ScheduleStateControlException {
        SQLException e32;
        int n;
        ResultSet rs;
        Statement st;
        Connection con;
        block20: {
            con = null;
            try {
                con = this.connectionFactory.getConnection();
            }
            catch (ConnectionFactoryException e2) {
                throw new ScheduleStateControlException(e2);
            }
            st = null;
            rs = null;
            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
            st.setString(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new ScheduleStateControlException("Schedule not found : " + id);
            }
            n = this.scheduleTableSchema.getControlState(rs.getString(1));
            Object var7_8 = null;
            if (rs == null) break block20;
            try {
                rs.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e32) {
                // empty catch block
            }
        }
        return n;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block23: {
                    SQLException e32;
                    Object var7_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e32) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block23;
                    try {
                        con.close();
                    }
                    catch (SQLException e32) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean changeState(String id, int state) throws ScheduleStateControlException {
        SQLException e222222;
        boolean bl;
        ResultSet rs;
        Statement st;
        Connection con;
        block38: {
            String newStateStr;
            int rowVersion;
            Date executeEndTime;
            Date executeStartTime;
            boolean isUpdateExecuteEndTime;
            boolean isUpdateExecuteStartTime;
            block34: {
                SQLException e222222;
                boolean bl2;
                block35: {
                    isUpdateExecuteStartTime = false;
                    isUpdateExecuteEndTime = false;
                    executeStartTime = null;
                    executeEndTime = null;
                    switch (state) {
                        case 3: {
                            executeStartTime = new Date();
                            isUpdateExecuteStartTime = true;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 7: {
                            executeEndTime = new Date();
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 1: 
                        case 2: {
                            isUpdateExecuteStartTime = true;
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            break;
                        }
                        default: {
                            throw new ScheduleStateControlException("Unknown state : " + state);
                        }
                    }
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e3) {
                        throw new ScheduleStateControlException(e3);
                    }
                    st = null;
                    rs = null;
                    st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                    st.setString(1, id);
                    rs = st.executeQuery();
                    if (!rs.next()) {
                        throw new ScheduleStateControlException("Schedule not found : " + id);
                    }
                    String oldStateStr = rs.getString(1);
                    rowVersion = rs.getInt(2);
                    rs.close();
                    rs = null;
                    newStateStr = this.scheduleTableSchema.getStateString(state);
                    if (!oldStateStr.equals(newStateStr)) break block34;
                    bl2 = false;
                    Object var17_17 = null;
                    if (rs == null) break block35;
                    try {
                        rs.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0;
            Object var17_18 = null;
            if (rs == null) break block38;
            try {
                rs.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block41: {
                    SQLException e222222;
                    Object var17_19 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block41;
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean changeState(String id, int oldState, int newState) throws ScheduleStateControlException {
        SQLException e222222;
        boolean bl;
        ResultSet rs;
        Statement st;
        Connection con;
        block38: {
            String newStateStr;
            int rowVersion;
            Date executeEndTime;
            Date executeStartTime;
            boolean isUpdateExecuteEndTime;
            boolean isUpdateExecuteStartTime;
            block34: {
                SQLException e222222;
                boolean bl2;
                block35: {
                    isUpdateExecuteStartTime = false;
                    isUpdateExecuteEndTime = false;
                    executeStartTime = null;
                    executeEndTime = null;
                    switch (newState) {
                        case 3: {
                            executeStartTime = new Date();
                            isUpdateExecuteStartTime = true;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 7: {
                            executeEndTime = new Date();
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 1: 
                        case 2: {
                            isUpdateExecuteStartTime = true;
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            break;
                        }
                        default: {
                            throw new ScheduleStateControlException("Unknown state : " + newState);
                        }
                    }
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e3) {
                        throw new ScheduleStateControlException(e3);
                    }
                    st = null;
                    rs = null;
                    st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                    st.setString(1, id);
                    rs = st.executeQuery();
                    if (!rs.next()) {
                        throw new ScheduleStateControlException("Schedule not found : " + id);
                    }
                    String oldStateStr = rs.getString(1);
                    rowVersion = rs.getInt(2);
                    rs.close();
                    rs = null;
                    newStateStr = this.scheduleTableSchema.getStateString(newState);
                    if (!oldStateStr.equals(newStateStr)) break block34;
                    bl2 = false;
                    Object var18_18 = null;
                    if (rs == null) break block35;
                    try {
                        rs.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.state + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            st.setString(++i, this.scheduleTableSchema.getStateString(oldState));
            bl = st.executeUpdate() != 0;
            Object var18_19 = null;
            if (rs == null) break block38;
            try {
                rs.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block41: {
                    SQLException e222222;
                    Object var18_20 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block41;
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean changeState(String id, int state, Object output) throws ScheduleStateControlException {
        SQLException e222222;
        boolean bl;
        ResultSet rs;
        Statement st;
        Connection con;
        block40: {
            String newStateStr;
            int rowVersion;
            String oldStateStr;
            Date executeEndTime;
            Date executeStartTime;
            boolean isUpdateExecuteEndTime;
            boolean isUpdateExecuteStartTime;
            block36: {
                SQLException e222222;
                boolean bl2;
                block37: {
                    isUpdateExecuteStartTime = false;
                    isUpdateExecuteEndTime = false;
                    executeStartTime = null;
                    executeEndTime = null;
                    switch (state) {
                        case 3: {
                            executeStartTime = new Date();
                            isUpdateExecuteStartTime = true;
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 7: {
                            executeEndTime = new Date();
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 1: 
                        case 2: {
                            isUpdateExecuteStartTime = true;
                            isUpdateExecuteEndTime = true;
                            break;
                        }
                        case 6: 
                        case 8: {
                            break;
                        }
                        default: {
                            throw new ScheduleStateControlException("Unknown state : " + state);
                        }
                    }
                    con = null;
                    try {
                        con = this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e3) {
                        throw new ScheduleStateControlException(e3);
                    }
                    st = null;
                    rs = null;
                    st = con.prepareStatement("select " + this.scheduleTableSchema.state + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                    st.setString(1, id);
                    rs = st.executeQuery();
                    if (!rs.next()) {
                        throw new ScheduleStateControlException("Schedule not found : " + id);
                    }
                    oldStateStr = rs.getString(1);
                    rowVersion = rs.getInt(2);
                    rs.close();
                    rs = null;
                    newStateStr = this.scheduleTableSchema.getStateString(state);
                    if (!oldStateStr.equals(newStateStr)) break block36;
                    bl2 = false;
                    Object var18_18 = null;
                    if (rs == null) break block37;
                    try {
                        rs.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.state + "=?," + this.scheduleTableSchema.output + "=?," + (isUpdateExecuteStartTime ? this.scheduleTableSchema.executeStartTime + "=?," : "") + (isUpdateExecuteEndTime ? this.scheduleTableSchema.executeEndTime + "=?," : "") + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.rowVersion + "='" + rowVersion + '\'');
            int i = 0;
            st.setString(++i, newStateStr);
            if (output == null) {
                st.setNull(++i, 12);
            } else {
                st.setString(++i, output.toString());
            }
            SimpleDateFormat format = new SimpleDateFormat(this.dateFormat + this.timeFormat);
            if (isUpdateExecuteStartTime) {
                st.setString(++i, executeStartTime == null ? null : format.format(executeStartTime));
            }
            if (isUpdateExecuteEndTime) {
                st.setString(++i, executeEndTime == null ? null : format.format(executeEndTime));
            }
            st.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            st.setString(++i, id);
            bl = st.executeUpdate() != 0 && !newStateStr.equals(oldStateStr);
            Object var18_19 = null;
            if (rs == null) break block40;
            try {
                rs.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e222222) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException e4) {
            try {
                throw new ScheduleStateControlException(e4);
            }
            catch (Throwable throwable) {
                block43: {
                    SQLException e222222;
                    Object var18_20 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e222222) {
                            // empty catch block
                        }
                    }
                    if (con == null) break block43;
                    try {
                        con.close();
                    }
                    catch (SQLException e222222) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeControlState(String id, int state) throws ScheduleStateControlException {
        block68: {
            block67: {
                block57: {
                    block66: {
                        block65: {
                            block56: {
                                block64: {
                                    block63: {
                                        block55: {
                                            block62: {
                                                block61: {
                                                    block54: {
                                                        block60: {
                                                            block52: {
                                                                block53: {
                                                                    con = null;
                                                                    try {
                                                                        con = this.connectionFactory.getConnection();
                                                                    }
                                                                    catch (ConnectionFactoryException e) {
                                                                        throw new ScheduleStateControlException(e);
                                                                    }
                                                                    result = false;
                                                                    st = null;
                                                                    rs = null;
                                                                    try {
                                                                        try {
                                                                            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                                                            st.setString(1, id);
                                                                            rs = st.executeQuery();
                                                                            if (!rs.next()) {
                                                                                throw new ScheduleStateControlException("Schedule not found : " + id);
                                                                            }
                                                                            oldStateStr = rs.getString(1);
                                                                            nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
                                                                            rowVersion = rs.getInt(2);
                                                                            rs.close();
                                                                            rs = null;
                                                                            if (nowOldState == state) {
                                                                                var10_12 = false;
                                                                                var16_17 = null;
                                                                                if (rs == null) break block52;
                                                                                break block53;
                                                                            }
                                                                            switch (state) {
                                                                                case 2: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var10_13 = false;
                                                                                    break block54;
                                                                                }
                                                                                case 3: {
                                                                                    if (nowOldState == 6) break;
                                                                                    var10_14 = false;
                                                                                    break block55;
                                                                                }
                                                                                case 4: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var10_15 = false;
                                                                                    break block56;
                                                                                }
                                                                                default: {
                                                                                    throw new ScheduleStateControlException("Unknown state : " + state);
                                                                                }
                                                                            }
                                                                            newStateStr = this.scheduleTableSchema.getControlStateString(state);
                                                                            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=?");
                                                                            st.setString(1, newStateStr);
                                                                            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                                                                            st.setString(3, id);
                                                                            v0 = result = st.executeUpdate() != 0;
                                                                            if (!result) break block57;
                                                                            try {
                                                                                if (this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
                                                                                    var11_29 = this.scheduleControlListeners;
                                                                                    synchronized (var11_29) {
                                                                                        itr = this.scheduleControlListeners.iterator();
                                                                                        while (itr.hasNext()) {
                                                                                            listener = (ScheduleControlListener)itr.next();
                                                                                            listener.changedControlState(id, state);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                break block57;
                                                                            }
                                                                            catch (ScheduleStateControlException e) {
                                                                                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                                                                                st.executeUpdate();
                                                                                throw e;
                                                                            }
                                                                        }
                                                                        catch (SQLException e) {
                                                                            throw new ScheduleStateControlException(e);
                                                                        }
                                                                    }
                                                                    catch (Throwable var15_33) {
                                                                        var16_22 = null;
                                                                        if (rs != null) {
                                                                            try {
                                                                                rs.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (st != null) {
                                                                            try {
                                                                                st.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (con == null) throw var15_33;
                                                                        try {
                                                                            con.close();
                                                                            throw var15_33;
                                                                        }
                                                                        catch (SQLException e) {
                                                                            // empty catch block
                                                                        }
                                                                        throw var15_33;
                                                                    }
                                                                }
                                                                ** try [egrp 5[TRYBLOCK] [15 : 710->720)] { 
lbl96:
                                                                // 1 sources

                                                                rs.close();
                                                                break block52;
lbl98:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (st != null) {
                                                                ** try [egrp 6[TRYBLOCK] [16 : 727->737)] { 
lbl103:
                                                                // 1 sources

                                                                st.close();
                                                                break block60;
lbl105:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con == null) return var10_12;
                                                        ** try [egrp 7[TRYBLOCK] [17 : 743->752)] { 
lbl110:
                                                        // 1 sources

                                                        con.close();
                                                        return var10_12;
lbl112:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                        return var10_12;
                                                    }
                                                    var16_18 = null;
                                                    if (rs != null) {
                                                        ** try [egrp 5[TRYBLOCK] [15 : 710->720)] { 
lbl119:
                                                        // 1 sources

                                                        rs.close();
                                                        break block61;
lbl121:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (st != null) {
                                                    ** try [egrp 6[TRYBLOCK] [16 : 727->737)] { 
lbl126:
                                                    // 1 sources

                                                    st.close();
                                                    break block62;
lbl128:
                                                    // 1 sources

                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (con == null) return var10_13;
                                            ** try [egrp 7[TRYBLOCK] [17 : 743->752)] { 
lbl133:
                                            // 1 sources

                                            con.close();
                                            return var10_13;
lbl135:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                            return var10_13;
                                        }
                                        var16_19 = null;
                                        if (rs != null) {
                                            ** try [egrp 5[TRYBLOCK] [15 : 710->720)] { 
lbl142:
                                            // 1 sources

                                            rs.close();
                                            break block63;
lbl144:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (st != null) {
                                        ** try [egrp 6[TRYBLOCK] [16 : 727->737)] { 
lbl149:
                                        // 1 sources

                                        st.close();
                                        break block64;
lbl151:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (con == null) return var10_14;
                                ** try [egrp 7[TRYBLOCK] [17 : 743->752)] { 
lbl156:
                                // 1 sources

                                con.close();
                                return var10_14;
lbl158:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                                return var10_14;
                            }
                            var16_20 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [15 : 710->720)] { 
lbl165:
                                // 1 sources

                                rs.close();
                                break block65;
lbl167:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (st != null) {
                            ** try [egrp 6[TRYBLOCK] [16 : 727->737)] { 
lbl172:
                            // 1 sources

                            st.close();
                            break block66;
lbl174:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var10_15;
                    ** try [egrp 7[TRYBLOCK] [17 : 743->752)] { 
lbl179:
                    // 1 sources

                    con.close();
                    return var10_15;
lbl181:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var10_15;
                }
                var16_21 = null;
                if (rs != null) {
                    ** try [egrp 5[TRYBLOCK] [15 : 710->720)] { 
lbl188:
                    // 1 sources

                    rs.close();
                    break block67;
lbl190:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 6[TRYBLOCK] [16 : 727->737)] { 
lbl195:
                // 1 sources

                st.close();
                break block68;
lbl197:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return result;
        try {}
        catch (SQLException e) {}
        con.close();
        return result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean changeControlState(String id, int oldState, int newState) throws ScheduleStateControlException {
        block68: {
            block67: {
                block57: {
                    block66: {
                        block65: {
                            block56: {
                                block64: {
                                    block63: {
                                        block55: {
                                            block62: {
                                                block61: {
                                                    block54: {
                                                        block60: {
                                                            block52: {
                                                                block53: {
                                                                    con = null;
                                                                    try {
                                                                        con = this.connectionFactory.getConnection();
                                                                    }
                                                                    catch (ConnectionFactoryException e) {
                                                                        throw new ScheduleStateControlException(e);
                                                                    }
                                                                    result = false;
                                                                    st = null;
                                                                    rs = null;
                                                                    try {
                                                                        try {
                                                                            st = con.prepareStatement("select " + this.scheduleTableSchema.controlState + ',' + this.scheduleTableSchema.rowVersion + " from " + this.scheduleTableSchema.table + " where " + this.scheduleTableSchema.id + "=?");
                                                                            st.setString(1, id);
                                                                            rs = st.executeQuery();
                                                                            if (!rs.next()) {
                                                                                throw new ScheduleStateControlException("Schedule not found : " + id);
                                                                            }
                                                                            oldStateStr = rs.getString(1);
                                                                            nowOldState = this.scheduleTableSchema.getControlState(oldStateStr);
                                                                            rowVersion = rs.getInt(2);
                                                                            rs.close();
                                                                            rs = null;
                                                                            if (nowOldState == newState) {
                                                                                var11_13 = false;
                                                                                var17_18 = null;
                                                                                if (rs == null) break block52;
                                                                                break block53;
                                                                            }
                                                                            switch (newState) {
                                                                                case 2: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var11_14 = false;
                                                                                    break block54;
                                                                                }
                                                                                case 3: {
                                                                                    if (nowOldState == 6) break;
                                                                                    var11_15 = false;
                                                                                    break block55;
                                                                                }
                                                                                case 4: {
                                                                                    if (nowOldState == 3) break;
                                                                                    var11_16 = false;
                                                                                    break block56;
                                                                                }
                                                                                default: {
                                                                                    throw new ScheduleStateControlException("Unknown state : " + newState);
                                                                                }
                                                                            }
                                                                            newStateStr = this.scheduleTableSchema.getControlStateString(newState);
                                                                            st = con.prepareStatement("update " + this.scheduleTableSchema.table + " set " + this.scheduleTableSchema.controlState + "=?," + this.scheduleTableSchema.rowVersion + "='" + (rowVersion + 1) + "'," + this.scheduleTableSchema.updateUserId + "='" + this.updateUserId + "'," + this.scheduleTableSchema.updateTime + "=?" + " where " + this.scheduleTableSchema.id + "=? and " + this.scheduleTableSchema.controlState + "=?");
                                                                            st.setString(1, newStateStr);
                                                                            st.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                                                                            st.setString(3, id);
                                                                            st.setString(4, this.scheduleTableSchema.getControlStateString(oldState));
                                                                            v0 = result = st.executeUpdate() != 0;
                                                                            if (!result) break block57;
                                                                            try {
                                                                                if (this.scheduleControlListeners != null && this.scheduleControlListeners.size() != 0) {
                                                                                    var12_30 = this.scheduleControlListeners;
                                                                                    synchronized (var12_30) {
                                                                                        itr = this.scheduleControlListeners.iterator();
                                                                                        while (itr.hasNext()) {
                                                                                            listener = (ScheduleControlListener)itr.next();
                                                                                            listener.changedControlState(id, this.state);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                break block57;
                                                                            }
                                                                            catch (ScheduleStateControlException e) {
                                                                                st.setString(1, this.scheduleTableSchema.getControlStateString(5));
                                                                                st.executeUpdate();
                                                                                throw e;
                                                                            }
                                                                        }
                                                                        catch (SQLException e) {
                                                                            throw new ScheduleStateControlException(e);
                                                                        }
                                                                    }
                                                                    catch (Throwable var16_34) {
                                                                        var17_23 = null;
                                                                        if (rs != null) {
                                                                            try {
                                                                                rs.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (st != null) {
                                                                            try {
                                                                                st.close();
                                                                            }
                                                                            catch (SQLException e) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (con == null) throw var16_34;
                                                                        try {
                                                                            con.close();
                                                                            throw var16_34;
                                                                        }
                                                                        catch (SQLException e) {
                                                                            // empty catch block
                                                                        }
                                                                        throw var16_34;
                                                                    }
                                                                }
                                                                ** try [egrp 5[TRYBLOCK] [15 : 746->756)] { 
lbl97:
                                                                // 1 sources

                                                                rs.close();
                                                                break block52;
lbl99:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            if (st != null) {
                                                                ** try [egrp 6[TRYBLOCK] [16 : 763->773)] { 
lbl104:
                                                                // 1 sources

                                                                st.close();
                                                                break block60;
lbl106:
                                                                // 1 sources

                                                                catch (SQLException e) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (con == null) return var11_13;
                                                        ** try [egrp 7[TRYBLOCK] [17 : 780->790)] { 
lbl111:
                                                        // 1 sources

                                                        con.close();
                                                        return var11_13;
lbl113:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                        return var11_13;
                                                    }
                                                    var17_19 = null;
                                                    if (rs != null) {
                                                        ** try [egrp 5[TRYBLOCK] [15 : 746->756)] { 
lbl120:
                                                        // 1 sources

                                                        rs.close();
                                                        break block61;
lbl122:
                                                        // 1 sources

                                                        catch (SQLException e) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (st != null) {
                                                    ** try [egrp 6[TRYBLOCK] [16 : 763->773)] { 
lbl127:
                                                    // 1 sources

                                                    st.close();
                                                    break block62;
lbl129:
                                                    // 1 sources

                                                    catch (SQLException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (con == null) return var11_14;
                                            ** try [egrp 7[TRYBLOCK] [17 : 780->790)] { 
lbl134:
                                            // 1 sources

                                            con.close();
                                            return var11_14;
lbl136:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                            return var11_14;
                                        }
                                        var17_20 = null;
                                        if (rs != null) {
                                            ** try [egrp 5[TRYBLOCK] [15 : 746->756)] { 
lbl143:
                                            // 1 sources

                                            rs.close();
                                            break block63;
lbl145:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (st != null) {
                                        ** try [egrp 6[TRYBLOCK] [16 : 763->773)] { 
lbl150:
                                        // 1 sources

                                        st.close();
                                        break block64;
lbl152:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (con == null) return var11_15;
                                ** try [egrp 7[TRYBLOCK] [17 : 780->790)] { 
lbl157:
                                // 1 sources

                                con.close();
                                return var11_15;
lbl159:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                                return var11_15;
                            }
                            var17_21 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [15 : 746->756)] { 
lbl166:
                                // 1 sources

                                rs.close();
                                break block65;
lbl168:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (st != null) {
                            ** try [egrp 6[TRYBLOCK] [16 : 763->773)] { 
lbl173:
                            // 1 sources

                            st.close();
                            break block66;
lbl175:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    if (con == null) return var11_16;
                    ** try [egrp 7[TRYBLOCK] [17 : 780->790)] { 
lbl180:
                    // 1 sources

                    con.close();
                    return var11_16;
lbl182:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var11_16;
                }
                var17_22 = null;
                if (rs != null) {
                    ** try [egrp 5[TRYBLOCK] [15 : 746->756)] { 
lbl189:
                    // 1 sources

                    rs.close();
                    break block67;
lbl191:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            if (st != null) {
                ** try [egrp 6[TRYBLOCK] [16 : 763->773)] { 
lbl196:
                // 1 sources

                st.close();
                break block68;
lbl198:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        if (con == null) return result;
        try {}
        catch (SQLException e) {}
        con.close();
        return result;
        return result;
    }

    public void addScheduleControlListener(ScheduleControlListener listener) {
        if ((this.scheduleControlListeners == null || this.scheduleControlListeners.size() == 0) && this.controlStateChecker == null && this.getState() == 3 && this.controlStateCheckInterval > 0L) {
            this.controlStateChecker = new Daemon(new ControlStateChecker());
            this.controlStateChecker.setName("Nimbus ControlStateChecker " + this.getServiceNameObject());
            this.controlStateChecker.start();
        }
        this.scheduleControlListeners.add(listener);
    }

    public void removeScheduleControlListener(ScheduleControlListener listener) {
        this.scheduleControlListeners.remove(listener);
    }

    protected class TimeoverChecker
    implements DaemonRunnable {
        protected TimeoverChecker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DatabaseScheduleManagerService.this.getTimeoverCheckInterval());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void consume(Object dequeued, DaemonControl ctrl) throws Throwable {
            block33: {
                SQLException e322;
                ResultSet rs;
                Statement st;
                Connection con;
                block28: {
                    con = null;
                    try {
                        con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e2) {
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", e2);
                        return;
                    }
                    st = null;
                    PreparedStatement ps = null;
                    rs = null;
                    st = con.createStatement();
                    SimpleDateFormat format = new SimpleDateFormat(DatabaseScheduleManagerService.this.dateFormat + DatabaseScheduleManagerService.this.timeFormat);
                    Calendar nowCal = Calendar.getInstance();
                    rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.date + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.time + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.state + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.date + "||" + DatabaseScheduleManagerService.this.scheduleTableSchema.time + "<'" + format.format(nowCal.getTime()) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + " is not null" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.maxDelayTime + ">0" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(4) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(5) + "' and " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "<>'" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(7) + '\'');
                    Calendar tmpCal = Calendar.getInstance();
                    while (rs.next()) {
                        Date time = format.parse(rs.getString(2) + rs.getString(3));
                        tmpCal.clear();
                        long maxDelayTime = rs.getLong(4);
                        tmpCal.setTimeInMillis(time.getTime() + maxDelayTime);
                        if (tmpCal.after(nowCal) || tmpCal.equals(nowCal)) continue;
                        String id = rs.getString(1);
                        if (ps == null) {
                            String checkStateStr = DatabaseScheduleManagerService.this.scheduleTableSchema.getCheckStateString(2);
                            ps = con.prepareStatement("update " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " set " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "='" + checkStateStr + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateUserId + "='" + DatabaseScheduleManagerService.this.updateUserId + "'," + DatabaseScheduleManagerService.this.scheduleTableSchema.updateTime + "=?" + " where " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + "=?" + " and " + DatabaseScheduleManagerService.this.scheduleTableSchema.checkState + "<>'" + checkStateStr + '\'');
                        }
                        ps.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                        ps.setString(2, id);
                        if (ps.executeUpdate() == 0) continue;
                        String state = rs.getString(5);
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00003", new Object[]{id, state});
                    }
                    Object var16_16 = null;
                    if (rs == null) break block28;
                    try {
                        rs.close();
                    }
                    catch (SQLException e322) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e322) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e322) {}
                }
                break block33;
                {
                    catch (SQLException e4) {
                        SQLException e322;
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00002", e4);
                        Object var16_17 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e322) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException e322) {
                                // empty catch block
                            }
                        }
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e322) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    SQLException e322;
                    Object var16_18 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e322) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e322) {
                            // empty catch block
                        }
                    }
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e322) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }

        public void garbage() {
        }
    }

    protected class ControlStateChecker
    implements DaemonRunnable {
        protected ControlStateChecker() {
        }

        public boolean onStart() {
            return true;
        }

        public boolean onStop() {
            return true;
        }

        public boolean onSuspend() {
            return true;
        }

        public boolean onResume() {
            return true;
        }

        public Object provide(DaemonControl ctrl) throws Throwable {
            Thread.sleep(DatabaseScheduleManagerService.this.getControlStateCheckInterval());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void consume(Object input, DaemonControl ctrl) throws Throwable {
            block41: {
                SQLException e422;
                ResultSet rs;
                Statement st;
                Connection con;
                block36: {
                    if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) {
                        return;
                    }
                    con = null;
                    try {
                        con = DatabaseScheduleManagerService.this.connectionFactory.getConnection();
                    }
                    catch (ConnectionFactoryException e2) {
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e2);
                        return;
                    }
                    st = null;
                    rs = null;
                    st = con.createStatement();
                    rs = st.executeQuery("select " + DatabaseScheduleManagerService.this.scheduleTableSchema.id + ',' + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + " from " + DatabaseScheduleManagerService.this.scheduleTableSchema.table + " where (" + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.state + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getStateString(6) + "') and (" + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(2) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(3) + "' or " + DatabaseScheduleManagerService.this.scheduleTableSchema.controlState + "='" + DatabaseScheduleManagerService.this.scheduleTableSchema.getControlStateString(4) + "')");
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String controlStateStr = rs.getString(2);
                        int controlState = DatabaseScheduleManagerService.this.scheduleTableSchema.getControlState(controlStateStr);
                        try {
                            if (DatabaseScheduleManagerService.this.scheduleControlListeners == null || DatabaseScheduleManagerService.this.scheduleControlListeners.size() == 0) continue;
                            Set set = DatabaseScheduleManagerService.this.scheduleControlListeners;
                            synchronized (set) {
                                Iterator itr = DatabaseScheduleManagerService.this.scheduleControlListeners.iterator();
                                while (itr.hasNext()) {
                                    ScheduleControlListener listener = (ScheduleControlListener)itr.next();
                                    listener.changedControlState(id, controlState);
                                }
                            }
                        }
                        catch (ScheduleStateControlException e3) {
                            try {
                                DatabaseScheduleManagerService.this.changeControlState(id, 5);
                            }
                            catch (ScheduleStateControlException e2) {
                                // empty catch block
                            }
                            DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e3);
                        }
                    }
                    Object var14_17 = null;
                    if (rs == null) break block36;
                    try {
                        rs.close();
                    }
                    catch (SQLException e422) {
                        // empty catch block
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e422) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e422) {}
                }
                break block41;
                {
                    catch (SQLException e5) {
                        SQLException e422;
                        DatabaseScheduleManagerService.this.getLogger().write("DSM__00001", e5);
                        Object var14_18 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e422) {
                                // empty catch block
                            }
                        }
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (SQLException e422) {
                                // empty catch block
                            }
                        }
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e422) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    SQLException e422;
                    Object var14_19 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e422) {
                            // empty catch block
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e422) {
                            // empty catch block
                        }
                    }
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e422) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }

        public void garbage() {
        }
    }

    public static class ScheduleDependsTableSchema
    extends ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public String table = "SCHEDULE_DEPENDS";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
    }

    public static class ScheduleTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_MASTER_ID = "MASTER_ID";
        public static final String DEFAULT_DATE = "S_DATE";
        public static final String DEFAULT_TIME = "S_TIME";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_OUTPUT = "OUTPUT";
        public static final String DEFAULT_INITIAL_DATE = "INITIAL_DATE";
        public static final String DEFAULT_INITIAL_TIME = "INITIAL_TIME";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_STATE = "STATE";
        public static final String DEFAULT_CONTROL_STATE = "CONTROL_STATE";
        public static final String DEFAULT_CHECK_STATE = "CHECK_STATE";
        public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR_KEY";
        public static final String DEFAULT_EXECUTE_START_TIME = "EXEC_S_TIME";
        public static final String DEFAULT_EXECUTE_END_TIME = "EXEC_E_TIME";
        public static final String DEFAULT_ROWVERSION = "ROWVERSION";
        public static final String DEFAULT_UPDATEUSERID = "UPDATEUSERID";
        public static final String DEFAULT_UPDATETIME = "UPDATETIME";
        public static final String DEFAULT_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_STATE_STRING_ENTRY = "E";
        public static final String DEFAULT_STATE_STRING_RUN = "R";
        public static final String DEFAULT_STATE_STRING_END = "N";
        public static final String DEFAULT_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_STATE_STRING_RETRY = "T";
        public static final String DEFAULT_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CONTROL_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CONTROL_STATE_STRING_PAUSE = "P";
        public static final String DEFAULT_CONTROL_STATE_STRING_RESUME = "R";
        public static final String DEFAULT_CONTROL_STATE_STRING_ABORT = "A";
        public static final String DEFAULT_CONTROL_STATE_STRING_FAILED = "F";
        public static final String DEFAULT_CONTROL_STATE_STRING_UNKNOWN = "U";
        public static final String DEFAULT_CHECK_STATE_STRING_INITIAL = "I";
        public static final String DEFAULT_CHECK_STATE_STRING_TIMEOVER = "O";
        public static final String DEFAULT_CHECK_STATE_STRING_UNKNOWN = "U";
        public String table = "SCHEDULE";
        public String id = "ID";
        public String masterId = "MASTER_ID";
        public String date = "S_DATE";
        public String time = "S_TIME";
        public String taskName = "TASK_NAME";
        public String input = "INPUT";
        public String output = "OUTPUT";
        public String initialDate = "INITIAL_DATE";
        public String initialTime = "INITIAL_TIME";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String state = "STATE";
        public String controlState = "CONTROL_STATE";
        public String checkState = "CHECK_STATE";
        public String executorKey = "EXECUTOR_KEY";
        public String executeStartTime = "EXEC_S_TIME";
        public String executeEndTime = "EXEC_E_TIME";
        public String rowVersion = "ROWVERSION";
        public String updateUserId = "UPDATEUSERID";
        public String updateTime = "UPDATETIME";
        public String stateString_INITIAL = "I";
        public String stateString_ENTRY = "E";
        public String stateString_RUN = "R";
        public String stateString_END = "N";
        public String stateString_FAILED = "F";
        public String stateString_PAUSE = "P";
        public String stateString_ABORT = "A";
        public String stateString_RETRY = "T";
        public String stateString_UNKNOWN = "U";
        public String controlStateString_INITIAL = "I";
        public String controlStateString_PAUSE = "P";
        public String controlStateString_RESUME = "R";
        public String controlStateString_ABORT = "A";
        public String controlStateString_FAILED = "F";
        public String controlStateString_UNKNOWN = "U";
        public String checkStateString_INITIAL = "I";
        public String checkStateString_TIMEOVER = "O";
        public String checkStateString_UNKNOWN = "U";

        public String getStateString(int state) {
            switch (state) {
                case 1: {
                    return this.stateString_INITIAL;
                }
                case 2: {
                    return this.stateString_ENTRY;
                }
                case 3: {
                    return this.stateString_RUN;
                }
                case 4: {
                    return this.stateString_END;
                }
                case 5: {
                    return this.stateString_FAILED;
                }
                case 6: {
                    return this.stateString_PAUSE;
                }
                case 7: {
                    return this.stateString_ABORT;
                }
                case 8: {
                    return this.stateString_RETRY;
                }
            }
            return this.stateString_UNKNOWN;
        }

        public int getState(String state) {
            if (this.stateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.stateString_ENTRY.equals(state)) {
                return 2;
            }
            if (this.stateString_RUN.equals(state)) {
                return 3;
            }
            if (this.stateString_END.equals(state)) {
                return 4;
            }
            if (this.stateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.stateString_PAUSE.equals(state)) {
                return 6;
            }
            if (this.stateString_ABORT.equals(state)) {
                return 7;
            }
            if (this.stateString_RETRY.equals(state)) {
                return 8;
            }
            return -1;
        }

        public String getControlStateString(int state) {
            switch (state) {
                case 1: {
                    return this.controlStateString_INITIAL;
                }
                case 2: {
                    return this.controlStateString_PAUSE;
                }
                case 3: {
                    return this.controlStateString_RESUME;
                }
                case 4: {
                    return this.controlStateString_ABORT;
                }
                case 5: {
                    return this.controlStateString_FAILED;
                }
            }
            return this.controlStateString_UNKNOWN;
        }

        public int getControlState(String state) {
            if (this.controlStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.controlStateString_PAUSE.equals(state)) {
                return 2;
            }
            if (this.controlStateString_ABORT.equals(state)) {
                return 4;
            }
            if (this.controlStateString_FAILED.equals(state)) {
                return 5;
            }
            if (this.controlStateString_RESUME.equals(state)) {
                return 3;
            }
            return -1;
        }

        public String getCheckStateString(int state) {
            switch (state) {
                case 1: {
                    return this.checkStateString_INITIAL;
                }
                case 2: {
                    return this.checkStateString_TIMEOVER;
                }
            }
            return this.checkStateString_UNKNOWN;
        }

        public int getCheckState(String state) {
            if (this.checkStateString_INITIAL.equals(state)) {
                return 1;
            }
            if (this.checkStateString_TIMEOVER.equals(state)) {
                return 2;
            }
            return -1;
        }
    }

    public static class ScheduleDependsMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_DEPENDS_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_DEPENDS_ID = "DEPENDS_ID";
        public String table = "SCHEDULE_DEPENDS_MST";
        public String id = "ID";
        public String dependsId = "DEPENDS_ID";
    }

    public static class ScheduleMasterTableSchema {
        public static final String DEFAULT_TABLE = "SCHEDULE_MST";
        public static final String DEFAULT_ID = "ID";
        public static final String DEFAULT_TASK_NAME = "TASK_NAME";
        public static final String DEFAULT_SCHEDULE_TYPE = "SCHEDULE_TYPE";
        public static final String DEFAULT_INPUT = "INPUT";
        public static final String DEFAULT_START_TIME = "START_TIME";
        public static final String DEFAULT_END_TIME = "END_TIME";
        public static final String DEFAULT_REPEAT_INTERVAL = "REPEAT_INTERVAL";
        public static final String DEFAULT_RETRY_INTERVAL = "RETRY_INTERVAL";
        public static final String DEFAULT_RETRY_END_TIME = "RETRY_END_TIME";
        public static final String DEFAULT_MAX_DELAY_TIME = "MAX_DELAY_TIME";
        public static final String DEFAULT_ENABLE = "ENABLE";
        public String table = "SCHEDULE_MST";
        public String id = "ID";
        public String taskName = "TASK_NAME";
        public String scheduleType = "SCHEDULE_TYPE";
        public String input = "INPUT";
        public String startTime = "START_TIME";
        public String endTime = "END_TIME";
        public String repeatInterval = "REPEAT_INTERVAL";
        public String retryInterval = "RETRY_INTERVAL";
        public String retryEndTime = "RETRY_END_TIME";
        public String maxDelayTime = "MAX_DELAY_TIME";
        public String enable = "ENABLE";
    }
}

