/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.semaphore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import jp.ossc.nimbus.service.semaphore.Semaphore;

public class MemorySemaphore
implements Semaphore,
Serializable {
    private static final long serialVersionUID = -408553618405283847L;
    protected volatile int mResourceCnt = -1;
    protected volatile int mInitialResource = -1;
    protected volatile boolean mFourceEndFlg = false;
    protected transient List waitThreads = Collections.synchronizedList(new ArrayList());
    protected transient Set knockThreads = Collections.synchronizedSet(new HashSet());
    protected transient Set usedThreads = Collections.synchronizedSet(new HashSet());
    protected transient Map threadTasks = Collections.synchronizedMap(new HashMap());
    protected long sleepTime = 10000L;
    protected long checkInterval = -1L;
    protected transient ResourceChecker checker;
    protected int maxUsedResource;
    protected int maxWaitedCount;
    protected transient Timer forceFreeTimer = new Timer(true);

    public boolean getResource() {
        return this.getResource(-1L);
    }

    public boolean getResource(int maxWaitCount) {
        return this.getResource(-1L, maxWaitCount);
    }

    public boolean getResource(long timeOutMiliSecond) {
        return this.getResource(timeOutMiliSecond, -1);
    }

    public boolean getResource(long timeOutMiliSecond, int maxWaitCount) {
        return this.getResource(timeOutMiliSecond, maxWaitCount, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount, long forceFreeMiliSecond) {
        boolean bl;
        boolean removeWait;
        Thread current;
        block63: {
            boolean tasks2;
            block60: {
                List list;
                block61: {
                    current = Thread.currentThread();
                    List list2 = this.waitThreads;
                    synchronized (list2) {
                        if (maxWaitCount > 0) {
                            if (this.waitThreads.size() >= maxWaitCount) return false;
                        }
                        if (this.mFourceEndFlg) {
                            return false;
                        }
                        this.waitThreads.add(current);
                    }
                    long timeOutMs = -1L;
                    if (timeOutMiliSecond >= 0L) {
                        timeOutMs = timeOutMiliSecond;
                    }
                    long processTime = 0L;
                    removeWait = false;
                    try {
                        while (!this.mFourceEndFlg) {
                            long proc;
                            block62: {
                                if (this.mResourceCnt > 0) {
                                    List list3 = this.waitThreads;
                                    synchronized (list3) {
                                        if (this.mResourceCnt > 0) {
                                            if (this.waitThreads.size() != 0 && this.waitThreads.get(0) == current) {
                                                --this.mResourceCnt;
                                                int nowUsed = this.mInitialResource - this.mResourceCnt;
                                                if (nowUsed > this.maxUsedResource) {
                                                    this.maxUsedResource = nowUsed;
                                                }
                                                this.waitThreads.remove(0);
                                                removeWait = true;
                                                Thread.interrupted();
                                                ForceFreeTimerTask task = null;
                                                if (forceFreeMiliSecond > 0L) {
                                                    task = new ForceFreeTimerTask(current);
                                                    this.forceFreeTimer.schedule((TimerTask)task, forceFreeMiliSecond);
                                                }
                                                this.usedThreads.add(current);
                                                if (this.threadTasks.containsKey(current)) {
                                                    Object tasks2 = this.threadTasks.get(current);
                                                    ArrayList<Object> taskList = null;
                                                    if (tasks2 instanceof List) {
                                                        taskList = (ArrayList<Object>)tasks2;
                                                    } else {
                                                        taskList = new ArrayList<Object>();
                                                        taskList.add(tasks2);
                                                        this.threadTasks.put(current, taskList);
                                                    }
                                                    taskList.add(task);
                                                } else {
                                                    this.threadTasks.put(current, task);
                                                }
                                                if (this.mResourceCnt > 0 && this.waitThreads.size() != 0) {
                                                    this.wakeUp();
                                                }
                                                tasks2 = true;
                                                // MONITOREXIT @DISABLED, blocks:[1, 56, 57, 59, 31, 15] lbl59 : MonitorExitStatement: MONITOREXIT : var12_15
                                                Object var23_23 = null;
                                                if (removeWait) break block60;
                                                list = this.waitThreads;
                                                break block61;
                                            }
                                            if (this.waitThreads.size() != 0) {
                                                this.wakeUp();
                                            }
                                        }
                                    }
                                } else {
                                    int nowWaited = this.waitThreads.size();
                                    if (nowWaited > this.maxWaitedCount) {
                                        this.maxWaitedCount = nowWaited;
                                    }
                                }
                                boolean isInterrupted = false;
                                proc = 0L;
                                Thread tasks2 = current;
                                synchronized (tasks2) {
                                    if (this.mFourceEndFlg || timeOutMs > 0L && timeOutMs <= processTime) {
                                        break;
                                    }
                                    if (timeOutMs >= 0L) {
                                        proc = System.currentTimeMillis();
                                    }
                                    isInterrupted = Thread.interrupted();
                                }
                                int priority = current.getPriority();
                                try {
                                    if (isInterrupted || this.mResourceCnt > 0) break block62;
                                    if (priority < 10) {
                                        try {
                                            current.setPriority(priority + 1);
                                        }
                                        catch (SecurityException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (this.mResourceCnt <= 0 && !this.knockThreads.contains(current)) {
                                        Thread.sleep(timeOutMs >= 0L ? timeOutMs - processTime : this.sleepTime);
                                    }
                                }
                                catch (InterruptedException e) {
                                    if (!this.knockThreads.contains(current)) {
                                        boolean bl2 = false;
                                        Object var23_24 = null;
                                        if (!removeWait) {
                                            List list4 = this.waitThreads;
                                            synchronized (list4) {
                                                if (!removeWait) {
                                                    this.waitThreads.remove(current);
                                                }
                                            }
                                        }
                                        this.knockThreads.remove(current);
                                        return bl2;
                                    }
                                }
                                finally {
                                    try {
                                        current.setPriority(priority);
                                    }
                                    catch (SecurityException e) {
                                    }
                                }
                            }
                            Thread thread = current;
                            synchronized (thread) {
                                this.knockThreads.remove(current);
                                Thread.interrupted();
                                if (timeOutMs < 0L) continue;
                            }
                            proc = System.currentTimeMillis() - proc;
                            processTime += proc;
                        }
                        bl = false;
                        break block63;
                    }
                    catch (Throwable throwable) {
                        Object var23_26 = null;
                        if (!removeWait) {
                            List list5 = this.waitThreads;
                            synchronized (list5) {
                                if (!removeWait) {
                                    this.waitThreads.remove(current);
                                }
                            }
                        }
                        this.knockThreads.remove(current);
                        throw throwable;
                    }
                }
                synchronized (list) {
                    if (!removeWait) {
                        this.waitThreads.remove(current);
                    }
                }
            }
            this.knockThreads.remove(current);
            return tasks2;
        }
        Object var23_25 = null;
        if (!removeWait) {
            List list = this.waitThreads;
            synchronized (list) {
                if (!removeWait) {
                    this.waitThreads.remove(current);
                }
            }
        }
        this.knockThreads.remove(current);
        return bl;
    }

    public void freeResource() {
        this.freeResource(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeResource(Thread usedThread) {
        boolean isUsed = false;
        Object object = usedThread;
        synchronized (object) {
            if (this.usedThreads.contains(usedThread)) {
                isUsed = true;
                Object tasks = this.threadTasks.get(usedThread);
                if (tasks instanceof List) {
                    List taskList = (List)tasks;
                    TimerTask task = (TimerTask)taskList.remove(0);
                    if (task != null) {
                        task.cancel();
                    }
                    if (taskList.size() == 0) {
                        this.threadTasks.remove(usedThread);
                        this.usedThreads.remove(usedThread);
                    }
                } else {
                    TimerTask task = (TimerTask)tasks;
                    if (task != null) {
                        task.cancel();
                    }
                    this.threadTasks.remove(usedThread);
                    this.usedThreads.remove(usedThread);
                }
            }
        }
        if (isUsed && this.mResourceCnt < this.mInitialResource) {
            object = this.waitThreads;
            synchronized (object) {
                if (this.mResourceCnt < this.mInitialResource) {
                    ++this.mResourceCnt;
                }
            }
        }
        if (this.mResourceCnt > 0 && this.waitThreads.size() != 0) {
            this.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean wakeUp() {
        if (this.waitThreads.size() != 0) {
            List list = this.waitThreads;
            synchronized (list) {
                if (this.waitThreads.size() != 0) {
                    Thread waitThread;
                    Thread thread = waitThread = (Thread)this.waitThreads.get(0);
                    synchronized (thread) {
                        this.knockThreads.add(waitThread);
                        waitThread.interrupt();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getResourceCapacity() {
        return this.mInitialResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCapacity(int capa) {
        List list = this.waitThreads;
        synchronized (list) {
            if (this.mInitialResource == -1) {
                this.mInitialResource = capa;
                this.mResourceCnt = capa;
            }
        }
    }

    public int getResourceRemain() {
        return this.mResourceCnt;
    }

    public int getWaitingCount() {
        return this.waitThreads.size();
    }

    public void setSleepTime(long millis) {
        this.sleepTime = millis;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setCheckInterval(long millis) {
        this.checkInterval = millis;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (this.checker != null) {
            this.checker.isStop = true;
            this.checker = null;
        }
        this.mFourceEndFlg = true;
        List list = this.waitThreads;
        synchronized (list) {
            while (this.usedThreads.size() != 0) {
                Object[] threads = this.usedThreads.toArray();
                for (int i = 0; i < threads.length; ++i) {
                    this.freeResource((Thread)threads[i]);
                }
            }
            this.wakeUp();
            this.forceFreeTimer.cancel();
            this.forceFreeTimer = new Timer(true);
        }
    }

    public synchronized void accept() {
        this.mFourceEndFlg = false;
        if (this.checkInterval > 0L) {
            this.checker = new ResourceChecker();
            this.checker.start();
        }
    }

    public int getMaxUsedResource() {
        return this.maxUsedResource;
    }

    public int getMaxWaitedCount() {
        return this.maxWaitedCount;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.waitThreads = Collections.synchronizedList(new ArrayList());
        this.knockThreads = Collections.synchronizedSet(new HashSet());
        this.usedThreads = Collections.synchronizedSet(new HashSet());
        this.threadTasks = Collections.synchronizedMap(new HashMap());
        this.forceFreeTimer = new Timer(true);
    }

    protected class ResourceChecker
    extends Thread {
        public boolean isStop;

        public ResourceChecker() {
            super("Nimbus SemaphoreResourceCheckDaemon");
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isStop && MemorySemaphore.this.checkInterval > 0L) {
                try {
                    Thread.sleep(MemorySemaphore.this.checkInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (MemorySemaphore.this.mResourceCnt <= 0 || MemorySemaphore.this.waitThreads.size() == 0) continue;
                MemorySemaphore.this.wakeUp();
            }
        }
    }

    protected class ForceFreeTimerTask
    extends TimerTask {
        protected Thread usedThread;

        public ForceFreeTimerTask(Thread usedThread) {
            this.usedThread = usedThread;
        }

        public void run() {
            MemorySemaphore.this.freeResource(this.usedThread);
        }
    }
}

