/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.core.NimbusClassLoader;

public class RecordSchema {
    public static final String PROPERTY_SCHEMA_ALIAS_NAME_LIST = "LIST";
    public static final String PROPERTY_SCHEMA_ALIAS_NAME_XPATH = "XPATH";
    private static final String PROP_SCHEMA_CLASS_DELIMETER = ":";
    protected static final Map recordSchemaManager = Collections.synchronizedMap(new HashMap());
    protected static final Map propertySchemaManager = Collections.synchronizedMap(new HashMap());
    protected static final Map propertySchemaAliasMap = Collections.synchronizedMap(new HashMap());
    protected Map propertySchemaMap = new LinkedHashMap();
    protected List propertyNames = new ArrayList();
    protected List primaryKeyProperties;
    protected String schema;

    public static RecordSchema getInstance(String schema) throws PropertySchemaDefineException {
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(schema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setSchema(schema);
            recordSchemaManager.put(schema, recordSchema);
        }
        return recordSchema;
    }

    public static RecordSchema getInstance(PropertySchema[] schemata) throws PropertySchemaDefineException {
        StringBuffer buf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < schemata.length; ++i) {
            PropertySchema propertySchema = schemata[i];
            buf.append(propertySchema.getSchema());
            if (i == schemata.length - 1) continue;
            buf.append(lineSep);
        }
        String schema = buf.toString();
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(schema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setPropertySchemata(schemata);
            recordSchemaManager.put(schema, recordSchema);
        }
        return recordSchema;
    }

    public RecordSchema appendSchema(String schema) throws PropertySchemaDefineException {
        StringBuffer buf = new StringBuffer();
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append(System.getProperty("line.separator"));
        }
        buf.append(schema);
        String newSchema = buf.toString();
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(newSchema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setSchema(newSchema);
            recordSchemaManager.put(newSchema, recordSchema);
        }
        return recordSchema;
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.propertySchemaMap.clear();
        this.propertyNames.clear();
        if (this.primaryKeyProperties != null) {
            this.primaryKeyProperties = null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(schema));
        String propertySchemaStr = null;
        try {
            while ((propertySchemaStr = reader.readLine()) != null) {
                PropertySchema propertySchema = this.createPropertySchema(propertySchemaStr);
                if (propertySchema == null) continue;
                if (this.propertySchemaMap.containsKey(propertySchema.getName())) {
                    throw new PropertySchemaDefineException(propertySchemaStr, "Property name is duplicated.");
                }
                this.propertySchemaMap.put(propertySchema.getName(), propertySchema);
                this.propertyNames.add(propertySchema.getName());
                if (!propertySchema.isPrimaryKey()) continue;
                if (this.primaryKeyProperties == null) {
                    this.primaryKeyProperties = new ArrayList();
                }
                this.primaryKeyProperties.add(propertySchema);
            }
        }
        catch (IOException e) {
            throw new PropertySchemaDefineException(schema, e);
        }
        this.schema = schema;
    }

    protected PropertySchema createPropertySchema(String schema) throws PropertySchemaDefineException {
        if (schema == null || schema.length() == 0) {
            return null;
        }
        Class propertySchemaClass = DefaultPropertySchema.class;
        int index = schema.indexOf(PROP_SCHEMA_CLASS_DELIMETER);
        if (index == -1 || index == schema.length() - 1) {
            throw new PropertySchemaDefineException(schema, "The class name of PropertySchema is not specified.");
        }
        if (index != 0) {
            String propertySchemaClassName = schema.substring(0, index);
            if (propertySchemaAliasMap.containsKey(propertySchemaClassName)) {
                propertySchemaClassName = (String)propertySchemaAliasMap.get(propertySchemaClassName);
            }
            try {
                propertySchemaClass = Class.forName(propertySchemaClassName, true, NimbusClassLoader.getInstance());
            }
            catch (ClassNotFoundException e) {
                throw new PropertySchemaDefineException(schema, "The class name of PropertySchema is illegal.", e);
            }
        }
        schema = schema.substring(index + 1);
        String propertySchemaKey = propertySchemaClass.getName() + schema;
        PropertySchema propertySchema = (PropertySchema)propertySchemaManager.get(propertySchemaKey);
        if (propertySchema == null) {
            try {
                propertySchema = (PropertySchema)propertySchemaClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new PropertySchemaDefineException(schema, e);
            }
            catch (IllegalAccessException e) {
                throw new PropertySchemaDefineException(schema, e);
            }
            propertySchema.setSchema(schema);
            propertySchemaManager.put(propertySchemaKey, propertySchema);
        }
        return propertySchema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setPropertySchemata(PropertySchema[] schemata) {
        this.propertySchemaMap.clear();
        this.propertyNames.clear();
        if (this.primaryKeyProperties != null) {
            this.primaryKeyProperties = null;
        }
        StringBuffer buf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < schemata.length; ++i) {
            PropertySchema propertySchema = schemata[i];
            buf.append(propertySchema.getSchema());
            if (i != schemata.length - 1) {
                buf.append(lineSep);
            }
            String propertySchemaKey = propertySchema.getClass().getName() + propertySchema.getSchema();
            propertySchemaManager.put(propertySchemaKey, propertySchema);
            this.propertySchemaMap.put(propertySchema.getName(), propertySchema);
            this.propertyNames.add(propertySchema.getName());
            if (!propertySchema.isPrimaryKey()) continue;
            if (this.primaryKeyProperties == null) {
                this.primaryKeyProperties = new ArrayList();
            }
            this.primaryKeyProperties.add(propertySchema);
        }
        this.schema = buf.toString();
    }

    public PropertySchema[] getPropertySchemata() {
        return this.propertySchemaMap.values().toArray(new PropertySchema[this.propertySchemaMap.size()]);
    }

    public PropertySchema[] getPrimaryKeyPropertySchemata() {
        return this.primaryKeyProperties == null || this.primaryKeyProperties.size() == 0 ? null : this.primaryKeyProperties.toArray(new PropertySchema[this.primaryKeyProperties.size()]);
    }

    public String getPropertyName(int index) {
        if (index < 0 || index >= this.propertyNames.size()) {
            return null;
        }
        return (String)this.propertyNames.get(index);
    }

    public int getPropertyIndex(String name) {
        return this.propertyNames.indexOf(name);
    }

    public PropertySchema getPropertySchema(int index) {
        if (index < 0 || index >= this.propertyNames.size()) {
            return null;
        }
        return (PropertySchema)this.propertySchemaMap.get(this.propertyNames.get(index));
    }

    public PropertySchema getPropertySchema(String name) {
        if (name == null) {
            return null;
        }
        return (PropertySchema)this.propertySchemaMap.get(name);
    }

    public int getPropertySize() {
        return this.propertyNames.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.propertySchemaMap != null) {
            Iterator schemata = this.propertySchemaMap.values().iterator();
            while (schemata.hasNext()) {
                buf.append(schemata.next());
                if (!schemata.hasNext()) continue;
                buf.append(';');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    static {
        propertySchemaAliasMap.put(PROPERTY_SCHEMA_ALIAS_NAME_LIST, "jp.ossc.nimbus.beans.dataset.RecordListPropertySchema");
        propertySchemaAliasMap.put(PROPERTY_SCHEMA_ALIAS_NAME_XPATH, "jp.ossc.nimbus.beans.dataset.XpathPropertySchema");
    }
}

