/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.recset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.InvalidSchemaException;
import jp.ossc.nimbus.recset.RowSchema;
import jp.ossc.nimbus.service.codemaster.CodeMasterUpdateKey;

public class RowData
implements Serializable,
Comparable,
Cloneable {
    private static final long serialVersionUID = 1440044638276534717L;
    private static final String FORMAT_DATE = "yyyy/MM/dd";
    private static final String FORMAT_TIMESTAMP = "yyyy/MM/dd HH:mm:ss";
    public static final char C_KEY_SEPARATOR = '\u001c';
    public static final int E_Record_TypeRead = 0;
    public static final int E_Record_TypeUpdate = 1;
    public static final int E_Record_TypeDelete = 2;
    public static final int E_Record_TypeInsert = 3;
    public static final int E_Record_TypeDeleteInsert = 4;
    public static final int E_Record_TypeIgnore = -1;
    private int mTransactionMode = -1;
    protected RowSchema mRowSchema;
    private Object[] mFields;
    private int mRowIndex = -1;
    private String mKey = null;

    public RowData(RowSchema rs) {
        this.mRowSchema = rs;
        this.mFields = new Object[rs.size()];
    }

    protected RowData makeGoneData(RowSchema rs) {
        RowData rd = new RowData(rs);
        ArrayList<Object> lst = new ArrayList<Object>();
        for (int rcnt = 0; rcnt < this.getRowSchema().size(); ++rcnt) {
            FieldSchema fs = this.getRowSchema().get(rcnt);
            if (!fs.isUpdateField()) continue;
            lst.add(this.get(rcnt));
        }
        rd.mFields = lst.toArray();
        rd.mTransactionMode = this.getTransactionMode();
        rd.makeUniqueKey();
        return rd;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getKey(String[] colNames) {
        if (colNames == null || colNames.length == 0) {
            return this.getKey();
        }
        if (this.getRowSchema() == null) {
            throw new IllegalArgumentException("Shema not initalize.");
        }
        int[] colIndexes = new int[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            FieldSchema field = this.getRowSchema().get(colNames[i]);
            if (field == null) {
                throw new IllegalArgumentException("Field not found : " + colNames[i]);
            }
            colIndexes[i] = field.getIndex();
        }
        return this.getKey(colIndexes);
    }

    public String getKey(int[] colIndexes) {
        if (colIndexes == null || colIndexes.length == 0) {
            return this.getKey();
        }
        StringBuffer ret = new StringBuffer();
        RowSchema rscm = this.getRowSchema();
        for (int i = 0; i < colIndexes.length; ++i) {
            FieldSchema csm = rscm.get(colIndexes[i]);
            if (csm == null) {
                throw new IllegalArgumentException("Field not found : " + colIndexes[i]);
            }
            ret.append(this.getString(csm.getIndex()));
            if (i == colIndexes.length - 1) continue;
            ret.append('\u001c');
        }
        return ret.toString();
    }

    public int getRowIndex() {
        return this.mRowIndex;
    }

    public RowSchema getRowSchema() {
        return this.mRowSchema;
    }

    public int getTransactionMode() {
        return this.mTransactionMode;
    }

    protected void setRowIndex(int i) {
        this.mRowIndex = i;
    }

    public void setTransactionModeForce(int trMode) {
        this.mTransactionMode = trMode;
    }

    public void remove() {
        this.setTransactionMode(2);
    }

    public void setTransactionMode(int trMode) {
        boolean wrtFlg = false;
        switch (this.getTransactionMode()) {
            case 0: {
                if (trMode != 1 && trMode != 2 && trMode != 4) break;
                this.mTransactionMode = trMode;
                break;
            }
            case 1: {
                if (trMode != 2 && trMode != 0 && trMode != 4) break;
                this.mTransactionMode = trMode;
                break;
            }
            case 2: {
                if (trMode == 3) {
                    this.mTransactionMode = 1;
                    break;
                }
                if (trMode != 1 && trMode != 0 && trMode != 4) break;
                this.mTransactionMode = trMode;
                break;
            }
            case 3: {
                if (trMode == 2) {
                    this.mTransactionMode = -1;
                }
                wrtFlg = true;
                break;
            }
            case 4: {
                if (trMode != 2 && trMode != 1 && trMode != 0) break;
                this.mTransactionMode = trMode;
                break;
            }
            default: {
                if (trMode == 3) {
                    this.mTransactionMode = trMode;
                    wrtFlg = true;
                    break;
                }
                if (trMode == 1) {
                    this.mTransactionMode = 3;
                    wrtFlg = true;
                    break;
                }
                if (trMode == 4) {
                    this.mTransactionMode = 3;
                    wrtFlg = true;
                    break;
                }
                if (trMode != 0) break;
                this.mTransactionMode = trMode;
                wrtFlg = true;
            }
        }
        if (wrtFlg) {
            this.makeUniqueKey();
        }
    }

    public void makeUniqueKey() {
        StringBuffer ret = new StringBuffer();
        RowSchema rscm = this.getRowSchema();
        int max = rscm.getUniqueKeySize();
        for (int rcnt = 0; rcnt < max; ++rcnt) {
            FieldSchema csm = rscm.getUniqueFieldSchema(rcnt);
            ret.append(this.getString(csm.getIndex()));
            if (rcnt == max - 1) continue;
            ret.append('\u001c');
        }
        this.mKey = ret.toString();
    }

    public ListIterator listIterator() {
        return Arrays.asList(this.mFields).listIterator();
    }

    public Object get(int index) {
        return this.mFields[index];
    }

    public Object get(String key) {
        return this.mFields[this.getFieldSchema(key).getIndex()];
    }

    private FieldSchema getFieldSchema(String name) throws InvalidSchemaException {
        if (this.mRowSchema == null) {
            throw new InvalidSchemaException("RowSchema is null.");
        }
        FieldSchema field = this.mRowSchema.get(name);
        if (field == null) {
            StringBuffer buf = new StringBuffer();
            int imax = this.mRowSchema.size();
            for (int i = 0; i < imax; ++i) {
                buf.append(this.mRowSchema.get(i).getFieldName());
                if (i == imax - 1) continue;
                buf.append(',');
            }
            throw new InvalidSchemaException("No such field : name=" + name + ", fieldNames=" + buf);
        }
        return field;
    }

    private FieldSchema getFieldSchema(int index) throws InvalidSchemaException {
        if (this.mRowSchema == null) {
            throw new InvalidSchemaException("RowSchema is null.");
        }
        FieldSchema field = this.mRowSchema.get(index);
        if (field == null) {
            throw new InvalidSchemaException("No such field : index=" + index + ", fieldLength=" + this.mRowSchema.size());
        }
        return field;
    }

    public String getString(int index) {
        int type = this.getFieldSchema(index).getFieldType();
        Object obj = this.mFields[index];
        if (obj == null) {
            return null;
        }
        String ret = null;
        switch (type) {
            case 3: {
                ret = (String)obj;
                break;
            }
            case 2: {
                ret = (String)obj;
                break;
            }
            case 4: {
                SimpleDateFormat sf = new SimpleDateFormat(FORMAT_DATE);
                ret = sf.format((java.util.Date)obj);
                break;
            }
            case 9: {
                SimpleDateFormat sf2 = new SimpleDateFormat(FORMAT_TIMESTAMP);
                ret = sf2.format(new java.util.Date(((Timestamp)obj).getTime()));
                break;
            }
            case 10: {
                ret = new String((byte[])obj);
                break;
            }
            case 11: {
                ret = new String((char[])obj);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                ret = obj.toString();
            }
        }
        return ret;
    }

    public Object getSqlTypeValue(int index) {
        int type = this.getFieldSchema(index).getFieldType();
        Object obj = this.mFields[index];
        if (obj == null) {
            return null;
        }
        switch (type) {
            case 4: {
                java.util.Date dt = (java.util.Date)obj;
                obj = new Date(dt.getTime());
                break;
            }
            case 9: {
                java.util.Date dt2 = (java.util.Date)obj;
                obj = new Timestamp(dt2.getTime());
                break;
            }
        }
        return obj;
    }

    public String getStringValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 2: 
            case 3: {
                return (String)this.mFields[index];
            }
            case 10: {
                return this.mFields[index] == null ? null : new String((byte[])this.mFields[index]);
            }
            case 11: {
                return this.mFields[index] == null ? null : new String((char[])this.mFields[index]);
            }
        }
        throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
    }

    public java.util.Date getDateValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 4: 
            case 9: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        return (java.util.Date)this.mFields[index];
    }

    public byte[] getBytesValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 10: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        return (byte[])this.mFields[index];
    }

    public InputStream getInputStreamValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 10: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        return new ByteArrayInputStream((byte[])this.mFields[index]);
    }

    public Reader getReaderValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 11: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        return new CharArrayReader((char[])this.mFields[index]);
    }

    public Integer getIntegerValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null || tmp instanceof Integer) {
            return (Integer)tmp;
        }
        return new Integer(tmp.intValue());
    }

    public int getIntValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            throw new NullPointerException(fs.getFieldName() + " is null.");
        }
        return tmp.intValue();
    }

    public Long getLongValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null || tmp instanceof Long) {
            return (Long)tmp;
        }
        return new Long(tmp.longValue());
    }

    public long getPrimitiveLongValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            throw new NullPointerException(fs.getFieldName() + " is null.");
        }
        return tmp.longValue();
    }

    public Float getFloatValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null || tmp instanceof Float) {
            return (Float)tmp;
        }
        return new Float(tmp.floatValue());
    }

    public float getPrimitiveFloatValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            throw new NullPointerException(fs.getFieldName() + " is null.");
        }
        return tmp.floatValue();
    }

    public Double getDoubleValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null || tmp instanceof Double) {
            return (Double)tmp;
        }
        return new Double(tmp.doubleValue());
    }

    public double getPrimitiveDoubleValue(int index) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        Number tmp = (Number)this.mFields[index];
        if (tmp == null) {
            throw new NullPointerException(fs.getFieldName() + " is null.");
        }
        return tmp.doubleValue();
    }

    public Object getSqlTypeValue(String key) {
        return this.getSqlTypeValue(this.getFieldSchema(key).getIndex());
    }

    public String getString(String key) {
        return this.getString(this.getFieldSchema(key).getIndex());
    }

    public String getStringValue(String key) {
        return this.getStringValue(this.getFieldSchema(key).getIndex());
    }

    public java.util.Date getDateValue(String key) {
        return this.getDateValue(this.getFieldSchema(key).getIndex());
    }

    public byte[] getBytesValue(String key) {
        return this.getBytesValue(this.getFieldSchema(key).getIndex());
    }

    public InputStream getInputStreamValue(String key) {
        return this.getInputStreamValue(this.getFieldSchema(key).getIndex());
    }

    public Reader getReaderValue(String key) {
        return this.getReaderValue(this.getFieldSchema(key).getIndex());
    }

    public Integer getIntegerValue(String key) {
        return this.getIntegerValue(this.getFieldSchema(key).getIndex());
    }

    public int getIntValue(String key) {
        return this.getIntValue(this.getFieldSchema(key).getIndex());
    }

    public Long getLongValue(String key) {
        return this.getLongValue(this.getFieldSchema(key).getIndex());
    }

    public long getPrimitiveLongValue(String key) {
        return this.getPrimitiveLongValue(this.getFieldSchema(key).getIndex());
    }

    public Float getFloatValue(String key) {
        return this.getFloatValue(this.getFieldSchema(key).getIndex());
    }

    public float getPrimitiveFloatValue(String key) {
        return this.getPrimitiveFloatValue(this.getFieldSchema(key).getIndex());
    }

    public Double getDoubleValue(String key) {
        return this.getDoubleValue(this.getFieldSchema(key).getIndex());
    }

    public double getPrimitiveDoubleValue(String key) {
        return this.getPrimitiveDoubleValue(this.getFieldSchema(key).getIndex());
    }

    public void setValueNative(int index, Object value) {
        FieldSchema fs = this.getFieldSchema(index);
        if (fs.isUniqueKey()) {
            switch (this.getTransactionMode()) {
                case 0: 
                case 1: 
                case 2: {
                    if (this.mFields[index] == null) break;
                    return;
                }
            }
        }
        this.mFields[index] = value;
        if (fs.isUniqueKey()) {
            this.makeUniqueKey();
        }
    }

    public void setValue(int index, String value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 2: 
            case 3: {
                this.setValueNative(index, value);
                break;
            }
            case 10: {
                if (value == null) {
                    this.setValueNative(index, null);
                    break;
                }
                this.setValueNative(index, value.getBytes());
                break;
            }
            case 11: {
                if (value == null) {
                    this.setValueNative(index, null);
                    break;
                }
                this.setValueNative(index, value.toCharArray());
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
    }

    public void setValue(int index, java.util.Date value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 4: 
            case 9: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, byte[] value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 10: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        if (this.mRowSchema.get(index).getFieldLength() > 0 && value != null && value.length > this.mRowSchema.get(index).getFieldLength()) {
            throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, InputStream value) throws IOException {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 10: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int length = 0;
        byte[] buf = new byte[1024];
        while ((length = value.read(buf)) != -1) {
            baos.write(buf, 0, length);
        }
        byte[] bytes = baos.toByteArray();
        if (this.mRowSchema.get(index).getFieldLength() > 0 && bytes != null && bytes.length > this.mRowSchema.get(index).getFieldLength()) {
            throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
        }
        this.setValueNative(index, bytes);
    }

    public void setValue(int index, char[] value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 11: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        if (this.mRowSchema.get(index).getFieldLength() > 0 && value != null && value.length > this.mRowSchema.get(index).getFieldLength()) {
            throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, Reader value) throws IOException {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 10: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        CharArrayWriter caw = new CharArrayWriter();
        int length = 0;
        char[] buf = new char[1024];
        while ((length = value.read(buf)) != -1) {
            caw.write(buf, 0, length);
        }
        char[] chars = caw.toCharArray();
        if (this.mRowSchema.get(index).getFieldLength() > 0 && chars != null && chars.length > this.mRowSchema.get(index).getFieldLength()) {
            throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
        }
        this.setValueNative(index, chars);
    }

    public void setValue(int index, Integer value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        if (value != null && this.mRowSchema.get(index).getFieldLength() > 0 && value != 0) {
            String tmp = value.toString();
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, int value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 1: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        if (this.mRowSchema.get(index).getFieldLength() > 0 && value != 0) {
            String tmp = Integer.toString(value);
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
            }
        }
        this.setValueNative(index, new Integer(value));
    }

    public void setValue(int index, Long value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        if (value != null && this.mRowSchema.get(index).getFieldLength() > 0 && value != 0L) {
            String tmp = value.toString();
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, long value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 8: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        if (this.mRowSchema.get(index).getFieldLength() > 0 && value != 0L) {
            String tmp = Long.toString(value);
            if ((tmp = tmp.replaceAll("-", "")).length() > this.mRowSchema.get(index).getFieldLength()) {
                throw new InvalidSchemaException("Length is over. Length of " + fs.getFieldName() + " is " + fs.getFieldLength());
            }
        }
        this.setValueNative(index, new Long(value));
    }

    public void setValue(int index, Float value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, float value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 5: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        this.setValueNative(index, new Float(value));
    }

    public void setValue(int index, Double value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        this.setValueNative(index, value);
    }

    public void setValue(int index, double value) {
        FieldSchema fs = this.getFieldSchema(index);
        switch (fs.getFieldType()) {
            case 7: {
                break;
            }
            default: {
                throw new InvalidSchemaException("Type of " + fs.getFieldName() + " is " + FieldSchema.getFieldTypeString(fs.getFieldType()));
            }
        }
        this.setValueNative(index, new Double(value));
    }

    public void setValue(String key, String value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, java.util.Date value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, byte[] value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, InputStream value) throws IOException {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, char[] value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, Reader value) throws IOException {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, Integer value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, int value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, Long value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, long value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, Float value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, float value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, Double value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public void setValue(String key, double value) {
        this.setValue(this.getFieldSchema(key).getIndex(), value);
    }

    public int size() {
        return this.mFields.length;
    }

    public RowData cloneRowData() {
        RowData rd = null;
        try {
            rd = (RowData)this.clone();
            rd.mFields = new Object[this.mFields.length];
            rd.mTransactionMode = -1;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        for (int rcnt = 0; rcnt < this.mFields.length; ++rcnt) {
            rd.mFields[rcnt] = this.cloneFieldData(rcnt);
        }
        return rd;
    }

    private Object cloneFieldData(int index) {
        FieldSchema schema = this.getFieldSchema(index);
        Object ret = this.mFields[index];
        switch (schema.getFieldType()) {
            case 4: 
            case 9: {
                if (ret == null) break;
                java.util.Date dt = (java.util.Date)ret;
                ret = new java.util.Date(dt.getTime());
                break;
            }
            case 10: {
                if (ret == null) break;
                byte[] bytes = (byte[])ret;
                byte[] newBytes = new byte[bytes.length];
                System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                ret = newBytes;
                break;
            }
            case 11: {
                if (ret == null) break;
                char[] chars = (char[])ret;
                char[] newChars = new char[chars.length];
                System.arraycopy(chars, 0, newChars, 0, chars.length);
                ret = newChars;
                break;
            }
        }
        return ret;
    }

    private List getFields() {
        return Arrays.asList(this.mFields);
    }

    public void clear() {
        this.mTransactionMode = -1;
        if (this.mFields != null) {
            for (int i = 0; i < this.mFields.length; ++i) {
                this.mFields[i] = null;
            }
        }
        this.mRowIndex = -1;
        this.mKey = null;
    }

    public boolean equals(RowData rd) {
        boolean ret = true;
        if (this.getRowSchema() == rd.getRowSchema()) {
            for (int rcnt = 0; rcnt < this.getFields().size(); ++rcnt) {
                Object obj0 = this.get(rcnt);
                Object obj1 = rd.get(rcnt);
                if (obj0 == null && obj1 == null) continue;
                if (obj0 == null || obj1 == null) {
                    ret = false;
                } else {
                    if (obj0.equals(obj1)) continue;
                    ret = false;
                }
                break;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof RowData)) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        RowData comp = (RowData)o;
        RowSchema mySchema = this.getRowSchema();
        RowSchema compSchema = comp.getRowSchema();
        if (mySchema == null && compSchema == null) {
            return this.hashCode() - comp.hashCode();
        }
        if (mySchema != null && compSchema == null) {
            return 1;
        }
        if (mySchema == null && compSchema != null) {
            return -1;
        }
        if (!mySchema.equals(compSchema) || mySchema.getUniqueKeySize() == 0) {
            return this.hashCode() - comp.hashCode();
        }
        String myKey = this.getKey();
        String compKey = comp.getKey();
        if (myKey == null && compKey == null) {
            return this.hashCode() - comp.hashCode();
        }
        if (myKey != null && compKey == null) {
            return 1;
        }
        if (myKey == null && compKey != null) {
            return -1;
        }
        return myKey.compareTo(compKey);
    }

    public CodeMasterUpdateKey createCodeMasterUpdateKey() {
        CodeMasterUpdateKey key = new CodeMasterUpdateKey();
        return this.createCodeMasterUpdateKey(key);
    }

    public CodeMasterUpdateKey createCodeMasterUpdateKey(CodeMasterUpdateKey key) {
        key.clear();
        RowSchema rowSchema = this.getRowSchema();
        int imax = rowSchema.getUniqueKeySize();
        for (int i = 0; i < imax; ++i) {
            FieldSchema fieldSchema = rowSchema.getUniqueFieldSchema(i);
            key.addKey(fieldSchema.getFieldName(), this.get(fieldSchema.getIndex()));
        }
        switch (this.getTransactionMode()) {
            case 1: 
            case 4: {
                key.update();
                break;
            }
            case 2: {
                key.remove();
                break;
            }
            case 3: {
                key.add();
                break;
            }
        }
        return key;
    }

    public void setCodeMasterUpdateKey(CodeMasterUpdateKey key) {
        this.setTransactionModeForce(-1);
        RowSchema rowSchema = this.getRowSchema();
        Iterator entries = key.getKeyMap().entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            FieldSchema fieldSchema = rowSchema.get((String)entry.getKey());
            if (fieldSchema == null) continue;
            this.setValueNative(fieldSchema.getIndex(), entry.getValue());
        }
        switch (key.getUpdateType()) {
            case 1: {
                this.setTransactionModeForce(3);
                break;
            }
            case 2: {
                this.setTransactionModeForce(1);
                break;
            }
            case 3: {
                this.setTransactionModeForce(2);
                break;
            }
            default: {
                this.setTransactionModeForce(0);
            }
        }
    }
}

