/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.ArrayList;
import java.util.List;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.BreakPointInterceptorServiceMBean;

public class BreakPointInterceptorService
extends ServiceBase
implements Interceptor,
BreakPointInterceptorServiceMBean {
    private static final long serialVersionUID = -2667830848395155759L;
    private Object monitor = new Object();
    private Object listenerMonitor = "monitor";
    private boolean enabled = true;
    private int breakPoint = 1;
    private long timeout;
    private List threads = new ArrayList();

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMonitor(Object monitor) {
        this.monitor = monitor;
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public void setBreakPoint(int breakPoint) {
        this.breakPoint = breakPoint;
    }

    public int getBreakPoint() {
        return this.breakPoint;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List suspendThreads() {
        List list = this.threads;
        synchronized (list) {
            return new ArrayList(this.threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSuspend() throws InterruptedException {
        if (this.getState() != 3) {
            return;
        }
        Object object = this.listenerMonitor;
        synchronized (object) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.size() != 0) {
                    return;
                }
            }
            this.listenerMonitor.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitSuspend(long timeout) throws InterruptedException {
        if (this.getState() != 3) {
            return false;
        }
        Object object = this.listenerMonitor;
        synchronized (object) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.size() != 0) {
                    return true;
                }
            }
            this.listenerMonitor.wait(timeout);
            list = this.threads;
            synchronized (list) {
                return this.threads.size() != 0;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSuspend(String threadName) throws InterruptedException {
        if (this.getState() != 3) {
            return;
        }
        Object object = this.listenerMonitor;
        synchronized (object) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.contains(threadName)) {
                    return;
                }
            }
            this.listenerMonitor.wait();
            list = this.threads;
            synchronized (list) {
                if (this.threads.contains(threadName)) {
                    return;
                }
            }
            this.waitSuspend(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitSuspend(String threadName, long timeout) throws InterruptedException {
        if (this.getState() != 3) {
            return false;
        }
        Object object = this.listenerMonitor;
        synchronized (object) {
            List list = this.threads;
            synchronized (list) {
                if (this.threads.contains(threadName)) {
                    return true;
                }
            }
            long startTime = System.currentTimeMillis();
            this.listenerMonitor.wait(timeout);
            long waitTime = System.currentTimeMillis() - startTime;
            List list2 = this.threads;
            synchronized (list2) {
                if (this.threads.contains(threadName)) {
                    return true;
                }
                if (waitTime >= timeout) {
                    return false;
                }
            }
            return this.waitSuspend(threadName, timeout - waitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        Object object = this.listenerMonitor;
        synchronized (object) {
            this.listenerMonitor.notifyAll();
        }
        object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        Object object;
        if (this.getState() == 3 && this.enabled && this.breakPoint == 1) {
            this.breakpoint();
        }
        try {
            object = chain.invokeNext(context);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                if (this.getState() != 3 || !this.enabled || this.breakPoint != 2) break block4;
                this.breakpoint();
            }
            throw throwable;
        }
        if (this.getState() == 3 && this.enabled && this.breakPoint == 2) {
            this.breakpoint();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakpoint() {
        Object object;
        Thread thread = Thread.currentThread();
        try {
            Object object2 = this.listenerMonitor;
            synchronized (object2) {
                List list = this.threads;
                synchronized (list) {
                    this.threads.add(thread.getName());
                }
                this.listenerMonitor.notifyAll();
            }
            object2 = this.monitor;
            synchronized (object2) {
                try {
                    if (this.timeout > 0L) {
                        this.monitor.wait(this.timeout);
                    } else {
                        this.monitor.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Object var8_8 = null;
            object = this.listenerMonitor;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Object object3 = this.listenerMonitor;
            synchronized (object3) {
                List list = this.threads;
                synchronized (list) {
                    this.threads.remove(thread.getName());
                }
            }
            throw throwable;
        }
        synchronized (object) {
            List list = this.threads;
            synchronized (list) {
                this.threads.remove(thread.getName());
            }
        }
    }
}

