/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.DefaultExceptionHandlerServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.servlet.ExceptionHandler;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;

public class DefaultExceptionHandlerService
extends ServiceBase
implements DefaultExceptionHandlerServiceMBean,
ExceptionHandler {
    private static final long serialVersionUID = -7679217558033186068L;
    public static final String REQUEST_ATTIBUTE_EXCEPTION_KEY = DefaultExceptionHandlerService.class.getName().replace('.', '_') + "_EXCEPTION";
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected String logMessageCode;
    protected boolean isOutputStackTraceLog = true;
    protected String exceptionJournalKey = "Exception";
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected int httpResponseStatus = -1;
    protected String httpResponseStatusMessage;
    protected String forwardPath;
    protected boolean isThrowException;
    protected String responseObjectAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;
    protected Object responseObject;

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setLogMessageCode(String code) {
        this.logMessageCode = code;
    }

    public String getLogMessageCode() {
        return this.logMessageCode;
    }

    public void setOutputStackTraceLog(boolean isOutput) {
        this.isOutputStackTraceLog = isOutput;
    }

    public boolean isOutputStackTraceLog() {
        return this.isOutputStackTraceLog;
    }

    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    public void setHttpResponseStatus(int status) {
        this.httpResponseStatus = status;
    }

    public int getHttpResponseStatus() {
        return this.httpResponseStatus;
    }

    public void setHttpResponseStatusMessage(String message) {
        this.httpResponseStatusMessage = message;
    }

    public String getHttpResponseStatusMessage() {
        return this.httpResponseStatusMessage;
    }

    public void setForwardPath(String path) {
        this.forwardPath = path;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public void setThrowException(boolean isThrow) {
        this.isThrowException = isThrow;
    }

    public boolean isThrowException() {
        return this.isThrowException;
    }

    public void setResponseObjectAttributeName(String name) {
        this.responseObjectAttributeName = name;
    }

    public String getResponseObjectAttributeName() {
        return this.responseObjectAttributeName;
    }

    public void setResponseObject(Object obj) {
        this.responseObject = obj;
    }

    public Object getResponseObject() {
        return this.responseObject;
    }

    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    public void handleException(Throwable th, ServletRequest request, ServletResponse response) throws Throwable {
        RequestDispatcher rd;
        if (this.logMessageCode != null) {
            Logger log = super.getLogger();
            if (this.isOutputStackTraceLog) {
                log.write(this.logMessageCode, th);
            } else {
                log.write(this.logMessageCode);
            }
        }
        if (this.journal != null) {
            this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
        }
        if (this.httpResponseStatus != -1 && response instanceof HttpServletResponse) {
            if (this.httpResponseStatusMessage == null) {
                ((HttpServletResponse)response).setStatus(this.httpResponseStatus);
            } else {
                ((HttpServletResponse)response).sendError(this.httpResponseStatus, this.httpResponseStatusMessage);
            }
        }
        if (this.responseObject != null) {
            request.setAttribute(this.responseObjectAttributeName, this.responseObject);
        }
        if (this.isThrowException) {
            throw th;
        }
        if (this.forwardPath != null && (rd = request.getRequestDispatcher(this.forwardPath)) != null) {
            request.setAttribute(REQUEST_ATTIBUTE_EXCEPTION_KEY, (Object)th);
            rd.forward(request, response);
        }
    }
}

